/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.AbstractKotlinParsing;
import org.jetbrains.kotlin.parsing.KotlinParsing;
import org.jetbrains.kotlin.parsing.KotlinWhitespaceAndCommentsBindersKt;
import org.jetbrains.kotlin.parsing.PrecedingDocCommentsBinder;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.parsing.TrailingCommentsBinder;

public class KotlinExpressionParsing
extends AbstractKotlinParsing {
    private static final TokenSet WHEN_CONDITION_RECOVERY_SET;
    private static final TokenSet WHEN_CONDITION_RECOVERY_SET_WITH_ARROW;
    private static final ImmutableMap<String, KtToken> KEYWORD_TEXTS;
    private static final TokenSet TOKEN_SET_TO_FOLLOW_AFTER_DESTRUCTURING_DECLARATION_IN_LAMBDA;
    private static final TokenSet TOKEN_SET_TO_FOLLOW_AFTER_DESTRUCTURING_DECLARATION_IN_LAMBDA_RECOVERY;
    private static final TokenSet EQ_RPAR_SET;
    private static final TokenSet ARROW_SET;
    private static final TokenSet ARROW_COMMA_SET;
    private static final TokenSet IN_KEYWORD_R_PAR_COLON_SET;
    private static final TokenSet IN_KEYWORD_L_BRACE_SET;
    private static final TokenSet IN_KEYWORD_L_BRACE_RECOVERY_SET;
    private static final TokenSet COLON_IN_KEYWORD_SET;
    private static final TokenSet L_PAR_L_BRACE_R_PAR_SET;
    private static final TokenSet IN_KEYWORD_SET;
    private static final TokenSet TRY_CATCH_RECOVERY_TOKEN_SET;
    private static final TokenSet TYPE_ARGUMENT_LIST_STOPPERS;
    static final TokenSet EXPRESSION_FIRST;
    public static final TokenSet STATEMENT_FIRST;
    private static final TokenSet STATEMENT_NEW_LINE_QUICK_RECOVERY_SET;
    static final TokenSet EXPRESSION_FOLLOW;
    private static final TokenSet ALLOW_NEWLINE_OPERATIONS;
    public static final TokenSet ALL_OPERATIONS;
    private final KotlinParsing myKotlinParsing;

    private static ImmutableMap<String, KtToken> tokenSetToMap(TokenSet tokens) {
        ImmutableMap.Builder<String, KtToken> builder2 = ImmutableMap.builder();
        for (IElementType token : tokens.getTypes()) {
            builder2.put(token.toString(), (KtToken)token);
        }
        return builder2.build();
    }

    public KotlinExpressionParsing(SemanticWhitespaceAwarePsiBuilder builder2, KotlinParsing kotlinParsing) {
        this(builder2, kotlinParsing, true);
    }

    public KotlinExpressionParsing(SemanticWhitespaceAwarePsiBuilder builder2, KotlinParsing kotlinParsing, boolean isLazy) {
        super(builder2, isLazy);
        this.myKotlinParsing = kotlinParsing;
    }

    public void parseExpression() {
        if (!this.atSet(EXPRESSION_FIRST)) {
            this.error("Expecting an expression");
            return;
        }
        this.parseBinaryExpression(Precedence.ASSIGNMENT);
    }

    private void parseBinaryExpression(Precedence precedence) {
        PsiBuilder.Marker expression2 = this.mark();
        precedence.parseHigherPrecedence(this);
        while (!this.interruptedWithNewLine() && this.atSet(precedence.getOperations())) {
            IElementType operation = this.tt();
            this.parseOperationReference();
            IElementType resultType = precedence.parseRightHandSide(operation, this);
            expression2.done(resultType);
            expression2 = expression2.precede();
        }
        expression2.drop();
    }

    private void parseLabeledExpression() {
        PsiBuilder.Marker expression2 = this.mark();
        this.parseLabelDefinition();
        this.parsePrefixExpression();
        expression2.done(KtNodeTypes.LABELED_EXPRESSION);
    }

    private void parsePrefixExpression() {
        if (this.at(KtTokens.AT)) {
            if (!this.parseLocalDeclaration(false, false)) {
                PsiBuilder.Marker expression2 = this.mark();
                this.myKotlinParsing.parseAnnotations(KotlinParsing.AnnotationParsingMode.DEFAULT);
                this.parsePrefixExpression();
                expression2.done(KtNodeTypes.ANNOTATED_EXPRESSION);
            }
        } else {
            this.myBuilder.disableJoiningComplexTokens();
            if (this.isAtLabelDefinitionOrMissingIdentifier()) {
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parseLabeledExpression();
            } else if (this.atSet(Precedence.PREFIX.getOperations())) {
                PsiBuilder.Marker expression3 = this.mark();
                this.parseOperationReference();
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parsePrefixExpression();
                expression3.done(KtNodeTypes.PREFIX_EXPRESSION);
            } else {
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parsePostfixExpression();
            }
        }
    }

    private boolean parseDoubleColonSuffix(@NotNull PsiBuilder.Marker expression2) {
        if (expression2 == null) {
            KotlinExpressionParsing.$$$reportNull$$$0(0);
        }
        if (!this.at(KtTokens.COLONCOLON)) {
            return false;
        }
        this.advance();
        if (this.at(KtTokens.CLASS_KEYWORD)) {
            this.advance();
            expression2.done(KtNodeTypes.CLASS_LITERAL_EXPRESSION);
            return true;
        }
        this.parseSimpleNameExpression();
        if (this.at(KtTokens.LT)) {
            PsiBuilder.Marker typeArgumentList = this.mark();
            if (this.myKotlinParsing.tryParseTypeArgumentList(TYPE_ARGUMENT_LIST_STOPPERS)) {
                typeArgumentList.error("Type arguments are not allowed");
            } else {
                typeArgumentList.rollbackTo();
            }
        }
        if (this.at(KtTokens.LPAR) && !this.myBuilder.newlineBeforeCurrentToken()) {
            PsiBuilder.Marker lpar = this.mark();
            this.parseCallSuffix();
            lpar.error("This syntax is reserved for future use; to call a reference, enclose it in parentheses: (foo::bar)(args)");
        }
        expression2.done(KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION);
        return true;
    }

    private void skipQuestionMarksBeforeDoubleColon() {
        if (this.at(KtTokens.QUEST)) {
            int k = 1;
            while (this.lookahead(k) == KtTokens.QUEST) {
                ++k;
            }
            if (this.lookahead(k) == KtTokens.COLONCOLON) {
                while (k > 0) {
                    this.advance();
                    --k;
                }
            }
        }
    }

    private void parsePostfixExpression() {
        boolean firstExpressionParsed;
        PsiBuilder.Marker expression2 = this.mark();
        boolean bl = firstExpressionParsed = this.at(KtTokens.COLONCOLON) ? this.parseDoubleColonSuffix(this.mark()) : this.parseAtomicExpression();
        while (!this.interruptedWithNewLine()) {
            if (this.at(KtTokens.LBRACKET)) {
                this.parseArrayAccess();
                expression2.done(KtNodeTypes.ARRAY_ACCESS_EXPRESSION);
            } else if (this.parseCallSuffix()) {
                expression2.done(KtNodeTypes.CALL_EXPRESSION);
            } else if (this.at(KtTokens.DOT) || this.at(KtTokens.SAFE_ACCESS)) {
                IElementType expressionType = this.at(KtTokens.DOT) ? KtNodeTypes.DOT_QUALIFIED_EXPRESSION : KtNodeTypes.SAFE_ACCESS_EXPRESSION;
                this.advance();
                if (!firstExpressionParsed) {
                    expression2.drop();
                    expression2 = this.mark();
                    firstExpressionParsed = this.parseAtomicExpression();
                    continue;
                }
                this.parseSelectorCallExpression();
                expression2.done(expressionType);
            } else if (this.atSet(Precedence.POSTFIX.getOperations())) {
                this.parseOperationReference();
                expression2.done(KtNodeTypes.POSTFIX_EXPRESSION);
            } else {
                this.skipQuestionMarksBeforeDoubleColon();
                if (!this.parseDoubleColonSuffix(expression2)) break;
            }
            expression2 = expression2.precede();
        }
        expression2.drop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseCallSuffix() {
        if (this.parseCallWithClosure()) return true;
        if (this.at(KtTokens.LPAR)) {
            this.parseValueArgumentList();
            this.parseCallWithClosure();
            return true;
        } else {
            if (!this.at(KtTokens.LT)) return false;
            PsiBuilder.Marker typeArgumentList = this.mark();
            if (this.myKotlinParsing.tryParseTypeArgumentList(TYPE_ARGUMENT_LIST_STOPPERS)) {
                typeArgumentList.done(KtNodeTypes.TYPE_ARGUMENT_LIST);
                if (!this.myBuilder.newlineBeforeCurrentToken() && this.at(KtTokens.LPAR)) {
                    this.parseValueArgumentList();
                }
                this.parseCallWithClosure();
                return true;
            } else {
                typeArgumentList.rollbackTo();
                return false;
            }
        }
    }

    private void parseSelectorCallExpression() {
        PsiBuilder.Marker mark = this.mark();
        this.parseAtomicExpression();
        if (!this.myBuilder.newlineBeforeCurrentToken() && this.parseCallSuffix()) {
            mark.done(KtNodeTypes.CALL_EXPRESSION);
        } else {
            mark.drop();
        }
    }

    private void parseOperationReference() {
        PsiBuilder.Marker operationReference = this.mark();
        this.advance();
        operationReference.done(KtNodeTypes.OPERATION_REFERENCE);
    }

    protected boolean parseCallWithClosure() {
        PsiBuilder.Marker argument;
        boolean success = false;
        while (true) {
            argument = this.mark();
            if (!this.parseAnnotatedLambda(false)) break;
            argument.done(KtNodeTypes.LAMBDA_ARGUMENT);
            success = true;
        }
        argument.drop();
        return success;
    }

    private boolean parseAnnotatedLambda(boolean preferBlock) {
        PsiBuilder.Marker annotated = this.mark();
        boolean wereAnnotations = this.myKotlinParsing.parseAnnotations(KotlinParsing.AnnotationParsingMode.DEFAULT);
        PsiBuilder.Marker labeled = this.mark();
        boolean wasLabel = this.isAtLabelDefinitionOrMissingIdentifier();
        if (wasLabel) {
            this.parseLabelDefinition();
        }
        if (!this.at(KtTokens.LBRACE)) {
            annotated.rollbackTo();
            return false;
        }
        this.parseFunctionLiteral(preferBlock, true);
        KotlinExpressionParsing.doneOrDrop(labeled, KtNodeTypes.LABELED_EXPRESSION, wasLabel);
        KotlinExpressionParsing.doneOrDrop(annotated, KtNodeTypes.ANNOTATED_EXPRESSION, wereAnnotations);
        return true;
    }

    private static void doneOrDrop(@NotNull PsiBuilder.Marker marker, @NotNull IElementType type2, boolean condition) {
        if (marker == null) {
            KotlinExpressionParsing.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            KotlinExpressionParsing.$$$reportNull$$$0(2);
        }
        if (condition) {
            marker.done(type2);
        } else {
            marker.drop();
        }
    }

    boolean isAtLabelDefinitionOrMissingIdentifier() {
        return this.at(KtTokens.IDENTIFIER) && this.myBuilder.rawLookup(1) == KtTokens.AT || this.at(KtTokens.AT);
    }

    private boolean parseAtomicExpression() {
        boolean ok = true;
        switch (this.getTokenId()) {
            case 52: {
                this.parseParenthesizedExpression();
                break;
            }
            case 48: {
                this.parseCollectionLiteralExpression();
                break;
            }
            case 21: {
                this.parseThisExpression();
                break;
            }
            case 22: {
                this.parseSuperExpression();
                break;
            }
            case 36: {
                this.parseObjectLiteral();
                break;
            }
            case 32: {
                this.parseThrow();
                break;
            }
            case 33: {
                this.parseReturn();
                break;
            }
            case 35: {
                this.parseJump(KtNodeTypes.CONTINUE);
                break;
            }
            case 34: {
                this.parseJump(KtNodeTypes.BREAK);
                break;
            }
            case 37: {
                this.parseIf();
                break;
            }
            case 42: {
                this.parseWhen();
                break;
            }
            case 38: {
                this.parseTry();
                break;
            }
            case 26: {
                this.parseFor();
                break;
            }
            case 40: {
                this.parseWhile();
                break;
            }
            case 41: {
                this.parseDoWhile();
                break;
            }
            case 46: {
                this.parseSimpleNameExpression();
                break;
            }
            case 50: {
                this.parseFunctionLiteral();
                break;
            }
            case 10: 
            case 147: {
                this.parseStringTemplate();
                break;
            }
            case 28: 
            case 29: {
                this.parseOneTokenExpression(KtNodeTypes.BOOLEAN_CONSTANT);
                break;
            }
            case 6: {
                this.parseOneTokenExpression(KtNodeTypes.INTEGER_CONSTANT);
                break;
            }
            case 8: {
                this.parseOneTokenExpression(KtNodeTypes.CHARACTER_CONSTANT);
                break;
            }
            case 7: {
                this.parseOneTokenExpression(KtNodeTypes.FLOAT_CONSTANT);
                break;
            }
            case 27: {
                this.parseOneTokenExpression(KtNodeTypes.NULL);
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 43: {
                if (this.parseLocalDeclaration(this.myBuilder.newlineBeforeCurrentToken(), false)) break;
                ok = false;
                break;
            }
            default: {
                ok = false;
            }
        }
        if (!ok) {
            this.errorWithRecovery("Expecting an element", TokenSet.orSet(EXPRESSION_FOLLOW, TokenSet.create(KtTokens.LONG_TEMPLATE_ENTRY_END)));
        }
        return ok;
    }

    private void parseStringTemplate() {
        assert (this._at(KtTokens.INTERPOLATION_PREFIX) || this._at(KtTokens.OPEN_QUOTE));
        PsiBuilder.Marker template = this.mark();
        if (this.at(KtTokens.INTERPOLATION_PREFIX)) {
            this.advance();
        }
        assert (this._at(KtTokens.OPEN_QUOTE));
        this.advance();
        while (!(this.eof() || this.at(KtTokens.CLOSING_QUOTE) || this.at(KtTokens.DANGLING_NEWLINE))) {
            this.parseStringTemplateElement();
        }
        if (this.at(KtTokens.DANGLING_NEWLINE)) {
            this.errorAndAdvance("Expecting '\"'");
        } else {
            this.expect(KtTokens.CLOSING_QUOTE, "Expecting '\"'");
        }
        template.done(KtNodeTypes.STRING_TEMPLATE);
    }

    private void parseStringTemplateElement() {
        if (this.at(KtTokens.REGULAR_STRING_PART)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done(KtNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY);
        } else if (this.at(KtTokens.ESCAPE_SEQUENCE)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done(KtNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY);
        } else if (this.at(KtTokens.SHORT_TEMPLATE_ENTRY_START)) {
            PsiBuilder.Marker entry = this.mark();
            this.advance();
            if (this.at(KtTokens.THIS_KEYWORD)) {
                PsiBuilder.Marker thisExpression = this.mark();
                PsiBuilder.Marker reference2 = this.mark();
                this.advance();
                reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
                thisExpression.done(KtNodeTypes.THIS_EXPRESSION);
            } else {
                KtToken keyword = KEYWORD_TEXTS.get(this.myBuilder.getTokenText());
                if (keyword != null) {
                    this.myBuilder.remapCurrentToken(keyword);
                    this.errorAndAdvance("Keyword cannot be used as a reference");
                } else {
                    PsiBuilder.Marker reference3 = this.mark();
                    this.expect(KtTokens.IDENTIFIER, "Expecting a name");
                    reference3.done(KtNodeTypes.REFERENCE_EXPRESSION);
                }
            }
            entry.done(KtNodeTypes.SHORT_STRING_TEMPLATE_ENTRY);
        } else if (this.at(KtTokens.LONG_TEMPLATE_ENTRY_START)) {
            PsiBuilder.Marker longTemplateEntry = this.mark();
            this.advance();
            while (!this.eof()) {
                int offset = this.myBuilder.getCurrentOffset();
                this.parseExpression();
                if (this._at(KtTokens.LONG_TEMPLATE_ENTRY_END)) {
                    this.advance();
                    break;
                }
                this.error("Expecting '}'");
                if (offset != this.myBuilder.getCurrentOffset()) continue;
                this.advance();
            }
            longTemplateEntry.done(KtNodeTypes.LONG_STRING_TEMPLATE_ENTRY);
        } else {
            this.errorAndAdvance("Unexpected token in a string template");
        }
    }

    private void parseWhen() {
        assert (this._at(KtTokens.WHEN_KEYWORD));
        PsiBuilder.Marker when = this.mark();
        this.advance();
        this.myBuilder.disableNewlines();
        if (this.at(KtTokens.LPAR)) {
            this.advanceAt(KtTokens.LPAR);
            PsiBuilder.Marker atWhenStart = this.mark();
            this.myKotlinParsing.parseAnnotationsList(EQ_RPAR_SET);
            if (this.at(KtTokens.VAL_KEYWORD) || this.at(KtTokens.VAR_KEYWORD)) {
                IElementType declType = this.myKotlinParsing.parseProperty(KotlinParsing.DeclarationParsingMode.LOCAL);
                atWhenStart.done(declType);
                atWhenStart.setCustomEdgeTokenBinders(PrecedingDocCommentsBinder.INSTANCE, TrailingCommentsBinder.INSTANCE);
            } else {
                atWhenStart.drop();
                this.parseExpression();
            }
            this.expect(KtTokens.RPAR, "Expecting ')'");
        }
        this.myBuilder.restoreNewlinesState();
        this.myBuilder.enableNewlines();
        if (this.expect(KtTokens.LBRACE, "Expecting '{'")) {
            while (!this.eof() && !this.at(KtTokens.RBRACE)) {
                this.parseWhenEntry();
            }
            this.expect(KtTokens.RBRACE, "Expecting '}'");
        }
        this.myBuilder.restoreNewlinesState();
        when.done(KtNodeTypes.WHEN);
    }

    private void parseWhenEntry() {
        PsiBuilder.Marker entry = this.mark();
        if (this.at(KtTokens.ELSE_KEYWORD)) {
            this.advance();
            this.parseWhenEntryGuardOrSuggest();
            if (!this.at(KtTokens.ARROW)) {
                this.errorUntil("Expecting '->'", TokenSet.create(KtTokens.ARROW, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.EOL_OR_SEMICOLON));
            }
            if (this.at(KtTokens.ARROW)) {
                this.advance();
                if (this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
                    this.error("Expecting an element");
                } else {
                    this.parseControlStructureBody();
                }
            } else if (this.at(KtTokens.LBRACE)) {
                this.parseControlStructureBody();
            } else if (!this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
                this.errorAndAdvance("Expecting '->'");
            }
        } else {
            this.parseWhenEntryNotElse();
        }
        entry.done(KtNodeTypes.WHEN_ENTRY);
        this.consumeIf(KtTokens.SEMICOLON);
    }

    private void parseWhenEntryNotElse() {
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance("Expecting a when-condition");
                continue;
            }
            this.parseWhenCondition();
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
            if (this.at(KtTokens.ARROW)) break;
        }
        this.parseWhenEntryGuardOrSuggest();
        this.expect(KtTokens.ARROW, "Expecting '->'", WHEN_CONDITION_RECOVERY_SET);
        if (this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
            this.error("Expecting an element");
        } else {
            this.parseControlStructureBody();
        }
    }

    private void parseWhenCondition() {
        PsiBuilder.Marker condition = this.mark();
        this.myBuilder.disableNewlines();
        switch (this.getTokenId()) {
            case 31: 
            case 92: {
                PsiBuilder.Marker mark = this.mark();
                this.advance();
                mark.done(KtNodeTypes.OPERATION_REFERENCE);
                if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                    this.error("Expecting an element");
                } else {
                    this.parseExpression();
                }
                condition.done(KtNodeTypes.WHEN_CONDITION_IN_RANGE);
                break;
            }
            case 30: 
            case 93: {
                this.advance();
                if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                    this.error("Expecting a type");
                } else {
                    this.myKotlinParsing.parseTypeRef();
                }
                condition.done(KtNodeTypes.WHEN_CONDITION_IS_PATTERN);
                break;
            }
            case 39: 
            case 51: 
            case 54: 
            case 68: {
                this.error("Expecting an expression, is-condition or in-condition");
                condition.done(KtNodeTypes.WHEN_CONDITION_EXPRESSION);
                break;
            }
            default: {
                this.parseExpression();
                condition.done(KtNodeTypes.WHEN_CONDITION_EXPRESSION);
            }
        }
        this.myBuilder.restoreNewlinesState();
    }

    private void parseWhenEntryGuardOrSuggest() {
        if (this.at(KtTokens.ANDAND)) {
            this.errorUntil("Unexpected '&&', use 'if' to introduce additional conditions; see https://kotl.in/guards-in-when", TokenSet.create(KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.ARROW));
        } else if (this.at(KtTokens.IF_KEYWORD)) {
            this.parseWhenEntryGuard();
        }
    }

    private void parseWhenEntryGuard() {
        assert (this._at(KtTokens.IF_KEYWORD));
        PsiBuilder.Marker guard = this.mark();
        this.advance();
        this.parseExpression();
        guard.done(KtNodeTypes.WHEN_ENTRY_GUARD);
    }

    private void parseArrayAccess() {
        this.parseAsCollectionLiteralExpression(KtNodeTypes.INDICES, false, "Expecting an index element");
    }

    private void parseCollectionLiteralExpression() {
        this.parseAsCollectionLiteralExpression(KtNodeTypes.COLLECTION_LITERAL_EXPRESSION, true, "Expecting an element");
    }

    private void parseAsCollectionLiteralExpression(IElementType nodeType, boolean canBeEmpty, String missingElementErrorMessage) {
        assert (this._at(KtTokens.LBRACKET));
        PsiBuilder.Marker innerExpressions = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (!canBeEmpty && this.at(KtTokens.RBRACKET)) {
            this.error(missingElementErrorMessage);
        } else {
            this.parseInnerExpressions(missingElementErrorMessage);
        }
        this.expect(KtTokens.RBRACKET, "Expecting ']'");
        this.myBuilder.restoreNewlinesState();
        innerExpressions.done(nodeType);
    }

    private void parseInnerExpressions(String missingElementErrorMessage) {
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance(missingElementErrorMessage);
            }
            if (this.at(KtTokens.RBRACKET)) break;
            this.parseExpression();
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
    }

    public void parseContractDescriptionBlock() {
        assert (this._at(KtTokens.CONTRACT_KEYWORD));
        this.advance();
        this.parseContractEffectList();
    }

    private void parseContractEffectList() {
        PsiBuilder.Marker block = this.mark();
        this.expect(KtTokens.LBRACKET, "Expecting '['");
        this.myBuilder.enableNewlines();
        this.parseContractEffects();
        this.expect(KtTokens.RBRACKET, "Expecting ']'");
        this.myBuilder.restoreNewlinesState();
        block.done(KtNodeTypes.CONTRACT_EFFECT_LIST);
    }

    private void parseContractEffects() {
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance("Expecting a contract effect");
            }
            if (this.at(KtTokens.RBRACKET)) break;
            PsiBuilder.Marker effect = this.mark();
            this.parseExpression();
            effect.done(KtNodeTypes.CONTRACT_EFFECT);
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
    }

    public void parseSimpleNameExpression() {
        PsiBuilder.Marker simpleName2 = this.mark();
        this.expect(KtTokens.IDENTIFIER, "Expecting an identifier");
        simpleName2.done(KtNodeTypes.REFERENCE_EXPRESSION);
    }

    private boolean parseLocalDeclaration(boolean rollbackIfDefinitelyNotExpression, boolean isScriptTopLevel) {
        PsiBuilder.Marker decl = this.mark();
        KotlinParsing.ModifierDetector detector = new KotlinParsing.ModifierDetector();
        this.myKotlinParsing.parseModifierList(detector, TokenSet.EMPTY);
        IElementType declType = this.parseLocalDeclarationRest(detector, rollbackIfDefinitelyNotExpression, isScriptTopLevel);
        if (declType != null) {
            KotlinExpressionParsing.closeDeclarationWithCommentBinders(decl, declType, declType != KtNodeTypes.PROPERTY && declType != KtNodeTypes.DESTRUCTURING_DECLARATION);
            return true;
        }
        decl.rollbackTo();
        return false;
    }

    private void parseFunctionLiteral() {
        this.parseFunctionLiteral(false, true);
    }

    public void parseFunctionLiteral(boolean preferBlock, boolean collapse) {
        assert (this._at(KtTokens.LBRACE));
        PsiBuilder.Marker literalExpression = this.mark();
        PsiBuilder.Marker literal = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        boolean paramsFound = false;
        IElementType token = this.tt();
        if (token == KtTokens.ARROW) {
            this.mark().done(KtNodeTypes.VALUE_PARAMETER_LIST);
            this.advance();
            paramsFound = true;
        } else if (token == KtTokens.IDENTIFIER || token == KtTokens.COLON || token == KtTokens.LPAR) {
            PsiBuilder.Marker rollbackMarker = this.mark();
            IElementType nextToken = this.lookahead(1);
            boolean preferParamsToExpressions = nextToken == KtTokens.COMMA || nextToken == KtTokens.COLON;
            this.parseFunctionLiteralParameterList();
            boolean bl = paramsFound = preferParamsToExpressions ? this.rollbackOrDrop(rollbackMarker, KtTokens.ARROW, "An -> is expected", KtTokens.RBRACE) : this.rollbackOrDropAt(rollbackMarker, KtTokens.ARROW);
        }
        if (!paramsFound && preferBlock) {
            literal.drop();
            this.parseStatements();
            this.expect(KtTokens.RBRACE, "Expecting '}'");
            literalExpression.done(KtNodeTypes.BLOCK);
            this.myBuilder.restoreNewlinesState();
            return;
        }
        if (collapse && this.isLazy) {
            this.myKotlinParsing.advanceBalancedBlock();
            literal.done(KtNodeTypes.FUNCTION_LITERAL);
            literalExpression.collapse(KtNodeTypes.LAMBDA_EXPRESSION);
        } else {
            PsiBuilder.Marker body2 = this.mark();
            this.parseStatements();
            body2.done(KtNodeTypes.BLOCK);
            body2.setCustomEdgeTokenBinders(KotlinWhitespaceAndCommentsBindersKt.PRECEDING_ALL_COMMENTS_BINDER, KotlinWhitespaceAndCommentsBindersKt.TRAILING_ALL_COMMENTS_BINDER);
            this.expect(KtTokens.RBRACE, "Expecting '}'");
            literal.done(KtNodeTypes.FUNCTION_LITERAL);
            literalExpression.done(KtNodeTypes.LAMBDA_EXPRESSION);
        }
        this.myBuilder.restoreNewlinesState();
    }

    private boolean rollbackOrDropAt(PsiBuilder.Marker rollbackMarker, IElementType dropAt) {
        if (this.at(dropAt)) {
            this.advance();
            rollbackMarker.drop();
            return true;
        }
        rollbackMarker.rollbackTo();
        return false;
    }

    private boolean rollbackOrDrop(PsiBuilder.Marker rollbackMarker, KtToken expected, String expectMessage, IElementType validForDrop) {
        if (this.at(expected)) {
            this.advance();
            rollbackMarker.drop();
            return true;
        }
        if (this.at(validForDrop)) {
            rollbackMarker.drop();
            this.expect(expected, expectMessage);
            return true;
        }
        rollbackMarker.rollbackTo();
        return false;
    }

    private void parseFunctionLiteralParameterList() {
        PsiBuilder.Marker parameterList2 = this.mark();
        while (!this.eof() && !this.at(KtTokens.ARROW)) {
            PsiBuilder.Marker parameter2 = this.mark();
            if (this.at(KtTokens.COLON)) {
                this.error("Expecting parameter name");
            } else if (this.at(KtTokens.LPAR)) {
                PsiBuilder.Marker destructuringDeclaration = this.mark();
                this.myKotlinParsing.parseMultiDeclarationName(TOKEN_SET_TO_FOLLOW_AFTER_DESTRUCTURING_DECLARATION_IN_LAMBDA, TOKEN_SET_TO_FOLLOW_AFTER_DESTRUCTURING_DECLARATION_IN_LAMBDA_RECOVERY);
                destructuringDeclaration.done(KtNodeTypes.DESTRUCTURING_DECLARATION);
            } else {
                this.expect(KtTokens.IDENTIFIER, "Expecting parameter name", ARROW_SET);
            }
            if (this.at(KtTokens.COLON)) {
                this.advance();
                this.myKotlinParsing.parseTypeRef(ARROW_COMMA_SET);
            }
            parameter2.done(KtNodeTypes.VALUE_PARAMETER);
            if (this.at(KtTokens.ARROW)) break;
            if (this.at(KtTokens.COMMA)) {
                this.advance();
                continue;
            }
            this.error("Expecting '->' or ','");
            break;
        }
        parameterList2.done(KtNodeTypes.VALUE_PARAMETER_LIST);
    }

    public void parseStatements() {
        this.parseStatements(false);
    }

    public void parseStatements(boolean isScriptTopLevel) {
        while (this.at(KtTokens.SEMICOLON)) {
            this.advance();
        }
        while (!this.eof() && !this.at(KtTokens.RBRACE)) {
            if (!this.atSet(STATEMENT_FIRST)) {
                this.errorAndAdvance("Expecting an element");
            }
            if (this.atSet(STATEMENT_FIRST)) {
                this.parseStatement(isScriptTopLevel);
            }
            if (this.at(KtTokens.SEMICOLON)) {
                while (this.at(KtTokens.SEMICOLON)) {
                    this.advance();
                }
                continue;
            }
            if (this.at(KtTokens.RBRACE)) break;
            if (isScriptTopLevel || this.myBuilder.newlineBeforeCurrentToken()) continue;
            String severalStatementsError = "Unexpected tokens (use ';' to separate expressions on the same line)";
            if (this.atSet(STATEMENT_NEW_LINE_QUICK_RECOVERY_SET)) {
                this.error(severalStatementsError);
                continue;
            }
            this.errorUntil(severalStatementsError, TokenSet.create(KtTokens.EOL_OR_SEMICOLON, KtTokens.LBRACE, KtTokens.RBRACE));
        }
    }

    private void parseStatement(boolean isScriptTopLevel) {
        if (!this.parseLocalDeclaration(false, isScriptTopLevel)) {
            if (!this.atSet(EXPRESSION_FIRST)) {
                this.errorAndAdvance("Expecting a statement");
            } else if (isScriptTopLevel) {
                PsiBuilder.Marker scriptInitializer = this.mark();
                this.parseBlockLevelExpression();
                scriptInitializer.done(KtNodeTypes.SCRIPT_INITIALIZER);
            } else {
                this.parseBlockLevelExpression();
            }
        }
    }

    private void parseBlockLevelExpression() {
        if (this.at(KtTokens.AT)) {
            PsiBuilder.Marker expression2 = this.mark();
            this.myKotlinParsing.parseAnnotations(KotlinParsing.AnnotationParsingMode.DEFAULT);
            if (!this.myBuilder.newlineBeforeCurrentToken()) {
                expression2.rollbackTo();
                this.parseExpression();
                return;
            }
            this.parseBlockLevelExpression();
            expression2.done(KtNodeTypes.ANNOTATED_EXPRESSION);
            return;
        }
        this.parseExpression();
    }

    @Nullable
    private IElementType parseLocalDeclarationRest(@NotNull KotlinParsing.ModifierDetector modifierDetector, boolean failIfDefinitelyNotExpression, boolean isScriptTopLevel) {
        IElementType lookahead;
        if (modifierDetector == null) {
            KotlinExpressionParsing.$$$reportNull$$$0(3);
        }
        IElementType keywordToken = this.tt();
        if (failIfDefinitelyNotExpression) {
            if (keywordToken != KtTokens.FUN_KEYWORD) {
                return null;
            }
            return this.myKotlinParsing.parseFunction(true);
        }
        if (keywordToken == KtTokens.OBJECT_KEYWORD && ((lookahead = this.lookahead(1)) == KtTokens.COLON || lookahead == KtTokens.LBRACE)) {
            return null;
        }
        return this.myKotlinParsing.parseCommonDeclaration(modifierDetector, KotlinParsing.NameParsingMode.REQUIRED, isScriptTopLevel ? KotlinParsing.DeclarationParsingMode.SCRIPT_TOPLEVEL : KotlinParsing.DeclarationParsingMode.LOCAL);
    }

    private void parseDoWhile() {
        assert (this._at(KtTokens.DO_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        if (!this.at(KtTokens.WHILE_KEYWORD)) {
            this.parseLoopBody();
        }
        if (this.expect(KtTokens.WHILE_KEYWORD, "Expecting 'while' followed by a post-condition")) {
            this.parseCondition();
        }
        loop.done(KtNodeTypes.DO_WHILE);
    }

    private void parseWhile() {
        assert (this._at(KtTokens.WHILE_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        this.parseCondition();
        this.parseLoopBody();
        loop.done(KtNodeTypes.WHILE);
    }

    private void parseFor() {
        assert (this._at(KtTokens.FOR_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        if (this.expect(KtTokens.LPAR, "Expecting '(' to open a loop range", EXPRESSION_FIRST)) {
            this.myBuilder.disableNewlines();
            if (!this.at(KtTokens.RPAR)) {
                PsiBuilder.Marker parameter2 = this.mark();
                if (!this.at(KtTokens.IN_KEYWORD)) {
                    this.myKotlinParsing.parseModifierList(IN_KEYWORD_R_PAR_COLON_SET);
                }
                if (this.at(KtTokens.VAL_KEYWORD) || this.at(KtTokens.VAR_KEYWORD)) {
                    this.advance();
                }
                if (this.at(KtTokens.LPAR)) {
                    PsiBuilder.Marker destructuringDeclaration = this.mark();
                    this.myKotlinParsing.parseMultiDeclarationName(IN_KEYWORD_L_BRACE_SET, IN_KEYWORD_L_BRACE_RECOVERY_SET);
                    destructuringDeclaration.done(KtNodeTypes.DESTRUCTURING_DECLARATION);
                } else {
                    this.expect(KtTokens.IDENTIFIER, "Expecting a variable name", COLON_IN_KEYWORD_SET);
                    if (this.at(KtTokens.COLON)) {
                        this.advance();
                        this.myKotlinParsing.parseTypeRef(IN_KEYWORD_SET);
                    }
                }
                parameter2.done(KtNodeTypes.VALUE_PARAMETER);
                if (this.expect(KtTokens.IN_KEYWORD, "Expecting 'in'", L_PAR_L_BRACE_R_PAR_SET)) {
                    PsiBuilder.Marker range = this.mark();
                    this.parseExpression();
                    range.done(KtNodeTypes.LOOP_RANGE);
                }
            } else {
                this.error("Expecting a variable name");
            }
            this.expectNoAdvance(KtTokens.RPAR, "Expecting ')'");
            this.myBuilder.restoreNewlinesState();
        }
        this.parseLoopBody();
        loop.done(KtNodeTypes.FOR);
    }

    private void parseControlStructureBody() {
        if (!this.parseAnnotatedLambda(true)) {
            this.parseBlockLevelExpression();
        }
    }

    private void parseLoopBody() {
        PsiBuilder.Marker body2 = this.mark();
        if (!this.at(KtTokens.SEMICOLON)) {
            this.parseControlStructureBody();
        }
        body2.done(KtNodeTypes.BODY);
    }

    private void parseTry() {
        assert (this._at(KtTokens.TRY_KEYWORD));
        PsiBuilder.Marker tryExpression = this.mark();
        this.advance();
        this.myKotlinParsing.parseBlock();
        boolean catchOrFinally = false;
        while (this.at(KtTokens.CATCH_KEYWORD)) {
            catchOrFinally = true;
            PsiBuilder.Marker catchBlock = this.mark();
            this.advance();
            if (this.atSet(TRY_CATCH_RECOVERY_TOKEN_SET)) {
                this.error("Expecting exception variable declaration");
            } else {
                PsiBuilder.Marker parameters2 = this.mark();
                this.expect(KtTokens.LPAR, "Expecting '('", TRY_CATCH_RECOVERY_TOKEN_SET);
                if (!this.atSet(TRY_CATCH_RECOVERY_TOKEN_SET)) {
                    this.myKotlinParsing.parseValueParameter(true);
                    if (this.at(KtTokens.COMMA)) {
                        this.advance();
                    }
                    this.expect(KtTokens.RPAR, "Expecting ')'", TRY_CATCH_RECOVERY_TOKEN_SET);
                } else {
                    this.error("Expecting exception variable declaration");
                }
                parameters2.done(KtNodeTypes.VALUE_PARAMETER_LIST);
            }
            if (this.at(KtTokens.LBRACE)) {
                this.myKotlinParsing.parseBlock();
            } else {
                this.error("Expecting a block: { ... }");
            }
            catchBlock.done(KtNodeTypes.CATCH);
        }
        if (this.at(KtTokens.FINALLY_KEYWORD)) {
            catchOrFinally = true;
            PsiBuilder.Marker finallyBlock = this.mark();
            this.advance();
            this.myKotlinParsing.parseBlock();
            finallyBlock.done(KtNodeTypes.FINALLY);
        }
        if (!catchOrFinally) {
            this.error("Expecting 'catch' or 'finally'");
        }
        tryExpression.done(KtNodeTypes.TRY);
    }

    private void parseIf() {
        assert (this._at(KtTokens.IF_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseCondition();
        PsiBuilder.Marker thenBranch = this.mark();
        if (!this.at(KtTokens.ELSE_KEYWORD) && !this.at(KtTokens.SEMICOLON)) {
            this.parseControlStructureBody();
        }
        if (this.at(KtTokens.SEMICOLON) && this.lookahead(1) == KtTokens.ELSE_KEYWORD) {
            this.advance();
        }
        thenBranch.done(KtNodeTypes.THEN);
        if (this.at(KtTokens.ELSE_KEYWORD) && this.lookahead(1) != KtTokens.ARROW) {
            this.advance();
            PsiBuilder.Marker elseBranch = this.mark();
            if (!this.at(KtTokens.SEMICOLON)) {
                this.parseControlStructureBody();
            }
            elseBranch.done(KtNodeTypes.ELSE);
        }
        marker.done(KtNodeTypes.IF);
    }

    private void parseCondition() {
        this.myBuilder.disableNewlines();
        if (this.expect(KtTokens.LPAR, "Expecting a condition in parentheses '(...)'", EXPRESSION_FIRST)) {
            PsiBuilder.Marker condition = this.mark();
            this.parseExpression();
            condition.done(KtNodeTypes.CONDITION);
            this.expect(KtTokens.RPAR, "Expecting ')");
        }
        this.myBuilder.restoreNewlinesState();
    }

    private void parseJump(IElementType type2) {
        assert (this._at(KtTokens.BREAK_KEYWORD) || this._at(KtTokens.CONTINUE_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseLabelReferenceWithNoWhitespace();
        marker.done(type2);
    }

    private void parseReturn() {
        assert (this._at(KtTokens.RETURN_KEYWORD));
        PsiBuilder.Marker returnExpression = this.mark();
        this.advance();
        this.parseLabelReferenceWithNoWhitespace();
        if (this.atSet(EXPRESSION_FIRST) && !this.at(KtTokens.EOL_OR_SEMICOLON)) {
            this.parseExpression();
        }
        returnExpression.done(KtNodeTypes.RETURN);
    }

    private void parseLabelReferenceWithNoWhitespace() {
        if (this.at(KtTokens.AT) && !this.myBuilder.newlineBeforeCurrentToken()) {
            if (KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(-1))) {
                this.error("There should be no space or comments before '@' in label reference");
            }
            this.parseLabelReference();
        }
    }

    void parseLabelDefinition() {
        assert (this.isAtLabelDefinitionOrMissingIdentifier()) : "Callers must check that current token is IDENTIFIER followed with '@'";
        PsiBuilder.Marker labelWrap = this.mark();
        PsiBuilder.Marker mark = this.mark();
        if (this.at(KtTokens.AT)) {
            this.errorAndAdvance("Expecting identifier before '@' in label definition");
            labelWrap.drop();
            mark.drop();
            return;
        }
        this.advance();
        this.advance();
        mark.done(KtNodeTypes.LABEL);
        labelWrap.done(KtNodeTypes.LABEL_QUALIFIER);
    }

    private void parseLabelReference() {
        assert (this._at(KtTokens.AT));
        PsiBuilder.Marker labelWrap = this.mark();
        PsiBuilder.Marker mark = this.mark();
        if (this.myBuilder.rawLookup(1) != KtTokens.IDENTIFIER) {
            this.errorAndAdvance("Label must be named");
            labelWrap.drop();
            mark.drop();
            return;
        }
        this.advance();
        this.advance();
        mark.done(KtNodeTypes.LABEL);
        labelWrap.done(KtNodeTypes.LABEL_QUALIFIER);
    }

    private void parseThrow() {
        assert (this._at(KtTokens.THROW_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseExpression();
        marker.done(KtNodeTypes.THROW);
    }

    private void parseParenthesizedExpression() {
        assert (this._at(KtTokens.LPAR));
        PsiBuilder.Marker mark = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (this.at(KtTokens.RPAR)) {
            this.error("Expecting an expression");
        } else {
            this.parseExpression();
        }
        this.expect(KtTokens.RPAR, "Expecting ')'");
        this.myBuilder.restoreNewlinesState();
        mark.done(KtNodeTypes.PARENTHESIZED);
    }

    private void parseThisExpression() {
        assert (this._at(KtTokens.THIS_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        PsiBuilder.Marker thisReference = this.mark();
        this.advance();
        thisReference.done(KtNodeTypes.REFERENCE_EXPRESSION);
        this.parseLabelReferenceWithNoWhitespace();
        mark.done(KtNodeTypes.THIS_EXPRESSION);
    }

    private void parseSuperExpression() {
        assert (this._at(KtTokens.SUPER_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        PsiBuilder.Marker superReference = this.mark();
        this.advance();
        superReference.done(KtNodeTypes.REFERENCE_EXPRESSION);
        if (this.at(KtTokens.LT)) {
            PsiBuilder.Marker supertype = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            this.myKotlinParsing.parseTypeRef();
            if (this.at(KtTokens.GT)) {
                this.advance();
                supertype.drop();
            } else {
                supertype.rollbackTo();
            }
            this.myBuilder.restoreNewlinesState();
        }
        this.parseLabelReferenceWithNoWhitespace();
        mark.done(KtNodeTypes.SUPER_EXPRESSION);
    }

    public void parseValueArgumentList() {
        PsiBuilder.Marker list = this.mark();
        this.myBuilder.disableNewlines();
        if (this.expect(KtTokens.LPAR, "Expecting an argument list", EXPRESSION_FOLLOW)) {
            if (!this.at(KtTokens.RPAR)) {
                while (true) {
                    if (this.at(KtTokens.COMMA)) {
                        this.errorAndAdvance("Expecting an argument");
                        continue;
                    }
                    this.parseValueArgument();
                    if (this.at(KtTokens.COLON) && this.lookahead(1) == KtTokens.IDENTIFIER) {
                        this.errorAndAdvance("Unexpected type specification", 2);
                    }
                    if (!this.at(KtTokens.COMMA)) {
                        if (!this.atSet(EXPRESSION_FIRST)) break;
                        this.error("Expecting ','");
                        continue;
                    }
                    this.advance();
                    if (this.at(KtTokens.RPAR)) break;
                }
            }
            this.expect(KtTokens.RPAR, "Expecting ')'", EXPRESSION_FOLLOW);
        }
        this.myBuilder.restoreNewlinesState();
        list.done(KtNodeTypes.VALUE_ARGUMENT_LIST);
    }

    private void parseValueArgument() {
        PsiBuilder.Marker argument = this.mark();
        if (this.at(KtTokens.IDENTIFIER) && this.lookahead(1) == KtTokens.EQ) {
            PsiBuilder.Marker argName = this.mark();
            PsiBuilder.Marker reference2 = this.mark();
            this.advance();
            reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
            argName.done(KtNodeTypes.VALUE_ARGUMENT_NAME);
            this.advance();
        }
        if (this.at(KtTokens.MUL)) {
            this.advance();
        }
        this.parseExpression();
        argument.done(KtNodeTypes.VALUE_ARGUMENT);
    }

    public void parseObjectLiteral() {
        PsiBuilder.Marker literal = this.mark();
        PsiBuilder.Marker declaration2 = this.mark();
        this.myKotlinParsing.parseObject(KotlinParsing.NameParsingMode.PROHIBITED, false);
        declaration2.done(KtNodeTypes.OBJECT_DECLARATION);
        literal.done(KtNodeTypes.OBJECT_LITERAL);
    }

    private void parseOneTokenExpression(IElementType type2) {
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        mark.done(type2);
    }

    @Override
    protected KotlinParsing create(SemanticWhitespaceAwarePsiBuilder builder2) {
        return this.myKotlinParsing.create(builder2);
    }

    private boolean interruptedWithNewLine() {
        return !ALLOW_NEWLINE_OPERATIONS.contains(this.tt()) && this.myBuilder.newlineBeforeCurrentToken();
    }

    static {
        Precedence[] values2;
        WHEN_CONDITION_RECOVERY_SET = TokenSet.create(KtTokens.RBRACE, KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.ELSE_KEYWORD);
        WHEN_CONDITION_RECOVERY_SET_WITH_ARROW = TokenSet.create(KtTokens.RBRACE, KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.ELSE_KEYWORD, KtTokens.ARROW, KtTokens.DOT);
        KEYWORD_TEXTS = KotlinExpressionParsing.tokenSetToMap(KtTokens.KEYWORDS);
        TOKEN_SET_TO_FOLLOW_AFTER_DESTRUCTURING_DECLARATION_IN_LAMBDA = TokenSet.create(KtTokens.ARROW, KtTokens.COMMA, KtTokens.COLON);
        TOKEN_SET_TO_FOLLOW_AFTER_DESTRUCTURING_DECLARATION_IN_LAMBDA_RECOVERY = TokenSet.orSet(TOKEN_SET_TO_FOLLOW_AFTER_DESTRUCTURING_DECLARATION_IN_LAMBDA, KotlinParsing.PARAMETER_NAME_RECOVERY_SET);
        EQ_RPAR_SET = TokenSet.create(KtTokens.EQ, KtTokens.RPAR);
        ARROW_SET = TokenSet.create(KtTokens.ARROW);
        ARROW_COMMA_SET = TokenSet.create(KtTokens.ARROW, KtTokens.COMMA);
        IN_KEYWORD_R_PAR_COLON_SET = TokenSet.create(KtTokens.IN_KEYWORD, KtTokens.RPAR, KtTokens.COLON);
        IN_KEYWORD_L_BRACE_SET = TokenSet.create(KtTokens.IN_KEYWORD, KtTokens.LBRACE);
        IN_KEYWORD_L_BRACE_RECOVERY_SET = TokenSet.orSet(IN_KEYWORD_L_BRACE_SET, KotlinParsing.PARAMETER_NAME_RECOVERY_SET);
        COLON_IN_KEYWORD_SET = TokenSet.create(KtTokens.COLON, KtTokens.IN_KEYWORD);
        L_PAR_L_BRACE_R_PAR_SET = TokenSet.create(KtTokens.LPAR, KtTokens.LBRACE, KtTokens.RPAR);
        IN_KEYWORD_SET = TokenSet.create(KtTokens.IN_KEYWORD);
        TRY_CATCH_RECOVERY_TOKEN_SET = TokenSet.create(KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.FINALLY_KEYWORD, KtTokens.CATCH_KEYWORD);
        TYPE_ARGUMENT_LIST_STOPPERS = TokenSet.create(KtTokens.INTEGER_LITERAL, KtTokens.FLOAT_LITERAL, KtTokens.CHARACTER_LITERAL, KtTokens.INTERPOLATION_PREFIX, KtTokens.OPEN_QUOTE, KtTokens.PACKAGE_KEYWORD, KtTokens.AS_KEYWORD, KtTokens.TYPE_ALIAS_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.CLASS_KEYWORD, KtTokens.THIS_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.FOR_KEYWORD, KtTokens.NULL_KEYWORD, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.IS_KEYWORD, KtTokens.THROW_KEYWORD, KtTokens.RETURN_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.IF_KEYWORD, KtTokens.TRY_KEYWORD, KtTokens.ELSE_KEYWORD, KtTokens.WHILE_KEYWORD, KtTokens.DO_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.RBRACKET, KtTokens.RBRACE, KtTokens.RPAR, KtTokens.PLUSPLUS, KtTokens.MINUSMINUS, KtTokens.EXCLEXCL, KtTokens.PLUS, KtTokens.MINUS, KtTokens.EXCL, KtTokens.DIV, KtTokens.PERC, KtTokens.LTEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.ANDAND, KtTokens.OROR, KtTokens.SAFE_ACCESS, KtTokens.ELVIS, KtTokens.SEMICOLON, KtTokens.RANGE, KtTokens.RANGE_UNTIL, KtTokens.EQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PERCEQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.NOT_IN, KtTokens.NOT_IS, KtTokens.COLONCOLON, KtTokens.COLON);
        EXPRESSION_FIRST = TokenSet.create(KtTokens.MINUS, KtTokens.PLUS, KtTokens.MINUSMINUS, KtTokens.PLUSPLUS, KtTokens.EXCL, KtTokens.EXCLEXCL, KtTokens.COLONCOLON, KtTokens.LPAR, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.INTERPOLATION_PREFIX, KtTokens.OPEN_QUOTE, KtTokens.INTEGER_LITERAL, KtTokens.CHARACTER_LITERAL, KtTokens.FLOAT_LITERAL, KtTokens.NULL_KEYWORD, KtTokens.LBRACE, KtTokens.FUN_KEYWORD, KtTokens.THIS_KEYWORD, KtTokens.SUPER_KEYWORD, KtTokens.IF_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.TRY_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.THROW_KEYWORD, KtTokens.RETURN_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.FOR_KEYWORD, KtTokens.WHILE_KEYWORD, KtTokens.DO_KEYWORD, KtTokens.IDENTIFIER, KtTokens.AT, KtTokens.LBRACKET);
        STATEMENT_FIRST = TokenSet.orSet(EXPRESSION_FIRST, TokenSet.create(KtTokens.FUN_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.CLASS_KEYWORD, KtTokens.TYPE_ALIAS_KEYWORD), KtTokens.MODIFIER_KEYWORDS);
        STATEMENT_NEW_LINE_QUICK_RECOVERY_SET = TokenSet.orSet(TokenSet.andSet(STATEMENT_FIRST, TokenSet.andNot(KtTokens.KEYWORDS, TokenSet.create(KtTokens.IN_KEYWORD))), TokenSet.create(KtTokens.EOL_OR_SEMICOLON));
        EXPRESSION_FOLLOW = TokenSet.create(KtTokens.EOL_OR_SEMICOLON, KtTokens.ARROW, KtTokens.COMMA, KtTokens.RBRACE, KtTokens.RPAR, KtTokens.RBRACKET);
        ALLOW_NEWLINE_OPERATIONS = TokenSet.create(KtTokens.DOT, KtTokens.SAFE_ACCESS, KtTokens.COLON, KtTokens.AS_KEYWORD, KtTokens.AS_SAFE, KtTokens.ELVIS, KtTokens.ANDAND, KtTokens.OROR);
        IElementType[] operations = new HashSet();
        for (Precedence precedence : values2 = Precedence.values()) {
            operations.addAll(Arrays.asList(precedence.getOperations().getTypes()));
        }
        ALL_OPERATIONS = TokenSet.create(operations.toArray(new IElementType[0]));
        operations = KtTokens.OPERATIONS.getTypes();
        HashSet<IElementType> opSet = new HashSet<IElementType>(Arrays.asList(operations));
        IElementType[] usedOperations = ALL_OPERATIONS.getTypes();
        HashSet<IElementType> usedSet = new HashSet<IElementType>(Arrays.asList(usedOperations));
        if (opSet.size() > usedSet.size()) {
            opSet.removeAll(usedSet);
            assert (false) : opSet;
        }
        assert (usedSet.size() == opSet.size()) : "Either some ops are unused, or something a non-op is used";
        usedSet.removeAll(opSet);
        assert (usedSet.isEmpty()) : ((Object)usedSet).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierDetector";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/parsing/KotlinExpressionParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDoubleColonSuffix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doneOrDrop";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLocalDeclarationRest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Precedence
    extends Enum<Precedence> {
        public static final /* enum */ Precedence POSTFIX;
        public static final /* enum */ Precedence PREFIX;
        public static final /* enum */ Precedence AS;
        public static final /* enum */ Precedence MULTIPLICATIVE;
        public static final /* enum */ Precedence ADDITIVE;
        public static final /* enum */ Precedence RANGE;
        public static final /* enum */ Precedence SIMPLE_NAME;
        public static final /* enum */ Precedence ELVIS;
        public static final /* enum */ Precedence IN_OR_IS;
        public static final /* enum */ Precedence COMPARISON;
        public static final /* enum */ Precedence EQUALITY;
        public static final /* enum */ Precedence CONJUNCTION;
        public static final /* enum */ Precedence DISJUNCTION;
        public static final /* enum */ Precedence ASSIGNMENT;
        private Precedence higher;
        private final TokenSet operations;
        private static final /* synthetic */ Precedence[] $VALUES;

        public static Precedence[] values() {
            return (Precedence[])$VALUES.clone();
        }

        public static Precedence valueOf(String name2) {
            return Enum.valueOf(Precedence.class, name2);
        }

        private Precedence(IElementType ... operations) {
            this.operations = TokenSet.create(operations);
        }

        public void parseHigherPrecedence(KotlinExpressionParsing parser) {
            assert (this.higher != null);
            parser.parseBinaryExpression(this.higher);
        }

        public IElementType parseRightHandSide(IElementType operation, KotlinExpressionParsing parser) {
            this.parseHigherPrecedence(parser);
            return KtNodeTypes.BINARY_EXPRESSION;
        }

        @NotNull
        public final TokenSet getOperations() {
            TokenSet tokenSet = this.operations;
            if (tokenSet == null) {
                Precedence.$$$reportNull$$$0(0);
            }
            return tokenSet;
        }

        static {
            Precedence[] values2;
            POSTFIX = new Precedence(KtTokens.PLUSPLUS, KtTokens.MINUSMINUS, KtTokens.EXCLEXCL, KtTokens.DOT, KtTokens.SAFE_ACCESS);
            PREFIX = new Precedence(new IElementType[]{KtTokens.MINUS, KtTokens.PLUS, KtTokens.MINUSMINUS, KtTokens.PLUSPLUS, KtTokens.EXCL}){

                @Override
                public void parseHigherPrecedence(KotlinExpressionParsing parser) {
                    throw new IllegalStateException("Don't call this method");
                }
            };
            AS = new Precedence(new IElementType[]{KtTokens.AS_KEYWORD, KtTokens.AS_SAFE}){

                @Override
                public IElementType parseRightHandSide(IElementType operation, KotlinExpressionParsing parser) {
                    parser.myKotlinParsing.parseTypeRefWithoutIntersections();
                    return KtNodeTypes.BINARY_WITH_TYPE;
                }

                @Override
                public void parseHigherPrecedence(KotlinExpressionParsing parser) {
                    parser.parsePrefixExpression();
                }
            };
            MULTIPLICATIVE = new Precedence(KtTokens.MUL, KtTokens.DIV, KtTokens.PERC);
            ADDITIVE = new Precedence(KtTokens.PLUS, KtTokens.MINUS);
            RANGE = new Precedence(KtTokens.RANGE, KtTokens.RANGE_UNTIL);
            SIMPLE_NAME = new Precedence(KtTokens.IDENTIFIER);
            ELVIS = new Precedence(KtTokens.ELVIS);
            IN_OR_IS = new Precedence(new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.IS_KEYWORD, KtTokens.NOT_IS}){

                @Override
                public IElementType parseRightHandSide(IElementType operation, KotlinExpressionParsing parser) {
                    if (operation == KtTokens.IS_KEYWORD || operation == KtTokens.NOT_IS) {
                        parser.myKotlinParsing.parseTypeRefWithoutIntersections();
                        return KtNodeTypes.IS_EXPRESSION;
                    }
                    return super.parseRightHandSide(operation, parser);
                }
            };
            COMPARISON = new Precedence(KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ);
            EQUALITY = new Precedence(KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ);
            CONJUNCTION = new Precedence(KtTokens.ANDAND);
            DISJUNCTION = new Precedence(KtTokens.OROR);
            ASSIGNMENT = new Precedence(KtTokens.EQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PERCEQ);
            $VALUES = new Precedence[]{POSTFIX, PREFIX, AS, MULTIPLICATIVE, ADDITIVE, RANGE, SIMPLE_NAME, ELVIS, IN_OR_IS, COMPARISON, EQUALITY, CONJUNCTION, DISJUNCTION, ASSIGNMENT};
            for (Precedence precedence : values2 = Precedence.values()) {
                int ordinal = precedence.ordinal();
                precedence.higher = ordinal > 0 ? values2[ordinal - 1] : null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinExpressionParsing$Precedence", "getOperations"));
        }
    }
}

