/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/RedundantNopsCleanupMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "<init>", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "recordNopsRequiredForDebugger", "requiredNops", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "recordNopsRequiredForTryCatchBlocks", "backend"})
@SourceDebugExtension(value={"SMAP\nRedundantNopsCleanupMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantNopsCleanupMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/RedundantNopsCleanupMethodTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Util.kt\norg/jetbrains/kotlin/codegen/optimization/common/UtilKt\n*L\n1#1,112:1\n774#2:113\n865#2,2:114\n209#3,5:116\n*S KotlinDebug\n*F\n+ 1 RedundantNopsCleanupMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/RedundantNopsCleanupMethodTransformer\n*L\n75#1:113\n75#1:114,2\n89#1:116,5\n*E\n"})
public final class RedundantNopsCleanupMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        new LabelNormalizationMethodTransformer().transform(internalClassName, methodNode);
        HashSet requiredNops = new HashSet();
        this.recordNopsRequiredForTryCatchBlocks(methodNode, requiredNops);
        this.recordNopsRequiredForDebugger(methodNode, requiredNops);
        AbstractInsnNode current = methodNode.instructions.getFirst();
        while (current != null) {
            if (current.getOpcode() == 0 && !requiredNops.contains(current)) {
                AbstractInsnNode toRemove = current;
                current = current.getNext();
                methodNode.instructions.remove(toRemove);
                continue;
            }
            current = current.getNext();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void recordNopsRequiredForDebugger(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        void $this$filterTo$iv$iv;
        HashSet<LabelNode> hashSet;
        RedundantNopsCleanupMethodTransformer $this$recordNopsRequiredForDebugger_u24lambda_u242 = this;
        boolean bl = false;
        HashSet<LabelNode> $this$recordNopsRequiredForDebugger_u24lambda_u242_u24lambda_u240 = hashSet = new HashSet<LabelNode>();
        boolean $i$a$-apply-RedundantNopsCleanupMethodTransformer$recordNopsRequiredForDebugger$specialLabels$1$localVarLables$22 = false;
        for (LocalVariableNode localVariable : methodNode.localVariables) {
            $this$recordNopsRequiredForDebugger_u24lambda_u242_u24lambda_u240.add(localVariable.start);
            $this$recordNopsRequiredForDebugger_u24lambda_u242_u24lambda_u240.add(localVariable.end);
        }
        HashSet<LabelNode> localVarLables = hashSet;
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
        Iterable $this$filter$iv = insnList;
        boolean $i$f$filter = false;
        Iterable $i$a$-apply-RedundantNopsCleanupMethodTransformer$recordNopsRequiredForDebugger$specialLabels$1$localVarLables$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AbstractInsnNode it = (AbstractInsnNode)element$iv$iv;
            boolean bl2 = false;
            if (!(kotlin.collections.CollectionsKt.contains((Iterable)localVarLables, (Object)it) || it instanceof LineNumberNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int i = 0;
        List specialLabels = (List)destination$iv$iv;
        int n = specialLabels.size() - 2;
        if (i <= n) {
            while (true) {
                AbstractInsnNode begin = (AbstractInsnNode)specialLabels.get(i);
                AbstractInsnNode end = (AbstractInsnNode)specialLabels.get(i + 1);
                if (begin instanceof LineNumberNode) {
                    CollectionsKt.addIfNotNull((Collection)requiredNops, RedundantNopsCleanupMethodTransformerKt.getRequiredNopInRange(begin, end));
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void recordNopsRequiredForTryCatchBlocks(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            AbstractInsnNode nop;
            AbstractInsnNode finger$iv;
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
            AbstractInsnNode $this$findNextOrNull$iv = labelNode;
            boolean $i$f$findNextOrNull = false;
            for (finger$iv = $this$findNextOrNull$iv.getNext(); finger$iv != null; finger$iv = finger$iv.getNext()) {
                AbstractInsnNode it = finger$iv;
                boolean bl = false;
                if (UtilKt.isMeaningful(it)) break;
            }
            AbstractInsnNode abstractInsnNode = nop = finger$iv;
            boolean bl = abstractInsnNode != null ? abstractInsnNode.getOpcode() == 0 : false;
            if (!bl) continue;
            requiredNops.add(nop);
        }
    }
}

