/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.FileAccessorCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarFileSystem;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarVirtualFile;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.LargeDynamicMappedBuffer;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipImplementationKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J$\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J\u0018\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001c*\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler;", "", "fileSystem", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "path", "", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;Ljava/lang/String;)V", "getFileSystem", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "myRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Ljava/io/File;", "getFile$cli_base", "()Ljava/io/File;", "cachedManifest", "", "createFile", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarVirtualFile;", "entry", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipEntryDescription;", "directories", "", "getOrCreateDirectory", "entryName", "", "splitPath", "Lkotlin/Pair;", "findFileByPath", "pathInJar", "contentsToByteArray", "zipEntryDescription", "cli-base"})
@SourceDebugExtension(value={"SMAP\nFastJarHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastJarHandler.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,121:1\n669#2,11:122\n1#3:133\n381#4,7:134\n*S KotlinDebug\n*F\n+ 1 FastJarHandler.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler\n*L\n42#1:122,11\n86#1:134,7\n*E\n"})
public final class FastJarHandler {
    @NotNull
    private final FastJarFileSystem fileSystem;
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    private final File file;
    @Nullable
    private final byte[] cachedManifest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public FastJarHandler(@NotNull FastJarFileSystem fileSystem, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.fileSystem = fileSystem;
        this.file = new File(path);
        List entries = null;
        Closeable closeable = new RandomAccessFile(this.file, "r");
        Iterator iterator2 = null;
        try {
            RandomAccessFile randomAccessFile = (RandomAccessFile)closeable;
            boolean bl = false;
            long l = randomAccessFile.length();
            Function2 function2 = (arg_0, arg_1) -> FastJarHandler.lambda$2$lambda$0(randomAccessFile, arg_0, arg_1);
            Function1<MappedByteBuffer, Unit> function1 = this.fileSystem.getUnmapBuffer$cli_base();
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
            LargeDynamicMappedBuffer largeBuffer = new LargeDynamicMappedBuffer(l, (Function2<? super Long, ? super Long, ? extends MappedByteBuffer>)function2, function1, byteOrder);
            try {
                byte[] byArray;
                Object v4;
                FastJarHandler fastJarHandler;
                Object object;
                block16: {
                    void $this$singleOrNull$iv;
                    try {
                        object = ZipImplementationKt.parseCentralDirectory(largeBuffer);
                    }
                    catch (Exception e) {
                        Logger.getInstance(this.getClass()).warn("Error while reading zip file: " + this.file.getPath() + ": " + e, e);
                        object = CollectionsKt.emptyList();
                    }
                    entries = object;
                    Iterable e = entries;
                    fastJarHandler = this;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        ZipEntryDescription it = (ZipEntryDescription)element$iv;
                        boolean bl2 = false;
                        if (!StringUtil.equals("META-INF/MANIFEST.MF", it.getRelativePath())) continue;
                        if (found$iv) {
                            v4 = null;
                            break block16;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v4 = !found$iv ? null : single$iv;
                }
                FastJarHandler fastJarHandler2 = fastJarHandler;
                object = v4;
                if (object != null) {
                    void p0;
                    Object $i$f$singleOrNull = object;
                    fastJarHandler = fastJarHandler2;
                    boolean bl3 = false;
                    byArray = ZipImplementationKt.contentsToByteArray(largeBuffer, (ZipEntryDescription)p0);
                    fastJarHandler2 = fastJarHandler;
                } else {
                    byArray = null;
                }
                fastJarHandler2.cachedManifest = byArray;
            }
            finally {
                largeBuffer.unmap();
            }
            randomAccessFile = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            iterator2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)((Object)iterator2));
        }
        this.myRoot = new FastJarVirtualFile(this, "", -1L, null, null);
        HashMap filesByRelativePath = new HashMap(entries.size());
        ((Map)filesByRelativePath).put("", this.myRoot);
        for (ZipEntryDescription entryDescription : entries) {
            FastJarVirtualFile fastJarVirtualFile = !entryDescription.isDirectory() ? this.createFile(entryDescription, filesByRelativePath) : this.getOrCreateDirectory(entryDescription.getRelativePath(), filesByRelativePath);
        }
        for (Object v : filesByRelativePath.values()) {
            Intrinsics.checkNotNullExpressionValue(v, (String)"next(...)");
            FastJarVirtualFile node = (FastJarVirtualFile)v;
            node.initChildrenArrayFromList();
        }
    }

    @NotNull
    public final FastJarFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final File getFile$cli_base() {
        return this.file;
    }

    private final FastJarVirtualFile createFile(ZipEntryDescription entry, Map<String, FastJarVirtualFile> directories2) {
        Pair<CharSequence, CharSequence> pair = this.splitPath(entry.getRelativePath());
        CharSequence parentName = (CharSequence)pair.component1();
        CharSequence shortName2 = (CharSequence)pair.component2();
        FastJarVirtualFile parentFile = this.getOrCreateDirectory(parentName, directories2);
        if (Intrinsics.areEqual((Object)".", (Object)shortName2)) {
            return parentFile;
        }
        return new FastJarVirtualFile(this, shortName2, entry.isDirectory() ? -1L : entry.getUncompressedSize(), parentFile, entry);
    }

    /*
     * WARNING - void declaration
     */
    private final FastJarVirtualFile getOrCreateDirectory(CharSequence entryName, Map<String, FastJarVirtualFile> directories2) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, FastJarVirtualFile> map = directories2;
        String key$iv = ((Object)entryName).toString();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Pair<CharSequence, CharSequence> pair = this.splitPath(entryName);
            CharSequence parentPath = (CharSequence)pair.component1();
            CharSequence shortName2 = (CharSequence)pair.component2();
            FastJarVirtualFile parentFile = this.getOrCreateDirectory(parentPath, directories2);
            FastJarVirtualFile answer$iv = new FastJarVirtualFile(this, shortName2, -1L, parentFile, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FastJarVirtualFile)object;
    }

    private final Pair<CharSequence, CharSequence> splitPath(CharSequence $this$splitPath) {
        int slashIndex;
        for (slashIndex = $this$splitPath.length() - 1; slashIndex >= 0 && $this$splitPath.charAt(slashIndex) != '/'; --slashIndex) {
        }
        if (slashIndex == -1) {
            return new Pair((Object)"", (Object)$this$splitPath);
        }
        return new Pair((Object)$this$splitPath.subSequence(0, slashIndex), (Object)$this$splitPath.subSequence(slashIndex + 1, $this$splitPath.length()));
    }

    @Nullable
    public final VirtualFile findFileByPath(@NotNull String pathInJar) {
        Intrinsics.checkNotNullParameter((Object)pathInJar, (String)"pathInJar");
        VirtualFile virtualFile = this.myRoot;
        return virtualFile != null ? virtualFile.findFileByRelativePath(pathInJar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] contentsToByteArray(@NotNull ZipEntryDescription zipEntryDescription) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)zipEntryDescription, (String)"zipEntryDescription");
        CharSequence relativePath = zipEntryDescription.getRelativePath();
        if (StringUtil.equals(relativePath, "META-INF/MANIFEST.MF")) {
            if (this.cachedManifest == null) {
                throw new FileNotFoundException(this.file + "!/" + relativePath);
            }
            return this.cachedManifest;
        }
        Closeable closeable = this.fileSystem.getCachedOpenFileHandles$cli_base().get(this.file);
        Throwable throwable = null;
        try {
            byte[] byArray2;
            FileAccessorCache.Handle it = (FileAccessorCache.Handle)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            FileAccessorCache.Handle handle = it;
            synchronized (handle) {
                boolean bl2 = false;
                byArray2 = ZipImplementationKt.contentsToByteArray((LargeDynamicMappedBuffer)((Pair)it.get()).getSecond(), zipEntryDescription);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    private static final MappedByteBuffer lambda$2$lambda$0(RandomAccessFile $randomAccessFile, long offset, long size) {
        MappedByteBuffer mappedByteBuffer = $randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, offset, size);
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"map(...)");
        return mappedByteBuffer;
    }
}

