/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.CountingThreadFactory;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AppScheduledExecutorService
extends SchedulingWrapper {
    static final String POOLED_THREAD_PREFIX = "ApplicationImpl pooled thread ";
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;

    @NotNull
    static ScheduledExecutorService getInstance() {
        return Holder.INSTANCE;
    }

    AppScheduledExecutorService(@NotNull String name2, long keepAliveTime, @NotNull TimeUnit unit) {
        super(new BackendThreadPoolExecutor(new MyThreadFactory(), keepAliveTime, unit), new AppDelayQueue());
        this.myName = name2;
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    private MyThreadFactory getCountingThreadFactory() {
        return (MyThreadFactory)((BackendThreadPoolExecutor)this.backendExecutorService).getThreadFactory();
    }

    public void setNewThreadListener(@NotNull BiConsumer<? super Thread, ? super Runnable> threadListener) {
        this.getCountingThreadFactory().setNewThreadListener(threadListener);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return AppScheduledExecutorService.notAllowedMethodCall();
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.notAllowedMethodCall();
    }

    static List<Runnable> notAllowedMethodCall() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void onDelayQueuePurgedOnShutdown() {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdown();
    }

    void shutdownAppScheduledExecutorService() {
        this.myLowMemoryWatcherManager.shutdown();
        this.doShutdown();
        this.delayQueue.shutdown(new SchedulingWrapper.MyScheduledFutureTask<Void>(() -> {}, null, 0L){

            @Override
            boolean executeMeInBackendExecutor() {
                this.set(null);
                return false;
            }
        });
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        if (!this.delayQueue.awaitTermination(deadline - System.nanoTime(), TimeUnit.NANOSECONDS)) {
            return false;
        }
        return super.awaitTermination(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @TestOnly
    @NotNull
    public String statistics() {
        return this.myName + " threads created counter = " + this.getCountingThreadFactory().counter;
    }

    @TestOnly
    public String dumpQueue() {
        return this.delayQueue.toString();
    }

    public int getBackendPoolExecutorSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    @TestOnly
    void setBackendPoolCorePoolSize(int size) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superSetCorePoolSize(size);
    }

    @NotNull
    public static Thread getPeriodicTasksThread() {
        return Holder.INSTANCE.delayQueue.getThread();
    }

    @TestOnly
    void waitForLowMemoryWatcherManagerInit(int timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.myLowMemoryWatcherManager.waitForInitComplete(timeout, unit);
    }

    @NotNull
    public static Runnable capturePropagationAndCancellationContext(@NotNull Runnable command) {
        if (!AppExecutorUtil.propagateContextOrCancellation()) {
            return command;
        }
        return Propagation.capturePropagationAndCancellationContext(command);
    }

    @NotNull
    public static <T> FutureTask<T> capturePropagationAndCancellationContext(@NotNull Callable<T> callable) {
        if (!AppExecutorUtil.propagateContextOrCancellation()) {
            return new FutureTask<T>(callable);
        }
        return Propagation.capturePropagationAndCancellationContext(callable);
    }

    private static final class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance", 1L, TimeUnit.MINUTES);

        private Holder() {
        }
    }

    static final class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        BackendThreadPoolExecutor(@NotNull ThreadFactory factory2, long keepAliveTime, @NotNull TimeUnit unit) {
            super(1, Integer.MAX_VALUE, keepAliveTime, unit, new SynchronousQueue<Runnable>(), factory2);
        }

        @Override
        public void execute(@NotNull Runnable command) {
            super.execute(AppScheduledExecutorService.capturePropagationAndCancellationContext(command));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value2) {
            return this.newTaskFor(Executors.callable(runnable, value2));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return AppScheduledExecutorService.capturePropagationAndCancellationContext(callable);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t2) {
            if (t2 != null && !(t2 instanceof ProcessCanceledException)) {
                Logger.getInstance(SchedulingWrapper.class).error("Worker exited due to exception", t2);
            }
        }

        private void superShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> superShutdownNow() {
            return super.shutdownNow();
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        private void superSetCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value2) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        void superSetKeepAliveTime(long time, TimeUnit unit) {
            super.setKeepAliveTime(time, unit);
        }

        @Override
        public void setThreadFactory(@NotNull ThreadFactory threadFactory) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }
    }

    private static final class MyThreadFactory
    extends CountingThreadFactory {
        private BiConsumer<? super Thread, ? super Runnable> newThreadListener;
        private final ThreadFactory myThreadFactory = Executors.privilegedThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = this.myThreadFactory.newThread(r);
            thread.setDaemon(true);
            thread.setName(AppScheduledExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
            thread.setPriority(4);
            BiConsumer<? super Thread, ? super Runnable> listener2 = this.newThreadListener;
            if (listener2 != null) {
                listener2.accept(thread, r);
            }
            return thread;
        }

        void setNewThreadListener(@NotNull BiConsumer<? super Thread, ? super Runnable> threadListener) {
            if (this.newThreadListener != null) {
                throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
            }
            this.newThreadListener = threadListener;
        }
    }
}

