/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PrivateInlineFunctionsReturningAnonymousObjectsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkTypeAndArguments", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkType", "frontend"})
public final class PrivateInlineFunctionsReturningAnonymousObjectsChecker
implements DeclarationChecker {
    @NotNull
    public static final PrivateInlineFunctionsReturningAnonymousObjectsChecker INSTANCE = new PrivateInlineFunctionsReturningAnonymousObjectsChecker();

    private PrivateInlineFunctionsReturningAnonymousObjectsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor2).isInline() && DescriptorVisibilities.isPrivate(((SimpleFunctionDescriptor)descriptor2).getVisibility()) && declaration2 instanceof KtNamedFunction)) {
            return;
        }
        PsiElement psiElement = ((KtNamedFunction)declaration2).getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        KotlinType kotlinType = ((SimpleFunctionDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType2 = kotlinType;
        this.checkTypeAndArguments(returnType2, nameIdentifier, context2);
    }

    private final void checkTypeAndArguments(KotlinType type2, PsiElement reportOn, DeclarationCheckerContext context2) {
        this.checkType(type2, reportOn, context2);
        for (TypeProjection argument : type2.getArguments()) {
            if (argument.isStarProjection()) continue;
            KotlinType kotlinType = argument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            this.checkTypeAndArguments(kotlinType, reportOn, context2);
        }
    }

    private final void checkType(KotlinType type2, PsiElement reportOn, DeclarationCheckerContext context2) {
        TypeConstructor returnTypeConstructor = type2.getConstructor();
        ClassifierDescriptor classifierDescriptor = returnTypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor returnTypeDeclarationDescriptor = classifierDescriptor;
        if (DescriptorUtils.isAnonymousObject(returnTypeDeclarationDescriptor)) {
            context2.getTrace().report(Errors.PRIVATE_INLINE_FUNCTIONS_RETURNING_ANONYMOUS_OBJECTS.on(reportOn));
        }
    }
}

