/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;

public class KtParameterElementType
extends KtStubElementType<KotlinParameterStub, KtParameter> {
    public KtParameterElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtParameterElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtParameter.class, KotlinParameterStub.class);
    }

    @Override
    @NotNull
    public KotlinParameterStub createStub(@NotNull KtParameter psi, StubElement parentStub) {
        FqName fqName;
        if (psi == null) {
            KtParameterElementType.$$$reportNull$$$0(1);
        }
        StringRef fqNameRef = StringRef.fromString((fqName = psi.getFqName()) != null ? fqName.asString() : null);
        return new KotlinParameterStubImpl(parentStub, fqNameRef, StringRef.fromString(psi.getName()), psi.isMutable(), psi.hasValOrVar(), psi.hasDefaultValue(), null);
    }

    @Override
    public void serialize(@NotNull KotlinParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtParameterElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtParameterElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isMutable());
        dataStream.writeBoolean(stub.hasValOrVar());
        dataStream.writeBoolean(stub.hasDefaultValue());
        FqName name2 = stub.getFqName();
        dataStream.writeName(name2 != null ? name2.asString() : null);
        dataStream.writeName(stub instanceof KotlinParameterStubImpl ? ((KotlinParameterStubImpl)stub).getFunctionTypeParameterName() : null);
    }

    @Override
    @NotNull
    public KotlinParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtParameterElementType.$$$reportNull$$$0(4);
        }
        StringRef name2 = dataStream.readName();
        boolean isMutable2 = dataStream.readBoolean();
        boolean hasValOrValNode = dataStream.readBoolean();
        boolean hasDefaultValue = dataStream.readBoolean();
        StringRef fqName = dataStream.readName();
        return new KotlinParameterStubImpl(parentStub, fqName, name2, isMutable2, hasValOrValNode, hasDefaultValue, dataStream.readNameString());
    }

    @Override
    public void indexStub(@NotNull KotlinParameterStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtParameterElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            KtParameterElementType.$$$reportNull$$$0(6);
        }
        StubIndexService.getInstance().indexParameter(stub, sink);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

