/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0018\u0010\u0012\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirParenthesizedLhsSetOperatorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isArrayAccess", "", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "(Lorg/jetbrains/kotlin/fir/references/FirNamedReference;)Z", "isAugmentedAssign", "isIncrementOrDecrement", "checkers"})
public final class FirParenthesizedLhsSetOperatorChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirParenthesizedLhsSetOperatorChecker INSTANCE = new FirParenthesizedLhsSetOperatorChecker();

    private FirParenthesizedLhsSetOperatorChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirNamedReference callee = expression2.getCalleeReference();
        KtSourceElement ktSourceElement = expression2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (!(Intrinsics.areEqual((Object)callee.getName(), (Object)OperatorNameConventions.SET) && (CollectionsKt.contains((Iterable)PsiUtilsKt.getUNWRAPPABLE_TOKEN_TYPES(), (Object)source.getElementType()) && this.isArrayAccess(callee) || PsiUtilsKt.hasUnwrappableAsAssignmentLhs(source) && this.isAugmentedAssign(callee) || PsiUtilsKt.hasUnwrappableAsAssignmentLhs(source) && this.isIncrementOrDecrement(callee)))) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getWRAPPED_LHS_IN_ASSIGNMENT(), (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean isArrayAccess(FirNamedReference $this$isArrayAccess) {
        KtSourceElement ktSourceElement = $this$isArrayAccess.getSource();
        return Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE);
    }

    private final boolean isAugmentedAssign(FirNamedReference $this$isAugmentedAssign) {
        KtSourceElement ktSourceElement = $this$isAugmentedAssign.getSource();
        return (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredAugmentedAssign;
    }

    private final boolean isIncrementOrDecrement(FirNamedReference $this$isIncrementOrDecrement) {
        KtSourceElement ktSourceElement = $this$isIncrementOrDecrement.getSource();
        return (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement;
    }
}

