/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.javac;

import com.intellij.mock.MockProject;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.javac.JavacLogger;
import org.jetbrains.kotlin.cli.jvm.javac.JavacWrapperKotlinResolverImpl;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.JavacWrapperKotlinResolver;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J}\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/javac/JavacWrapperRegistrar;", "", "<init>", "()V", "JAVAC_CONTEXT_CLASS", "", "registerJavac", "", "project", "Lcom/intellij/mock/MockProject;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "javaFiles", "", "Ljava/io/File;", "kotlinFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "arguments", "", "bootClasspath", "sourcePath", "lightClassGenerationSupport", "Lorg/jetbrains/kotlin/asJava/LightClassGenerationSupport;", "packagePartsProviders", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "(Lcom/intellij/mock/MockProject;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Ljava/util/List;Ljava/util/List;[Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/asJava/LightClassGenerationSupport;Ljava/util/List;)Z", "cli-base"})
public final class JavacWrapperRegistrar {
    @NotNull
    public static final JavacWrapperRegistrar INSTANCE = new JavacWrapperRegistrar();
    @NotNull
    private static final String JAVAC_CONTEXT_CLASS = "com.sun.tools.javac.util.Context";

    private JavacWrapperRegistrar() {
    }

    public final boolean registerJavac(@NotNull MockProject project, @NotNull CompilerConfiguration configuration2, @NotNull List<? extends File> javaFiles, @NotNull List<? extends KtFile> kotlinFiles, @Nullable String[] arguments2, @Nullable List<? extends File> bootClasspath, @Nullable List<? extends File> sourcePath, @NotNull LightClassGenerationSupport lightClassGenerationSupport, @NotNull List<JvmPackagePartProvider> packagePartsProviders) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter(javaFiles, (String)"javaFiles");
        Intrinsics.checkNotNullParameter(kotlinFiles, (String)"kotlinFiles");
        Intrinsics.checkNotNullParameter((Object)lightClassGenerationSupport, (String)"lightClassGenerationSupport");
        Intrinsics.checkNotNullParameter(packagePartsProviders, (String)"packagePartsProviders");
        MessageCollector messageCollector = configuration2.getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"getNotNull(...)");
        MessageCollector messageCollector2 = messageCollector;
        try {
            Class.forName(JAVAC_CONTEXT_CLASS);
        }
        catch (ClassNotFoundException e) {
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "'com.sun.tools.javac.util.Context' class can't be found ('tools.jar' is not found)", null, 4, null);
            return false;
        }
        Context context2 = new Context();
        JavacLogger.Companion.preRegister(context2, messageCollector2);
        List<File> jvmClasspathRoots = JvmContentRootsKt.getJvmClasspathRoots(configuration2);
        File outputDirectory = configuration2.get(JVMConfigurationKeys.OUTPUT_DIRECTORY);
        boolean compileJava = configuration2.getBoolean(JVMConfigurationKeys.COMPILE_JAVA);
        JavacWrapperKotlinResolverImpl kotlinSupertypesResolver = new JavacWrapperKotlinResolverImpl(lightClassGenerationSupport);
        JavacWrapper javacWrapper = new JavacWrapper((Collection)javaFiles, (Collection)kotlinFiles, arguments2, jvmClasspathRoots, bootClasspath, sourcePath, (JavacWrapperKotlinResolver)kotlinSupertypesResolver, packagePartsProviders, compileJava, outputDirectory, context2);
        project.registerService(JavacWrapper.class, javacWrapper);
        return true;
    }
}

