/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure;

import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinModuleDependentsProviderBase;
import org.jetbrains.kotlin.analysis.api.projectStructure.DependenciesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.KaStaticModuleDependentsProviderKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0016\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR9\u0010\u000e\u001a-\u0012\u000e\u0012\f0\u0004\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u00110\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\r\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/KtStaticModuleDependentsProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinModuleDependentsProviderBase;", "modules", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "<init>", "(Ljava/util/List;)V", "directDependentsByKtModule", "", "", "getDirectDependentsByKtModule", "()Ljava/util/Map;", "directDependentsByKtModule$delegate", "Lkotlin/Lazy;", "transitiveDependentsByKtModule", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "refinementDependentsByKtModule", "getRefinementDependentsByKtModule", "refinementDependentsByKtModule$delegate", "getDirectDependents", "module", "getTransitiveDependents", "getRefinementDependents", "analysis-api-standalone-base"})
@SourceDebugExtension(value={"SMAP\nKaStaticModuleDependentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaStaticModuleDependentsProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/KtStaticModuleDependentsProvider\n+ 2 KaStaticModuleDependentsProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/KaStaticModuleDependentsProviderKt\n*L\n1#1,51:1\n40#2,11:52\n40#2,11:63\n*S KotlinDebug\n*F\n+ 1 KaStaticModuleDependentsProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/KtStaticModuleDependentsProvider\n*L\n18#1:52,11\n26#1:63,11\n*E\n"})
public final class KtStaticModuleDependentsProvider
extends KotlinModuleDependentsProviderBase {
    @NotNull
    private final List<KaModule> modules;
    @NotNull
    private final Lazy directDependentsByKtModule$delegate;
    @NotNull
    private final ConcurrentMap<KaModule, Set<KaModule>> transitiveDependentsByKtModule;
    @NotNull
    private final Lazy refinementDependentsByKtModule$delegate;

    public KtStaticModuleDependentsProvider(@NotNull List<? extends KaModule> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.modules = modules;
        this.directDependentsByKtModule$delegate = LazyKt.lazy(() -> KtStaticModuleDependentsProvider.directDependentsByKtModule_delegate$lambda$1(this));
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createConcurrentSoftMap(...)");
        this.transitiveDependentsByKtModule = concurrentMap;
        this.refinementDependentsByKtModule$delegate = LazyKt.lazy(() -> KtStaticModuleDependentsProvider.refinementDependentsByKtModule_delegate$lambda$3(this));
    }

    private final Map<KaModule, Set<KaModule>> getDirectDependentsByKtModule() {
        Lazy lazy = this.directDependentsByKtModule$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<KaModule, Set<KaModule>> getRefinementDependentsByKtModule() {
        Lazy lazy = this.refinementDependentsByKtModule$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<KaModule> getDirectDependents(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Set set = this.getDirectDependentsByKtModule().get(module2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    @NotNull
    public Set<KaModule> getTransitiveDependents(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Set set = this.transitiveDependentsByKtModule.computeIfAbsent(module2, arg_0 -> KtStaticModuleDependentsProvider.getTransitiveDependents$lambda$5(arg_0 -> KtStaticModuleDependentsProvider.getTransitiveDependents$lambda$4(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        return set;
    }

    @Override
    @NotNull
    public Set<KaModule> getRefinementDependents(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Set set = this.getRefinementDependentsByKtModule().get(module2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private static final Map directDependentsByKtModule_delegate$lambda$1(KtStaticModuleDependentsProvider this$0) {
        Map map;
        List<KaModule> modules$iv = this$0.modules;
        boolean $i$f$buildDependentsMap = false;
        Map $this$buildDependentsMap_u24lambda_u240$iv = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterator<KaModule> iterator2 = modules$iv.iterator();
        while (iterator2.hasNext()) {
            KaModule module$iv;
            KaModule it = module$iv = iterator2.next();
            boolean bl2 = false;
            for (KaModule dependency$iv : DependenciesKt.allDirectDependencies(it)) {
                if (Intrinsics.areEqual((Object)dependency$iv, (Object)module$iv)) continue;
                Function1 function1 = KaStaticModuleDependentsProviderKt.buildDependentsMap.1.dependents.1.INSTANCE;
                Object v = $this$buildDependentsMap_u24lambda_u240$iv.computeIfAbsent(dependency$iv, new Function(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                        this.function = function2;
                    }

                    public final /* synthetic */ Object apply(Object p0) {
                        return this.function.invoke(p0);
                    }
                });
                Intrinsics.checkNotNullExpressionValue(v, (String)"computeIfAbsent(...)");
                Set dependents$iv = (Set)v;
                dependents$iv.add(module$iv);
            }
        }
        return MapsKt.build((Map)map);
    }

    private static final Map refinementDependentsByKtModule_delegate$lambda$3(KtStaticModuleDependentsProvider this$0) {
        Map map;
        List<KaModule> modules$iv = this$0.modules;
        boolean $i$f$buildDependentsMap = false;
        Map $this$buildDependentsMap_u24lambda_u240$iv = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterator<KaModule> iterator2 = modules$iv.iterator();
        while (iterator2.hasNext()) {
            KaModule module$iv;
            KaModule it = module$iv = iterator2.next();
            boolean bl2 = false;
            for (KaModule dependency$iv : CollectionsKt.asSequence((Iterable)it.getTransitiveDependsOnDependencies())) {
                if (Intrinsics.areEqual((Object)dependency$iv, (Object)module$iv)) continue;
                Function1 function1 = KaStaticModuleDependentsProviderKt.buildDependentsMap.1.dependents.1.INSTANCE;
                Object v = $this$buildDependentsMap_u24lambda_u240$iv.computeIfAbsent(dependency$iv, new /* invalid duplicate definition of identical inner class */);
                Intrinsics.checkNotNullExpressionValue(v, (String)"computeIfAbsent(...)");
                Set dependents$iv = (Set)v;
                dependents$iv.add(module$iv);
            }
        }
        return MapsKt.build((Map)map);
    }

    private static final Set getTransitiveDependents$lambda$4(KtStaticModuleDependentsProvider this$0, KaModule it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.computeTransitiveDependents(it);
    }

    private static final Set getTransitiveDependents$lambda$5(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }
}

