/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache.impl;

import com.intellij.openapi.util.IntRef;
import com.intellij.util.io.pagecache.Page;
import com.intellij.util.io.pagecache.impl.PageImpl;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PagesTable {
    private static final double GROWTH_FACTOR = 1.5;
    private static final double SHRINK_FACTOR = 2.0;
    private static final int MIN_TABLE_SIZE = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.4f;
    private final float loadFactor;
    private int pagesCount = 0;
    @NotNull
    private volatile AtomicReferenceArray<PageImpl> pages;
    private final transient ReentrantLock pagesLock = new ReentrantLock();

    public PagesTable(int initialSize) {
        this(initialSize, 0.4f);
    }

    public PagesTable(int initialSize, float loadFactor) {
        this.loadFactor = loadFactor;
        int size = Math.max(16, (int)((float)initialSize / this.loadFactor));
        this.pages = new AtomicReferenceArray(size);
    }

    @Nullable
    public Page lookupIfExist(int pageIndex) {
        return PagesTable.findPageOrInsertionIndex(this.pages, pageIndex, null);
    }

    @NotNull
    public PageImpl lookupOrCreate(int pageIndex, @NotNull IntFunction<PageImpl> uninitializedPageFactory) throws IOException {
        PageImpl page;
        if (uninitializedPageFactory == null) {
            PagesTable.$$$reportNull$$$0(0);
        }
        if ((page = PagesTable.findPageOrInsertionIndex(this.pages, pageIndex, null)) != null) {
            PageImpl pageImpl = page;
            if (pageImpl == null) {
                PagesTable.$$$reportNull$$$0(1);
            }
            return pageImpl;
        }
        return this.insertNewPage(pageIndex, uninitializedPageFactory);
    }

    public void flushAll() throws IOException {
        AtomicReferenceArray<PageImpl> pagesLocal = this.pages;
        for (int i = 0; i < pagesLocal.length(); ++i) {
            PageImpl page = pagesLocal.get(i);
            if (page == null || !page.isDirty()) continue;
            page.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shrinkIfNeeded(int alivePagesCount) {
        int expectedTableSize = (int)Math.ceil((float)alivePagesCount / this.loadFactor);
        if (expectedTableSize >= 16 && (double)expectedTableSize * 2.0 < (double)this.pages.length()) {
            this.pagesLock.lock();
            try {
                try {
                    this.rehashToSize(expectedTableSize);
                }
                catch (NoFreeSpaceException e) {
                    boolean bl = false;
                    this.pagesLock.unlock();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.pagesLock.unlock();
            }
        }
        return false;
    }

    public AtomicReferenceArray<PageImpl> pages() {
        return this.pages;
    }

    public ReentrantLock pagesLock() {
        return this.pagesLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private PageImpl insertNewPage(int pageIndex, IntFunction<PageImpl> uninitializedPageFactory) {
        PageImpl blankPage;
        IntRef insertionIndexRef = new IntRef();
        this.pagesLock.lock();
        try {
            PageImpl alreadyInsertedPage = PagesTable.findPageOrInsertionIndex(this.pages, pageIndex, insertionIndexRef);
            if (alreadyInsertedPage != null) {
                PageImpl pageImpl = alreadyInsertedPage;
                PageImpl pageImpl2 = pageImpl;
                if (pageImpl2 == null) {
                    PagesTable.$$$reportNull$$$0(2);
                }
                return pageImpl2;
            }
            if (insertionIndexRef.get() < 0) {
                int newTableSize = (int)Math.ceil((double)((float)this.pagesCount / this.loadFactor) * 1.5);
                this.rehashToSize(newTableSize);
                PageImpl mustBeNull = PagesTable.findPageOrInsertionIndex(this.pages, pageIndex, insertionIndexRef);
                if (mustBeNull != null) {
                    throw new AssertionError((Object)("Bug: first lookup(pageIndex: " + pageIndex + ") founds nothing, same search after resize must find nothing too " + this.pages));
                }
                if (insertionIndexRef.get() < 0) {
                    throw new AssertionError((Object)("Bug: table just resized {length: " + this.pages.length() + ", pages: " + this.pagesCount + "} => there must be a free slot for pageIndex: " + pageIndex));
                }
            }
            blankPage = uninitializedPageFactory.apply(pageIndex);
            int insertionIndex = insertionIndexRef.get();
            this.pages.set(insertionIndex, blankPage);
            ++this.pagesCount;
            if ((float)this.pagesCount > (float)this.pages.length() * this.loadFactor) {
                int newTableSize = (int)Math.ceil((double)((float)this.pagesCount / this.loadFactor) * 1.5);
                this.rehashToSize(newTableSize);
            }
        }
        finally {
            this.pagesLock.unlock();
        }
        PageImpl pageImpl = blankPage;
        if (pageImpl == null) {
            PagesTable.$$$reportNull$$$0(3);
        }
        return pageImpl;
    }

    private void rehashToSize(int newPagesSize) throws NoFreeSpaceException {
        int pagesCopied;
        assert (this.pagesLock.isHeldByCurrentThread()) : "Must hold pagesLock while rehashing";
        AtomicReferenceArray<PageImpl> newPages = new AtomicReferenceArray<PageImpl>(newPagesSize);
        this.pagesCount = pagesCopied = PagesTable.rehashWithoutTombstones(this.pages, newPages);
        this.pages = newPages;
    }

    private static int rehashWithoutTombstones(@NotNull AtomicReferenceArray<PageImpl> sourcePages, @NotNull AtomicReferenceArray<PageImpl> targetPages) throws NoFreeSpaceException {
        if (sourcePages == null) {
            PagesTable.$$$reportNull$$$0(4);
        }
        if (targetPages == null) {
            PagesTable.$$$reportNull$$$0(5);
        }
        IntRef insertionIndexRef = new IntRef();
        int pagesCopied = 0;
        for (int i = 0; i < sourcePages.length(); ++i) {
            PageImpl page = sourcePages.get(i);
            if (page == null || page.isTombstone()) continue;
            int pageIndex = page.pageIndex();
            PageImpl pageMustNotBeFound = PagesTable.findPageOrInsertionIndex(targetPages, pageIndex, insertionIndexRef);
            int insertionIndex = insertionIndexRef.get();
            if (pageMustNotBeFound != null) {
                throw new AssertionError((Object)("Page[#" + pageIndex + "] is copying now -- can't be already in .newPages! \nsource: " + sourcePages + "\ntarget: " + targetPages));
            }
            if (insertionIndex < 0) {
                if (pagesCopied == targetPages.length()) {
                    throw new NoFreeSpaceException("Not enough space in targetPages(length: " + targetPages.length() + "): sourcePages(length: " + sourcePages.length() + ") contains > " + pagesCopied + " !tombstone pages. \nsource: " + sourcePages + "\ntarget: " + targetPages);
                }
                throw new AssertionError((Object)("Bug: insertion index must be found for Page[#" + pageIndex + "] during rehash.  source.length: " + sourcePages.length() + " target.length: " + targetPages.length() + "\nsource: " + sourcePages + "\ntarget: " + targetPages));
            }
            targetPages.set(insertionIndex, page);
            ++pagesCopied;
        }
        return pagesCopied;
    }

    @Nullable
    private static PageImpl findPageOrInsertionIndex(@NotNull AtomicReferenceArray<PageImpl> pages, int pageIndex, @Nullable IntRef insertionIndexRef) {
        if (pages == null) {
            PagesTable.$$$reportNull$$$0(6);
        }
        int length = pages.length();
        int initialSlotIndex = PagesTable.hash(pageIndex) % length;
        boolean probeStep = true;
        int firstTombstoneIndex = -1;
        int slotIndex = initialSlotIndex;
        for (int probeNo = 0; probeNo < length; ++probeNo) {
            PageImpl page = pages.get(slotIndex);
            if (page == null) {
                if (insertionIndexRef != null) {
                    int insertionIndex = firstTombstoneIndex >= 0 ? firstTombstoneIndex : slotIndex;
                    insertionIndexRef.set(insertionIndex);
                }
                return null;
            }
            if (page.isTombstone()) {
                if (firstTombstoneIndex < 0) {
                    firstTombstoneIndex = slotIndex;
                }
            } else if (page.pageIndex() == pageIndex) {
                if (insertionIndexRef != null) {
                    insertionIndexRef.set(slotIndex);
                }
                return page;
            }
            slotIndex = (slotIndex + 1) % length;
        }
        if (insertionIndexRef != null) {
            insertionIndexRef.set(-1);
        }
        return null;
    }

    private static int hash(int pageIndex) {
        return Math.abs(HashCommon.mix(pageIndex));
    }

    public String probeLengthsHistogram() {
        Int2IntMap histo = this.collectProbeLengthsHistogram();
        int sum = histo.values().intStream().sum();
        return histo.keySet().intStream().sorted().mapToObj(len -> String.format("%3d: %4d (%4.1f%%)", len, histo.get(len), (double)histo.get(len) * 100.0 / (double)sum)).collect(Collectors.joining("\n"));
    }

    @VisibleForTesting
    public Int2IntMap collectProbeLengthsHistogram() {
        Int2IntOpenHashMap histo = new Int2IntOpenHashMap();
        for (int i = 0; i < this.pages.length(); ++i) {
            PageImpl page = this.pages.get(i);
            if (page == null) continue;
            int probingLength = PagesTable.probingSequenceLengthFor(this.pages, page.pageIndex());
            histo.mergeInt(probingLength, 1, Integer::sum);
        }
        return histo;
    }

    private static int probingSequenceLengthFor(@NotNull AtomicReferenceArray<PageImpl> pages, int pageIndex) {
        if (pages == null) {
            PagesTable.$$$reportNull$$$0(7);
        }
        int length = pages.length();
        int initialSlotIndex = PagesTable.hash(pageIndex) % length;
        boolean probeStep = true;
        int slotIndex = initialSlotIndex;
        for (int probeNo = 0; probeNo < length; ++probeNo) {
            PageImpl page = pages.get(slotIndex);
            if (page == null) {
                return probeNo;
            }
            if (!page.isTombstone() && page.pageIndex() == pageIndex) {
                return probeNo;
            }
            slotIndex = (slotIndex + 1) % length;
        }
        return pages.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uninitializedPageFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/pagecache/impl/PagesTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPages";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/pagecache/impl/PagesTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupOrCreate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "insertNewPage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lookupOrCreate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rehashWithoutTombstones";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPageOrInsertionIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "probingSequenceLengthFor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NoFreeSpaceException
    extends IllegalStateException {
        private NoFreeSpaceException(String message) {
            super(message);
        }
    }
}

