/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ActivityImpl
implements Activity {
    public Scope scope;
    public String[] attributes;
    private final String name;
    private String description;
    private String threadName;
    private long threadId;
    private final long start;
    private long end;
    private final ActivityImpl parent;
    @Nullable
    private final ActivityCategory category;
    @Nullable
    private final String pluginId;

    public ActivityImpl(@Nullable String name2, long start, @Nullable ActivityImpl parent2) {
        this(name2, start, parent2, null);
    }

    ActivityImpl(@Nullable String name2, long start, @Nullable ActivityImpl parent2, @Nullable String pluginId) {
        this(name2, start, parent2, pluginId, null);
    }

    ActivityImpl(@Nullable String name2, long start, @Nullable ActivityImpl parent2, @Nullable String pluginId, @Nullable ActivityCategory category) {
        this.name = name2;
        this.start = start;
        this.parent = parent2;
        this.pluginId = pluginId;
        this.category = category;
        this.updateThreadName();
    }

    @NotNull
    public String getThreadName() {
        String string2 = this.threadName;
        if (string2 == null) {
            ActivityImpl.$$$reportNull$$$0(0);
        }
        return string2;
    }

    private void updateThreadName() {
        Thread thread = Thread.currentThread();
        this.threadId = thread.getId();
        this.threadName = thread.getName();
    }

    public long getThreadId() {
        return this.threadId;
    }

    @Nullable
    public ActivityImpl getParent() {
        return this.parent;
    }

    @Nullable
    public ActivityCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public ActivityImpl startChild(@NotNull String name2) {
        if (name2 == null) {
            ActivityImpl.$$$reportNull$$$0(1);
        }
        return new ActivityImpl(name2, System.nanoTime(), this, this.pluginId, this.category);
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            ActivityImpl.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getPluginId() {
        return this.pluginId;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @ApiStatus.Internal
    public void setEnd(long end) {
        assert (this.end == 0L) : "not started or already ended";
        this.end = end;
    }

    @Override
    public void end() {
        this.end = System.nanoTime();
        StartUpMeasurer.addActivity(this);
    }

    @Override
    public void setDescription(@NotNull String value2) {
        if (value2 == null) {
            ActivityImpl.$$$reportNull$$$0(3);
        }
        this.description = value2;
    }

    @Override
    @NotNull
    public ActivityImpl endAndStart(@NotNull String name2) {
        if (name2 == null) {
            ActivityImpl.$$$reportNull$$$0(4);
        }
        this.end = System.nanoTime();
        StartUpMeasurer.addActivity(this);
        return new ActivityImpl(name2, this.end, this.parent, this.pluginId, this.category);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("ActivityImpl(name=").append(this.name).append(", start=");
        ActivityImpl.nanoToString(this.start, builder2);
        builder2.append(", end=");
        ActivityImpl.nanoToString(this.end, builder2);
        builder2.append(", category=").append((Object)this.category).append(")");
        return builder2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void nanoToString(long start, @NotNull StringBuilder stringBuilder) {
        void builder2;
        if (stringBuilder == null) {
            ActivityImpl.$$$reportNull$$$0(5);
        }
        builder2.append(TimeUnit.NANOSECONDS.toMillis(start - StartUpMeasurer.getStartTime())).append("ms (").append(TimeUnit.NANOSECONDS.toMicros(start - StartUpMeasurer.getStartTime())).append("\u03bcs)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/ActivityImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/ActivityImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "endAndStart";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nanoToString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

