/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.CompoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a8\u0006\u000b"}, d2={"incorporateBound", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilderImpl;", "newBound", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "addConstraintFromBounds", "old", "new", "generateNewBound", "bound", "substitution", "frontend"})
@SourceDebugExtension(value={"SMAP\nconstraintIncorporation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 constraintIncorporation.kt\norg/jetbrains/kotlin/resolve/calls/inference/ConstraintIncorporationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1869#2,2:134\n1761#2,3:136\n*S KotlinDebug\n*F\n+ 1 constraintIncorporation.kt\norg/jetbrains/kotlin/resolve/calls/inference/ConstraintIncorporationKt\n*L\n63#1:134,2\n123#1:136,3\n*E\n"})
public final class ConstraintIncorporationKt {
    public static final void incorporateBound(@NotNull ConstraintSystemBuilderImpl $this$incorporateBound, @NotNull TypeBounds.Bound newBound) {
        Intrinsics.checkNotNullParameter((Object)$this$incorporateBound, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newBound, (String)"newBound");
        TypeVariable typeVariable = newBound.getTypeVariable();
        TypeBoundsImpl typeBounds = $this$incorporateBound.getTypeBounds$frontend(typeVariable);
        int n2 = typeBounds.getBounds().size();
        for (int oldBoundIndex = 0; oldBoundIndex < n2; ++oldBoundIndex) {
            Object e2 = ((ArrayList)typeBounds.getBounds()).get(oldBoundIndex);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            ConstraintIncorporationKt.addConstraintFromBounds($this$incorporateBound, (TypeBounds.Bound)e2, newBound);
        }
        List list = $this$incorporateBound.getUsedInBounds$frontend().get(typeVariable);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List boundsUsedIn = list;
        int n3 = ((Collection)boundsUsedIn).size();
        for (int index2 = 0; index2 < n3; ++index2) {
            TypeBounds.Bound boundUsedIn = (TypeBounds.Bound)boundsUsedIn.get(index2);
            ConstraintIncorporationKt.generateNewBound($this$incorporateBound, boundUsedIn, newBound);
        }
        KotlinType constrainingType = newBound.getConstrainingType();
        if ($this$incorporateBound.isMyTypeVariable$frontend(constrainingType)) {
            ConstraintContext context2 = new ConstraintContext(newBound.getPosition(), newBound.getDerivedFrom(), false, false, 12, null);
            TypeVariable typeVariable2 = $this$incorporateBound.getMyTypeVariable$frontend(constrainingType);
            Intrinsics.checkNotNull((Object)typeVariable2);
            $this$incorporateBound.addBound$frontend(typeVariable2, typeVariable.getType(), TypeBoundsKt.reverse(newBound.getKind()), context2);
            return;
        }
        Iterable $this$forEach$iv = $this$incorporateBound.getNestedTypeVariables$frontend(constrainingType);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeVariable it = (TypeVariable)element$iv;
            boolean bl2 = false;
            Collection boundsForNestedVariable = $this$incorporateBound.getTypeBounds$frontend(it).getBounds();
            int n4 = boundsForNestedVariable.size();
            for (int index3 = 0; index3 < n4; ++index3) {
                Object e3 = ((ArrayList)boundsForNestedVariable).get(index3);
                Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
                ConstraintIncorporationKt.generateNewBound($this$incorporateBound, newBound, (TypeBounds.Bound)e3);
            }
        }
    }

    private static final void addConstraintFromBounds(ConstraintSystemBuilderImpl $this$addConstraintFromBounds, TypeBounds.Bound old, TypeBounds.Bound bound) {
        if (Intrinsics.areEqual((Object)old, (Object)bound)) {
            return;
        }
        KotlinType oldType = old.getConstrainingType();
        KotlinType newType = bound.getConstrainingType();
        ConstraintPosition[] constraintPositionArray = new ConstraintPosition[]{old.getPosition(), bound.getPosition()};
        ConstraintContext context2 = new ConstraintContext(new CompoundConstraintPosition(constraintPositionArray), SetsKt.plus(old.getDerivedFrom(), (Iterable)bound.getDerivedFrom()), false, false, 12, null);
        if (old.getKind().ordinal() < bound.getKind().ordinal()) {
            $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, oldType, newType, context2);
        } else if (old.getKind().ordinal() > bound.getKind().ordinal()) {
            $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, newType, oldType, context2);
        } else if (old.getKind() == bound.getKind() && old.getKind() == TypeBounds.BoundKind.EXACT_BOUND) {
            $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.EQUAL, oldType, newType, context2);
        }
    }

    private static final void generateNewBound(ConstraintSystemBuilderImpl $this$generateNewBound, TypeBounds.Bound bound, TypeBounds.Bound substitution) {
        KotlinType kotlinType;
        if (bound == substitution) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[substitution.getKind().ordinal()]) {
            case 1: {
                kotlinType = substitution.getConstrainingType();
                break;
            }
            case 2: {
                kotlinType = new CapturedType(new TypeProjectionImpl(Variance.OUT_VARIANCE, substitution.getConstrainingType()), null, false, null, 14, null);
                break;
            }
            case 3: {
                kotlinType = new CapturedType(new TypeProjectionImpl(Variance.IN_VARIANCE, substitution.getConstrainingType()), null, false, null, 14, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KotlinType substitutedType = kotlinType;
        TypeProjectionImpl newTypeProjection = new TypeProjectionImpl(substitutedType);
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(MapsKt.mapOf((Pair)TuplesKt.to((Object)substitution.getTypeVariable().getType().getConstructor(), (Object)newTypeProjection)));
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        KotlinType kotlinType2 = substitutor2.substitute(bound.getConstrainingType(), Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType type2 = kotlinType2;
        ConstraintPosition[] constraintPositionArray = new ConstraintPosition[]{bound.getPosition(), substitution.getPosition()};
        CompoundConstraintPosition position = new CompoundConstraintPosition(constraintPositionArray);
        if (substitution.getKind() == TypeBounds.BoundKind.EXACT_BOUND) {
            ConstraintIncorporationKt.generateNewBound$addNewBound($this$generateNewBound, bound, substitution, position, type2, bound.getKind());
            return;
        }
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(type2);
        if (ConstraintIncorporationKt.generateNewBound$containsConstrainingTypeWithoutProjection(approximationBounds.getUpper(), substitution) && bound.getKind() != TypeBounds.BoundKind.LOWER_BOUND) {
            ConstraintIncorporationKt.generateNewBound$addNewBound($this$generateNewBound, bound, substitution, position, approximationBounds.getUpper(), TypeBounds.BoundKind.UPPER_BOUND);
        }
        if (ConstraintIncorporationKt.generateNewBound$containsConstrainingTypeWithoutProjection(approximationBounds.getLower(), substitution) && bound.getKind() != TypeBounds.BoundKind.UPPER_BOUND) {
            ConstraintIncorporationKt.generateNewBound$addNewBound($this$generateNewBound, bound, substitution, position, approximationBounds.getLower(), TypeBounds.BoundKind.LOWER_BOUND);
        }
    }

    private static final void generateNewBound$addNewBound(ConstraintSystemBuilderImpl $this_generateNewBound, TypeBounds.Bound $bound, TypeBounds.Bound $substitution, CompoundConstraintPosition position, KotlinType newConstrainingType, TypeBounds.BoundKind newBoundKind) {
        if ($this_generateNewBound.getNestedTypeVariables$frontend(newConstrainingType).contains($bound.getTypeVariable())) {
            return;
        }
        HashSet<TypeVariable> derivedFrom = new HashSet<TypeVariable>(SetsKt.plus($bound.getDerivedFrom(), (Iterable)$substitution.getDerivedFrom()));
        if (derivedFrom.contains($substitution.getTypeVariable())) {
            return;
        }
        derivedFrom.add($substitution.getTypeVariable());
        $this_generateNewBound.addBound$frontend($bound.getTypeVariable(), newConstrainingType, newBoundKind, new ConstraintContext(position, derivedFrom, false, false, 12, null));
    }

    private static final boolean generateNewBound$containsConstrainingTypeWithoutProjection(KotlinType $this$generateNewBound_u24containsConstrainingTypeWithoutProjection, TypeBounds.Bound $substitution) {
        boolean bl2;
        block3: {
            Iterable $this$any$iv = ConstraintSystemUtilsKt.getNestedArguments($this$generateNewBound_u24containsConstrainingTypeWithoutProjection);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeProjection it = (TypeProjection)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getType().getConstructor(), (Object)$substitution.getConstrainingType().getConstructor()) && it.getProjectionKind() == Variance.INVARIANT)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeBounds.BoundKind.values().length];
            try {
                nArray[TypeBounds.BoundKind.EXACT_BOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeBounds.BoundKind.UPPER_BOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeBounds.BoundKind.LOWER_BOUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

