/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u00a8\u0006\u0003"}, d2={"hasSideEffect", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnusedExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnusedExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionCheckerKt\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n44#2:187\n1761#3,3:188\n*S KotlinDebug\n*F\n+ 1 FirUnusedExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionCheckerKt\n*L\n168#1:187\n168#1:188,3\n*E\n"})
public final class FirUnusedExpressionCheckerKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasSideEffect(FirExpression $this$hasSideEffect) {
        FirExpression firExpression = $this$hasSideEffect;
        if (firExpression instanceof FirLiteralExpression) return false;
        if (firExpression instanceof FirClassReferenceExpression) return false;
        if (firExpression instanceof FirResolvedQualifier) return false;
        if (firExpression instanceof FirThisReceiverExpression) {
            return false;
        }
        if (firExpression instanceof FirAnonymousFunctionExpression) {
            return false;
        }
        if (!(firExpression instanceof FirSmartCastExpression)) {
            if (firExpression instanceof FirCallableReferenceAccess) {
                boolean bl2;
                boolean bl3;
                FirExpression firExpression2 = ((FirCallableReferenceAccess)$this$hasSideEffect).getDispatchReceiver();
                if (firExpression2 != null) {
                    if (FirUnusedExpressionCheckerKt.hasSideEffect(firExpression2)) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) return true;
                FirExpression firExpression3 = ((FirCallableReferenceAccess)$this$hasSideEffect).getExtensionReceiver();
                if (firExpression3 != null) {
                    if (FirUnusedExpressionCheckerKt.hasSideEffect(firExpression3)) {
                        return true;
                    }
                    bl2 = false;
                } else {
                    bl2 = false;
                }
                if (bl2) return true;
                FirExpression firExpression4 = ((FirCallableReferenceAccess)$this$hasSideEffect).getExplicitReceiver();
                if (firExpression4 == null) return false;
                if (!FirUnusedExpressionCheckerKt.hasSideEffect(firExpression4)) return false;
                return true;
            }
            if (firExpression instanceof FirStringConcatenationCall || firExpression instanceof FirGetClassCall) {
                FirExpression it;
                FirCall $this$arguments$iv = (FirCall)((Object)$this$hasSideEffect);
                boolean $i$f$getArguments = false;
                Iterable $this$any$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object element$iv = iterator2.next();
                    it = (FirExpression)element$iv;
                    boolean bl4 = false;
                } while (!FirUnusedExpressionCheckerKt.hasSideEffect(it));
                return true;
            }
            if (!(firExpression instanceof FirPropertyAccessExpression)) return true;
            KtSourceElement ktSourceElement = ((FirPropertyAccessExpression)$this$hasSideEffect).getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE)) {
                return true;
            }
            FirBasedSymbol<?> propertySymbol = FirReferenceUtilsKt.getSymbol(((FirPropertyAccessExpression)$this$hasSideEffect).getCalleeReference());
            if (propertySymbol instanceof FirValueParameterSymbol) return false;
            if (propertySymbol instanceof FirReceiverParameterSymbol) {
                return false;
            }
            if (!(propertySymbol instanceof FirPropertySymbol)) return true;
            if (!((FirPropertySymbol)propertySymbol).isLocal()) return true;
            if (!((FirPropertySymbol)propertySymbol).getHasDelegate()) return false;
            return true;
        }
        boolean bl5 = FirUnusedExpressionCheckerKt.hasSideEffect(((FirSmartCastExpression)$this$hasSideEffect).getOriginalExpression());
        return bl5;
    }

    public static final /* synthetic */ boolean access$hasSideEffect(FirExpression $receiver) {
        return FirUnusedExpressionCheckerKt.hasSideEffect($receiver);
    }
}

