/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileEntry;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.descriptors.impl.EmptyPackageFragmentDescriptor;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImplKt;
import org.jetbrains.kotlin.ir.symbols.impl.IrFileSymbolImpl;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0012\u0010\u0010\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000b\u001a\u001a\u0010\u0010\u001a\u00020\u000f*\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005\u00a8\u0006\u0014"}, d2={"deserializeFqName", "", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "fqn", "", "", "createFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "deserializeFileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "fileEntryProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/FileEntry;", "fileEntry", "protoFile", "Lorg/jetbrains/kotlin/library/IrLibrary;", "fileIndex", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrFileDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
public final class IrFileDeserializerKt {
    @NotNull
    public static final String deserializeFqName(@NotNull IrLibraryFile $this$deserializeFqName, @NotNull List<Integer> fqn) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeFqName, (String)"<this>");
        Intrinsics.checkNotNullParameter(fqn, (String)"fqn");
        return CollectionsKt.joinToString$default((Iterable)fqn, (CharSequence)".", null, null, (int)0, null, (Function1)((Function1)new Function1<Integer, String>((Object)$this$deserializeFqName){

            public final String invoke(int p0) {
                return ((IrLibraryFile)this.receiver).string(p0);
            }
        }), (int)30, null);
    }

    @NotNull
    public static final org.jetbrains.kotlin.ir.declarations.IrFile createFile(@NotNull IrLibraryFile $this$createFile, @NotNull IrModuleFragment module2, @NotNull IrFile fileProto) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)fileProto, (String)"fileProto");
        IrFileEntry fileEntry2 = IrFileDeserializerKt.deserializeFileEntry(IrFileDeserializerKt.fileEntry($this$createFile, fileProto));
        List<Integer> list = fileProto.getFqNameList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFqNameList(...)");
        FqName fqName = new FqName(IrFileDeserializerKt.deserializeFqName($this$createFile, list));
        EmptyPackageFragmentDescriptor packageFragmentDescriptor = new EmptyPackageFragmentDescriptor(module2.getDescriptor(), fqName);
        IrFileSymbolImpl symbol = new IrFileSymbolImpl(packageFragmentDescriptor);
        return IrFileImplKt.IrFileImpl(fileEntry2, symbol, fqName, module2);
    }

    @NotNull
    public static final IrFileEntry deserializeFileEntry(@NotNull FileEntry fileEntryProto) {
        Intrinsics.checkNotNullParameter((Object)fileEntryProto, (String)"fileEntryProto");
        String fileName2 = fileEntryProto.getName();
        Intrinsics.checkNotNull((Object)fileName2);
        List<Integer> list = fileEntryProto.getLineStartOffsetList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLineStartOffsetList(...)");
        return new NaiveSourceBasedFileEntryImpl(fileName2, CollectionsKt.toIntArray((Collection)list), 0, 4, null);
    }

    @NotNull
    public static final FileEntry fileEntry(@NotNull IrLibraryFile $this$fileEntry, @NotNull IrFile protoFile) {
        FileEntry fileEntry2;
        Intrinsics.checkNotNullParameter((Object)$this$fileEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        if (protoFile.hasFileEntryId()) {
            fileEntry2 = $this$fileEntry.fileEntry(protoFile.getFileEntryId());
            if (fileEntry2 == null) {
                throw new IllegalStateException("Invalid KLib: cannot read file entry by its index".toString());
            }
        } else {
            if (!protoFile.hasFileEntry()) {
                boolean bl2 = false;
                String string2 = "Invalid KLib: either fileEntry or fileEntryId must be present";
                throw new IllegalArgumentException(string2.toString());
            }
            FileEntry fileEntry3 = protoFile.getFileEntry();
            Intrinsics.checkNotNull((Object)fileEntry3);
            fileEntry2 = fileEntry3;
        }
        return fileEntry2;
    }

    @NotNull
    public static final FileEntry fileEntry(@NotNull IrLibrary $this$fileEntry, @NotNull IrFile protoFile, int fileIndex) {
        FileEntry fileEntry2;
        Intrinsics.checkNotNullParameter((Object)$this$fileEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        if (protoFile.hasFileEntryId() && $this$fileEntry.getHasFileEntriesTable()) {
            byte[] byArray = $this$fileEntry.fileEntry(protoFile.getFileEntryId(), fileIndex);
            if (byArray == null) {
                throw new IllegalStateException("Invalid KLib: cannot read file entry by its index".toString());
            }
            byte[] fileEntry3 = byArray;
            FileEntry fileEntry4 = FileEntry.parseFrom(fileEntry3);
            Intrinsics.checkNotNull((Object)fileEntry4);
            fileEntry2 = fileEntry4;
        } else {
            if (!protoFile.hasFileEntry()) {
                boolean bl2 = false;
                String string2 = "Invalid KLib: either fileEntry or valid fileEntryId must be present. Valid fileEntryId is a valid index in existing file entries table";
                throw new IllegalArgumentException(string2.toString());
            }
            FileEntry fileEntry5 = protoFile.getFileEntry();
            Intrinsics.checkNotNull((Object)fileEntry5);
            fileEntry2 = fileEntry5;
        }
        return fileEntry2;
    }
}

