/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionDirection;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UnsignedProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/RangeToHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoHandler;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "preferJavaLikeCounterLoop", "", "progressionElementTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "matchIterable", "expression", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionHeaderInfo;", "data", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "convertToExclusiveUpperBound", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "progressionType", "allowedMethods", "", "", "convertIrCall", "irCall", "convertIrConst", "irConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "ir.backend.common"})
public final class RangeToHandler
implements HeaderInfoHandler<IrCall, ProgressionType> {
    @NotNull
    private final CommonBackendContext context;
    private final boolean preferJavaLikeCounterLoop;
    @NotNull
    private final Collection<IrType> progressionElementTypes;
    @NotNull
    private final List<String> allowedMethods;

    public RangeToHandler(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.preferJavaLikeCounterLoop = this.context.getPreferJavaLikeCounterLoop();
        this.progressionElementTypes = this.context.getSymbols().getProgressionElementTypes();
        Object[] objectArray = new String[]{"kotlin.ByteArray.<get-size>", "kotlin.CharArray.<get-size>", "kotlin.String.<get-length>", "kotlin.ShortArray.<get-size>", "kotlin.IntArray.<get-size>", "kotlin.LongArray.<get-size>", "kotlin.FloatArray.<get-size>", "kotlin.DoubleArray.<get-size>", "kotlin.BooleanArray.<get-size>", "kotlin.collections.List.<get-size>", "kotlin.collections.MutableList.<get-size>", "kotlin.CharSequence.<get-length>", "kotlin.collections.Set.<get-size>", "kotlin.collections.MutableSet.<get-size>", "kotlin.collections.Map.<get-size>", "kotlin.collections.MutableMap.<get-size>"};
        this.allowedMethods = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean matchIterable(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        return IrUtilsKt.hasShape$default(callee, true, false, 0, 1, null, 22, null) && this.progressionElementTypes.contains(callee.getParameters().get(0).getType()) && this.progressionElementTypes.contains(callee.getParameters().get(1).getType()) && Intrinsics.areEqual((Object)callee.getName(), (Object)OperatorNameConventions.RANGE_TO);
    }

    @NotNull
    public ProgressionHeaderInfo build(@NotNull IrCall expression2, @NotNull ProgressionType data, @NotNull IrSymbol scopeOwner) {
        IrExpression lastExclusive;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        DeclarationIrBuilder $this$build_u24lambda_u240 = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl2 = false;
        Object e2 = expression2.getArguments().get(0);
        Intrinsics.checkNotNull(e2);
        IrExpression first = (IrExpression)e2;
        Object e3 = expression2.getArguments().get(1);
        Intrinsics.checkNotNull(e3);
        IrExpression last = (IrExpression)e3;
        IrConstImpl step = ExpressionHelpersKt.irInt$default($this$build_u24lambda_u240, 1, null, 2, null);
        ProgressionDirection direction = ProgressionDirection.INCREASING;
        return this.preferJavaLikeCounterLoop && (lastExclusive = this.convertToExclusiveUpperBound(last, data)) != null ? new ProgressionHeaderInfo(data, first, lastExclusive, step, false, false, false, direction, null, last, 288, null) : new ProgressionHeaderInfo(data, first, last, step, false, false, null, direction, null, null, 880, null);
    }

    private final IrExpression convertToExclusiveUpperBound(IrExpression $this$convertToExclusiveUpperBound, ProgressionType progressionType) {
        IrExpression irExpression;
        block2: {
            block3: {
                if (!(progressionType instanceof UnsignedProgressionType)) break block2;
                if (this.preferJavaLikeCounterLoop) break block3;
                Long l2 = UtilsKt.getConstLongValue($this$convertToExclusiveUpperBound);
                long l3 = -1L;
                if (l2 == null || l2 != l3) break block2;
            }
            return null;
        }
        return (irExpression = $this$convertToExclusiveUpperBound) instanceof IrConst ? this.convertIrConst((IrConst)$this$convertToExclusiveUpperBound) : (irExpression instanceof IrCall ? this.convertIrCall((IrCall)$this$convertToExclusiveUpperBound) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IrExpression convertIrCall(IrCall irCall) {
        if (!Intrinsics.areEqual((Object)irCall.getOrigin(), (Object)IrStatementOrigin.Companion.getMINUS())) return null;
        Object e2 = irCall.getArguments().get(1);
        if (!(e2 instanceof IrConst)) return null;
        IrConst irConst = (IrConst)e2;
        if (irConst == null) return null;
        boolean bl2 = Intrinsics.areEqual((Object)irConst.getValue(), (Object)1);
        if (!bl2) return null;
        if (!this.allowedMethods.contains(RangeToHandler.convertIrCall$dispatchReceiverName(irCall))) return null;
        IrExpression irExpression = irCall.getDispatchReceiver();
        return irExpression;
    }

    private final IrExpression convertIrConst(IrConst irConst) {
        IrExpression irExpression;
        int startOffset = irConst.getStartOffset();
        int endOffset = irConst.getEndOffset();
        IrType type2 = irConst.getType();
        IrConstKind irConstKind = irConst.getKind();
        if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Char.INSTANCE)) {
            Object object = irConst.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Char");
            char charValue = ((Character)object).charValue();
            irExpression = charValue != '\uffff' ? IrConstImpl.Companion.char(startOffset, endOffset, type2, (char)(charValue + '\u0001')) : null;
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Byte.INSTANCE)) {
            Object object = irConst.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Byte");
            byte byteValue = (Byte)object;
            irExpression = byteValue != 127 ? IrConstImpl.Companion.byte(startOffset, endOffset, type2, (byte)(byteValue + 1)) : null;
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Short.INSTANCE)) {
            Object object = irConst.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
            short shortValue = (Short)object;
            irExpression = shortValue != Short.MAX_VALUE ? IrConstImpl.Companion.short(startOffset, endOffset, type2, (short)(shortValue + 1)) : null;
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Int.INSTANCE)) {
            Object object = irConst.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            int intValue = (Integer)object;
            irExpression = intValue != Integer.MAX_VALUE ? IrConstImpl.Companion.int(startOffset, endOffset, type2, intValue + 1) : null;
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Long.INSTANCE)) {
            Object object = irConst.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            long longValue = (Long)object;
            irExpression = longValue != Long.MAX_VALUE ? IrConstImpl.Companion.long(startOffset, endOffset, type2, longValue + 1L) : null;
        } else {
            irExpression = null;
        }
        return irExpression;
    }

    private static final String convertIrCall$dispatchReceiverName(IrCall $this$convertIrCall_u24dispatchReceiverName) {
        IrExpression irExpression = $this$convertIrCall_u24dispatchReceiverName.getDispatchReceiver();
        Object object = irExpression instanceof IrCall ? (IrCall)irExpression : null;
        return String.valueOf(object != null && (object = ((IrCall)object).getSymbol()) != null && (object = (IrSimpleFunction)object.getOwner()) != null ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object) : null);
    }
}

