/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrPropertyAccessorsChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrPropertyAccessorsChecker
implements IrDeclarationChecker<IrProperty> {
    @NotNull
    public static final IrPropertyAccessorsChecker INSTANCE = new IrPropertyAccessorsChecker();

    private IrPropertyAccessorsChecker() {
    }

    @Override
    public void check(@NotNull IrProperty declaration2, @NotNull CheckerContext context2) {
        block3: {
            IrSimpleFunction it;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            IrSimpleFunction irSimpleFunction = declaration2.getGetter();
            if (irSimpleFunction != null) {
                it = irSimpleFunction;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getCorrespondingPropertySymbol(), (Object)declaration2.getSymbol())) {
                    context2.error(declaration2, "Getter of property '" + RenderIrElementKt.render$default(declaration2, null, 1, null) + "' has an inconsistent corresponding property symbol.");
                }
            }
            IrSimpleFunction irSimpleFunction2 = declaration2.getSetter();
            if (irSimpleFunction2 == null) break block3;
            it = irSimpleFunction2;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it.getCorrespondingPropertySymbol(), (Object)declaration2.getSymbol())) {
                context2.error(declaration2, "Setter of property '" + RenderIrElementKt.render$default(declaration2, null, 1, null) + "' has an inconsistent corresponding property symbol.");
            }
        }
    }
}

