/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptDependencyModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableSoftValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableWeakValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.ValueReferenceCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirBuiltinsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirAbstractSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirCommonSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirDanglingFileSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJvmSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirNativeSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirWasmSessionFactory;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.WasmPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatform;

@LLFirInternals
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J\u0018\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0015H\u0002JK\u0010\u0016\u001a\u00020\t\"\b\b\u0000\u0010\u0017*\u00020\b2\u0006\u0010\u0011\u001a\u0002H\u00172\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\t0\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bJ(\u0010 \u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\b2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0013J\u0006\u0010#\u001a\u00020\u001dJ\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\bJ\u0019\u0010&\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\bH\u0082\u0010J\u0006\u0010'\u001a\u00020\u001dJ\u0006\u0010(\u001a\u00020\u001dJ \u0010)\u001a\u00020\u001d2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J \u0010*\u001a\u00020\u001d2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J5\u0010+\u001a\u00020\u001d2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0082\bJ\u0010\u00100\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010\u0011\u001a\u00020\bH\u0002J\b\u00103\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010-\u001a\u00020\u0013*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sourceCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/SessionStorage;", "binaryCache", "danglingFileSessionCache", "unstableDanglingFileSessionCache", "createWeakValueCache", "createSoftValueCache", "getSession", "module", "preferBinary", "", "getDanglingFileCachedSession", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule;", "getCachedSession", "T", "storage", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "checkSessionValidity", "", "session", "removeSession", "removeSessionFrom", "removeAllSessions", "includeLibraryModules", "removeUnstableDanglingFileSessions", "removeContextualDanglingFileSessions", "contextModule", "hasContextModule", "removeAllDanglingFileSessions", "removeAllScriptSessions", "removeAllScriptSessionsFrom", "removeAllSessionsFrom", "removeAllMatchingSessionsFrom", "shouldBeRemoved", "supportsIsolatedSessionCreation", "getSupportsIsolatedSessionCreation", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Z", "createSession", "createPlatformAwareSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirAbstractSessionFactory;", "dispose", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n206#1:290\n207#1,4:292\n211#1:297\n206#1:298\n207#1,4:300\n211#1:305\n206#1:306\n207#1,4:308\n211#1:313\n206#1:314\n207#1,4:316\n211#1:321\n37#2,2:285\n37#2,2:287\n1#3:289\n1869#4:291\n1870#4:296\n1869#4:299\n1870#4:304\n1869#4:307\n1870#4:312\n1869#4:315\n1870#4:320\n1869#4,2:322\n1740#4,3:324\n1740#4,3:327\n1740#4,3:330\n1740#4,3:333\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n*L\n153#1:290\n153#1:292,4\n153#1:297\n167#1:298\n167#1:300,4\n167#1:305\n170#1:306\n170#1:308,4\n170#1:313\n196#1:314\n196#1:316,4\n196#1:321\n84#1:285,2\n101#1:287,2\n153#1:291\n153#1:296\n167#1:299\n167#1:304\n170#1:307\n170#1:312\n196#1:315\n196#1:320\n206#1:322,2\n247#1:324,3\n248#1:327,3\n249#1:330,3\n250#1:333,3\n*E\n"})
public final class LLFirSessionCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CleanableValueReferenceCache<KaModule, LLFirSession> sourceCache;
    @NotNull
    private final CleanableValueReferenceCache<KaModule, LLFirSession> binaryCache;
    @NotNull
    private final CleanableValueReferenceCache<KaModule, LLFirSession> danglingFileSessionCache;
    @NotNull
    private final CleanableValueReferenceCache<KaModule, LLFirSession> unstableDanglingFileSessionCache;

    public LLFirSessionCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sourceCache = this.createWeakValueCache();
        this.binaryCache = this.createSoftValueCache();
        this.danglingFileSessionCache = this.createWeakValueCache();
        this.unstableDanglingFileSessionCache = this.createWeakValueCache();
    }

    private final CleanableValueReferenceCache<KaModule, LLFirSession> createWeakValueCache() {
        return new CleanableWeakValueReferenceCache(LLFirSessionCache::createWeakValueCache$lambda$0);
    }

    private final CleanableValueReferenceCache<KaModule, LLFirSession> createSoftValueCache() {
        return new CleanableSoftValueReferenceCache(LLFirSessionCache::createSoftValueCache$lambda$1);
    }

    @NotNull
    public final LLFirSession getSession(@NotNull KaModule module2, boolean preferBinary) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        if (module2 instanceof KaBuiltinsModule && preferBinary) {
            return LLFirBuiltinsSessionFactory.Companion.getInstance(this.project).getBuiltinsSession(module2.getTargetPlatform());
        }
        if (module2 instanceof KaLibraryModule && (preferBinary || ((KaLibraryModule)module2).isSdk())) {
            return this.getCachedSession(module2, this.binaryCache, arg_0 -> LLFirSessionCache.getSession$lambda$2(this, module2, arg_0));
        }
        if (module2 instanceof KaDanglingFileModule) {
            return this.getDanglingFileCachedSession((KaDanglingFileModule)module2);
        }
        return this.getCachedSession(module2, this.sourceCache, (Function1)new Function1<KaModule, LLFirSession>((Object)this){

            public final LLFirSession invoke(KaModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
            }
        });
    }

    public static /* synthetic */ LLFirSession getSession$default(LLFirSessionCache lLFirSessionCache, KaModule kaModule, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return lLFirSessionCache.getSession(kaModule, bl2);
    }

    private final LLFirSession getDanglingFileCachedSession(KaDanglingFileModule module2) {
        if (KaModuleKt.isStable(module2)) {
            return this.getCachedSession((KaModule)module2, this.danglingFileSessionCache, (Function1)new Function1<KaModule, LLFirSession>((Object)this){

                public final LLFirSession invoke(KaModule p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
                }
            });
        }
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirSession session = this.unstableDanglingFileSessionCache.compute(module2, (Function2<KaModule, LLFirSession, LLFirSession>)((Function2)(arg_0, arg_1) -> LLFirSessionCache.getDanglingFileCachedSession$lambda$3(this, module2, arg_0, arg_1)));
        if (session == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.checkSessionValidity(session);
        return session;
    }

    private final <T extends KaModule> LLFirSession getCachedSession(T module2, CleanableValueReferenceCache<KaModule, LLFirSession> storage, Function1<? super T, ? extends LLFirSession> factory2) {
        LLFirSession lLFirSession;
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        if (this.getSupportsIsolatedSessionCreation(module2)) {
            lLFirSession = storage.computeIfAbsent(module2, (Function1<KaModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$4(factory2, module2, arg_0)));
        } else {
            lLFirSession = storage.get(module2);
            if (lLFirSession == null) {
                LLFirSessionCache $this$getCachedSession_u24lambda_u246 = this;
                boolean bl2 = false;
                LLFirSession newSession = (LLFirSession)factory2.invoke(module2);
                lLFirSession = storage.computeIfAbsent(module2, (Function1<KaModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$6$lambda$5(newSession, arg_0)));
            }
        }
        LLFirSession session = lLFirSession;
        this.checkSessionValidity(session);
        return session;
    }

    private final void checkSessionValidity(LLFirSession session) {
        if (!session.isValid()) {
            boolean bl2 = false;
            String string2 = "A session acquired via `getSession` should always be valid. Module: " + session.getKtModule();
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final boolean removeSession(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean didSourceSessionExist = this.removeSessionFrom(module2, this.sourceCache);
        boolean didBinarySessionExist = module2 instanceof KaLibraryModule && this.removeSessionFrom(module2, this.binaryCache);
        boolean didDanglingFileSessionExist = module2 instanceof KaDanglingFileModule && this.removeSessionFrom(module2, this.danglingFileSessionCache);
        boolean didUnstableDanglingFileSessionExist = module2 instanceof KaDanglingFileModule && this.removeSessionFrom(module2, this.unstableDanglingFileSessionCache);
        return didSourceSessionExist || didBinarySessionExist || didDanglingFileSessionExist || didUnstableDanglingFileSessionExist;
    }

    private final boolean removeSessionFrom(KaModule module2, CleanableValueReferenceCache<KaModule, LLFirSession> storage) {
        return storage.remove(module2) != null;
    }

    public final void removeAllSessions(boolean includeLibraryModules) {
        if (includeLibraryModules) {
            this.removeAllSessionsFrom(this.sourceCache);
            this.removeAllSessionsFrom(this.binaryCache);
        } else {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableValueReferenceCache<KaModule, LLFirSession> storage$iv = this.sourceCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl2 = false;
                KaModule it = module$iv;
                boolean bl3 = false;
                if (!(!(it instanceof KaLibraryModule) && !(it instanceof KaLibrarySourceModule))) continue;
                storage$iv.remove(module$iv);
            }
        }
        this.removeAllDanglingFileSessions();
    }

    public final void removeUnstableDanglingFileSessions() {
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeContextualDanglingFileSessions(@NotNull KaModule contextModule) {
        Intrinsics.checkNotNullParameter((Object)contextModule, (String)"contextModule");
        this.removeUnstableDanglingFileSessions();
        if (contextModule instanceof KaDanglingFileModule) {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableValueReferenceCache<KaModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl2 = false;
                KaModule it = module$iv;
                boolean bl3 = false;
                if (!(it instanceof KaDanglingFileModule && this.hasContextModule((KaDanglingFileModule)it, contextModule))) continue;
                storage$iv.remove(module$iv);
            }
        } else {
            LLFirSessionCache this_$iv = this;
            CleanableValueReferenceCache<KaModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl4 = false;
                KaModule it = module$iv;
                boolean bl5 = false;
                if (!(it instanceof KaDanglingFileModule && ((KaDanglingFileModule)it).isCodeFragment())) continue;
                storage$iv.remove(module$iv);
            }
        }
    }

    private final boolean hasContextModule(KaDanglingFileModule module2, KaModule contextModule) {
        boolean bl2;
        block2: {
            LLFirSessionCache lLFirSessionCache = this;
            while (true) {
                KaModule candidate;
                if (Intrinsics.areEqual((Object)(candidate = module2.getContextModule()), (Object)contextModule)) {
                    bl2 = true;
                    break block2;
                }
                if (!(candidate instanceof KaDanglingFileModule)) break;
                LLFirSessionCache lLFirSessionCache2 = lLFirSessionCache;
                KaDanglingFileModule kaDanglingFileModule = (KaDanglingFileModule)candidate;
                KaModule kaModule = contextModule;
                lLFirSessionCache = lLFirSessionCache2;
                module2 = kaDanglingFileModule;
                contextModule = kaModule;
            }
            bl2 = false;
        }
        return bl2;
    }

    public final void removeAllDanglingFileSessions() {
        this.removeAllSessionsFrom(this.danglingFileSessionCache);
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeAllScriptSessions() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeAllScriptSessionsFrom(this.sourceCache);
        this.removeAllScriptSessionsFrom(this.binaryCache);
    }

    private final void removeAllScriptSessionsFrom(CleanableValueReferenceCache<KaModule, LLFirSession> storage) {
        LLFirSessionCache this_$iv = this;
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv$iv = storage.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            KaModule module$iv = (KaModule)element$iv$iv;
            boolean bl2 = false;
            KaModule it = module$iv;
            boolean bl3 = false;
            if (!(it instanceof KaScriptModule || it instanceof KaScriptDependencyModule)) continue;
            storage.remove(module$iv);
        }
    }

    private final void removeAllSessionsFrom(CleanableValueReferenceCache<KaModule, LLFirSession> storage) {
        storage.clear();
    }

    private final void removeAllMatchingSessionsFrom(CleanableValueReferenceCache<KaModule, LLFirSession> storage, Function1<? super KaModule, Boolean> shouldBeRemoved) {
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv = storage.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KaModule module2 = (KaModule)element$iv;
            boolean bl2 = false;
            if (!((Boolean)shouldBeRemoved.invoke((Object)module2)).booleanValue()) continue;
            storage.remove(module2);
        }
    }

    private final boolean getSupportsIsolatedSessionCreation(KaModule $this$supportsIsolatedSessionCreation) {
        return !($this$supportsIsolatedSessionCreation instanceof KaDanglingFileModule);
    }

    private final LLFirSession createSession(KaModule module2) {
        LLFirSession lLFirSession;
        LLFirAbstractSessionFactory sessionFactory = this.createPlatformAwareSessionFactory(module2);
        KaModule kaModule = module2;
        if (kaModule instanceof KaSourceModule) {
            lLFirSession = sessionFactory.createSourcesSession((KaSourceModule)module2);
        } else if (kaModule instanceof KaBuiltinsModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaLibraryModule) {
            lLFirSession = ((KaLibraryModule)module2).isSdk() ? (LLFirSession)sessionFactory.createBinaryLibrarySession((KaLibraryModule)module2) : (LLFirSession)sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaLibrarySourceModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaScriptModule) {
            lLFirSession = sessionFactory.createScriptSession((KaScriptModule)module2);
        } else if (kaModule instanceof KaDanglingFileModule) {
            LLFirSession contextSession = this.getSession(((KaDanglingFileModule)module2).getContextModule(), false);
            lLFirSession = sessionFactory.createDanglingFileSession((KaDanglingFileModule)module2, contextSession);
        } else if (kaModule instanceof KaNotUnderContentRootModule) {
            lLFirSession = sessionFactory.createNotUnderContentRootResolvableSession((KaNotUnderContentRootModule)module2);
        } else {
            throw new IllegalStateException(("Unexpected module kind: " + Reflection.getOrCreateKotlinClass(module2.getClass()).getSimpleName()).toString());
        }
        return lLFirSession;
    }

    private final LLFirAbstractSessionFactory createPlatformAwareSessionFactory(KaModule module2) {
        LLFirAbstractSessionFactory lLFirAbstractSessionFactory;
        SimplePlatform it;
        boolean bl2;
        boolean $i$f$all;
        Iterable $this$all$iv;
        TargetPlatform targetPlatform;
        block18: {
            targetPlatform = module2.getTargetPlatform();
            $this$all$iv = targetPlatform;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (SimplePlatform)element$iv;
                    boolean bl3 = false;
                    if (it instanceof JvmPlatform) continue;
                    bl2 = false;
                    break block18;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            lLFirAbstractSessionFactory = new LLFirJvmSessionFactory(this.project);
        } else {
            boolean bl4;
            block19: {
                $this$all$iv = targetPlatform;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (SimplePlatform)element$iv;
                        boolean bl5 = false;
                        if (it instanceof JsPlatform) continue;
                        bl4 = false;
                        break block19;
                    }
                    bl4 = true;
                }
            }
            if (bl4) {
                lLFirAbstractSessionFactory = new LLFirJsSessionFactory(this.project);
            } else {
                boolean bl6;
                block20: {
                    $this$all$iv = targetPlatform;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl6 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (SimplePlatform)element$iv;
                            boolean bl7 = false;
                            if (it instanceof WasmPlatform) continue;
                            bl6 = false;
                            break block20;
                        }
                        bl6 = true;
                    }
                }
                if (bl6) {
                    lLFirAbstractSessionFactory = new LLFirWasmSessionFactory(this.project);
                } else {
                    boolean bl8;
                    block21: {
                        $this$all$iv = targetPlatform;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl8 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it = (SimplePlatform)element$iv;
                                boolean bl9 = false;
                                if (it instanceof NativePlatform) continue;
                                bl8 = false;
                                break block21;
                            }
                            bl8 = true;
                        }
                    }
                    lLFirAbstractSessionFactory = bl8 ? (LLFirAbstractSessionFactory)new LLFirNativeSessionFactory(this.project) : (LLFirAbstractSessionFactory)new LLFirCommonSessionFactory(this.project);
                }
            }
        }
        return lLFirAbstractSessionFactory;
    }

    @Override
    public void dispose() {
    }

    private static final ValueReferenceCleaner createWeakValueCache$lambda$0(LLFirSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LLFirSessionCleaner(it.getRequestedDisposableOrNull$low_level_api_fir());
    }

    private static final ValueReferenceCleaner createSoftValueCache$lambda$1(LLFirSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LLFirSessionCleaner(it.getRequestedDisposableOrNull$low_level_api_fir());
    }

    private static final LLFirSession getSession$lambda$2(LLFirSessionCache this$0, KaModule $module, KaLibraryModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createPlatformAwareSessionFactory($module).createBinaryLibrarySession((KaLibraryModule)$module);
    }

    private static final LLFirSession getDanglingFileCachedSession$lambda$3(LLFirSessionCache this$0, KaDanglingFileModule $module, KaModule kaModule, LLFirSession existingSession) {
        Intrinsics.checkNotNullParameter((Object)kaModule, (String)"<unused var>");
        return existingSession instanceof LLFirDanglingFileSession && !((LLFirDanglingFileSession)existingSession).getHasFileModifications() ? existingSession : this$0.createSession($module);
    }

    private static final LLFirSession getCachedSession$lambda$4(Function1 $factory, KaModule $module, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LLFirSession)$factory.invoke((Object)$module);
    }

    private static final LLFirSession getCachedSession$lambda$6$lambda$5(LLFirSession $newSession, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $newSession;
    }

    public static final /* synthetic */ LLFirSession access$createSession(LLFirSessionCache $this, KaModule module2) {
        return $this.createSession(module2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    @SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,284:1\n31#2,2:285\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion\n*L\n41#1:285,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = project;
            boolean $i$f$service = false;
            Class<LLFirSessionCache> serviceClass$iv = LLFirSessionCache.class;
            LLFirSessionCache lLFirSessionCache = $this$service$iv.getService(serviceClass$iv);
            if (lLFirSessionCache == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            return lLFirSessionCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

