/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.packages;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.messages.MessageBusConnection;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTopics;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationKind;
import org.jetbrains.kotlin.analysis.api.platform.packages.KotlinPackageProvider;
import org.jetbrains.kotlin.analysis.api.platform.packages.KotlinPackageProviderFactory;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH$J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016R/\u0010\u0007\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/packages/KotlinCachingPackageProviderFactory;", "Lorg/jetbrains/kotlin/analysis/api/platform/packages/KotlinPackageProviderFactory;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "packageProviderCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/psi/search/GlobalSearchScope;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/analysis/api/platform/packages/KotlinPackageProvider;", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "createNewPackageProvider", "searchScope", "createPackageProvider", "invalidateAll", "", "dispose", "analysis-api-platform-interface"})
@SourceDebugExtension(value={"SMAP\nKotlinCachingPackageProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCachingPackageProviderFactory.kt\norg/jetbrains/kotlin/analysis/api/platform/packages/KotlinCachingPackageProviderFactory\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,87:1\n81#2,7:88\n76#2,2:95\n57#2:97\n78#2:98\n*S KotlinDebug\n*F\n+ 1 KotlinCachingPackageProviderFactory.kt\norg/jetbrains/kotlin/analysis/api/platform/packages/KotlinCachingPackageProviderFactory\n*L\n75#1:88,7\n75#1:95,2\n75#1:97\n75#1:98\n*E\n"})
public abstract class KotlinCachingPackageProviderFactory
implements KotlinPackageProviderFactory,
Disposable {
    @NotNull
    private final LoadingCache<GlobalSearchScope, KotlinPackageProvider> packageProviderCache;

    public KotlinCachingPackageProviderFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LoadingCache<Object, KotlinPackageProvider> loadingCache = Caffeine.newBuilder().weakKeys().expireAfterAccess(Duration.ofSeconds(30L)).build(arg_0 -> KotlinCachingPackageProviderFactory.packageProviderCache$lambda$0((Function1)new Function1<GlobalSearchScope, KotlinPackageProvider>((Object)this){

            public final KotlinPackageProvider invoke(GlobalSearchScope p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((KotlinCachingPackageProviderFactory)this.receiver).createNewPackageProvider(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(loadingCache, (String)"build(...)");
        this.packageProviderCache = loadingCache;
        MessageBusConnection connection = KotlinMessageBusProviderKt.getAnalysisMessageBus(project).connect(this);
        connection.subscribe(KotlinModificationTopics.INSTANCE.getMODULE_STATE_MODIFICATION(), (arg_0, arg_1) -> KotlinCachingPackageProviderFactory._init_$lambda$1(this, arg_0, arg_1));
        connection.subscribe(KotlinModificationTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION(), arg_0 -> KotlinCachingPackageProviderFactory._init_$lambda$2(this, arg_0));
        connection.subscribe(KotlinModificationTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION(), () -> KotlinCachingPackageProviderFactory._init_$lambda$3(this));
        connection.subscribe(KotlinModificationTopics.INSTANCE.getGLOBAL_SOURCE_MODULE_STATE_MODIFICATION(), () -> KotlinCachingPackageProviderFactory._init_$lambda$4(this));
        connection.subscribe(KotlinModificationTopics.INSTANCE.getGLOBAL_SCRIPT_MODULE_STATE_MODIFICATION(), () -> KotlinCachingPackageProviderFactory._init_$lambda$5(this));
        connection.subscribe(KotlinModificationTopics.INSTANCE.getGLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION(), () -> KotlinCachingPackageProviderFactory._init_$lambda$6(this));
    }

    @NotNull
    protected abstract KotlinPackageProvider createNewPackageProvider(@NotNull GlobalSearchScope var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KotlinPackageProvider createPackageProvider(@NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        KotlinPackageProvider kotlinPackageProvider = this.packageProviderCache.get(searchScope);
        if (kotlinPackageProvider == null) {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Couldn't create a package provider for the given scope.";
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl2 = false;
            void $this$createPackageProvider_u24lambda_u247 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl3 = false;
            $this$createPackageProvider_u24lambda_u247.withEntry("scope", searchScope.toString());
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        return kotlinPackageProvider;
    }

    private final void invalidateAll() {
        this.packageProviderCache.invalidateAll();
    }

    @Override
    public void dispose() {
    }

    private static final KotlinPackageProvider packageProviderCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (KotlinPackageProvider)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$1(KotlinCachingPackageProviderFactory this$0, KaModule kaModule, KotlinModuleStateModificationKind kotlinModuleStateModificationKind) {
        Intrinsics.checkNotNullParameter((Object)kaModule, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinModuleStateModificationKind), (String)"<unused var>");
        this$0.invalidateAll();
    }

    private static final void _init_$lambda$2(KotlinCachingPackageProviderFactory this$0, KaModule kaModule) {
        Intrinsics.checkNotNullParameter((Object)kaModule, (String)"<unused var>");
        this$0.invalidateAll();
    }

    private static final void _init_$lambda$3(KotlinCachingPackageProviderFactory this$0) {
        this$0.invalidateAll();
    }

    private static final void _init_$lambda$4(KotlinCachingPackageProviderFactory this$0) {
        this$0.invalidateAll();
    }

    private static final void _init_$lambda$5(KotlinCachingPackageProviderFactory this$0) {
        this$0.invalidateAll();
    }

    private static final void _init_$lambda$6(KotlinCachingPackageProviderFactory this$0) {
        this$0.invalidateAll();
    }
}

