/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0012\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ&\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0007J1\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0001\u0010\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\u00150\u0017\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0001\u0010\u001a*\u00028\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u001e\u001a\u0002H\u001a\"\b\b\u0001\u0010\u001a*\u00028\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001dJ%\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000!\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/extensions/ProjectExtensionPointName;", "T", "", "Lcom/intellij/openapi/extensions/BaseExtensionPointName;", "name", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)V", "addChangeListener", "", "areaInstance", "Lcom/intellij/openapi/extensions/AreaInstance;", "listener", "Ljava/lang/Runnable;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addExtensionPointListener", "Lcom/intellij/openapi/extensions/ExtensionPointListener;", "asSequence", "Lkotlin/sequences/Sequence;", "computeSafeIfAny", "R", "processor", "Ljava/util/function/Function;", "(Lcom/intellij/openapi/extensions/AreaInstance;Ljava/util/function/Function;)Ljava/lang/Object;", "findExtension", "V", "instanceOf", "Ljava/lang/Class;", "(Ljava/lang/Class;Lcom/intellij/openapi/extensions/AreaInstance;)Ljava/lang/Object;", "findExtensionOrFail", "findFirstSafe", "predicate", "Ljava/util/function/Predicate;", "(Lcom/intellij/openapi/extensions/AreaInstance;Ljava/util/function/Predicate;)Ljava/lang/Object;", "getExtensions", "", "getPoint", "Lcom/intellij/openapi/extensions/ExtensionPoint;", "hasAnyExtensions", "", "intellij.platform.extensions"})
@SourceDebugExtension(value={"SMAP\nProjectExtensionPointName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectExtensionPointName.kt\ncom/intellij/openapi/extensions/ProjectExtensionPointName\n+ 2 ExtensionProcessingHelper.kt\ncom/intellij/openapi/extensions/impl/ExtensionProcessingHelper\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n31#2,14:56\n47#2:71\n11#3:70\n*S KotlinDebug\n*F\n+ 1 ProjectExtensionPointName.kt\ncom/intellij/openapi/extensions/ProjectExtensionPointName\n*L\n42#1:56,14\n42#1:71\n42#1:70\n*E\n"})
public final class ProjectExtensionPointName<T>
extends BaseExtensionPointName<T> {
    public ProjectExtensionPointName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(name2, null);
    }

    @NotNull
    public final ExtensionPoint<T> getPoint(@NotNull AreaInstance areaInstance) {
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        return this.getPointImpl(areaInstance);
    }

    @NotNull
    public final List<T> getExtensions(@NotNull AreaInstance areaInstance) {
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        return this.getPointImpl(areaInstance).getExtensionList();
    }

    @Nullable
    public final <V extends T> V findExtension(@NotNull Class<V> instanceOf, @NotNull AreaInstance areaInstance) {
        Intrinsics.checkNotNullParameter(instanceOf, (String)"instanceOf");
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        return this.getPointImpl(areaInstance).findExtension(instanceOf, false, ThreeState.UNSURE);
    }

    @NotNull
    public final <V extends T> V findExtensionOrFail(@NotNull Class<V> instanceOf, @NotNull AreaInstance areaInstance) {
        Intrinsics.checkNotNullParameter(instanceOf, (String)"instanceOf");
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        V v2 = this.getPointImpl(areaInstance).findExtension(instanceOf, true, ThreeState.UNSURE);
        Intrinsics.checkNotNull(v2);
        return v2;
    }

    public final boolean hasAnyExtensions(@NotNull AreaInstance areaInstance) {
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        return this.getPointImpl(areaInstance).size() != 0;
    }

    @Nullable
    public final T findFirstSafe(@NotNull AreaInstance areaInstance, @NotNull Predicate<? super T> predicate) {
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return ExtensionProcessingHelper.INSTANCE.findFirstSafe$intellij_platform_extensions(predicate, this.getPointImpl(areaInstance).asSequence());
    }

    @Nullable
    public final <R> R computeSafeIfAny(@NotNull AreaInstance areaInstance, @NotNull Function<T, R> processor) {
        R r2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            ExtensionProcessingHelper extensionProcessingHelper = ExtensionProcessingHelper.INSTANCE;
            Sequence sequence$iv = this.getPointImpl(areaInstance).asSequence();
            boolean $i$f$computeSafeIfAny$intellij_platform_extensions = false;
            for (Object t$iv : sequence$iv) {
                try {
                    Object p0 = t$iv;
                    boolean bl2 = false;
                    R r3 = processor.apply(p0);
                    if (r3 == null) continue;
                    R it$iv = r3;
                    boolean bl3 = false;
                    r2 = it$iv;
                    break block5;
                }
                catch (ProcessCanceledException e$iv) {
                    throw e$iv;
                }
                catch (CancellationException e$iv) {
                    throw e$iv;
                }
                catch (Throwable e$iv) {
                    boolean $i$f$logger = false;
                    Logger logger2 = Logger.getInstance(ExtensionPointImpl.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.error(e$iv);
                }
            }
            r2 = null;
        }
        return r2;
    }

    public final void addExtensionPointListener(@NotNull AreaInstance areaInstance, @NotNull ExtensionPointListener<T> listener2, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.getPointImpl(areaInstance).addExtensionPointListener(listener2, false, parentDisposable);
    }

    public final void addChangeListener(@NotNull AreaInstance areaInstance, @NotNull Runnable listener2, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.getPointImpl(areaInstance).addChangeListener(listener2, parentDisposable);
    }

    @ApiStatus.Experimental
    @NotNull
    public final Sequence<T> asSequence(@NotNull AreaInstance areaInstance) {
        Intrinsics.checkNotNullParameter((Object)areaInstance, (String)"areaInstance");
        return this.getPointImpl(areaInstance).asSequence();
    }
}

