/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

public class JvmClassName {
    private final String internalName;
    private FqName fqName;

    @NotNull
    public static JvmClassName byInternalName(@NotNull String internalName) {
        if (internalName == null) {
            JvmClassName.$$$reportNull$$$0(0);
        }
        return new JvmClassName(internalName);
    }

    @NotNull
    public static JvmClassName byClassId(@NotNull ClassId classId) {
        if (classId == null) {
            JvmClassName.$$$reportNull$$$0(1);
        }
        return new JvmClassName(JvmClassName.internalNameByClassId(classId));
    }

    @NotNull
    public static String internalNameByClassId(@NotNull ClassId classId) {
        if (classId == null) {
            JvmClassName.$$$reportNull$$$0(2);
        }
        FqName packageFqName = classId.getPackageFqName();
        String relativeClassName = classId.getRelativeClassName().asString().replace('.', '$');
        String string2 = packageFqName.isRoot() ? relativeClassName : packageFqName.asString().replace('.', '/') + "/" + relativeClassName;
        if (string2 == null) {
            JvmClassName.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull FqName fqName) {
        if (fqName == null) {
            JvmClassName.$$$reportNull$$$0(4);
        }
        JvmClassName r2 = new JvmClassName(fqName.asString().replace('.', '/'));
        r2.fqName = fqName;
        JvmClassName jvmClassName = r2;
        if (jvmClassName == null) {
            JvmClassName.$$$reportNull$$$0(5);
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull String fqName) {
        if (fqName == null) {
            JvmClassName.$$$reportNull$$$0(6);
        }
        return JvmClassName.byFqNameWithoutInnerClasses(new FqName(fqName));
    }

    private JvmClassName(@NotNull String internalName) {
        if (internalName == null) {
            JvmClassName.$$$reportNull$$$0(7);
        }
        this.internalName = internalName;
    }

    @NotNull
    public FqName getFqNameForClassNameWithoutDollars() {
        if (this.fqName == null) {
            this.fqName = new FqName(this.internalName.replace('$', '.').replace('/', '.'));
        }
        FqName fqName = this.fqName;
        if (fqName == null) {
            JvmClassName.$$$reportNull$$$0(8);
        }
        return fqName;
    }

    @NotNull
    public FqName getFqNameForTopLevelClassMaybeWithDollars() {
        return new FqName(this.internalName.replace('/', '.'));
    }

    @NotNull
    public FqName getPackageFqName() {
        int lastSlash = this.internalName.lastIndexOf("/");
        if (lastSlash == -1) {
            FqName fqName = FqName.ROOT;
            if (fqName == null) {
                JvmClassName.$$$reportNull$$$0(9);
            }
            return fqName;
        }
        return new FqName(this.internalName.substring(0, lastSlash).replace('/', '.'));
    }

    @NotNull
    public String getInternalName() {
        String string2 = this.internalName;
        if (string2 == null) {
            JvmClassName.$$$reportNull$$$0(10);
        }
        return string2;
    }

    public String toString() {
        return this.internalName;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        return this.internalName.equals(((JvmClassName)o2).internalName);
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/JvmClassName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/JvmClassName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "internalNameByClassId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "byFqNameWithoutInnerClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameForClassNameWithoutDollars";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFqName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "byInternalName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "byClassId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "internalNameByClassId";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "byFqNameWithoutInnerClasses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

