/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002!\"B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J(\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001dH\u0002J \u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002#$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "classKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "check", "", "declaration", "containingDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkFinalUpperBounds", "checkExtensionFunctionTypeBound", "checkTypeAliasBound", "checkOnlyOneTypeParameterBound", "checkBoundUniqueness", "checkConflictingBounds", "checkDynamicBounds", "isRelated", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "checkInconsistentTypeParameterBounds", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n37#2:207\n37#2:208\n1869#3,2:209\n1869#3,2:211\n774#3:213\n865#3,2:214\n1869#3,2:216\n1669#3,8:218\n3307#3,10:226\n774#3:236\n865#3,2:237\n774#3:239\n865#3,2:240\n1669#3,8:242\n1869#3,2:250\n1869#3,2:252\n1563#3:254\n1634#3,3:255\n1869#3,2:258\n1869#3:260\n1869#3,2:261\n1870#3:263\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker\n*L\n75#1:207\n76#1:208\n78#1:209,2\n89#1:211,2\n103#1:213\n103#1:214,2\n103#1:216,2\n110#1:218,8\n111#1:226,10\n118#1:236\n118#1:237,2\n134#1:239\n134#1:240,2\n135#1:242,8\n137#1:250,2\n145#1:252,2\n166#1:254\n166#1:255,3\n173#1:258,2\n152#1:260\n154#1:261,2\n152#1:263\n*E\n"})
public abstract class FirTypeParameterBoundsChecker
extends FirDeclarationChecker<FirTypeParameter> {
    @NotNull
    private final Set<ClassKind> classKinds;

    private FirTypeParameterBoundsChecker(MppCheckerKind mppKind) {
        super(mppKind);
        ClassKind[] classKindArray = new ClassKind[]{ClassKind.CLASS, ClassKind.ENUM_CLASS, ClassKind.OBJECT};
        this.classKinds = SetsKt.setOf((Object[])classKindArray);
    }

    protected final void check(@NotNull FirTypeParameter declaration2, @NotNull FirDeclaration containingDeclaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)containingDeclaration, (String)"containingDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (containingDeclaration instanceof FirConstructor) {
            return;
        }
        this.checkFinalUpperBounds(declaration2, containingDeclaration, context2, reporter);
        this.checkExtensionFunctionTypeBound(declaration2, context2, reporter);
        FirMemberDeclaration firMemberDeclaration = containingDeclaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration : null;
        if (!(firMemberDeclaration != null ? FirHelpersKt.isInlineOnly(firMemberDeclaration, context2.getSession()) : false)) {
            this.checkOnlyOneTypeParameterBound(declaration2, context2, reporter);
        }
        this.checkBoundUniqueness(declaration2, context2, reporter);
        this.checkConflictingBounds(declaration2, context2, reporter);
        this.checkTypeAliasBound(declaration2, containingDeclaration, context2, reporter);
        this.checkDynamicBounds(declaration2, context2, reporter);
        this.checkInconsistentTypeParameterBounds(declaration2, context2, reporter);
    }

    private final void checkFinalUpperBounds(FirTypeParameter declaration2, FirDeclaration containingDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        boolean $i$f$isOverride;
        FirMemberDeclaration $this$isOverride$iv;
        if (containingDeclaration instanceof FirSimpleFunction) {
            $this$isOverride$iv = (FirMemberDeclaration)containingDeclaration;
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        if (containingDeclaration instanceof FirProperty) {
            $this$isOverride$iv = (FirMemberDeclaration)containingDeclaration;
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        Iterable $this$forEach$iv = declaration2.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound = (FirResolvedTypeRef)element$iv;
            boolean bl2 = false;
            ConeKotlinType boundType = bound.getConeType();
            if (boundType instanceof ConeDynamicType || TypeUtilsKt.canHaveSubtypesAccordingToK1(boundType, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getFINAL_UPPER_BOUND(), (Object)bound.getConeType(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkExtensionFunctionTypeBound(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration2.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound = (FirResolvedTypeRef)element$iv;
            boolean bl2 = false;
            if (!TypeUtilsKt.isExtensionFunctionType(bound, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getUPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeAliasBound(FirTypeParameter declaration2, FirDeclaration containingDeclaration, CheckerContext context2, DiagnosticReporter reporter) {
        if (containingDeclaration instanceof FirTypeAlias) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = declaration2.getBounds();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirTypeRef it = (FirTypeRef)element$iv$iv;
                boolean bl2 = false;
                KtSourceElement ktSourceElement = it.getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeRef bound = (FirTypeRef)element$iv;
                boolean bl3 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getBOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$distinctBy$iv = declaration2.getSymbol().getResolvedBounds();
        boolean $i$f$distinctBy = false;
        HashSet<ConeKotlinType> set$iv = new HashSet<ConeKotlinType>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)e$iv;
            boolean bl2 = false;
            ConeKotlinType key$iv = it.getConeType();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List bounds2 = list$iv;
        Iterable $this$partition$iv = bounds2;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
            boolean bl3 = false;
            boolean bl4 = it.getConeType() instanceof ConeTypeParameterType ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List boundWithParam = (List)pair.component1();
        List otherBounds = (List)pair.component2();
        if (boundWithParam.size() > 1 || boundWithParam.size() == 1 && !((Collection)otherBounds).isEmpty()) {
            KtSourceElement ktSourceElement;
            void $this$filterTo$iv$iv;
            SourceNavigator $this$checkOnlyOneTypeParameterBound_u24lambda_u247 = SourceNavigator.Companion.forElement(declaration2);
            boolean bl5 = false;
            Iterable $this$filter$iv = bounds2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                boolean bl6 = false;
                if (!$this$checkOnlyOneTypeParameterBound_u24lambda_u247.isInTypeConstraint(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set constraintBounds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (bounds2.size() == 2) {
                FirResolvedTypeRef boundDecl;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.firstOrNull((List)otherBounds);
                if (firResolvedTypeRef == null) {
                    firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.last((List)boundWithParam);
                }
                ktSourceElement = constraintBounds.contains(boundDecl = firResolvedTypeRef) ? boundDecl.getSource() : declaration2.getSource();
            } else {
                ktSourceElement = declaration2.getSource();
            }
            KtSourceElement reportOn = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportOn, FirErrors.INSTANCE.getBOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBoundUniqueness(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirResolvedTypeRef bound;
        FirResolvedTypeRef it;
        void $this$filterTo$iv$iv;
        Set seenClasses = new LinkedHashSet();
        Iterable $this$filter$iv = declaration2.getSymbol().getResolvedBounds();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirResolvedTypeRef)element$iv$iv;
            boolean bl2 = false;
            if (!(!(it instanceof FirErrorTypeRef))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allNonErrorBounds = (List)destination$iv$iv;
        Iterable $this$distinctBy$iv = allNonErrorBounds;
        boolean $i$f$distinctBy = false;
        HashSet<ClassId> set$iv = new HashSet<ClassId>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ClassId key$iv;
            it = (FirResolvedTypeRef)e$iv;
            boolean bl3 = false;
            Object object = FirHelpersKt.fullyExpandedClassId(it.getConeType(), context2.getSession());
            if (object == null) {
                object = it.getConeType();
            }
            if (!set$iv.add(key$iv = object)) continue;
            list$iv.add(e$iv);
        }
        List uniqueBounds = list$iv;
        Iterable $this$forEach$iv = uniqueBounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirRegularClassSymbol symbol;
            bound = (FirResolvedTypeRef)element$iv;
            boolean bl4 = false;
            if (ToSymbolUtilsKt.toRegularClassSymbol(bound.getConeType(), context2.getSession()) == null) continue;
            boolean bl5 = false;
            if (!this.classKinds.contains((Object)symbol.getClassKind()) || !seenClasses.add(symbol) || seenClasses.size() <= 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getONLY_ONE_CLASS_BOUND_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
        }
        $this$forEach$iv = CollectionsKt.minus((Iterable)allNonErrorBounds, (Iterable)uniqueBounds);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            bound = (FirResolvedTypeRef)element$iv;
            boolean bl6 = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getREPEATED_BOUND(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConflictingBounds(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        block5: {
            block4: {
                Collection<ConeKotlinType> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object = (FirTypeRef)CollectionsKt.singleOrNull(declaration2.getBounds());
                if (object != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? ConeBuiltinTypeUtilsKt.isNothing((ConeKotlinType)object) : false) break block4;
                if (declaration2.getBounds().size() < 2) break block5;
                Iterable iterable = declaration2.getSymbol().getResolvedBounds();
                FirTypeParameterBoundsChecker firTypeParameterBoundsChecker = this;
                CheckerContext checkerContext = context2;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getConeType());
                }
                collection = (List)destination$iv$iv;
                if (!FirTypeParameterBoundsChecker.checkConflictingBounds$anyConflictingTypes(checkerContext, firTypeParameterBoundsChecker, (List<? extends ConeKotlinType>)collection)) break block5;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getCONFLICTING_UPPER_BOUNDS(), (Object)declaration2.getSymbol(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkDynamicBounds(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration2.getBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeRef bound = (FirTypeRef)element$iv;
            boolean bl2 = false;
            if (!(FirTypeUtilsKt.getConeType(bound) instanceof ConeDynamicType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getDYNAMIC_UPPER_BOUND(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean isRelated(KotlinTypeMarker $this$isRelated, TypeCheckerProviderContext context2, KotlinTypeMarker type2) {
        return TypeUtilsKt.isSubtypeOf($this$isRelated, context2, type2) || FirHelpersKt.isSupertypeOf($this$isRelated, context2, type2);
    }

    private final void checkInconsistentTypeParameterBounds(FirTypeParameter declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        if (declaration2.getBounds().size() <= 1) {
            return;
        }
        List firTypeRefClasses = new ArrayList();
        Set firRegularClassesSet = new LinkedHashSet();
        for (FirResolvedTypeRef bound : declaration2.getSymbol().getResolvedBounds()) {
            FirRegularClassSymbol classSymbol;
            if (FirHelpersKt.toRegularClassSymbol(bound, context2.getSession()) == null) continue;
            if (!firRegularClassesSet.add(classSymbol)) {
                return;
            }
            firTypeRefClasses.add(TuplesKt.to((Object)bound, (Object)classSymbol));
        }
        FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(firTypeRefClasses, context2, reporter, declaration2.getSource(), false);
    }

    private static final boolean checkConflictingBounds$anyConflictingTypes(CheckerContext $context, FirTypeParameterBoundsChecker this$0, List<? extends ConeKotlinType> types2) {
        Iterable $this$forEach$iv = types2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeKotlinType type2 = (ConeKotlinType)element$iv;
            boolean bl2 = false;
            if (TypeUtilsKt.canHaveSubtypesAccordingToK1(type2, $context.getSession())) continue;
            Iterable $this$forEach$iv2 = types2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConeKotlinType otherType = (ConeKotlinType)element$iv2;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)type2, (Object)otherType) || this$0.isRelated(type2, TypeComponentsKt.getTypeContext($context.getSession()), otherType)) continue;
                return true;
            }
        }
        return false;
    }

    public /* synthetic */ FirTypeParameterBoundsChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,206:1\n34#2:207\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass\n*L\n36#1:207\n*E\n"})
    public static final class ForExpectClass
    extends FirTypeParameterBoundsChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirTypeParameter declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            if (firDeclaration == null) {
                return;
            }
            FirDeclaration containingDeclaration = firDeclaration;
            FirMemberDeclaration firMemberDeclaration = containingDeclaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl2 = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl2 = false;
            }
            if (!bl2) {
                return;
            }
            this.check(declaration2, containingDeclaration, context2, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,206:1\n34#2:207\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular\n*L\n28#1:207\n*E\n"})
    public static final class Regular
    extends FirTypeParameterBoundsChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirTypeParameter declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            if (firDeclaration == null) {
                return;
            }
            FirDeclaration containingDeclaration = firDeclaration;
            FirMemberDeclaration firMemberDeclaration = containingDeclaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl2 = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
            this.check(declaration2, containingDeclaration, context2, reporter);
        }
    }
}

