/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.h;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSpliterator;
import it.unimi.dsi.fastutil.ints.Y;
import it.unimi.dsi.fastutil.ints.ag;
import it.unimi.dsi.fastutil.ints.q;
import it.unimi.dsi.fastutil.ints.r;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public class IntLinkedOpenHashSet
extends r
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient int[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(int expected, float f2) {
        void var2_2;
        void var1_1;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        IntLinkedOpenHashSet intLinkedOpenHashSet = this;
        intLinkedOpenHashSet.minN = intLinkedOpenHashSet.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new int[this.n + 1];
        this.link = new long[this.n + 1];
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(int expected) {
        this((int)var1_1, 0.75f);
        void var1_1;
    }

    public IntLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(Collection<? extends Integer> c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((q)this).addAll((Collection<? extends Integer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(Collection<? extends Integer> c2) {
        this((Collection<? extends Integer>)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(IntCollection c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((q)this).addAll((IntCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(IntCollection c2) {
        this((IntCollection)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(IntIterator i2, float f2) {
        this(16, (float)var2_2);
        void var2_2;
        while (i2.hasNext()) {
            ((q)this).add(i2.nextInt());
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(IntIterator i2) {
        this((IntIterator)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(Iterator<?> i2, float f2) {
        this(IntIterators.asIntIterator((Iterator)var1_1), (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(Iterator<?> i2) {
        this(IntIterators.asIntIterator((Iterator)var1_1));
        void var1_1;
    }

    public IntLinkedOpenHashSet(int[] a2, int offset, int length, float f2) {
        this(length < 0 ? 0 : length, f2);
        IntArrays.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            ((q)this).add(a2[offset + i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(int[] a2, int offset, int length) {
        this((int[])var1_1, (int)var2_2, (int)var3_3, 0.75f);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(int[] a2, float f2) {
        this(a2, 0, ((void)var1_1).length, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntLinkedOpenHashSet(int[] a2) {
        this((int[])var1_1, 0.75f);
        void var1_1;
    }

    public static IntLinkedOpenHashSet of() {
        return new IntLinkedOpenHashSet();
    }

    public static IntLinkedOpenHashSet of(int e2) {
        int n2;
        IntLinkedOpenHashSet intLinkedOpenHashSet = new IntLinkedOpenHashSet(1, 0.75f);
        ((q)intLinkedOpenHashSet).add(n2);
        return intLinkedOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static IntLinkedOpenHashSet of(int e0, int e1) {
        int n2;
        IntLinkedOpenHashSet intLinkedOpenHashSet = new IntLinkedOpenHashSet(2, 0.75f);
        ((q)intLinkedOpenHashSet).add(n2);
        if (!((q)intLinkedOpenHashSet).add(e1)) {
            void var1_1;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((int)var1_1)));
        }
        return intLinkedOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static IntLinkedOpenHashSet of(int e0, int e1, int e2) {
        int n2;
        IntLinkedOpenHashSet intLinkedOpenHashSet = new IntLinkedOpenHashSet(3, 0.75f);
        ((q)intLinkedOpenHashSet).add(n2);
        if (!((q)intLinkedOpenHashSet).add(e1)) {
            void var1_1;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((int)var1_1)));
        }
        if (!((q)intLinkedOpenHashSet).add(e2)) {
            void var2_2;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((int)var2_2)));
        }
        return intLinkedOpenHashSet;
    }

    public static IntLinkedOpenHashSet of(int ... a2) {
        int[] nArray;
        IntLinkedOpenHashSet intLinkedOpenHashSet = new IntLinkedOpenHashSet(a2.length, 0.75f);
        for (int n2 : nArray) {
            if (((q)intLinkedOpenHashSet).add(n2)) continue;
            throw new IllegalArgumentException("Duplicate element ".concat(String.valueOf(n2)));
        }
        return intLinkedOpenHashSet;
    }

    public static IntLinkedOpenHashSet toSet(IntStream stream) {
        return stream.collect(IntLinkedOpenHashSet::new, IntLinkedOpenHashSet::add, IntLinkedOpenHashSet::addAll);
    }

    /*
     * WARNING - void declaration
     */
    public static IntLinkedOpenHashSet toSetWithExpectedSize(IntStream stream, int expectedSize) {
        void var1_1;
        IntStream intStream;
        if (expectedSize <= 16) {
            return IntLinkedOpenHashSet.toSet(stream);
        }
        return intStream.collect(new Y.b<IntLinkedOpenHashSet>((int)var1_1, n2 -> {
            if (n2 <= 16) {
                return new IntLinkedOpenHashSet();
            }
            return new IntLinkedOpenHashSet(n2);
        }), IntLinkedOpenHashSet::add, IntLinkedOpenHashSet::addAll);
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private void a(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(IntCollection c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.a((long)(intLinkedOpenHashSet.size() + c2.size()));
        }
        return super.addAll((IntCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends Integer> c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.a((long)(intLinkedOpenHashSet.size() + c2.size()));
        }
        return super.addAll((Collection<? extends Integer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(int k2) {
        int n2;
        if (k2 == 0) {
            if (this.containsNull) {
                return false;
            }
            n2 = this.n;
            this.containsNull = true;
        } else {
            void var1_1;
            int[] nArray = this.key;
            n2 = HashCommon.mix(k2) & this.mask;
            int n3 = this.key[n2];
            if (n3 != 0) {
                if (n3 == k2) {
                    return false;
                }
                while ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) {
                    if (n3 != k2) continue;
                    return false;
                }
            }
            nArray[n2] = var1_1;
        }
        if (this.size == 0) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.first = intLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n4 = this.last;
            this.link[n4] = this.link[n4] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.rehash(HashCommon.arraySize(intLinkedOpenHashSet.size + 1, this.f));
        }
        return true;
    }

    private void a(int n2) {
        int[] nArray = this.key;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = n4 + 1 & this.mask;
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    return;
                }
                int n5 = HashCommon.mix(n3) & this.mask;
                if (n4 > n2 ? n4 >= n5 && n5 > n2 : n4 >= n5 || n5 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            nArray[n4] = n3;
            this.a(n2, n4);
        }
    }

    private boolean b(int n2) {
        --this.size;
        this.e(n2);
        this.a(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.rehash(intLinkedOpenHashSet.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(int k222) {
        int k222;
        if (k222 == 0) {
            if (this.containsNull) {
                IntLinkedOpenHashSet k222 = this;
                this.containsNull = false;
                k222.key[k222.n] = 0;
                --k222.size;
                IntLinkedOpenHashSet intLinkedOpenHashSet = k222;
                intLinkedOpenHashSet.e(intLinkedOpenHashSet.n);
                if (k222.n > k222.minN && k222.size < k222.maxFill / 4 && k222.n > 16) {
                    IntLinkedOpenHashSet intLinkedOpenHashSet2 = k222;
                    intLinkedOpenHashSet2.rehash(intLinkedOpenHashSet2.n / 2);
                }
                return true;
            }
            return false;
        }
        int[] nArray = this.key;
        int n2 = HashCommon.mix(k222) & this.mask;
        int n3 = this.key[n2];
        if (n3 == 0) {
            return false;
        }
        if (k222 == n3) {
            return this.b(n2);
        }
        do {
            if ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) continue;
            return false;
        } while (k222 != n3);
        return this.b(n2);
    }

    @Override
    public boolean contains(int k2) {
        if (k2 == 0) {
            return this.containsNull;
        }
        int[] nArray = this.key;
        int n2 = HashCommon.mix(k2) & this.mask;
        int n3 = this.key[n2];
        if (n3 == 0) {
            return false;
        }
        if (k2 == n3) {
            return true;
        }
        do {
            if ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) continue;
            return false;
        } while (k2 != n3);
        return true;
    }

    public int removeFirstInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int n2 = this.first;
        if (this.size == 1) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.last = -1;
            intLinkedOpenHashSet.first = -1;
        } else {
            this.first = (int)this.link[n2];
            if (this.first >= 0) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
        }
        int n4 = this.key[n2];
        --this.size;
        if (n4 == 0) {
            this.containsNull = false;
            this.key[this.n] = 0;
        } else {
            this.a(n2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.rehash(intLinkedOpenHashSet.n / 2);
        }
        return n4;
    }

    public int removeLastInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int n2 = this.last;
        if (this.size == 1) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.last = -1;
            intLinkedOpenHashSet.first = -1;
        } else {
            this.last = (int)(this.link[n2] >>> 32);
            if (this.last >= 0) {
                int n3 = this.last;
                this.link[n3] = this.link[n3] | 0xFFFFFFFFL;
            }
        }
        int n4 = this.key[n2];
        --this.size;
        if (n4 == 0) {
            this.containsNull = false;
            this.key[this.n] = 0;
        } else {
            this.a(n2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.rehash(intLinkedOpenHashSet.n / 2);
        }
        return n4;
    }

    private void c(int n2) {
        if (this.size == 1 || this.first == n2) {
            return;
        }
        if (this.last == n2) {
            int n3 = this.last = (int)(this.link[n2] >>> 32);
            this.link[n3] = this.link[n3] | 0xFFFFFFFFL;
        } else {
            long l2 = this.link[n2];
            int n4 = (int)(l2 >>> 32);
            int n5 = (int)l2;
            int n6 = n4;
            this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n7 = n5;
            this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n8 = this.first;
        this.link[n8] = this.link[n8] ^ (this.link[this.first] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = n2;
    }

    private void d(int n2) {
        if (this.size == 1 || this.last == n2) {
            return;
        }
        if (this.first == n2) {
            int n3 = this.first = (int)this.link[n2];
            this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
        } else {
            long l2 = this.link[n2];
            int n4 = (int)(l2 >>> 32);
            int n5 = (int)l2;
            int n6 = n4;
            this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n7 = n5;
            this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n8 = this.last;
        this.link[n8] = this.link[n8] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = n2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAndMoveToFirst(int k2) {
        void var1_1;
        int n2;
        if (k2 == 0) {
            if (this.containsNull) {
                IntLinkedOpenHashSet intLinkedOpenHashSet = this;
                intLinkedOpenHashSet.c(intLinkedOpenHashSet.n);
                return false;
            }
            this.containsNull = true;
            n2 = this.n;
        } else {
            int[] nArray = this.key;
            n2 = HashCommon.mix(k2) & this.mask;
            while (nArray[n2] != 0) {
                if (k2 == nArray[n2]) {
                    this.c(n2);
                    return false;
                }
                n2 = n2 + 1 & this.mask;
            }
        }
        this.key[n2] = var1_1;
        if (this.size == 0) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.first = intLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.first;
            this.link[n3] = this.link[n3] ^ (this.link[this.first] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = n2;
        }
        if (this.size++ >= this.maxFill) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.rehash(HashCommon.arraySize(intLinkedOpenHashSet.size, this.f));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAndMoveToLast(int k2) {
        void var1_1;
        int n2;
        if (k2 == 0) {
            if (this.containsNull) {
                IntLinkedOpenHashSet intLinkedOpenHashSet = this;
                intLinkedOpenHashSet.d(intLinkedOpenHashSet.n);
                return false;
            }
            this.containsNull = true;
            n2 = this.n;
        } else {
            int[] nArray = this.key;
            n2 = HashCommon.mix(k2) & this.mask;
            while (nArray[n2] != 0) {
                if (k2 == nArray[n2]) {
                    this.d(n2);
                    return false;
                }
                n2 = n2 + 1 & this.mask;
            }
        }
        this.key[n2] = var1_1;
        if (this.size == 0) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.first = intLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.last;
            this.link[n3] = this.link[n3] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.rehash(HashCommon.arraySize(intLinkedOpenHashSet.size, this.f));
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0);
        IntLinkedOpenHashSet intLinkedOpenHashSet = this;
        intLinkedOpenHashSet.last = -1;
        intLinkedOpenHashSet.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void e(int n2) {
        if (this.size == 0) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.last = -1;
            intLinkedOpenHashSet.first = -1;
            return;
        }
        if (this.first == n2) {
            this.first = (int)this.link[n2];
            if (this.first >= 0) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == n2) {
            this.last = (int)(this.link[n2] >>> 32);
            if (this.last >= 0) {
                int n4 = this.last;
                this.link[n4] = this.link[n4] | 0xFFFFFFFFL;
            }
            return;
        }
        long l2 = this.link[n2];
        n2 = (int)(l2 >>> 32);
        int n5 = (int)l2;
        int n6 = n2;
        this.link[n6] = this.link[n6] ^ (this.link[n2] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n7 = n5;
        this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected final void a(int n2, int n3) {
        if (this.size == 1) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = this;
            intLinkedOpenHashSet.first = intLinkedOpenHashSet.last = n3;
            this.link[n3] = -1L;
            return;
        }
        if (this.first == n2) {
            this.first = n3;
            int n4 = (int)this.link[n2];
            this.link[n4] = this.link[n4] ^ (this.link[(int)this.link[n2]] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n3] = this.link[n2];
            return;
        }
        if (this.last == n2) {
            this.last = n3;
            int n5 = (int)(this.link[n2] >>> 32);
            this.link[n5] = this.link[n5] ^ (this.link[(int)(this.link[n2] >>> 32)] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n3] = this.link[n2];
            return;
        }
        long l2 = this.link[n2];
        n2 = (int)(l2 >>> 32);
        int n6 = (int)l2;
        int n7 = n2;
        this.link[n7] = this.link[n7] ^ (this.link[n2] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n8 = n6;
        this.link[n8] = this.link[n8] ^ (this.link[n6] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n3] = l2;
    }

    @Override
    public int firstInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public int lastInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public IntSortedSet tailSet(int from2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntSortedSet headSet(int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntSortedSet subSet(int from2, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntComparator comparator() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public IntListIterator iterator(int from2) {
        void var1_1;
        return new a(this, (int)var1_1);
    }

    @Override
    public IntListIterator iterator() {
        return new a(this);
    }

    @Override
    public IntSpliterator spliterator() {
        return ag.a((IntIterator)this.iterator(), h.a(this), 337);
    }

    @Override
    public void forEach(IntConsumer action) {
        int n2 = this.first;
        while (n2 != -1) {
            int n3 = n2;
            n2 = (int)this.link[n3];
            action.accept(this.key[n3]);
        }
    }

    public boolean trim() {
        IntLinkedOpenHashSet intLinkedOpenHashSet = this;
        return intLinkedOpenHashSet.trim(intLinkedOpenHashSet.size);
    }

    public boolean trim(int n2) {
        int n3 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (n3 >= this.n || this.size > HashCommon.maxFill(n3, this.f)) {
            return true;
        }
        try {
            this.rehash(n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        int[] nArray = this.key;
        int n2 = newN - 1;
        int[] nArray2 = new int[newN + 1];
        int n3 = this.first;
        int n4 = -1;
        int n5 = -1;
        long[] lArray = this.link;
        long[] lArray2 = new long[newN + 1];
        this.first = -1;
        int n6 = this.size;
        while (n6-- != 0) {
            int n7;
            if (nArray[n3] == 0) {
                n7 = newN;
            } else {
                n7 = HashCommon.mix(nArray[n3]) & n2;
                while (nArray2[n7] != 0) {
                    n7 = n7 + 1 & n2;
                }
            }
            nArray2[n7] = nArray[n3];
            if (n4 != -1) {
                int n8 = n5;
                lArray2[n8] = lArray2[n8] ^ (lArray2[n5] ^ (long)n7 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n9 = n7;
                lArray2[n9] = lArray2[n9] ^ (lArray2[n7] ^ ((long)n5 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n5 = n7;
            } else {
                n5 = this.first = n7;
                lArray2[n7] = -1L;
            }
            n4 = n3;
            n3 = (int)lArray[n3];
        }
        this.link = lArray2;
        this.last = n5;
        if (n5 != -1) {
            int n10 = n5;
            lArray2[n10] = lArray2[n10] | 0xFFFFFFFFL;
        }
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = nArray2;
    }

    public IntLinkedOpenHashSet clone() {
        IntLinkedOpenHashSet intLinkedOpenHashSet;
        try {
            intLinkedOpenHashSet = (IntLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        intLinkedOpenHashSet.key = (int[])this.key.clone();
        intLinkedOpenHashSet.containsNull = this.containsNull;
        intLinkedOpenHashSet.link = (long[])this.link.clone();
        return intLinkedOpenHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        IntLinkedOpenHashSet intLinkedOpenHashSet = this;
        int n3 = intLinkedOpenHashSet.containsNull ? intLinkedOpenHashSet.size - 1 : intLinkedOpenHashSet.size;
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0) {
                ++n4;
            }
            n2 += this.key[n4];
            ++n4;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        IntListIterator intListIterator = this.iterator();
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            s2.writeInt(intListIterator.nextInt());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new int[this.n + 1];
        int[] nArray = this.key;
        this.link = new long[this.n + 1];
        long[] lArray = this.link;
        int n2 = -1;
        IntLinkedOpenHashSet intLinkedOpenHashSet = this;
        intLinkedOpenHashSet.last = -1;
        intLinkedOpenHashSet.first = -1;
        int n3 = this.size;
        while (n3-- != 0) {
            int n4;
            int n5 = s2.readInt();
            if (n5 == 0) {
                n4 = this.n;
                this.containsNull = true;
            } else {
                n4 = HashCommon.mix(n5) & this.mask;
                if (nArray[n4] != 0) {
                    while (nArray[n4 = n4 + 1 & this.mask] != 0) {
                    }
                }
            }
            nArray[n4] = n5;
            if (this.first != -1) {
                int n6 = n2;
                lArray[n6] = lArray[n6] ^ (lArray[n2] ^ (long)n4 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n7 = n4;
                lArray[n7] = lArray[n7] ^ (lArray[n4] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n2 = n4;
                continue;
            }
            n2 = this.first = n4;
            int n8 = n4;
            lArray[n8] = lArray[n8] | 0xFFFFFFFF00000000L;
        }
        this.last = n2;
        if (n2 != -1) {
            int n9 = n2;
            lArray[n9] = lArray[n9] | 0xFFFFFFFFL;
        }
    }

    private final class a
    implements IntListIterator {
        private int a = -1;
        private int b = -1;
        private int c = -1;
        private int d = -1;
        private /* synthetic */ IntLinkedOpenHashSet e;

        a(IntLinkedOpenHashSet intLinkedOpenHashSet) {
            this.e = intLinkedOpenHashSet;
            this.b = intLinkedOpenHashSet.first;
            this.d = 0;
        }

        a(IntLinkedOpenHashSet intLinkedOpenHashSet, int n2) {
            this.e = intLinkedOpenHashSet;
            if (n2 == 0) {
                if (intLinkedOpenHashSet.containsNull) {
                    this.b = (int)intLinkedOpenHashSet.link[intLinkedOpenHashSet.n];
                    this.a = intLinkedOpenHashSet.n;
                    return;
                }
                throw new NoSuchElementException("The key " + n2 + " does not belong to this set.");
            }
            if (intLinkedOpenHashSet.key[intLinkedOpenHashSet.last] == n2) {
                this.a = intLinkedOpenHashSet.last;
                this.d = intLinkedOpenHashSet.size;
                return;
            }
            int[] nArray = intLinkedOpenHashSet.key;
            int n3 = HashCommon.mix(n2) & intLinkedOpenHashSet.mask;
            while (nArray[n3] != 0) {
                if (nArray[n3] == n2) {
                    this.b = (int)intLinkedOpenHashSet.link[n3];
                    this.a = n3;
                    return;
                }
                n3 = n3 + 1 & intLinkedOpenHashSet.mask;
            }
            throw new NoSuchElementException("The key " + n2 + " does not belong to this set.");
        }

        @Override
        public final boolean hasNext() {
            return this.b != -1;
        }

        @Override
        public final boolean hasPrevious() {
            return this.a != -1;
        }

        @Override
        public final int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.c = this.b;
            this.b = (int)this.e.link[this.c];
            this.a = this.c;
            if (this.d >= 0) {
                ++this.d;
            }
            return this.e.key[this.c];
        }

        @Override
        public final int a() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.c = this.a;
            this.a = (int)(this.e.link[this.c] >>> 32);
            this.b = this.c;
            if (this.d >= 0) {
                --this.d;
            }
            return this.e.key[this.c];
        }

        @Override
        public final void forEachRemaining(IntConsumer action) {
            int[] nArray = this.e.key;
            long[] lArray = this.e.link;
            while (this.b != -1) {
                this.c = this.b;
                this.b = (int)lArray[this.c];
                this.a = this.c;
                if (this.d >= 0) {
                    ++this.d;
                }
                action.accept(nArray[this.c]);
            }
        }

        private final void b() {
            if (this.d >= 0) {
                return;
            }
            if (this.a == -1) {
                this.d = 0;
                return;
            }
            if (this.b == -1) {
                this.d = this.e.size;
                return;
            }
            int n2 = this.e.first;
            this.d = 1;
            while (n2 != this.a) {
                n2 = (int)this.e.link[n2];
                ++this.d;
            }
        }

        @Override
        public final int nextIndex() {
            this.b();
            return this.d;
        }

        @Override
        public final int previousIndex() {
            this.b();
            return this.d - 1;
        }

        @Override
        public final void remove() {
            this.b();
            if (this.c == -1) {
                throw new IllegalStateException();
            }
            if (this.c == this.a) {
                --this.d;
                this.a = (int)(this.e.link[this.c] >>> 32);
            } else {
                this.b = (int)this.e.link[this.c];
            }
            --this.e.size;
            if (this.a == -1) {
                this.e.first = this.b;
            } else {
                int n2 = this.a;
                this.e.link[n2] = this.e.link[n2] ^ (this.e.link[this.a] ^ (long)this.b & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.b == -1) {
                this.e.last = this.a;
            } else {
                int n3 = this.b;
                this.e.link[n3] = this.e.link[n3] ^ (this.e.link[this.b] ^ ((long)this.a & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int n4 = this.c;
            this.c = -1;
            if (n4 == this.e.n) {
                this.e.containsNull = false;
                this.e.key[this.e.n] = 0;
                return;
            }
            int[] nArray = this.e.key;
            while (true) {
                int n5;
                int n6 = n4;
                n4 = n6 + 1 & this.e.mask;
                while (true) {
                    if ((n5 = nArray[n4]) == 0) {
                        nArray[n6] = 0;
                        return;
                    }
                    int n7 = HashCommon.mix(n5) & this.e.mask;
                    if (n6 > n4 ? n6 >= n7 && n7 > n4 : n6 >= n7 || n7 > n4) break;
                    n4 = n4 + 1 & this.e.mask;
                }
                nArray[n6] = n5;
                if (this.b == n4) {
                    this.b = n6;
                }
                if (this.a == n4) {
                    this.a = n6;
                }
                this.e.a(n4, n6);
            }
        }
    }
}

