/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.util.ArrayUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharsetToolkit {
    public static final String UTF8 = "UTF-8";
    @Deprecated
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final Charset UTF_32BE_CHARSET = Charset.forName("UTF-32BE");
    public static final Charset UTF_32LE_CHARSET = Charset.forName("UTF-32LE");
    public static final Charset WIN_1251_CHARSET = Charset.forName("windows-1251");
    private static final byte FF = -1;
    private static final byte FE = -2;
    private static final byte EF = -17;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final int BINARY_THRESHOLD = 9;
    private final byte[] buffer;
    @NotNull
    private final Charset defaultCharset;
    private final boolean enforce8Bit;
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    private static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    private static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    public static final String FILE_ENCODING_PROPERTY = "file.encoding";
    private static final Map<Charset, byte[]> CHARSET_TO_MANDATORY_BOM = new HashMap<Charset, byte[]>(4);

    public CharsetToolkit(byte @NotNull [] buffer, @NotNull Charset defaultCharset, boolean enforce8Bit) {
        if (defaultCharset == null) {
            CharsetToolkit.$$$reportNull$$$0(0);
        }
        if (buffer == null) {
            CharsetToolkit.$$$reportNull$$$0(1);
        }
        this.buffer = buffer;
        this.defaultCharset = defaultCharset;
        this.enforce8Bit = enforce8Bit;
        if (buffer.length == 0) {
            throw new IllegalArgumentException("Can't analyze empty buffer");
        }
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            CharsetToolkit.$$$reportNull$$$0(2);
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        CharsetToolkit.detectBOMFromStream(stream);
        InputStream inputStream = stream;
        if (inputStream == null) {
            CharsetToolkit.$$$reportNull$$$0(3);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte @Nullable [] detectBOMFromStream(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            CharsetToolkit.$$$reportNull$$$0(4);
        }
        assert (stream.markSupported());
        stream.mark(4);
        boolean mustReset = true;
        try {
            int ret = stream.read();
            if (ret == -1) {
                byte[] byArray = null;
                return byArray;
            }
            byte b0 = (byte)ret;
            if (b0 != -17 && b0 != -1 && b0 != -2 && b0 != 0) {
                byte[] byArray = null;
                return byArray;
            }
            ret = stream.read();
            if (ret == -1) {
                byte[] byArray = null;
                return byArray;
            }
            byte b1 = (byte)ret;
            if (b0 == -1 && b1 == -2) {
                stream.mark(2);
                ret = stream.read();
                if (ret == -1) {
                    byte[] byArray = UTF16LE_BOM;
                    return byArray;
                }
                byte b2 = (byte)ret;
                if (b2 != 0) {
                    byte[] byArray = UTF16LE_BOM;
                    return byArray;
                }
                ret = stream.read();
                if (ret == -1) {
                    byte[] byArray = UTF16LE_BOM;
                    return byArray;
                }
                byte b3 = (byte)ret;
                if (b3 != 0) {
                    byte[] byArray = UTF16LE_BOM;
                    return byArray;
                }
                mustReset = false;
                byte[] byArray = UTF32LE_BOM;
                return byArray;
            }
            if (b0 == -2 && b1 == -1) {
                mustReset = false;
                byte[] b2 = UTF16BE_BOM;
                return b2;
            }
            if (b0 == -17 && b1 == -69) {
                ret = stream.read();
                if (ret == -1) {
                    byte[] b2 = null;
                    return b2;
                }
                byte b2 = (byte)ret;
                if (b2 == -65) {
                    mustReset = false;
                    byte[] b3 = UTF8_BOM;
                    return b3;
                }
                byte[] b3 = null;
                return b3;
            }
            if (b0 == 0 && b1 == 0) {
                ret = stream.read();
                if (ret == -1) {
                    byte[] b2 = null;
                    return b2;
                }
                byte b2 = (byte)ret;
                if (b2 != -2) {
                    byte[] b3 = null;
                    return b3;
                }
                ret = stream.read();
                if (ret == -1) {
                    byte[] b3 = null;
                    return b3;
                }
                byte b3 = (byte)ret;
                if (b3 != -1) {
                    byte[] byArray = null;
                    return byArray;
                }
                mustReset = false;
                byte[] byArray = UTF32BE_BOM;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (mustReset) {
                stream.reset();
            }
        }
    }

    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.defaultCharset;
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(5);
        }
        return charset;
    }

    public Charset guessEncoding(int startOffset, int endOffset, @NotNull Charset defaultCharset) {
        Charset charset;
        if (defaultCharset == null) {
            CharsetToolkit.$$$reportNull$$$0(6);
        }
        if ((charset = this.guessFromBOM()) != null) {
            return charset;
        }
        GuessedEncoding encoding = this.guessFromContent(startOffset, endOffset);
        switch (encoding) {
            case SEVEN_BIT: {
                return this.enforce8Bit ? defaultCharset : StandardCharsets.US_ASCII;
            }
            case INVALID_UTF8: {
                return defaultCharset;
            }
            case VALID_UTF8: {
                return StandardCharsets.UTF_8;
            }
        }
        return null;
    }

    @NotNull
    public static String bytesToString(byte @NotNull [] bytes, @NotNull Charset defaultCharset) {
        if (defaultCharset == null) {
            CharsetToolkit.$$$reportNull$$$0(7);
        }
        if (bytes == null) {
            CharsetToolkit.$$$reportNull$$$0(8);
        }
        if (bytes.length == 0) {
            return "";
        }
        Charset charset = new CharsetToolkit(bytes, defaultCharset, false).guessEncoding(bytes.length);
        if (charset == null) {
            charset = defaultCharset;
        }
        return CharsetToolkit.decodeString(bytes, charset);
    }

    @NotNull
    public static String decodeString(byte @NotNull [] bytes, @NotNull Charset charset) {
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(9);
        }
        if (bytes == null) {
            CharsetToolkit.$$$reportNull$$$0(10);
        }
        int bomLength = CharsetToolkit.getBOMLength(bytes, charset);
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
        String string2 = charBuffer.toString();
        if (string2 == null) {
            CharsetToolkit.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Nullable
    public static String tryDecodeString(byte @NotNull [] bytes, @NotNull Charset charset) {
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(12);
        }
        if (bytes == null) {
            CharsetToolkit.$$$reportNull$$$0(13);
        }
        try {
            int bomLength = CharsetToolkit.getBOMLength(bytes, charset);
            ByteBuffer buffer = ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength);
            CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException e2) {
            return null;
        }
    }

    @NotNull
    public GuessedEncoding guessFromContent(int guess_length) {
        GuessedEncoding guessedEncoding = this.guessFromContent(0, guess_length);
        if (guessedEncoding == null) {
            CharsetToolkit.$$$reportNull$$$0(14);
        }
        return guessedEncoding;
    }

    @NotNull
    public GuessedEncoding guessFromContent(int startOffset, int endOffset) {
        boolean highOrderBit = false;
        boolean validU8Char = true;
        boolean hasBinary = false;
        int end = Math.min(this.buffer.length, endOffset);
        for (int i2 = startOffset; i2 < end; ++i2) {
            byte b5;
            byte b0 = this.buffer[i2];
            byte b1 = i2 + 1 >= end ? (byte)0 : this.buffer[i2 + 1];
            byte b2 = i2 + 2 >= end ? (byte)0 : this.buffer[i2 + 2];
            byte b3 = i2 + 3 >= end ? (byte)0 : this.buffer[i2 + 3];
            byte b4 = i2 + 4 >= end ? (byte)0 : this.buffer[i2 + 4];
            byte by = b5 = i2 + 5 >= end ? (byte)0 : this.buffer[i2 + 5];
            if (b0 < 0) {
                highOrderBit = true;
                if (CharsetToolkit.isTwoBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1)) {
                        validU8Char = false;
                    } else {
                        ++i2;
                    }
                } else if (CharsetToolkit.isThreeBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1) || !CharsetToolkit.isContinuationChar(b2)) {
                        validU8Char = false;
                    } else {
                        i2 += 2;
                    }
                } else if (CharsetToolkit.isFourBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3))) {
                        validU8Char = false;
                    } else {
                        i2 += 3;
                    }
                } else if (CharsetToolkit.isFiveBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4))) {
                        validU8Char = false;
                    } else {
                        i2 += 4;
                    }
                } else if (CharsetToolkit.isSixBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4) && CharsetToolkit.isContinuationChar(b5))) {
                        validU8Char = false;
                    } else {
                        i2 += 5;
                    }
                } else {
                    validU8Char = false;
                }
            } else if (b0 < 9) {
                hasBinary = true;
                break;
            }
            if (!validU8Char) break;
        }
        if (!highOrderBit && !hasBinary) {
            GuessedEncoding guessedEncoding = GuessedEncoding.SEVEN_BIT;
            if (guessedEncoding == null) {
                CharsetToolkit.$$$reportNull$$$0(15);
            }
            return guessedEncoding;
        }
        if (!validU8Char) {
            GuessedEncoding guessedEncoding = GuessedEncoding.INVALID_UTF8;
            if (guessedEncoding == null) {
                CharsetToolkit.$$$reportNull$$$0(16);
            }
            return guessedEncoding;
        }
        if (hasBinary) {
            GuessedEncoding guessedEncoding = GuessedEncoding.BINARY;
            if (guessedEncoding == null) {
                CharsetToolkit.$$$reportNull$$$0(17);
            }
            return guessedEncoding;
        }
        GuessedEncoding guessedEncoding = GuessedEncoding.VALID_UTF8;
        if (guessedEncoding == null) {
            CharsetToolkit.$$$reportNull$$$0(18);
        }
        return guessedEncoding;
    }

    @Nullable
    public Charset guessFromBOM() {
        return CharsetToolkit.guessFromBOM(this.buffer);
    }

    @Nullable
    public static Charset guessFromBOM(byte @NotNull [] buffer) {
        if (buffer == null) {
            CharsetToolkit.$$$reportNull$$$0(19);
        }
        if (CharsetToolkit.hasUTF8Bom(buffer)) {
            return StandardCharsets.UTF_8;
        }
        if (CharsetToolkit.hasUTF32BEBom(buffer)) {
            return UTF_32BE_CHARSET;
        }
        if (CharsetToolkit.hasUTF32LEBom(buffer)) {
            return UTF_32LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16LEBom(buffer)) {
            return StandardCharsets.UTF_16LE;
        }
        if (CharsetToolkit.hasUTF16BEBom(buffer)) {
            return StandardCharsets.UTF_16BE;
        }
        return null;
    }

    public Charset guessEncoding(int guess_length) {
        return this.guessEncoding(0, guess_length, this.defaultCharset);
    }

    public static Charset guessEncoding(@NotNull File f2, int bufferLength, @NotNull Charset defaultCharset) throws IOException {
        int read2;
        if (f2 == null) {
            CharsetToolkit.$$$reportNull$$$0(20);
        }
        if (defaultCharset == null) {
            CharsetToolkit.$$$reportNull$$$0(21);
        }
        if (bufferLength == 0) {
            throw new IllegalArgumentException("Can't analyze empty buffer");
        }
        byte[] buffer = new byte[bufferLength];
        try (FileInputStream fis = new FileInputStream(f2);){
            read2 = fis.read(buffer);
        }
        CharsetToolkit toolkit = new CharsetToolkit(buffer, defaultCharset, false);
        return toolkit.guessEncoding(read2);
    }

    private static boolean isContinuationChar(byte b2) {
        return b2 <= -65;
    }

    private static boolean isTwoBytesSequence(byte b2) {
        return -64 <= b2 && b2 <= -33;
    }

    private static boolean isThreeBytesSequence(byte b2) {
        return -32 <= b2 && b2 <= -17;
    }

    private static boolean isFourBytesSequence(byte b2) {
        return -16 <= b2 && b2 <= -9;
    }

    private static boolean isFiveBytesSequence(byte b2) {
        return -8 <= b2 && b2 <= -5;
    }

    private static boolean isSixBytesSequence(byte b2) {
        return -4 <= b2 && b2 <= -3;
    }

    @NotNull
    public static Charset getDefaultSystemCharset() {
        Charset charset = Charset.defaultCharset();
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(22);
        }
        return charset;
    }

    @NotNull
    public static Charset getPlatformCharset() {
        String name2 = System.getProperty("sun.jnu.encoding");
        Charset value2 = CharsetToolkit.forName(name2);
        Charset charset = value2 == null ? CharsetToolkit.getDefaultSystemCharset() : value2;
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(23);
        }
        return charset;
    }

    public static boolean hasUTF8Bom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(24);
        }
        return ArrayUtil.startsWith(bom, UTF8_BOM);
    }

    public static boolean hasUTF16LEBom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(25);
        }
        return ArrayUtil.startsWith(bom, UTF16LE_BOM);
    }

    public static boolean hasUTF16BEBom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(26);
        }
        return ArrayUtil.startsWith(bom, UTF16BE_BOM);
    }

    public static boolean hasUTF32BEBom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(27);
        }
        return ArrayUtil.startsWith(bom, UTF32BE_BOM);
    }

    public static boolean hasUTF32LEBom(byte @NotNull [] bom) {
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(28);
        }
        return ArrayUtil.startsWith(bom, UTF32LE_BOM);
    }

    public static Charset @NotNull [] getAvailableCharsets() {
        Collection<Charset> collection = Charset.availableCharsets().values();
        Charset[] charsetArray = collection.toArray(new Charset[0]);
        if (charsetArray == null) {
            CharsetToolkit.$$$reportNull$$$0(29);
        }
        return charsetArray;
    }

    public static int getBOMLength(byte @NotNull [] content, @NotNull Charset charset) {
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(30);
        }
        if (content == null) {
            CharsetToolkit.$$$reportNull$$$0(31);
        }
        if (charset.name().contains(UTF8) && CharsetToolkit.hasUTF8Bom(content)) {
            return UTF8_BOM.length;
        }
        if (CharsetToolkit.hasUTF32BEBom(content)) {
            return UTF32BE_BOM.length;
        }
        if (CharsetToolkit.hasUTF32LEBom(content)) {
            return UTF32LE_BOM.length;
        }
        if (CharsetToolkit.hasUTF16LEBom(content)) {
            return UTF16LE_BOM.length;
        }
        if (CharsetToolkit.hasUTF16BEBom(content)) {
            return UTF16BE_BOM.length;
        }
        return 0;
    }

    public static byte @Nullable [] getMandatoryBom(@NotNull Charset charset) {
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(32);
        }
        return CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    public static byte @Nullable [] getPossibleBom(@NotNull Charset charset) {
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(33);
        }
        return charset.equals(StandardCharsets.UTF_8) ? UTF8_BOM : CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    public static boolean canHaveBom(@NotNull Charset charset, byte @NotNull [] bom) {
        if (charset == null) {
            CharsetToolkit.$$$reportNull$$$0(34);
        }
        if (bom == null) {
            CharsetToolkit.$$$reportNull$$$0(35);
        }
        return charset.equals(StandardCharsets.UTF_8) && Arrays.equals(bom, UTF8_BOM) || Arrays.equals(CharsetToolkit.getMandatoryBom(charset), bom);
    }

    @Nullable
    public static Charset forName(@Nullable String name2) {
        Charset charset = null;
        if (name2 != null) {
            try {
                charset = Charset.forName(name2);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
        }
        return charset;
    }

    static {
        CHARSET_TO_MANDATORY_BOM.put(StandardCharsets.UTF_16LE, UTF16LE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(StandardCharsets.UTF_16BE, UTF16BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32BE_CHARSET, UTF32BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32LE_CHARSET, UTF32LE_BOM);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/CharsetToolkit";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 9: 
            case 12: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bom";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/CharsetToolkit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inputStreamSkippingBOM";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeString";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFromContent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemCharset";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformCharset";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableCharsets";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamSkippingBOM";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectBOMFromStream";
                break;
            }
            case 6: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "guessEncoding";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "decodeString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryDecodeString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "guessFromBOM";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF8Bom";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF16LEBom";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF16BEBom";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF32BEBom";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasUTF32LEBom";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getBOMLength";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMandatoryBom";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleBom";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "canHaveBom";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 29: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum GuessedEncoding {
        SEVEN_BIT,
        VALID_UTF8,
        INVALID_UTF8,
        BINARY;

    }
}

