/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceDescriptor {
    @Attribute
    public final String serviceInterface;
    @Attribute
    @RequiredElement
    public final String serviceImplementation;
    @Attribute
    public final String testServiceImplementation;
    @Attribute
    public final String headlessImplementation;
    @Attribute
    public final boolean overrides;
    @Attribute
    @ApiStatus.Internal
    @Nullable
    public final String configurationSchemaKey;
    @Attribute
    @ApiStatus.Internal
    public final PreloadMode preload;
    @Attribute
    public final ExtensionDescriptor.Os os;
    @Attribute
    @Nullable
    public final ClientKind client;

    public ServiceDescriptor(String serviceInterface, String serviceImplementation, String testServiceImplementation, String headlessImplementation, boolean overrides2, @Nullable String configurationSchemaKey, @NotNull PreloadMode preload, @Nullable ClientKind client, @Nullable ExtensionDescriptor.Os os) {
        if (preload == null) {
            ServiceDescriptor.$$$reportNull$$$0(0);
        }
        this.serviceInterface = serviceInterface;
        this.serviceImplementation = serviceImplementation;
        this.testServiceImplementation = testServiceImplementation;
        this.headlessImplementation = headlessImplementation;
        this.overrides = overrides2;
        this.configurationSchemaKey = configurationSchemaKey;
        this.preload = preload;
        this.client = client;
        this.os = os;
    }

    @Nullable
    public String getImplementation() {
        if (this.testServiceImplementation != null && ApplicationManager.getApplication().isUnitTestMode()) {
            return this.testServiceImplementation;
        }
        if (this.headlessImplementation != null && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return this.headlessImplementation;
        }
        return this.serviceImplementation;
    }

    public String toString() {
        return "ServiceDescriptor(interface='" + this.serviceInterface + '\'' + ", serviceImplementation='" + this.serviceImplementation + '\'' + ", testServiceImplementation='" + this.testServiceImplementation + '\'' + ", headlessImplementation='" + this.headlessImplementation + '\'' + ", overrides=" + this.overrides + ", configurationSchemaKey='" + this.configurationSchemaKey + '\'' + ", preload=" + (Object)((Object)this.preload) + ", client=" + (Object)((Object)this.client) + ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preload", "com/intellij/openapi/components/ServiceDescriptor", "<init>"));
    }

    @ApiStatus.Internal
    public static enum PreloadMode {
        TRUE,
        FALSE,
        AWAIT,
        NOT_HEADLESS,
        NOT_LIGHT_EDIT;

    }
}

