/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001FB7\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0012B/\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0014J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001dJ\u0018\u00108\u001a\u0002062\u0006\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020\tH\u0016J\b\u0010;\u001a\u000206H\u0002J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0005J\u0012\u0010?\u001a\u0002062\b\u0010@\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010A\u001a\u0002062\b\u0010B\u001a\u0004\u0018\u00010\tH\u0002J\u0006\u0010C\u001a\u00020\rJ\u0006\u0010D\u001a\u00020\rJ\b\u0010E\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R.\u0010\"\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010#j\u0004\u0018\u0001`$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0016\u0010)\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\r01X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "stackTrace", "", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/Map;Ljava/util/List;)V", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "exception", "(Ljava/lang/Throwable;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getFields", "()Ljava/util/Map;", "upValues", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getUpValues", "superWrapperClass", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "message", "getMessage", "()Ljava/lang/String;", "cause", "getCause", "()Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "exceptionFqName", "exceptionHierarchy", "", "messageProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "causeProperty", "copyFieldsFrom", "", "wrapper", "setField", "symbol", "state", "recalculateCauseAndMessage", "isSubtypeOf", "", "ancestor", "setMessage", "messageValue", "setCause", "causeValue", "getShortDescription", "getFullDescription", "toString", "Companion", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nExceptionState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/ExceptionState\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1321#2,2:156\n1#3:158\n1761#4,3:159\n*S KotlinDebug\n*F\n+ 1 ExceptionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/ExceptionState\n*L\n55#1:156,2\n81#1:159,3\n*E\n"})
public final class ExceptionState
extends Throwable
implements Complex,
StateWithClosure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @NotNull
    private final Map<IrSymbol, Variable> upValues;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;
    private String exceptionFqName;
    @NotNull
    private final List<String> exceptionHierarchy;
    @NotNull
    private final IrProperty messageProperty;
    @NotNull
    private final IrProperty causeProperty;
    @NotNull
    private final List<String> stackTrace;

    private ExceptionState(IrClass irClass, Map<IrSymbol, State> fields, List<String> stackTrace) {
        this.irClass = irClass;
        this.fields = fields;
        this.upValues = new LinkedHashMap();
        this.exceptionHierarchy = new ArrayList();
        this.messageProperty = UtilsKt.getOriginalPropertyByName(this.getIrClass(), "message");
        this.causeProperty = UtilsKt.getOriginalPropertyByName(this.getIrClass(), "cause");
        this.stackTrace = CollectionsKt.reversed((Iterable)stackTrace);
        if (this.exceptionFqName == null) {
            this.exceptionFqName = this.irClassFqName();
        }
        if (!this.getFields().containsKey(this.messageProperty.getSymbol())) {
            this.setMessage(null);
        }
        if (!this.getFields().containsKey(this.causeProperty.getSymbol())) {
            this.setCause(null);
        }
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public Map<IrSymbol, Variable> getUpValues() {
        return this.upValues;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    @Override
    @Nullable
    public String getMessage() {
        State state = this.getField(this.messageProperty.getSymbol());
        return state != null ? StateKt.asStringOrNull(state) : null;
    }

    @Override
    @Nullable
    public ExceptionState getCause() {
        State state = this.getField(this.causeProperty.getSymbol());
        return state instanceof ExceptionState ? (ExceptionState)state : null;
    }

    public ExceptionState(@NotNull IrClass irClass, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this(irClass, new LinkedHashMap(), environment.getCallStack$ir_interpreter().getStackTrace());
    }

    public ExceptionState(@NotNull Throwable exception, @NotNull IrClass irClass, @NotNull List<String> stackTrace, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this(irClass, ExceptionState.Companion.evaluateFields(exception, irClass, environment), CollectionsKt.plus((Collection)stackTrace, (Iterable)ExceptionState.Companion.evaluateAdditionalStackTrace(exception, environment)));
        this.setCause(null);
        if (!Intrinsics.areEqual((Object)irClass.getName().asString(), (Object)exception.getClass().getSimpleName())) {
            String string2 = exception.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            this.exceptionFqName = string2;
            Collection collection = this.exceptionHierarchy;
            String string3 = this.exceptionFqName;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
                string3 = null;
            }
            collection.add(string3);
            Sequence $this$forEach$iv = SequencesKt.generateSequence(exception.getClass().getSuperclass(), ExceptionState::_init_$lambda$0);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Class it = (Class)element$iv;
                boolean bl2 = false;
                ((Collection)this.exceptionHierarchy).add(it.getName());
            }
            this.exceptionHierarchy.remove(CollectionsKt.getLastIndex(this.exceptionHierarchy));
        }
    }

    public final void copyFieldsFrom(@NotNull Wrapper wrapper) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
            Object object = wrapper.getValue();
            Throwable throwable = object instanceof Throwable ? (Throwable)object : null;
            if (throwable == null) break block0;
            Throwable it = throwable;
            boolean bl2 = false;
            this.setMessage(it.getMessage());
            Throwable throwable2 = it.getCause();
            this.setCause(throwable2 instanceof ExceptionState ? (ExceptionState)throwable2 : null);
        }
    }

    @Override
    public void setField(@NotNull IrSymbol symbol, @NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Complex.super.setField(symbol, state);
        this.recalculateCauseAndMessage();
    }

    /*
     * WARNING - void declaration
     */
    private final void recalculateCauseAndMessage() {
        block4: {
            String string2;
            StringBuilder stringBuilder;
            block6: {
                block5: {
                    void it;
                    if (this.getMessage() != null || this.getCause() == null) break block4;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    ExceptionState exceptionState = this.getCause();
                    Intrinsics.checkNotNull((Object)exceptionState);
                    String string3 = exceptionState.exceptionFqName;
                    if (string3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
                        string3 = null;
                    }
                    stringBuilder = stringBuilder2.append(string3);
                    ExceptionState exceptionState2 = this.getCause();
                    Intrinsics.checkNotNull((Object)exceptionState2);
                    string2 = exceptionState2.getMessage();
                    if (string2 == null) break block5;
                    String string4 = string2;
                    StringBuilder stringBuilder3 = stringBuilder;
                    boolean bl2 = false;
                    String string5 = ": " + (String)it;
                    stringBuilder = stringBuilder3;
                    string2 = string5;
                    if (string5 != null) break block6;
                }
                string2 = "";
            }
            String causeMessage = stringBuilder.append(string2).toString();
            this.setMessage(causeMessage);
        }
    }

    public final boolean isSubtypeOf(@NotNull IrClass ancestor) {
        Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
        if (!((Collection)this.exceptionHierarchy).isEmpty()) {
            boolean bl2;
            block4: {
                Iterable $this$any$iv = this.exceptionHierarchy;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        CharSequence charSequence = it;
                        String string2 = ancestor.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                        if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                        bl2 = true;
                        break block4;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        return IrUtilsKt.isSubclassOf(this.getIrClass(), ancestor);
    }

    private final void setMessage(String messageValue) {
        IrSymbol irSymbol = this.messageProperty.getSymbol();
        IrSimpleFunction irSimpleFunction = this.messageProperty.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        this.setField(irSymbol, new Primitive(messageValue, irSimpleFunction.getReturnType()));
    }

    private final void setCause(State causeValue) {
        IrSymbol irSymbol = this.causeProperty.getSymbol();
        State state = causeValue;
        if (state == null) {
            IrSimpleFunction irSimpleFunction = this.causeProperty.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            state = Primitive.Companion.nullStateOfType(irSimpleFunction.getReturnType());
        }
        this.setField(irSymbol, state);
    }

    @NotNull
    public final String getShortDescription() {
        String it = this.getMessage();
        boolean bl2 = false;
        String string2 = it;
        String message = (string2 != null ? ((CharSequence)string2).length() > 0 : false) ? ": " + it : "";
        StringBuilder stringBuilder = new StringBuilder().append("Exception ");
        String string3 = this.exceptionFqName;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
            string3 = null;
        }
        return stringBuilder.append(string3).append(message).toString();
    }

    @NotNull
    public final String getFullDescription() {
        String prefix = !((Collection)this.stackTrace).isEmpty() ? "\n\t" : "";
        String postfix = this.stackTrace.size() > 10 ? "\n\t..." : "";
        Object object = this.getCause();
        if (object == null || (object = ((ExceptionState)object).getFullDescription()) == null || (object = StringsKt.replaceFirst$default((String)object, (String)"Exception ", (String)"\nCaused by: ", (boolean)false, (int)4, null)) == null) {
            object = "";
        }
        Object causeMessage = object;
        return this.getShortDescription() + CollectionsKt.joinToString$default((Iterable)this.stackTrace.subList(0, Math.min(this.stackTrace.size(), 10)), (CharSequence)"\n\t", (CharSequence)prefix, (CharSequence)postfix, (int)0, null, null, (int)56, null) + (String)causeMessage;
    }

    @Override
    @NotNull
    public String toString() {
        String string2;
        block6: {
            block5: {
                string2 = this.getMessage();
                if (string2 == null) break block5;
                String it = string2;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = this.exceptionFqName;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
                    string3 = null;
                }
                String string4 = stringBuilder.append(string3).append(": ").append(it).toString();
                string2 = string4;
                if (string4 != null) break block6;
            }
            if ((string2 = this.exceptionFqName) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionFqName");
                string2 = null;
            }
        }
        return string2;
    }

    private static final Class _init_$lambda$0(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuperclass();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion;", "", "<init>", "()V", "evaluateFields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "exception", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "evaluateAdditionalStackTrace", "", "", "e", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nExceptionState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,155:1\n1563#2:156\n1634#2,3:157\n1563#2:163\n1634#2,3:164\n1#3:160\n12637#4,2:161\n*S KotlinDebug\n*F\n+ 1 ExceptionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion\n*L\n119#1:156\n119#1:157,3\n130#1:163\n130#1:164,3\n127#1:161,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Map<IrSymbol, State> evaluateFields(Throwable exception, IrClass irClass, IrInterpreterEnvironment environment) {
            Map map;
            block7: {
                Pair messageVar;
                block6: {
                    Map causeVar;
                    Map map2;
                    Object object;
                    Throwable it;
                    List<String> stackTrace = environment.getCallStack$ir_interpreter().getStackTrace();
                    IrProperty messageProperty = UtilsKt.getOriginalPropertyByName(irClass, "message");
                    IrProperty causeProperty = UtilsKt.getOriginalPropertyByName(irClass, "cause");
                    IrPropertySymbol irPropertySymbol = messageProperty.getSymbol();
                    String string2 = exception.getMessage();
                    IrSimpleFunction irSimpleFunction = messageProperty.getGetter();
                    Intrinsics.checkNotNull((Object)irSimpleFunction);
                    messageVar = TuplesKt.to((Object)irPropertySymbol, (Object)new Primitive(string2, irSimpleFunction.getReturnType()));
                    Throwable throwable = exception.getCause();
                    if (throwable != null) {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        it = throwable;
                        boolean bl2 = false;
                        IrPropertySymbol irPropertySymbol2 = causeProperty.getSymbol();
                        Collection collection2 = stackTrace;
                        StackTraceElement[] stackTraceElementArray = it.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.reversed((Object[])stackTraceElementArray);
                        Collection collection3 = collection2;
                        IrClass irClass2 = irClass;
                        Throwable throwable2 = it;
                        IrPropertySymbol irPropertySymbol3 = irPropertySymbol2;
                        boolean $i$f$map = false;
                        void var18_16 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            collection.add("at " + it2);
                        }
                        collection = (List)destination$iv$iv;
                        IrInterpreterEnvironment irInterpreterEnvironment = environment;
                        List list = CollectionsKt.plus((Collection)collection3, (Iterable)collection);
                        IrClass irClass3 = irClass2;
                        Throwable throwable3 = throwable2;
                        map2 = TuplesKt.to((Object)irPropertySymbol3, (Object)new ExceptionState(throwable3, irClass3, list, irInterpreterEnvironment));
                    } else {
                        map2 = null;
                    }
                    if ((map = (causeVar = map2)) == null) break block6;
                    it = map;
                    boolean bl4 = false;
                    object = new Pair[]{messageVar, it};
                    Map map3 = MapsKt.mutableMapOf((Pair[])object);
                    map = map3;
                    if (map3 != null) break block7;
                }
                Pair[] pairArray = new Pair[]{messageVar};
                map = MapsKt.mutableMapOf((Pair[])pairArray);
            }
            return map;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> evaluateAdditionalStackTrace(Throwable e2, IrInterpreterEnvironment environment) {
            boolean bl2;
            Object it;
            int $i$f$any;
            Object[] $this$any$iv;
            List additionalStack;
            block7: {
                additionalStack = new ArrayList();
                StackTraceElement[] stackTraceElementArray = e2.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                $this$any$iv = stackTraceElementArray;
                $i$f$any = 0;
                for (Object element$iv : $this$any$iv) {
                    it = (StackTraceElement)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)((StackTraceElement)it).getClassName(), (Object)"java.lang.invoke.MethodHandle")) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                StackTraceElement[] stackTraceElementArray = e2.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                $this$any$iv = stackTraceElementArray;
                int n2 = $this$any$iv.length;
                for ($i$f$any = 0; $i$f$any < n2; ++$i$f$any) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    int index2 = $i$f$any;
                    Object stackTraceElement = $this$any$iv[$i$f$any];
                    if (!Intrinsics.areEqual((Object)((StackTraceElement)stackTraceElement).getMethodName(), (Object)"invokeWithArguments")) continue;
                    StackTraceElement[] stackTraceElementArray2 = e2.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray2, (String)"getStackTrace(...)");
                    it = CollectionsKt.reversed((Iterable)ArraysKt.slice((Object[])stackTraceElementArray2, (IntRange)RangesKt.until((int)0, (int)index2)));
                    List list = additionalStack;
                    boolean $i$f$map = false;
                    void var11_19 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        StackTraceElement stackTraceElement2 = (StackTraceElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add("at " + it2);
                    }
                    list.addAll((List)destination$iv$iv);
                    break;
                }
                StackTraceElement[] stackTraceElementArray3 = e2.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray3, (String)"getStackTrace(...)");
                StackTraceElement it3 = (StackTraceElement)ArraysKt.first((Object[])stackTraceElementArray3);
                boolean bl5 = false;
                String lastNeededValue = it3.getClassName() + '.' + it3.getMethodName();
                block3: for (Throwable cause = e2.getCause(); cause != null; cause = cause.getCause()) {
                    StackTraceElement[] stackTraceElementArray4;
                    Intrinsics.checkNotNullExpressionValue((Object)cause.getStackTrace(), (String)"getStackTrace(...)");
                    int n3 = stackTraceElementArray4.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        StackTraceElement causeStackTraceElement;
                        int causeStackIndex = i2;
                        StackTraceElement it4 = causeStackTraceElement = stackTraceElementArray4[i2];
                        boolean bl6 = false;
                        String currentStackTraceValue = it4.getClassName() + '.' + it4.getMethodName();
                        if (!Intrinsics.areEqual((Object)currentStackTraceValue, (Object)lastNeededValue)) continue;
                        StackTraceElement[] stackTraceElementArray5 = cause.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray5, (String)"getStackTrace(...)");
                        cause.setStackTrace((StackTraceElement[])ArraysKt.reversedArray((Object[])ArraysKt.sliceArray((Object[])stackTraceElementArray5, (IntRange)RangesKt.until((int)0, (int)causeStackIndex))));
                        continue block3;
                    }
                }
            }
            if (environment.getConfiguration().getCollapseStackTraceFromJDK() && !((Collection)additionalStack).isEmpty()) {
                return CollectionsKt.listOf((Object)"at <JDK>");
            }
            return additionalStack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

