/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.proxy.reflection;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KVisibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KFunctionProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.ReflectionProxy;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b \u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0003@ABB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ'\u00101\u001a\u0004\u0018\u00010\u00032\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000303\"\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00104J \u00105\u001a\u0004\u0018\u00010\u00032\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010\u000306H\u0016J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0004J\u0013\u0010<\u001a\u00020\u00132\b\u0010=\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010>\u001a\u00020:H\u0016J\b\u0010?\u001a\u00020\u001bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\"R\u0016\u0010-\u001a\u0004\u0018\u00010.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy;", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/ReflectionProxy;", "Lkotlin/reflect/KProperty;", "", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KPropertyState;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KPropertyState;Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;)V", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KPropertyState;", "getCallInterceptor", "()Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "propertyType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getPropertyType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "isAbstract", "", "()Z", "isConst", "isFinal", "isLateinit", "isOpen", "isSuspend", "name", "", "getName", "()Ljava/lang/String;", "annotations", "", "", "getAnnotations", "()Ljava/util/List;", "parameters", "Lkotlin/reflect/KParameter;", "getParameters", "returnType", "Lkotlin/reflect/KType;", "getReturnType", "()Lkotlin/reflect/KType;", "typeParameters", "Lkotlin/reflect/KTypeParameter;", "getTypeParameters", "visibility", "Lkotlin/reflect/KVisibility;", "getVisibility", "()Lkotlin/reflect/KVisibility;", "call", "args", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "callBy", "", "checkArguments", "", "expected", "", "actual", "equals", "other", "hashCode", "toString", "Accessor", "Getter", "Setter", "ir.interpreter"})
public abstract class AbstractKPropertyProxy
implements ReflectionProxy,
KProperty<Object> {
    @NotNull
    private final KPropertyState state;
    @NotNull
    private final CallInterceptor callInterceptor;

    public AbstractKPropertyProxy(@NotNull KPropertyState state, @NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        this.state = state;
        this.callInterceptor = callInterceptor;
    }

    @Override
    @NotNull
    public KPropertyState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public CallInterceptor getCallInterceptor() {
        return this.callInterceptor;
    }

    @NotNull
    protected final IrType getPropertyType() {
        IrSimpleFunction irSimpleFunction = this.getState().getProperty().getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        return irSimpleFunction.getReturnType();
    }

    public boolean isAbstract() {
        return this.getState().getProperty().getModality() == Modality.ABSTRACT;
    }

    public boolean isConst() {
        return this.getState().getProperty().isConst();
    }

    public boolean isFinal() {
        return this.getState().getProperty().getModality() == Modality.FINAL;
    }

    public boolean isLateinit() {
        return this.getState().getProperty().isLateinit();
    }

    public boolean isOpen() {
        return this.getState().getProperty().getModality() == Modality.OPEN;
    }

    public boolean isSuspend() {
        return false;
    }

    @NotNull
    public String getName() {
        String string2 = this.getState().getProperty().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return string2;
    }

    @NotNull
    public List<Annotation> getAnnotations() {
        String string2 = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @NotNull
    public List<KParameter> getParameters() {
        return this.getState().getParameters(this.getCallInterceptor());
    }

    @NotNull
    public KType getReturnType() {
        return this.getState().getReturnType(this.getCallInterceptor());
    }

    @NotNull
    public List<KTypeParameter> getTypeParameters() {
        return CollectionsKt.emptyList();
    }

    @Nullable
    public KVisibility getVisibility() {
        return this.toKVisibility(this.getState().getProperty().getVisibility());
    }

    @Nullable
    public Object call(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.getGetter().call(Arrays.copyOf(args, args.length));
    }

    @Nullable
    public Object callBy(@NotNull Map<KParameter, ? extends Object> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return this.getGetter().callBy(args);
    }

    protected final void checkArguments(int expected, int actual) {
        if (expected != actual) {
            throw new IllegalArgumentException("Callable expects " + expected + " arguments, but " + actual + " were provided.");
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AbstractKPropertyProxy)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getState(), (Object)((AbstractKPropertyProxy)other).getState());
    }

    @Override
    public int hashCode() {
        return this.getState().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getState().toString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a6\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy$Accessor;", "R", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/KFunctionProxy;", "Lkotlin/reflect/KProperty$Accessor;", "", "Lkotlin/reflect/KFunction;", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy;Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;)V", "property", "Lkotlin/reflect/KProperty;", "getProperty", "()Lkotlin/reflect/KProperty;", "ir.interpreter"})
    public abstract class Accessor<R>
    extends KFunctionProxy<R>
    implements KProperty.Accessor<Object>,
    KFunction<R> {
        @NotNull
        private final KProperty<Object> property;

        public Accessor(KFunctionState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super(state, AbstractKPropertyProxy.this.getCallInterceptor());
            this.property = AbstractKPropertyProxy.this;
        }

        @NotNull
        public KProperty<Object> getProperty() {
            return this.property;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a6\u0004\u0018\u00002\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001R\u00020\u00032\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy$Getter;", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy$Accessor;", "", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy;", "Lkotlin/reflect/KProperty$Getter;", "getterState", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy;Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;)V", "ir.interpreter"})
    public abstract class Getter
    extends Accessor<Object>
    implements KProperty.Getter<Object> {
        public Getter(KFunctionState getterState) {
            Intrinsics.checkNotNullParameter((Object)getterState, (String)"getterState");
            super(getterState);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a6\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u00032\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy$Setter;", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy$Accessor;", "", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy;", "Lkotlin/reflect/KMutableProperty$Setter;", "", "setterState", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/AbstractKPropertyProxy;Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;)V", "ir.interpreter"})
    public abstract class Setter
    extends Accessor<Unit>
    implements KMutableProperty.Setter<Object> {
        public Setter(KFunctionState setterState) {
            Intrinsics.checkNotNullParameter((Object)setterState, (String)"setterState");
            super(setterState);
        }
    }
}

