/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ContextCollector;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ContextCollectorDsl;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DesignationInterceptor;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirControlFlowGraphOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKindKt;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.FirTowerDataMode;
import org.jetbrains.kotlin.fir.resolve.ImplicitValueStorage;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.SessionHolderImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowAnalyzerContext;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.UtilKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ClassExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.MergePostponedLambdaExitsNode;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculatorForFullBodyResolve;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveContext;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirExpressionsResolveTransformerKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirLocalScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirMemberTypeParameterScope;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.SmartcastStability;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0003{|}B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010(\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0006\u0010/\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0002J \u00102\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0-2\u0006\u00100\u001a\u000201H\u0002J\u001e\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u00104\u001a\u00020\u00052\n\u00105\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u0010\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020HH\u0016J\u0014\u0010I\u001a\u00020\u000f*\u00020J2\u0006\u0010G\u001a\u00020HH\u0002J\u0014\u0010K\u001a\u00020\u000f*\u00020J2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010L\u001a\u00020\u000f*\u00020J2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u000f2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\u000f2\u0006\u0010Y\u001a\u00020ZH\u0016J\"\u0010[\u001a\u00020\u000f*\u00020\u001d2\u0006\u0010Y\u001a\u00020Z2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u000f0]H\u0002J\u000e\u0010^\u001a\u0004\u0018\u00010_*\u00020_H\u0002J\u0010\u0010`\u001a\u00020\u000f2\u0006\u0010a\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020\u000f2\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010f\u001a\u00020\u000f2\u0006\u0010g\u001a\u00020hH\u0016J\u0010\u0010i\u001a\u00020\u000f2\u0006\u0010j\u001a\u00020kH\u0016J\u0010\u0010l\u001a\u00020\u000f2\u0006\u0010m\u001a\u00020nH\u0016J\u0010\u0010o\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010p\u001a\u00020\u000f2\u0006\u0010q\u001a\u00020rH\u0016J\u0014\u0010s\u001a\u00020\u000f*\u00020J2\u0006\u0010#\u001a\u00020$H\u0003J*\u0010t\u001a\u00020\u000f2\u0006\u0010u\u001a\u00020\u001a2\u0017\u0010q\u001a\u0013\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\u0002\bvH\u0082\bJ\u0016\u0010w\u001a\u00020\u000f2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000f0]H\u0002J\u001f\u0010x\u001a\u00020\u000f2\u0006\u0010u\u001a\u00020\u001a2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000f0]H\u0082\bJ\u0017\u0010y\u001a\u00020\u000f2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000f0]H\u0082\bJ\u0017\u0010z\u001a\u00020\u000f2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000f0]H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u001fj\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0013`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010+\u001a>\u0012\u0004\u0012\u00020,\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0-0\u001fj\u001e\u0012\u0004\u0012\u00020,\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0-`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitorVoid;", "bodyHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "shouldCollectBodyContext", "", "filter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$FilterResponse;", "designationPathInterceptor", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/DesignationInterceptor;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;ZLkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/DesignationInterceptor;)V", "collect", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "get", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$Context;", "element", "kind", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;", "isActive", "parents", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lkotlin/collections/ArrayList;", "context", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveContext;", "result", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$ContextKey;", "Lkotlin/collections/HashMap;", "getSessionHolder", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitElement", "dumpContext", "fir", "computeContext", "getClosestControlFlowNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "nodesCache", "Lorg/jetbrains/kotlin/fir/declarations/FirControlFlowGraphOwner;", "", "findNode", "container", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "buildDeclarationNodesMapping", "getControlFlowNode", "isAcceptedControlFlowNode", "node", "visitScript", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "visitFile", "visitCodeFragment", "codeFragment", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "processClassHeader", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$Processor;", "processFileHeader", "processAnonymousObjectHeader", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "forPropertyInitializerIfNonLocal", "f", "Lkotlin/Function0;", "unwrap", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "visitAnonymousInitializer", "anonymousInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "visitAnonymousObject", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "processSignatureAnnotations", "withProcessor", "parent", "Lkotlin/ExtensionFunctionType;", "withInterceptor", "withParent", "onActive", "onActiveBody", "ContextKey", "Processor", "FilteringVisitor", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nContextCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextCollector.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BodyResolveContext.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveContext\n+ 6 TransformUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/TransformUtilsKt\n+ 7 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 8 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 9 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,935:1\n913#1,3:936\n922#1,4:939\n917#1,3:943\n859#1:955\n913#1,3:956\n860#1:959\n928#1,4:960\n861#1:964\n917#1,3:965\n862#1:968\n859#1:969\n913#1,3:970\n860#1:973\n922#1,4:995\n861#1:1011\n917#1,3:1012\n862#1:1015\n928#1,2:1016\n931#1:1035\n922#1,2:1036\n913#1,7:1038\n925#1:1045\n922#1,2:1046\n913#1,7:1048\n925#1:1055\n859#1:1056\n913#1,3:1057\n860#1:1060\n928#1,2:1061\n931#1:1069\n861#1:1071\n917#1,3:1072\n862#1:1075\n859#1:1086\n913#1,3:1087\n860#1:1090\n928#1,2:1091\n922#1,2:1124\n925#1:1162\n922#1,4:1163\n931#1:1169\n861#1:1170\n917#1,3:1171\n862#1:1174\n928#1,2:1175\n922#1,4:1193\n931#1:1202\n859#1:1203\n913#1,3:1204\n860#1:1207\n928#1,2:1208\n922#1,4:1220\n931#1:1241\n861#1:1242\n917#1,3:1243\n862#1:1246\n859#1:1247\n913#1,3:1248\n860#1:1251\n928#1,2:1252\n922#1,4:1260\n922#1,4:1264\n922#1,4:1280\n922#1,4:1284\n931#1:1292\n861#1:1293\n917#1,3:1294\n862#1:1297\n859#1:1308\n913#1,3:1309\n860#1:1312\n928#1,2:1313\n922#1,4:1338\n931#1:1350\n861#1:1351\n917#1,3:1352\n862#1:1355\n859#1:1356\n913#1,3:1357\n860#1:1360\n928#1,4:1361\n861#1:1365\n917#1,3:1366\n862#1:1369\n859#1:1370\n913#1,3:1371\n860#1:1374\n928#1,2:1375\n922#1,4:1384\n931#1:1390\n861#1:1391\n917#1,3:1392\n862#1:1395\n859#1:1396\n913#1,3:1397\n860#1:1400\n928#1,2:1401\n922#1,4:1415\n931#1:1423\n861#1:1424\n917#1,3:1425\n862#1:1428\n859#1:1429\n913#1,3:1430\n860#1:1433\n928#1,4:1434\n861#1:1438\n917#1,3:1439\n862#1:1442\n859#1:1443\n913#1,3:1444\n860#1:1447\n928#1,2:1448\n931#1:1451\n861#1:1452\n917#1,3:1453\n862#1:1456\n859#1:1457\n913#1,3:1458\n860#1:1461\n928#1,2:1462\n931#1:1472\n861#1:1473\n917#1,3:1474\n862#1:1477\n922#1,4:1478\n913#1,7:1482\n922#1,4:1500\n922#1,4:1504\n922#1,4:1508\n922#1,4:1512\n922#1,4:1516\n922#1,4:1520\n922#1,4:1524\n922#1,4:1528\n922#1,4:1532\n1056#2:946\n1563#2:987\n1634#2,3:988\n384#3,7:947\n1#4:954\n1#4:1008\n1#4:1303\n1#4:1336\n1#4:1408\n440#5,3:974\n443#5:980\n186#5,3:981\n444#5,3:984\n447#5:991\n154#5,3:992\n158#5,2:999\n190#5,2:1001\n448#5:1003\n880#5,2:1018\n196#5,14:1020\n882#5:1034\n176#5,6:1063\n298#5,3:1076\n186#5,3:1079\n301#5,2:1082\n190#5,2:1084\n970#5:1093\n154#5,3:1094\n982#5:1097\n1002#5:1098\n196#5,11:1099\n1003#5:1110\n186#5,3:1111\n1004#5,5:1114\n190#5,2:1119\n1009#5:1121\n208#5,2:1122\n992#5,11:1126\n196#5,11:1137\n1003#5:1148\n186#5,3:1149\n1004#5,5:1152\n190#5,2:1157\n1009#5:1159\n208#5,2:1160\n158#5,2:1167\n872#5:1177\n196#5,11:1178\n873#5:1189\n154#5,3:1190\n158#5,2:1197\n208#5,2:1199\n874#5:1201\n747#5,5:1210\n298#5:1215\n752#5:1216\n154#5,3:1217\n158#5,2:1224\n299#5,2:1226\n186#5,3:1228\n301#5,2:1231\n154#5,6:1233\n190#5,2:1239\n923#5:1254\n298#5:1255\n924#5:1256\n154#5,3:1257\n158#5,2:1268\n299#5,2:1270\n186#5,3:1272\n301#5,2:1275\n154#5,3:1277\n158#5,2:1288\n190#5,2:1290\n962#5:1298\n186#5,3:1299\n963#5:1302\n964#5:1304\n190#5,2:1305\n858#5:1315\n196#5,11:1316\n859#5:1327\n154#5,3:1328\n860#5:1331\n186#5,3:1332\n861#5:1335\n862#5:1337\n190#5,2:1342\n863#5:1344\n158#5,2:1345\n864#5:1347\n208#5,2:1348\n906#5,4:1377\n154#5,3:1381\n158#5,2:1388\n892#5:1403\n186#5,3:1404\n893#5:1407\n894#5,3:1409\n154#5,3:1412\n158#5,2:1419\n190#5,2:1421\n480#5:1450\n1034#5:1464\n186#5,3:1465\n1035#5,2:1468\n190#5,2:1470\n71#6,3:977\n75#6,4:1004\n79#6,2:1009\n61#7:1070\n45#8:1307\n81#9,7:1489\n76#9,2:1496\n57#9:1498\n78#9:1499\n*S KotlinDebug\n*F\n+ 1 ContextCollector.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor\n*L\n238#1:936,3\n241#1:939,4\n238#1:943,3\n394#1:955\n394#1:956,3\n394#1:959\n399#1:960,4\n394#1:964\n394#1:965,3\n394#1:968\n414#1:969\n414#1:970,3\n414#1:973\n422#1:995,4\n414#1:1011\n414#1:1012,3\n414#1:1015\n443#1:1016,2\n443#1:1035\n466#1:1036,2\n467#1:1038,7\n466#1:1045\n494#1:1046,2\n495#1:1048,7\n494#1:1055\n506#1:1056\n506#1:1057,3\n506#1:1060\n511#1:1061,2\n511#1:1069\n506#1:1071\n506#1:1072,3\n506#1:1075\n568#1:1086\n568#1:1087,3\n568#1:1090\n573#1:1091,2\n594#1:1124,2\n594#1:1162\n600#1:1163,4\n573#1:1169\n568#1:1170\n568#1:1171,3\n568#1:1174\n610#1:1175,2\n616#1:1193,4\n610#1:1202\n623#1:1203\n623#1:1204,3\n623#1:1207\n628#1:1208,2\n644#1:1220,4\n628#1:1241\n623#1:1242\n623#1:1243,3\n623#1:1246\n651#1:1247\n651#1:1248,3\n651#1:1251\n656#1:1252,2\n662#1:1260,4\n676#1:1264,4\n662#1:1280,4\n676#1:1284,4\n656#1:1292\n651#1:1293\n651#1:1294,3\n651#1:1297\n723#1:1308\n723#1:1309,3\n723#1:1312\n728#1:1313,2\n734#1:1338,4\n728#1:1350\n723#1:1351\n723#1:1352,3\n723#1:1355\n741#1:1356\n741#1:1357,3\n741#1:1360\n746#1:1361,4\n741#1:1365\n741#1:1366,3\n741#1:1369\n759#1:1370\n759#1:1371,3\n759#1:1374\n764#1:1375,2\n768#1:1384,4\n764#1:1390\n759#1:1391\n759#1:1392,3\n759#1:1395\n776#1:1396\n776#1:1397,3\n776#1:1400\n781#1:1401,2\n785#1:1415,4\n781#1:1423\n776#1:1424\n776#1:1425,3\n776#1:1428\n793#1:1429\n793#1:1430,3\n793#1:1433\n798#1:1434,4\n793#1:1438\n793#1:1439,3\n793#1:1442\n819#1:1443\n819#1:1444,3\n819#1:1447\n824#1:1448,2\n824#1:1451\n819#1:1452\n819#1:1453,3\n819#1:1456\n837#1:1457\n837#1:1458,3\n837#1:1461\n840#1:1462,2\n840#1:1472\n837#1:1473\n837#1:1474,3\n837#1:1477\n852#1:1478,4\n859#1:1482,7\n405#1:1500,4\n522#1:1504,4\n589#1:1508,4\n639#1:1512,4\n666#1:1516,4\n670#1:1520,4\n752#1:1524,4\n807#1:1528,4\n811#1:1532,4\n283#1:946\n417#1:987\n417#1:988,3\n342#1:947,7\n417#1:1008\n698#1:1303\n731#1:1336\n782#1:1408\n417#1:974,3\n417#1:980\n417#1:981,3\n417#1:984,3\n417#1:991\n417#1:992,3\n417#1:999,2\n417#1:1001,2\n417#1:1003\n444#1:1018,2\n444#1:1020,14\n444#1:1034\n514#1:1063,6\n545#1:1076,3\n545#1:1079,3\n545#1:1082,2\n545#1:1084,2\n576#1:1093\n576#1:1094,3\n580#1:1097\n580#1:1098\n580#1:1099,11\n580#1:1110\n580#1:1111,3\n580#1:1114,5\n580#1:1119,2\n580#1:1121\n580#1:1122,2\n595#1:1126,11\n595#1:1137,11\n595#1:1148\n595#1:1149,3\n595#1:1152,5\n595#1:1157,2\n595#1:1159\n595#1:1160,2\n576#1:1167,2\n613#1:1177\n613#1:1178,11\n613#1:1189\n613#1:1190,3\n613#1:1197,2\n613#1:1199,2\n613#1:1201\n633#1:1210,5\n633#1:1215\n633#1:1216\n633#1:1217,3\n633#1:1224,2\n633#1:1226,2\n633#1:1228,3\n633#1:1231,2\n633#1:1233,6\n633#1:1239,2\n659#1:1254\n659#1:1255\n659#1:1256\n659#1:1257,3\n659#1:1268,2\n659#1:1270,2\n659#1:1272,3\n659#1:1275,2\n659#1:1277,3\n659#1:1288,2\n659#1:1290,2\n698#1:1298\n698#1:1299,3\n698#1:1302\n698#1:1304\n698#1:1305,2\n731#1:1315\n731#1:1316,11\n731#1:1327\n731#1:1328,3\n731#1:1331\n731#1:1332,3\n731#1:1335\n731#1:1337\n731#1:1342,2\n731#1:1344\n731#1:1345,2\n731#1:1347\n731#1:1348,2\n765#1:1377,4\n765#1:1381,3\n765#1:1388,2\n782#1:1403\n782#1:1404,3\n782#1:1407\n782#1:1409,3\n782#1:1412,3\n782#1:1419,2\n782#1:1421,2\n827#1:1450\n841#1:1464\n841#1:1465,3\n841#1:1468,2\n841#1:1470,2\n417#1:977,3\n417#1:1004,4\n417#1:1009,2\n531#1:1070\n706#1:1307\n200#1:1489,7\n200#1:1496,2\n200#1:1498\n200#1:1499\n*E\n"})
final class ContextCollectorVisitor
extends FirDefaultVisitorVoid {
    @NotNull
    private final SessionHolder bodyHolder;
    private final boolean shouldCollectBodyContext;
    @NotNull
    private final Function1<PsiElement, ContextCollector.FilterResponse> filter;
    @Nullable
    private final DesignationInterceptor designationPathInterceptor;
    private boolean isActive;
    @NotNull
    private final ArrayList<FirElement> parents;
    @NotNull
    private final BodyResolveContext context;
    @NotNull
    private final HashMap<ContextKey, ContextCollector.Context> result;
    @NotNull
    private final HashMap<FirControlFlowGraphOwner, Map<FirElement, CFGNode<?>>> nodesCache;

    public ContextCollectorVisitor(@NotNull SessionHolder bodyHolder, boolean shouldCollectBodyContext, @NotNull Function1<? super PsiElement, ? extends ContextCollector.FilterResponse> filter, @Nullable DesignationInterceptor designationPathInterceptor) {
        Intrinsics.checkNotNullParameter((Object)bodyHolder, (String)"bodyHolder");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.bodyHolder = bodyHolder;
        this.shouldCollectBodyContext = shouldCollectBodyContext;
        this.filter = filter;
        this.designationPathInterceptor = designationPathInterceptor;
        this.isActive = true;
        this.parents = new ArrayList();
        this.context = new BodyResolveContext(ReturnTypeCalculatorForFullBodyResolve.Companion.getDefault(), new DataFlowAnalyzerContext(this.bodyHolder.getSession()), null, null, 12, null);
        this.result = new HashMap();
        this.nodesCache = new HashMap();
    }

    public final void collect(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.designationPathInterceptor != null) {
            this.withInterceptor((Function0<Unit>)((Function0)() -> ContextCollectorVisitor.collect$lambda$1(file2, this)));
        } else {
            file2.accept(this);
        }
    }

    @Nullable
    public final ContextCollector.Context get(@NotNull PsiElement element2, @NotNull ContextCollector.ContextKind kind) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        ContextKey key = new ContextKey(element2, kind);
        return this.result.get(key);
    }

    private final SessionHolder getSessionHolder(FirDeclaration declaration2) {
        FirSession session = declaration2.getModuleData().getSession();
        return Intrinsics.areEqual((Object)session, (Object)this.bodyHolder.getSession()) ? this.bodyHolder : (SessionHolder)new SessionHolderImpl(session, this.bodyHolder.getScopeSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitElement(@NotNull FirElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.dumpContext(element2, ContextCollector.ContextKind.SELF);
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withParent = false;
        this_$iv.parents.add(element2);
        try {
            boolean bl2 = false;
            this.dumpContext(element2, ContextCollector.ContextKind.BODY);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActive = false;
            if (this_$iv2.isActive) {
                boolean bl3 = false;
                element2.acceptChildren(this);
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv.parents);
        }
    }

    private final void dumpContext(FirElement fir, ContextCollector.ContextKind kind) {
        ProgressManager.checkCanceled();
        if (kind == ContextCollector.ContextKind.BODY && !this.shouldCollectBodyContext) {
            return;
        }
        PsiElement psiElement = UtilsKt.getPsi(fir);
        if (psiElement == null) {
            return;
        }
        PsiElement psi = psiElement;
        ContextKey key = new ContextKey(psi, kind);
        if (((Map)this.result).containsKey(key)) {
            return;
        }
        ContextCollector.FilterResponse response = (ContextCollector.FilterResponse)((Object)this.filter.invoke((Object)psi));
        if (response != ContextCollector.FilterResponse.SKIP) {
            ((Map)this.result).put(key, this.computeContext(fir, kind));
        }
        if (response == ContextCollector.FilterResponse.STOP) {
            this.isActive = false;
        }
    }

    private final ContextCollector.Context computeContext(FirElement fir, ContextCollector.ContextKind kind) {
        ImplicitValueStorage implicitReceiverStack = this.context.getTowerDataContext().getImplicitValueStorage();
        Map smartCasts = new LinkedHashMap();
        CFGNode<?> cfgNode = this.getClosestControlFlowNode(fir, kind);
        if (cfgNode != null) {
            Iterator $this$sortedBy$iv;
            PersistentFlow flow = cfgNode.getFlow();
            Iterable iterable = flow.getKnownVariables();
            boolean $i$f$sortedBy = false;
            List realVariables = CollectionsKt.sortedWith((Iterable)((Object)$this$sortedBy$iv), (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    RealVariable it = (RealVariable)a2;
                    boolean bl2 = false;
                    Name name2 = FirDeclarationUtilKt.getMemberDeclarationNameOrNull(it.getSymbol());
                    it = (RealVariable)b2;
                    Comparable comparable = (Comparable)((Object)(name2 != null ? name2.asString() : null));
                    bl2 = false;
                    Name name3 = FirDeclarationUtilKt.getMemberDeclarationNameOrNull(it.getSymbol());
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)(name3 != null ? name3.asString() : null))));
                }
            });
            for (RealVariable realVariable : realVariables) {
                TypeStatement typeStatement;
                SmartcastStability stability;
                if (flow.getTypeStatement(realVariable) == null || (stability = realVariable.getStability(flow, this.bodyHolder.getSession())) != SmartcastStability.STABLE_VALUE && stability != SmartcastStability.CAPTURED_VARIABLE) continue;
                smartCasts.put(typeStatement.getVariable(), typeStatement.getExactType());
                if (!realVariable.isImplicit()) continue;
                ConeKotlinType smartCastedType = UtilKt.smartCastedType(typeStatement, TypeComponentsKt.getTypeContext(this.bodyHolder.getSession()));
                implicitReceiverStack.replaceImplicitValueType(realVariable.getSymbol(), smartCastedType);
            }
        }
        FirTowerDataContext towerDataContextSnapshot = this.context.getTowerDataContext().createSnapshot(true);
        for (RealVariable realVariable : smartCasts.keySet()) {
            if (!realVariable.isImplicit()) continue;
            implicitReceiverStack.replaceImplicitValueType(realVariable.getSymbol(), realVariable.getOriginalType());
        }
        return new ContextCollector.Context(towerDataContextSnapshot, smartCasts);
    }

    private final CFGNode<?> getClosestControlFlowNode(FirElement fir, ContextCollector.ContextKind kind) {
        CFGNode<?> selfNode = this.getControlFlowNode(fir, kind);
        if (selfNode != null) {
            return selfNode;
        }
        for (FirElement parent2 : CollectionsKt.asReversedMutable((List)this.parents)) {
            CFGNode<?> parentNode = this.getControlFlowNode(parent2, kind);
            if (parentNode == null) continue;
            return parentNode;
        }
        return null;
    }

    private final CFGNode<?> findNode(FirControlFlowGraphOwner container, FirElement element2, ControlFlowGraph flow) {
        Object object;
        Map $this$getOrPut$iv = this.nodesCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(container);
        if (value$iv == null) {
            boolean bl2 = false;
            Map<FirElement, CFGNode<?>> answer$iv = this.buildDeclarationNodesMapping(flow);
            $this$getOrPut$iv.put(container, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map map = (Map)object;
        return (CFGNode)map.get(element2);
    }

    private final Map<FirElement, CFGNode<?>> buildDeclarationNodesMapping(ControlFlowGraph flow) {
        Map<FirElement, CFGNode<?>> map;
        Map<FirElement, CFGNode<?>> map2 = new HashMap();
        HashMap $this$buildDeclarationNodesMapping_u24lambda_u246 = map2;
        boolean bl2 = false;
        for (CFGNode<?> node : flow.getNodes()) {
            if (!this.isAcceptedControlFlowNode(node)) continue;
            Object fir = node.getFir();
            $this$buildDeclarationNodesMapping_u24lambda_u246.putIfAbsent(fir, node);
        }
        if ((map2 = (Map)map2).isEmpty()) {
            boolean bl3 = false;
            map = MapsKt.emptyMap();
        } else {
            map = map2;
        }
        return map;
    }

    private final CFGNode<?> getControlFlowNode(FirElement fir, ContextCollector.ContextKind kind) {
        for (FirDeclaration container : CollectionsKt.asReversedMutable((List)((List)this.context.getContainers()))) {
            ControlFlowGraph cfg;
            FirControlFlowGraphReference cfgReference;
            FirControlFlowGraphOwner cfgOwner;
            FirControlFlowGraphOwner firControlFlowGraphOwner = container instanceof FirControlFlowGraphOwner ? (FirControlFlowGraphOwner)((Object)container) : null;
            if (firControlFlowGraphOwner == null || (cfgOwner = firControlFlowGraphOwner).getControlFlowGraphReference() == null || FirControlFlowGraphReferenceImplKt.getControlFlowGraph(cfgReference) == null) continue;
            CFGNode node = this.findNode((FirControlFlowGraphOwner)((Object)container), fir, cfg);
            if (node != null) {
                CFGNode cFGNode;
                switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                    case 1: {
                        cFGNode = (CFGNode)CollectionsKt.singleOrNull(node.getPreviousNodes());
                        if (cFGNode != null) {
                            CFGNode cFGNode2;
                            CFGNode it = cFGNode2 = cFGNode;
                            boolean bl2 = false;
                            cFGNode = cfg.getNodes().contains(it) ? cFGNode2 : null;
                            if (cFGNode != null) break;
                        }
                        cFGNode = node;
                        break;
                    }
                    case 2: {
                        cFGNode = node;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return cFGNode;
            }
            if (cfg.isSubGraph()) continue;
            return null;
        }
        return null;
    }

    private final boolean isAcceptedControlFlowNode(CFGNode<?> node) {
        return node instanceof ClassExitNode ? false : !(node instanceof MergePostponedLambdaExitsNode) || ((MergePostponedLambdaExitsNode)node).getFlowInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitScript(@NotNull FirScript script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(script);
        try {
            boolean bl2 = false;
            Processor $this$visitScript_u24lambda_u2412 = new Processor(this_$iv);
            boolean bl3 = false;
            this.dumpContext(script, ContextCollector.ContextKind.SELF);
            this.processSignatureAnnotations($this$visitScript_u24lambda_u2412, script);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl4 = false;
                SessionHolder holder = this.getSessionHolder(script);
                this.context.withScript(script, holder, () -> ContextCollectorVisitor.visitScript$lambda$12$lambda$11$lambda$10(this, script, $this$visitScript_u24lambda_u2412));
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(file2);
        try {
            int n2;
            int size$iv$iv;
            boolean bl2 = false;
            Processor $this$visitFile_u24lambda_u2416 = new Processor(this_$iv);
            boolean bl3 = false;
            SessionHolder holder = this.getSessionHolder(file2);
            BodyResolveContext this_$iv2 = this.context;
            boolean $i$f$withFile = false;
            this_$iv2.clear();
            this_$iv2.setFile(file2);
            List<FirScope> scopes$iv$iv = this_$iv2.getFileImportsScope();
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv$iv = scopes$iv$iv.size();
            try {
                Unit unit;
                boolean bl4 = false;
                BodyResolveContext this_$iv$iv2 = this_$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv = this_$iv$iv2.getTowerDataContext();
                try {
                    void $this$mapTo$iv$iv$iv;
                    void $this$map$iv$iv;
                    boolean bl5 = false;
                    List importingScopes$iv = ImportingScopesKt.createImportingScopes$default(file2, holder.getSession(), holder.getScopeSession(), false, 8, null);
                    CollectionsKt.addAll((Collection)this_$iv2.getFileImportsScope(), (Iterable)importingScopes$iv);
                    Iterable iterable = importingScopes$iv;
                    BodyResolveContext bodyResolveContext = this_$iv2;
                    boolean $i$f$map = false;
                    Unit unit2 = $this$map$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                        void it$iv;
                        FirScope firScope = (FirScope)item$iv$iv$iv;
                        Collection collection = destination$iv$iv$iv;
                        boolean bl6 = false;
                        collection.add(ImplicitReceiverUtilsKt.asTowerDataElement((FirScope)it$iv, false));
                    }
                    bodyResolveContext.addNonLocalTowerDataElements((List)destination$iv$iv$iv);
                    BodyResolveContext this_$iv$iv3 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add((Object)file2);
                    try {
                        boolean bl7 = false;
                        this.dumpContext(file2, ContextCollector.ContextKind.SELF);
                        this.processFileHeader($this$visitFile_u24lambda_u2416, file2);
                        ContextCollectorVisitor this_$iv3 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv3.isActive) {
                            boolean bl8 = false;
                            this.withInterceptor((Function0<Unit>)((Function0)() -> ContextCollectorVisitor.visitFile$lambda$16$lambda$15$lambda$14$lambda$13($this$visitFile_u24lambda_u2416, file2)));
                        }
                        unit2 = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                    unit = unit2;
                }
                finally {
                    this_$iv$iv2.replaceTowerDataContext(initialContext$iv$iv);
                }
                Unit unit3 = unit;
                size$iv$iv = scopes$iv$iv.size();
                int n3 = n2 = size$iv$iv >= sizeBefore$iv$iv ? 1 : 0;
            }
            catch (Throwable throwable) {
                int n4;
                int size$iv$iv2 = scopes$iv$iv.size();
                int n5 = n4 = size$iv$iv2 >= sizeBefore$iv$iv ? 1 : 0;
                if (_Assertions.ENABLED && n4 == 0) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                n4 = size$iv$iv2 - sizeBefore$iv$iv;
                int n6 = 0;
                while (n6 < n4) {
                    int it$iv$iv = n6++;
                    boolean bl9 = false;
                    List<FirScope> it$iv$iv2 = scopes$iv$iv;
                    boolean bl10 = false;
                    it$iv$iv2.remove(it$iv$iv2.size() - 1);
                }
                throw throwable;
            }
            if (_Assertions.ENABLED && n2 == 0) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            n2 = size$iv$iv - sizeBefore$iv$iv;
            int n7 = 0;
            while (n7 < n2) {
                int it$iv$iv = n7++;
                boolean bl11 = false;
                List<FirScope> it$iv$iv3 = scopes$iv$iv;
                boolean bl12 = false;
                it$iv$iv3.remove(it$iv$iv3.size() - 1);
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    @Override
    public void visitCodeFragment(@NotNull FirCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        FirLazyDeclarationResolverKt.lazyResolveToPhase(codeFragment, FirResolvePhase.BODY_RESOLVE);
        SessionHolder holder = this.getSessionHolder(codeFragment);
        this.context.withCodeFragment(codeFragment, holder, () -> ContextCollectorVisitor.visitCodeFragment$lambda$17(this, codeFragment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitAnnotationCall(@NotNull FirAnnotationCall annotationCall) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        this.dumpContext(annotationCall, ContextCollector.ContextKind.SELF);
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$onActiveBody = false;
        if (this_$iv.isActive || this_$iv.shouldCollectBodyContext) {
            boolean bl2 = false;
            BodyResolveContext this_$iv2 = this.context;
            boolean $i$f$forAnnotation = false;
            if (this_$iv2.getContainerIfAny() instanceof FirRegularClass && !this_$iv2.getInsideClassHeader()) {
                void this_$iv$iv;
                BodyResolveContext bodyResolveContext = this_$iv2;
                FirTowerDataMode mode$iv$iv = FirTowerDataMode.CLASS_HEADER_ANNOTATIONS;
                boolean $i$f$withTowerDataMode = false;
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    boolean bl3 = false;
                    this_$iv$iv.setTowerDataMode(mode$iv$iv);
                    boolean bl4 = false;
                    this.dumpContext(annotationCall, ContextCollector.ContextKind.BODY);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
            } else {
                boolean bl5 = false;
                this.dumpContext(annotationCall, ContextCollector.ContextKind.BODY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$withParent = false;
            this_$iv2.parents.add(functionCall);
            try {
                boolean bl3 = false;
                functionCall.acceptChildren(this);
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv2.parents);
            }
        }
        this.dumpContext(functionCall, ContextCollector.ContextKind.SELF);
        FirExpressionsResolveTransformerKt.addReceiversFromExtensions(this.context, functionCall, this.bodyHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$withParent = false;
            this_$iv2.parents.add(propertyAccessExpression);
            try {
                boolean bl3 = false;
                FirReference calleeReference = propertyAccessExpression.getCalleeReference();
                propertyAccessExpression.acceptChildren(new FilteringVisitor(this, SetsKt.setOf((Object)calleeReference)));
                calleeReference.accept(this);
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv2.parents);
            }
        }
        this.dumpContext(propertyAccessExpression, ContextCollector.ContextKind.SELF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(regularClass);
        try {
            boolean bl2 = false;
            Processor $this$visitRegularClass_u24lambda_u2429 = new Processor(this_$iv);
            boolean bl3 = false;
            this.dumpContext(regularClass, ContextCollector.ContextKind.SELF);
            this.processSignatureAnnotations($this$visitRegularClass_u24lambda_u2429, regularClass);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl4 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(regularClass, FirResolvePhase.STATUS);
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withContainingClass = false;
                this_$iv3.getContainingClassDeclarations().add((Object)regularClass);
                try {
                    boolean bl5 = false;
                    this.processClassHeader($this$visitRegularClass_u24lambda_u2429, regularClass);
                    SessionHolder holder = this.getSessionHolder(regularClass);
                    this.context.withRegularClass(regularClass, holder, () -> ContextCollectorVisitor.visitRegularClass$lambda$29$lambda$28$lambda$27$lambda$26(this, regularClass, $this$visitRegularClass_u24lambda_u2429));
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv3.getContainingClassDeclarations().removeLast();
                }
            }
            FirClassLikeDeclaration $this$isLocal$iv = regularClass;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                this.context.storeClassIfNotNested(regularClass, regularClass.getModuleData().getSession());
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processClassHeader(Processor $this$processClassHeader, FirRegularClass regularClass) {
        BodyResolveContext this_$iv = this.context;
        boolean $i$f$withTypeParametersOf = false;
        if (((FirMemberDeclaration)regularClass).getTypeParameters().isEmpty()) {
            boolean bl2 = false;
            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getContextParameters());
            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getTypeParameters());
            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getSuperTypeRefs());
        } else {
            FirMemberTypeParameterScope scope$iv = new FirMemberTypeParameterScope(regularClass);
            BodyResolveContext this_$iv$iv = this_$iv;
            boolean $i$f$withTowerDataCleanup = false;
            FirTowerDataContext initialContext$iv$iv = this_$iv$iv.getTowerDataContext();
            try {
                boolean bl3 = false;
                this_$iv.addNonLocalTowerDataElement(ImplicitReceiverUtilsKt.asTowerDataElement(scope$iv, false));
                boolean bl4 = false;
                $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getContextParameters());
                $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getTypeParameters());
                $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getSuperTypeRefs());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv$iv.replaceTowerDataContext(initialContext$iv$iv);
            }
        }
    }

    private final void processFileHeader(Processor $this$processFileHeader, FirFile file2) {
        $this$processFileHeader.process(file2.getPackageDirective());
        $this$processFileHeader.processList((Collection<? extends FirElement>)file2.getImports());
        $this$processFileHeader.processList((Collection<? extends FirElement>)file2.getAnnotations());
    }

    private final void processAnonymousObjectHeader(Processor $this$processAnonymousObjectHeader, FirAnonymousObject anonymousObject) {
        $this$processAnonymousObjectHeader.processList((Collection<? extends FirElement>)anonymousObject.getSuperTypeRefs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitConstructor(@NotNull FirConstructor constructor) {
        block22: {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(constructor);
            try {
                boolean bl2 = false;
                Processor $this$visitConstructor_u24lambda_u2439 = new Processor(this_$iv);
                boolean bl3 = false;
                this.dumpContext(constructor, ContextCollector.ContextKind.SELF);
                this.processSignatureAnnotations($this$visitConstructor_u24lambda_u2439, constructor);
                ContextCollectorVisitor this_$iv2 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv2.isActive && !this_$iv2.shouldCollectBodyContext) break block22;
                boolean bl4 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(constructor, FirResolvePhase.BODY_RESOLVE);
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withConstructor = false;
                BodyResolveContext this_$iv$iv2 = this_$iv3;
                boolean $i$f$withContainer = false;
                this_$iv$iv2.getContainers().add((Object)constructor);
                try {
                    void this_$iv$iv$iv;
                    boolean bl5 = false;
                    SessionHolder holder = this.getSessionHolder(constructor);
                    FirDeclaration firDeclaration = this.context.getContainerIfAny();
                    FirRegularClass containingClass = firDeclaration instanceof FirRegularClass ? (FirRegularClass)firDeclaration : null;
                    Object this_$iv4 = this.context;
                    boolean $i$f$forConstructorParameters = false;
                    BodyResolveContext this_$iv$iv3 = this_$iv4;
                    boolean $i$f$forConstructorParametersOrDelegatedConstructorCall2 = false;
                    BodyResolveContext bodyResolveContext = this_$iv$iv3;
                    FirTowerDataMode mode$iv$iv$iv = FirTowerDataMode.CONSTRUCTOR_HEADER;
                    boolean $i$f$withTowerDataMode = false;
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$withTowerDataModeCleanup2 = false;
                    FirTowerDataMode initialMode$iv$iv$iv$iv = this_$iv$iv$iv$iv.getTowerDataMode();
                    try {
                        Unit unit;
                        boolean bl6 = false;
                        this_$iv$iv$iv.setTowerDataMode(mode$iv$iv$iv);
                        boolean bl7 = false;
                        BodyResolveContext this_$iv$iv$iv2 = this_$iv$iv3;
                        boolean $i$f$withTowerDataCleanup = false;
                        FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv2.getTowerDataContext();
                        try {
                            boolean bl8 = false;
                            if (!constructor.isPrimary()) {
                                this_$iv$iv3.addInaccessibleImplicitReceiverValue(containingClass, holder);
                            }
                            this_$iv$iv3.addLocalScope(this_$iv$iv3.buildConstructorParametersScope(constructor, holder.getSession()));
                            boolean bl9 = false;
                            $this$visitConstructor_u24lambda_u2439.processList((Collection<? extends FirElement>)constructor.getValueParameters());
                            unit = Unit.INSTANCE;
                        }
                        finally {
                            this_$iv$iv$iv2.replaceTowerDataContext(initialContext$iv$iv$iv);
                        }
                        Unit bl9 = unit;
                    }
                    finally {
                        this_$iv$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv$iv);
                    }
                    this.context.forConstructorBody(constructor, holder.getSession(), () -> ContextCollectorVisitor.visitConstructor$lambda$39$lambda$38$lambda$37$lambda$33($this$visitConstructor_u24lambda_u2439, constructor, this));
                    this_$iv4 = this;
                    boolean $i$f$onActive = false;
                    if (((ContextCollectorVisitor)this_$iv4).isActive) {
                        void this_$iv$iv$iv3;
                        void this_$iv5;
                        boolean bl10 = false;
                        BodyResolveContext $i$f$forConstructorParametersOrDelegatedConstructorCall2 = this.context;
                        FirRegularClass owningClass$iv = null;
                        boolean $i$f$forDelegatedConstructorCall = false;
                        void this_$iv$iv4 = this_$iv5;
                        boolean $i$f$forConstructorParametersOrDelegatedConstructorCall3 = false;
                        void $i$f$withTowerDataModeCleanup2 = this_$iv$iv4;
                        FirTowerDataMode mode$iv$iv$iv2 = FirTowerDataMode.CONSTRUCTOR_HEADER;
                        boolean $i$f$withTowerDataMode2 = false;
                        void this_$iv$iv$iv$iv2 = this_$iv$iv$iv3;
                        boolean $i$f$withTowerDataModeCleanup3 = false;
                        FirTowerDataMode initialMode$iv$iv$iv$iv2 = this_$iv$iv$iv$iv2.getTowerDataMode();
                        try {
                            Unit unit;
                            boolean bl11 = false;
                            this_$iv$iv$iv3.setTowerDataMode(mode$iv$iv$iv2);
                            boolean bl12 = false;
                            void this_$iv$iv$iv4 = this_$iv$iv4;
                            boolean $i$f$withTowerDataCleanup = false;
                            FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv4.getTowerDataContext();
                            try {
                                boolean bl13 = false;
                                if (!constructor.isPrimary()) {
                                    this_$iv$iv4.addInaccessibleImplicitReceiverValue(owningClass$iv, holder);
                                }
                                this_$iv$iv4.addLocalScope(this_$iv$iv4.buildConstructorParametersScope(constructor, holder.getSession()));
                                boolean bl14 = false;
                                $this$visitConstructor_u24lambda_u2439.process(constructor.getDelegatedConstructor());
                                unit = Unit.INSTANCE;
                            }
                            finally {
                                this_$iv$iv$iv4.replaceTowerDataContext(initialContext$iv$iv$iv);
                            }
                            Unit unit2 = unit;
                        }
                        finally {
                            this_$iv$iv$iv$iv2.setTowerDataMode(initialMode$iv$iv$iv$iv2);
                        }
                    }
                    this_$iv4 = this;
                    $i$f$onActive = false;
                    if (((ContextCollectorVisitor)this_$iv4).isActive) {
                        boolean bl15 = false;
                        $this$visitConstructor_u24lambda_u2439.processChildren(constructor);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.getContainers().removeLast();
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        this.dumpContext(enumEntry, ContextCollector.ContextKind.SELF);
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$onActiveBody = false;
        if (this_$iv.isActive || this_$iv.shouldCollectBodyContext) {
            void this_$iv$iv;
            boolean bl2 = false;
            FirLazyDeclarationResolverKt.lazyResolveToPhase(enumEntry, FirResolvePhase.BODY_RESOLVE);
            BodyResolveContext this_$iv2 = this.context;
            boolean $i$f$withEnumEntry = false;
            BodyResolveContext bodyResolveContext = this_$iv2;
            FirTowerDataMode mode$iv$iv = FirTowerDataMode.ENUM_ENTRY;
            boolean $i$f$withTowerDataMode = false;
            void this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$withTowerDataModeCleanup = false;
            FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
            try {
                Unit unit;
                boolean bl3 = false;
                this_$iv$iv.setTowerDataMode(mode$iv$iv);
                boolean bl4 = false;
                BodyResolveContext this_$iv$iv2 = this_$iv2;
                boolean $i$f$withContainer = false;
                this_$iv$iv2.getContainers().add((Object)enumEntry);
                try {
                    boolean bl5 = false;
                    this.dumpContext(enumEntry, ContextCollector.ContextKind.BODY);
                    ContextCollectorVisitor this_$iv3 = this;
                    boolean $i$f$onActive = false;
                    if (this_$iv3.isActive) {
                        boolean bl6 = false;
                        super.visitEnumEntry(enumEntry);
                    }
                    unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.getContainers().removeLast();
                }
                Unit unit2 = unit;
            }
            finally {
                this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
        block16: {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(simpleFunction);
            try {
                void this_$iv2;
                boolean bl2 = false;
                Processor $this$visitSimpleFunction_u24lambda_u2448 = new Processor(this_$iv);
                boolean bl3 = false;
                this.dumpContext(simpleFunction, ContextCollector.ContextKind.SELF);
                this.processSignatureAnnotations($this$visitSimpleFunction_u24lambda_u2448, simpleFunction);
                ContextCollectorVisitor this_$iv3 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv3.isActive && !this_$iv3.shouldCollectBodyContext) break block16;
                boolean bl4 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(simpleFunction, FirResolvePhase.BODY_RESOLVE);
                SessionHolder holder = this.getSessionHolder(simpleFunction);
                BodyResolveContext bodyResolveContext = this.context;
                FirSession session$iv = holder.getSession();
                boolean $i$f$withSimpleFunction = false;
                if (!(this_$iv2.getContainerIfAny() instanceof FirClass)) {
                    this_$iv2.storeFunction(simpleFunction, session$iv);
                }
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$withTypeParametersOf = false;
                if (((FirMemberDeclaration)simpleFunction).getTypeParameters().isEmpty()) {
                    boolean bl5 = false;
                    void this_$iv$iv3 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add((Object)simpleFunction);
                    try {
                        boolean bl6 = false;
                        this.context.forFunctionBody(simpleFunction, holder, () -> ContextCollectorVisitor.visitSimpleFunction$lambda$48$lambda$47$lambda$46$lambda$44($this$visitSimpleFunction_u24lambda_u2448, simpleFunction, this));
                        ContextCollectorVisitor this_$iv4 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv4.isActive) {
                            boolean bl7 = false;
                            $this$visitSimpleFunction_u24lambda_u2448.processChildren(simpleFunction);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block16;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                }
                FirMemberTypeParameterScope scope$iv$iv = new FirMemberTypeParameterScope(simpleFunction);
                void this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv.getTowerDataContext();
                try {
                    Unit unit;
                    boolean bl8 = false;
                    this_$iv$iv2.addNonLocalTowerDataElement(ImplicitReceiverUtilsKt.asTowerDataElement(scope$iv$iv, false));
                    boolean bl9 = false;
                    void this_$iv$iv4 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv4.getContainers().add((Object)simpleFunction);
                    try {
                        boolean bl10 = false;
                        this.context.forFunctionBody(simpleFunction, holder, () -> ContextCollectorVisitor.visitSimpleFunction$lambda$48$lambda$47$lambda$46$lambda$44($this$visitSimpleFunction_u24lambda_u2448, simpleFunction, this));
                        ContextCollectorVisitor this_$iv5 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv5.isActive) {
                            boolean bl11 = false;
                            $this$visitSimpleFunction_u24lambda_u2448.processChildren(simpleFunction);
                        }
                        unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv4.getContainers().removeLast();
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv$iv.replaceTowerDataContext(initialContext$iv$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitProperty(@NotNull FirProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(property2);
        try {
            boolean bl2 = false;
            Processor $this$visitProperty_u24lambda_u2456 = new Processor(this_$iv);
            boolean bl3 = false;
            this.dumpContext(property2, ContextCollector.ContextKind.SELF);
            this.processSignatureAnnotations($this$visitProperty_u24lambda_u2456, property2);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl4 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(property2, FirResolvePhase.BODY_RESOLVE);
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withProperty = false;
                BodyResolveContext this_$iv$iv2 = this_$iv3;
                boolean $i$f$withTypeParametersOf = false;
                if (((FirMemberDeclaration)property2).getTypeParameters().isEmpty()) {
                    boolean bl5 = false;
                    BodyResolveContext this_$iv$iv3 = this_$iv3;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add((Object)property2);
                    try {
                        boolean bl6 = false;
                        this.dumpContext(property2, ContextCollector.ContextKind.BODY);
                        ContextCollectorVisitor this_$iv4 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv4.isActive) {
                            boolean bl7 = false;
                            this.forPropertyInitializerIfNonLocal(this.context, property2, (Function0<Unit>)((Function0)() -> ContextCollectorVisitor.visitProperty$lambda$56$lambda$55$lambda$54$lambda$52$lambda$51($this$visitProperty_u24lambda_u2456, property2, this)));
                        }
                        this_$iv4 = this;
                        $i$f$onActive = false;
                        if (this_$iv4.isActive) {
                            boolean bl8 = false;
                            $this$visitProperty_u24lambda_u2456.processChildren(property2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                }
                FirMemberTypeParameterScope scope$iv$iv = new FirMemberTypeParameterScope(property2);
                BodyResolveContext this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv.getTowerDataContext();
                try {
                    Unit unit;
                    boolean bl9 = false;
                    this_$iv$iv2.addNonLocalTowerDataElement(ImplicitReceiverUtilsKt.asTowerDataElement(scope$iv$iv, false));
                    boolean bl10 = false;
                    BodyResolveContext this_$iv$iv4 = this_$iv3;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv4.getContainers().add((Object)property2);
                    try {
                        boolean bl11 = false;
                        this.dumpContext(property2, ContextCollector.ContextKind.BODY);
                        ContextCollectorVisitor this_$iv5 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv5.isActive) {
                            boolean bl12 = false;
                            this.forPropertyInitializerIfNonLocal(this.context, property2, (Function0<Unit>)((Function0)() -> ContextCollectorVisitor.visitProperty$lambda$56$lambda$55$lambda$54$lambda$52$lambda$51($this$visitProperty_u24lambda_u2456, property2, this)));
                        }
                        this_$iv5 = this;
                        $i$f$onActive = false;
                        if (this_$iv5.isActive) {
                            boolean bl13 = false;
                            $this$visitProperty_u24lambda_u2456.processChildren(property2);
                        }
                        unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv4.getContainers().removeLast();
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv$iv.replaceTowerDataContext(initialContext$iv$iv$iv);
                }
            }
            if (property2.isLocal()) {
                this.context.storeVariable(property2, property2.getModuleData().getSession());
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forPropertyInitializerIfNonLocal(BodyResolveContext $this$forPropertyInitializerIfNonLocal, FirProperty property2, Function0<Unit> f2) {
        if (!property2.isLocal()) {
            BodyResolveContext this_$iv = $this$forPropertyInitializerIfNonLocal;
            boolean $i$f$forPropertyInitializer = false;
            BodyResolveContext this_$iv$iv = this_$iv;
            boolean $i$f$withTowerDataCleanup = false;
            FirTowerDataContext initialContext$iv$iv = this_$iv$iv.getTowerDataContext();
            try {
                boolean bl2 = false;
                FirLocalScope firLocalScope = this_$iv.getPrimaryConstructorPureParametersScope();
                if (firLocalScope != null) {
                    FirLocalScope it$iv = firLocalScope;
                    boolean bl3 = false;
                    this_$iv.addLocalScope(it$iv);
                }
                Object object = f2.invoke();
            }
            finally {
                this_$iv$iv.replaceTowerDataContext(initialContext$iv$iv);
            }
        } else {
            f2.invoke();
        }
    }

    private final FirExpression unwrap(FirExpression $this$unwrap) {
        FirExpression firExpression;
        FirExpression firExpression2 = $this$unwrap;
        if (firExpression2 instanceof FirCheckNotNullCall) {
            FirCall $this$argument$iv = (FirCall)((Object)$this$unwrap);
            boolean $i$f$getArgument = false;
            firExpression = this.unwrap((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
        } else if (firExpression2 instanceof FirSafeCallExpression) {
            FirStatement firStatement = ((FirSafeCallExpression)$this$unwrap).getSelector();
            FirExpression firExpression3 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
            firExpression = firExpression3 != null ? this.unwrap(firExpression3) : null;
        } else {
            firExpression = $this$unwrap;
        }
        return firExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitField(@NotNull FirField field) {
        block14: {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(field);
            try {
                void this_$iv$iv2;
                boolean bl2 = false;
                Processor $this$visitField_u24lambda_u2460 = new Processor(this_$iv);
                boolean bl3 = false;
                this.dumpContext(field, ContextCollector.ContextKind.SELF);
                this.processSignatureAnnotations($this$visitField_u24lambda_u2460, field);
                ContextCollectorVisitor this_$iv2 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv2.isActive && !this_$iv2.shouldCollectBodyContext) break block14;
                boolean bl4 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(field, FirResolvePhase.BODY_RESOLVE);
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withField = false;
                BodyResolveContext bodyResolveContext = this_$iv3;
                FirTowerDataMode mode$iv$iv = FirTowerDataMode.CONSTRUCTOR_HEADER;
                boolean $i$f$withTowerDataMode = false;
                void this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    Unit unit;
                    boolean bl5 = false;
                    this_$iv$iv2.setTowerDataMode(mode$iv$iv);
                    boolean bl6 = false;
                    BodyResolveContext this_$iv$iv3 = this_$iv3;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add((Object)field);
                    try {
                        Unit unit2;
                        boolean bl7 = false;
                        BodyResolveContext this_$iv$iv4 = this_$iv3;
                        boolean $i$f$withTowerDataCleanup = false;
                        FirTowerDataContext initialContext$iv$iv = this_$iv$iv4.getTowerDataContext();
                        try {
                            boolean bl8 = false;
                            FirLocalScope firLocalScope = this_$iv3.getPrimaryConstructorAllParametersScope();
                            if (firLocalScope != null) {
                                FirLocalScope it$iv = firLocalScope;
                                boolean bl9 = false;
                                this_$iv3.addLocalScope(it$iv);
                            }
                            boolean bl10 = false;
                            this.dumpContext(field, ContextCollector.ContextKind.BODY);
                            ContextCollectorVisitor this_$iv4 = this;
                            boolean $i$f$onActive = false;
                            if (this_$iv4.isActive) {
                                boolean bl11 = false;
                                $this$visitField_u24lambda_u2460.process(field.getInitializer());
                            }
                            unit2 = Unit.INSTANCE;
                        }
                        finally {
                            this_$iv$iv4.replaceTowerDataContext(initialContext$iv$iv);
                        }
                        unit = unit2;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                    Unit unit3 = unit;
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(propertyAccessor);
        try {
            boolean bl2 = false;
            Processor $this$visitPropertyAccessor_u24lambda_u2464 = new Processor(this_$iv);
            boolean bl3 = false;
            this.dumpContext(propertyAccessor, ContextCollector.ContextKind.SELF);
            this.processSignatureAnnotations($this$visitPropertyAccessor_u24lambda_u2464, propertyAccessor);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl4 = false;
                SessionHolder holder = this.getSessionHolder(propertyAccessor);
                BodyResolveContext.withPropertyAccessor$default(this.context, (FirProperty)propertyAccessor.getPropertySymbol().getFir(), propertyAccessor, holder, false, () -> ContextCollectorVisitor.visitPropertyAccessor$lambda$64$lambda$63$lambda$62(this, propertyAccessor, $this$visitPropertyAccessor_u24lambda_u2464), 8, null);
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitValueParameter(@NotNull FirValueParameter valueParameter2) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(valueParameter2);
            try {
                void this_$iv2;
                boolean bl2 = false;
                Processor $this$visitValueParameter_u24lambda_u2468 = new Processor(this_$iv);
                boolean bl3 = false;
                this.dumpContext(valueParameter2, ContextCollector.ContextKind.SELF);
                this.processSignatureAnnotations($this$visitValueParameter_u24lambda_u2468, valueParameter2);
                ContextCollectorVisitor this_$iv3 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv3.isActive && !this_$iv3.shouldCollectBodyContext) break block8;
                boolean bl4 = false;
                BodyResolveContext bodyResolveContext = this.context;
                FirSession session$iv = valueParameter2.getModuleData().getSession();
                boolean $i$f$withValueParameter = false;
                if (!(valueParameter2.getName().isSpecial() && Intrinsics.areEqual((Object)valueParameter2.getName(), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR) || FirValueParameterKindKt.isLegacyContextReceiver(valueParameter2))) {
                    this_$iv2.storeVariable(valueParameter2, session$iv);
                }
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$withContainer = false;
                this_$iv$iv2.getContainers().add((Object)valueParameter2);
                try {
                    boolean bl5 = false;
                    this.dumpContext(valueParameter2, ContextCollector.ContextKind.BODY);
                    ContextCollectorVisitor this_$iv4 = this;
                    boolean $i$f$onActive = false;
                    if (this_$iv4.isActive) {
                        boolean bl6 = false;
                        $this$visitValueParameter_u24lambda_u2468.processChildren(valueParameter2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.getContainers().removeLast();
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)anonymousInitializer, (String)"anonymousInitializer");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(anonymousInitializer);
            try {
                void this_$iv2;
                boolean bl2 = false;
                Processor $this$visitAnonymousInitializer_u24lambda_u2472 = new Processor(this_$iv);
                boolean bl3 = false;
                this.dumpContext(anonymousInitializer, ContextCollector.ContextKind.SELF);
                this.processSignatureAnnotations($this$visitAnonymousInitializer_u24lambda_u2472, anonymousInitializer);
                ContextCollectorVisitor this_$iv3 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv3.isActive && !this_$iv3.shouldCollectBodyContext) break block11;
                boolean bl4 = false;
                BodyResolveContext bodyResolveContext = this.context;
                FirSession session$iv = anonymousInitializer.getModuleData().getSession();
                boolean $i$f$withAnonymousInitializer = false;
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv = this_$iv$iv2.getTowerDataContext();
                try {
                    Unit unit;
                    boolean bl5 = false;
                    FirLocalScope firLocalScope = this_$iv2.getPrimaryConstructorPureParametersScope();
                    if (firLocalScope != null) {
                        FirLocalScope it$iv = firLocalScope;
                        boolean bl6 = false;
                        this_$iv2.addLocalScope(it$iv);
                    }
                    this_$iv2.addLocalScope(new FirLocalScope(session$iv));
                    this_$iv2.addAnonymousInitializer(anonymousInitializer);
                    void this_$iv$iv3 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add((Object)anonymousInitializer);
                    try {
                        boolean bl7 = false;
                        this.dumpContext(anonymousInitializer, ContextCollector.ContextKind.BODY);
                        ContextCollectorVisitor this_$iv4 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv4.isActive) {
                            boolean bl8 = false;
                            FirLazyDeclarationResolverKt.lazyResolveToPhase(anonymousInitializer, FirResolvePhase.BODY_RESOLVE);
                            $this$visitAnonymousInitializer_u24lambda_u2472.processChildren(anonymousInitializer);
                        }
                        unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv2.replaceTowerDataContext(initialContext$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction) {
        Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(anonymousFunction);
        try {
            boolean bl2 = false;
            Processor $this$visitAnonymousFunction_u24lambda_u2477 = new Processor(this_$iv);
            boolean bl3 = false;
            this.dumpContext(anonymousFunction, ContextCollector.ContextKind.SELF);
            this.processSignatureAnnotations($this$visitAnonymousFunction_u24lambda_u2477, anonymousFunction);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl4 = false;
                this.context.withAnonymousFunction(anonymousFunction, this.bodyHolder, ResolutionMode.ContextIndependent.INSTANCE, () -> ContextCollectorVisitor.visitAnonymousFunction$lambda$77$lambda$76$lambda$75(anonymousFunction, $this$visitAnonymousFunction_u24lambda_u2477, this));
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(anonymousObject);
        try {
            boolean bl2 = false;
            Processor $this$visitAnonymousObject_u24lambda_u2481 = new Processor(this_$iv);
            boolean bl3 = false;
            this.dumpContext(anonymousObject, ContextCollector.ContextKind.SELF);
            this.processSignatureAnnotations($this$visitAnonymousObject_u24lambda_u2481, anonymousObject);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                void this_$iv3;
                boolean bl4 = false;
                this.processAnonymousObjectHeader($this$visitAnonymousObject_u24lambda_u2481, anonymousObject);
                BodyResolveContext bodyResolveContext = this.context;
                SessionHolder holder$iv = this.bodyHolder;
                boolean $i$f$withAnonymousObject = false;
                this_$iv3.withScopesForClass(anonymousObject, holder$iv, (Function0)new Function0<Unit>((BodyResolveContext)this_$iv3, anonymousObject, this, anonymousObject, $this$visitAnonymousObject_u24lambda_u2481){
                    final /* synthetic */ BodyResolveContext this$0$inline_fun;
                    final /* synthetic */ FirAnonymousObject $anonymousObject;
                    final /* synthetic */ ContextCollectorVisitor this$0;
                    final /* synthetic */ FirAnonymousObject $anonymousObject$inlined;
                    final /* synthetic */ Processor $this_withProcessor$inlined;
                    {
                        this.this$0$inline_fun = $receiver;
                        this.$anonymousObject = $anonymousObject;
                        this.this$0 = contextCollectorVisitor;
                        this.$anonymousObject$inlined = firAnonymousObject;
                        this.$this_withProcessor$inlined = processor;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final Unit invoke() {
                        Unit unit;
                        void this_$iv;
                        BodyResolveContext bodyResolveContext = this.this$0$inline_fun;
                        FirDeclaration declaration$iv = this.$anonymousObject;
                        boolean $i$f$withContainer = false;
                        this_$iv.getContainers().add((Object)declaration$iv);
                        try {
                            boolean bl2 = false;
                            ContextCollectorVisitor.access$dumpContext(this.this$0, this.$anonymousObject$inlined, ContextCollector.ContextKind.BODY);
                            ContextCollectorVisitor this_$iv2 = this.this$0;
                            boolean $i$f$onActive = false;
                            if (ContextCollectorVisitor.access$isActive$p(this_$iv2)) {
                                boolean bl3 = false;
                                this.$this_withProcessor$inlined.processChildren(this.$anonymousObject$inlined);
                            }
                            unit = Unit.INSTANCE;
                        }
                        finally {
                            this_$iv.getContainers().removeLast();
                        }
                        return unit;
                    }
                });
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitBlock(@NotNull FirBlock block) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(block);
            try {
                void this_$iv2;
                boolean bl2 = false;
                Processor $this$visitBlock_u24lambda_u2484 = new Processor(this_$iv);
                boolean bl3 = false;
                this.dumpContext(block, ContextCollector.ContextKind.SELF);
                ContextCollectorVisitor this_$iv3 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv3.isActive && !this_$iv3.shouldCollectBodyContext) break block6;
                boolean bl4 = false;
                BodyResolveContext bodyResolveContext = this.context;
                FirSession session$iv = this.bodyHolder.getSession();
                boolean $i$f$forBlock = false;
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv = this_$iv$iv2.getTowerDataContext();
                try {
                    boolean bl5 = false;
                    this_$iv2.addLocalScope(new FirLocalScope(session$iv));
                    boolean bl6 = false;
                    $this$visitBlock_u24lambda_u2484.processChildren(block);
                    this.dumpContext(block, ContextCollector.ContextKind.BODY);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.replaceTowerDataContext(initialContext$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    @ContextCollectorDsl
    private final void processSignatureAnnotations(Processor $this$processSignatureAnnotations, FirDeclaration declaration2) {
        for (FirAnnotation annotation : declaration2.getAnnotations()) {
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$onActive = false;
            if (!this_$iv.isActive) continue;
            boolean bl2 = false;
            $this$processSignatureAnnotations.process(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withProcessor(FirElement parent2, Function1<? super Processor, Unit> block) {
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withParent = false;
        this_$iv.parents.add(parent2);
        try {
            boolean bl2 = false;
            block.invoke((Object)new Processor(this));
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CollectionsKt.removeLast((List)this_$iv.parents);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final void withInterceptor(Function0<Unit> block) {
        FirElement target;
        DesignationInterceptor designationInterceptor = this.designationPathInterceptor;
        FirElement firElement = target = designationInterceptor != null ? designationInterceptor.invoke() : null;
        if (target != null) {
            target.accept(this);
        } else {
            block.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withParent(FirElement parent2, Function0<Unit> block) {
        boolean $i$f$withParent = false;
        this.parents.add(parent2);
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CollectionsKt.removeLast((List)this.parents);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final void onActive(Function0<Unit> block) {
        boolean $i$f$onActive = false;
        if (this.isActive) {
            block.invoke();
        }
    }

    private final void onActiveBody(Function0<Unit> block) {
        boolean $i$f$onActiveBody = false;
        if (this.isActive || this.shouldCollectBodyContext) {
            block.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit collect$lambda$1(FirFile $file, ContextCollectorVisitor this$0) {
        void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
        ExceptionAttachmentBuilder exceptionAttachmentBuilder;
        String message$iv = "Designation path is empty";
        Throwable cause$iv = null;
        String attachmentName$iv = "info.txt";
        boolean $i$f$errorWithAttachment = false;
        boolean $i$f$buildErrorWithAttachment = false;
        KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
        KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
        boolean $i$f$buildAttachment = false;
        ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
        String string2 = attachmentName$iv;
        KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
        boolean bl2 = false;
        void $this$collect_u24lambda_u241_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
        boolean bl3 = false;
        FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$collect_u24lambda_u241_u24lambda_u240, "file", $file);
        FirDesignationKt.withFirDesignationEntry((ExceptionAttachmentBuilder)$this$collect_u24lambda_u241_u24lambda_u240, "designation", this$0.designationPathInterceptor.getDesignation());
        kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
        throw (Throwable)exception$iv$iv;
    }

    private static final Unit visitScript$lambda$12$lambda$11$lambda$10$lambda$9$lambda$8(Processor $this_withProcessor, FirScript $script) {
        $this_withProcessor.processChildren($script);
        return Unit.INSTANCE;
    }

    private static final Unit visitScript$lambda$12$lambda$11$lambda$10(ContextCollectorVisitor this$0, FirScript $script, Processor $this_withProcessor) {
        this$0.dumpContext($script, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            this$0.withInterceptor((Function0<Unit>)((Function0)() -> ContextCollectorVisitor.visitScript$lambda$12$lambda$11$lambda$10$lambda$9$lambda$8($this_withProcessor, $script)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitFile$lambda$16$lambda$15$lambda$14$lambda$13(Processor $this_withProcessor, FirFile $file) {
        $this_withProcessor.processChildren($file);
        return Unit.INSTANCE;
    }

    private static final Unit visitCodeFragment$lambda$17(ContextCollectorVisitor this$0, FirCodeFragment $codeFragment) {
        super.visitCodeFragment($codeFragment);
        return Unit.INSTANCE;
    }

    private static final Unit visitRegularClass$lambda$29$lambda$28$lambda$27$lambda$26$lambda$25$lambda$24(Processor $this_withProcessor, FirRegularClass $regularClass) {
        $this_withProcessor.processChildren($regularClass);
        return Unit.INSTANCE;
    }

    private static final Unit visitRegularClass$lambda$29$lambda$28$lambda$27$lambda$26(ContextCollectorVisitor this$0, FirRegularClass $regularClass, Processor $this_withProcessor) {
        this$0.dumpContext($regularClass, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            this$0.withInterceptor((Function0<Unit>)((Function0)() -> ContextCollectorVisitor.visitRegularClass$lambda$29$lambda$28$lambda$27$lambda$26$lambda$25$lambda$24($this_withProcessor, $regularClass)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitConstructor$lambda$39$lambda$38$lambda$37$lambda$33(Processor $this_withProcessor, FirConstructor $constructor, ContextCollectorVisitor this$0) {
        $this_withProcessor.processList((Collection<? extends FirElement>)$constructor.getValueParameters());
        this$0.dumpContext($constructor, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            $this_withProcessor.process($constructor.getBody());
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitSimpleFunction$lambda$48$lambda$47$lambda$46$lambda$44(Processor $this_withProcessor, FirSimpleFunction $simpleFunction, ContextCollectorVisitor this$0) {
        $this_withProcessor.processList((Collection<? extends FirElement>)$simpleFunction.getValueParameters());
        this$0.dumpContext($simpleFunction, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            $this_withProcessor.process($simpleFunction.getBody());
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitProperty$lambda$56$lambda$55$lambda$54$lambda$52$lambda$51(Processor $this_withProcessor, FirProperty $property, ContextCollectorVisitor this$0) {
        $this_withProcessor.process($property.getInitializer());
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            $this_withProcessor.process($property.getDelegate());
        }
        this_$iv = this$0;
        $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl3 = false;
            $this_withProcessor.process($property.getBackingField());
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitPropertyAccessor$lambda$64$lambda$63$lambda$62(ContextCollectorVisitor this$0, FirPropertyAccessor $propertyAccessor, Processor $this_withProcessor) {
        this$0.dumpContext($propertyAccessor, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            $this_withProcessor.processChildren($propertyAccessor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitAnonymousFunction$lambda$77$lambda$76$lambda$75(FirAnonymousFunction $anonymousFunction, Processor $this_withProcessor, ContextCollectorVisitor this$0) {
        for (FirValueParameter parameter2 : $anonymousFunction.getValueParameters()) {
            $this_withProcessor.process(parameter2);
            this$0.context.storeVariable(parameter2, this$0.bodyHolder.getSession());
        }
        this$0.dumpContext($anonymousFunction, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl2 = false;
            $this_withProcessor.process($anonymousFunction.getBody());
        }
        this_$iv = this$0;
        $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl3 = false;
            $this_withProcessor.processChildren($anonymousFunction);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$dumpContext(ContextCollectorVisitor $this, FirElement fir, ContextCollector.ContextKind kind) {
        $this.dumpContext(fir, kind);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$ContextKey;", "", "element", "Lcom/intellij/psi/PsiElement;", "kind", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getKind", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "low-level-api-fir"})
    private static final class ContextKey {
        @NotNull
        private final PsiElement element;
        @NotNull
        private final ContextCollector.ContextKind kind;

        public ContextKey(@NotNull PsiElement element2, @NotNull ContextCollector.ContextKind kind) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            this.element = element2;
            this.kind = kind;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @NotNull
        public final ContextCollector.ContextKind getKind() {
            return this.kind;
        }

        @NotNull
        public final PsiElement component1() {
            return this.element;
        }

        @NotNull
        public final ContextCollector.ContextKind component2() {
            return this.kind;
        }

        @NotNull
        public final ContextKey copy(@NotNull PsiElement element2, @NotNull ContextCollector.ContextKind kind) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            return new ContextKey(element2, kind);
        }

        public static /* synthetic */ ContextKey copy$default(ContextKey contextKey, PsiElement psiElement, ContextCollector.ContextKind contextKind, int n2, Object object) {
            if ((n2 & 1) != 0) {
                psiElement = contextKey.element;
            }
            if ((n2 & 2) != 0) {
                contextKind = contextKey.kind;
            }
            return contextKey.copy(psiElement, contextKind);
        }

        @NotNull
        public String toString() {
            return "ContextKey(element=" + this.element + ", kind=" + (Object)((Object)this.kind) + ')';
        }

        public int hashCode() {
            int result2 = this.element.hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextKey)) {
                return false;
            }
            ContextKey contextKey = (ContextKey)other;
            if (!Intrinsics.areEqual((Object)this.element, (Object)contextKey.element)) {
                return false;
            }
            return this.kind == contextKey.kind;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$FilteringVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "delegate", "elementsToSkip", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "<init>", "(Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;Ljava/util/Set;)V", "getDelegate", "()Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "getElementsToSkip", "()Ljava/util/Set;", "visitElement", "", "element", "low-level-api-fir"})
    private static final class FilteringVisitor
    extends FirVisitorVoid {
        @NotNull
        private final FirVisitorVoid delegate;
        @NotNull
        private final Set<FirElement> elementsToSkip;

        public FilteringVisitor(@NotNull FirVisitorVoid delegate, @NotNull Set<? extends FirElement> elementsToSkip) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter(elementsToSkip, (String)"elementsToSkip");
            this.delegate = delegate;
            this.elementsToSkip = elementsToSkip;
        }

        @NotNull
        public final FirVisitorVoid getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final Set<FirElement> getElementsToSkip() {
            return this.elementsToSkip;
        }

        @Override
        public void visitElement(@NotNull FirElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            if (!this.elementsToSkip.contains(element2)) {
                element2.accept(this.delegate);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0007J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$Processor;", "", "delegate", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "<init>", "(Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;)V", "elementsToSkip", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lkotlin/collections/HashSet;", "process", "", "element", "processList", "elements", "", "processChildren", "low-level-api-fir"})
    private static final class Processor {
        @NotNull
        private final FirVisitorVoid delegate;
        @NotNull
        private final HashSet<FirElement> elementsToSkip;

        public Processor(@NotNull FirVisitorVoid delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.elementsToSkip = new HashSet();
        }

        @ContextCollectorDsl
        public final void process(@Nullable FirElement element2) {
            if (element2 != null) {
                element2.accept(this.delegate);
                ((Collection)this.elementsToSkip).add(element2);
            }
        }

        @ContextCollectorDsl
        public final void processList(@NotNull Collection<? extends FirElement> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            for (FirElement firElement : elements) {
                this.process(firElement);
                ((Collection)this.elementsToSkip).add(firElement);
            }
        }

        @ContextCollectorDsl
        public final void processChildren(@NotNull FirElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            FilteringVisitor visitor2 = new FilteringVisitor(this.delegate, (Set<? extends FirElement>)this.elementsToSkip);
            element2.acceptChildren(visitor2);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContextCollector.ContextKind.values().length];
            try {
                nArray[ContextCollector.ContextKind.SELF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContextCollector.ContextKind.BODY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

