/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.PageCacheUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectByteBufferAllocator {
    private static final ExecutorService singleThreadAllocator = SystemInfoRt.isLinux && SystemProperties.getBooleanProperty("idea.limit.paged.storage.allocators", true) ? ConcurrencyUtil.newSingleThreadExecutor("DirectBufferWrapper allocation thread") : null;
    private static final boolean USE_POOLED_ALLOCATOR = SystemProperties.getBooleanProperty("idea.index.use.pooled.page.allocator", true);
    private static final int POOL_CAPACITY_PER_BUFFER_SIZE = 40;
    private final ConcurrentSkipListMap<Integer, ArrayBlockingQueue<ByteBuffer>> buffersPool = new ConcurrentSkipListMap();
    private final AtomicLong totalSizeOfBuffersInCache = new AtomicLong();
    private final int maxBuffersToCacheInBytes;
    private final AtomicLong totalSizeOfBuffersAllocated = new AtomicLong();
    private final AtomicInteger hits = new AtomicInteger();
    private final AtomicInteger misses = new AtomicInteger();
    private final AtomicInteger reclaimed = new AtomicInteger();
    private final AtomicInteger disposed = new AtomicInteger();
    public static final DirectByteBufferAllocator ALLOCATOR = new DirectByteBufferAllocator(USE_POOLED_ALLOCATOR ? PageCacheUtils.MAX_DIRECT_BUFFERS_POOL_BYTES : 0);

    private static <E extends Exception> ByteBuffer allocate(ThrowableComputable<? extends ByteBuffer, E> computable) throws E {
        if (singleThreadAllocator != null) {
            try {
                return singleThreadAllocator.submit(computable::compute).get();
            }
            catch (InterruptedException e2) {
                Logger.getInstance(DirectByteBufferAllocator.class).error("ByteBuffer allocation in dedicated thread was interrupted", e2);
                return computable.compute();
            }
            catch (ExecutionException e3) {
                Throwable cause = e3.getCause();
                if (cause instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)cause;
                }
                ExceptionUtil.rethrow(e3);
                throw new RuntimeException(e3);
            }
        }
        return computable.compute();
    }

    private DirectByteBufferAllocator(int maxBuffersToCacheInBytes) {
        if (maxBuffersToCacheInBytes < 0) {
            throw new IllegalArgumentException("sizeLimitInBytes(=" + maxBuffersToCacheInBytes + ") must be >=0");
        }
        this.maxBuffersToCacheInBytes = maxBuffersToCacheInBytes;
    }

    @NotNull
    public ByteBuffer allocate(int size) {
        if (this.useBuffersCache()) {
            int capacity;
            Map.Entry<Integer, ArrayBlockingQueue<ByteBuffer>> buffersOfCapacity = this.buffersPool.ceilingEntry(size);
            while (buffersOfCapacity != null && (capacity = buffersOfCapacity.getKey().intValue()) <= size * 2) {
                ByteBuffer cachedBuffer = buffersOfCapacity.getValue().poll();
                if (cachedBuffer != null) {
                    cachedBuffer.clear().limit(size);
                    this.totalSizeOfBuffersInCache.addAndGet(-capacity);
                    this.hits.incrementAndGet();
                    ByteBuffer byteBuffer = cachedBuffer;
                    if (byteBuffer == null) {
                        DirectByteBufferAllocator.$$$reportNull$$$0(0);
                    }
                    return byteBuffer;
                }
                buffersOfCapacity = this.buffersPool.higherEntry(capacity);
            }
        }
        this.misses.incrementAndGet();
        this.totalSizeOfBuffersAllocated.addAndGet(size);
        ByteBuffer byteBuffer = DirectByteBufferAllocator.allocateNewBuffer(size);
        if (byteBuffer == null) {
            DirectByteBufferAllocator.$$$reportNull$$$0(1);
        }
        return byteBuffer;
    }

    private boolean useBuffersCache() {
        return this.maxBuffersToCacheInBytes > 0;
    }

    public void release(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            DirectByteBufferAllocator.$$$reportNull$$$0(2);
        }
        int capacity = buffer.capacity();
        if (this.useBuffersCache() && this.totalSizeOfBuffersInCache.get() < (long)this.maxBuffersToCacheInBytes && this.buffersPool.computeIfAbsent(capacity, __ -> new ArrayBlockingQueue(40)).offer(buffer)) {
            this.totalSizeOfBuffersInCache.addAndGet(capacity);
            this.reclaimed.incrementAndGet();
            return;
        }
        this.totalSizeOfBuffersAllocated.addAndGet(-capacity);
        ByteBufferUtil.cleanBuffer(buffer);
        this.disposed.incrementAndGet();
    }

    private static ByteBuffer allocateNewBuffer(int size) {
        return DirectByteBufferAllocator.allocate(() -> ByteBuffer.allocateDirect(size));
    }

    public Statistics getStatistics() {
        return new Statistics(this.hits.get(), this.misses.get(), this.reclaimed.get(), this.disposed.get(), this.totalSizeOfBuffersInCache.get(), this.totalSizeOfBuffersAllocated.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/DirectByteBufferAllocator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "allocate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/DirectByteBufferAllocator";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Statistics {
        public final int hits;
        public final int misses;
        public final int reclaimed;
        public final int disposed;
        public final long totalSizeOfBuffersCachedInBytes;
        public final long totalSizeOfBuffersAllocatedInBytes;

        private Statistics(int hits, int misses, int reclaimed, int disposed, long totalSizeOfBuffersCachedInBytes, long totalSizeOfBuffersAllocatedInBytes) {
            this.hits = hits;
            this.misses = misses;
            this.reclaimed = reclaimed;
            this.disposed = disposed;
            this.totalSizeOfBuffersCachedInBytes = totalSizeOfBuffersCachedInBytes;
            this.totalSizeOfBuffersAllocatedInBytes = totalSizeOfBuffersAllocatedInBytes;
        }
    }
}

