/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i = className.lastIndexOf(46);
            return i == -1 ? "" : className.substring(0, i);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public static String extractClassName(@NotNull String fqName) {
        int i;
        if (fqName == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        String string2 = (i = fqName.lastIndexOf(46)) == -1 ? fqName : fqName.substring(i + 1);
        if (string2 == null) {
            ClassUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public static String createNewClassQualifiedName(String qualifiedName2, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName2 == null || qualifiedName2.isEmpty()) {
            return className;
        }
        return qualifiedName2 + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass, @NotNull StringBuilder buf) {
        String qName;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(2);
        }
        if (buf == null) {
            ClassUtil.$$$reportNull$$$0(3);
        }
        if ((qName = aClass.getQualifiedName()) != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = PsiTreeUtil.getContextOfType((PsiElement)aClass, PsiClass.class, true);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass, parentClass));
                String name2 = aClass.getName();
                if (name2 != null) {
                    buf.append(name2);
                }
            }
        }
    }

    private static int getNonQualifiedClassIdx(@NotNull PsiClass psiClass, @NotNull PsiClass containingClass) {
        if (psiClass == null) {
            ClassUtil.$$$reportNull$$$0(4);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(5);
        }
        ObjectIntMap indices = (ObjectIntMap)CachedValuesManager.getCachedValue(containingClass, () -> {
            ObjectIntHashMap<PsiClass> map = new ObjectIntHashMap<PsiClass>();
            int index2 = 0;
            for (PsiClass aClass : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(containingClass)).postOrderDfsTraversal().filter(PsiClass.class)) {
                if (aClass.getQualifiedName() != null) continue;
                map.put(aClass, ++index2);
            }
            return CachedValueProvider.Result.create(map, containingClass);
        });
        return indices.get(psiClass);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        String prefix;
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(6);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(7);
        }
        final int idx = !(prefix = ClassUtil.getDigitPrefix(indexName)).isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name2 = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result2 = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx;

            @Override
            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result2[0] == null) {
                    super.visitElement(element2);
                }
            }

            @Override
            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual(name2, aClass.getName())) {
                            result2[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (Comparing.strEqual(name2, aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result2[0] = aClass;
                    }
                }
            }

            @Override
            public void visitTypeParameter(@NotNull PsiTypeParameter classParameter) {
                if (classParameter == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classParameter";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/ClassUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeParameter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result2[0];
    }

    @NotNull
    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i;
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(8);
        }
        for (i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
        }
        String string2 = i == 0 ? "" : indexName.substring(0, i);
        if (string2 == null) {
            ClassUtil.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name2) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(10);
        }
        if (name2 == null) {
            ClassUtil.$$$reportNull$$$0(11);
        }
        return ClassUtil.findPsiClass(manager, name2, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name2, @Nullable PsiClass parent2, boolean jvmCompatible) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(12);
        }
        if (name2 == null) {
            ClassUtil.$$$reportNull$$$0(13);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope(manager.getProject());
        return ClassUtil.findPsiClass(manager, name2, parent2, jvmCompatible, scope);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name2, @Nullable PsiClass parent2, boolean jvmCompatible, @NotNull GlobalSearchScope scope) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(14);
        }
        if (name2 == null) {
            ClassUtil.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            ClassUtil.$$$reportNull$$$0(16);
        }
        if (parent2 != null) {
            return ClassUtil.findSubClass(name2, parent2, jvmCompatible);
        }
        PsiClass result2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(name2, scope);
        if (result2 != null) {
            return result2;
        }
        int p = 0;
        while ((p = name2.indexOf(36, p + 1)) > 0 && p < name2.length() - 1) {
            String suffix;
            String prefix = name2.substring(0, p);
            parent2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(prefix, scope);
            if (parent2 == null || (result2 = ClassUtil.findSubClass(suffix = name2.substring(p + 1), parent2, jvmCompatible)) == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private static PsiClass findSubClass(@NotNull String name2, @NotNull PsiClass parent2, boolean jvmCompatible) {
        PsiClass result2;
        if (name2 == null) {
            ClassUtil.$$$reportNull$$$0(17);
        }
        if (parent2 == null) {
            ClassUtil.$$$reportNull$$$0(18);
        }
        PsiClass psiClass = result2 = ClassUtil.isIndexed(name2) ? ClassUtil.findNonQualifiedClassByIndex(name2, parent2, jvmCompatible) : parent2.findInnerClassByName(name2, false);
        if (result2 != null) {
            return result2;
        }
        int p = 0;
        while ((p = name2.indexOf(36, p + 1)) > 0 && p < name2.length() - 1) {
            String suffix;
            String prefix = name2.substring(0, p);
            PsiClass subClass = ClassUtil.isIndexed(prefix) ? ClassUtil.findNonQualifiedClassByIndex(prefix, parent2, jvmCompatible) : parent2.findInnerClassByName(prefix, false);
            if (subClass == null || (result2 = ClassUtil.findSubClass(suffix = name2.substring(p + 1), subClass, jvmCompatible)) == null) continue;
            return result2;
        }
        return null;
    }

    private static boolean isIndexed(String name2) {
        return Character.isDigit(name2.charAt(0));
    }

    @Nullable
    @NlsSafe
    public static String getJVMClassName(@NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(19);
        }
        if ((containingClass = aClass.getContainingClass()) != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(@NotNull PsiManager manager, @NotNull String jvmClassName) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(20);
        }
        if (jvmClassName == null) {
            ClassUtil.$$$reportNull$$$0(21);
        }
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }

    public static boolean isTopLevelClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(22);
        }
        if (aClass.getContainingClass() != null) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiElement parent2 = aClass.getParent();
        if (parent2 instanceof PsiDeclarationStatement && parent2.getParent() instanceof PsiCodeBlock) {
            return false;
        }
        PsiFile parentFile = aClass.getContainingFile();
        return parentFile != null && parentFile.getLanguage() == JavaLanguage.INSTANCE;
    }

    public static String getAsmMethodSignature(PsiMethod method) {
        StringBuilder signature = new StringBuilder();
        signature.append("(");
        for (PsiParameter param : method.getParameterList().getParameters()) {
            signature.append(ClassUtil.getBinaryPresentation(param.getType()));
        }
        signature.append(")");
        signature.append(ClassUtil.getBinaryPresentation(Optional.ofNullable(method.getReturnType()).orElse(PsiTypes.voidType())));
        return signature.toString();
    }

    public static String getVMParametersMethodSignature(PsiMethod method) {
        return StringUtil.join(method.getParameterList().getParameters(), param -> {
            PsiType type2 = TypeConversionUtil.erasure(param.getType());
            return type2 != null ? type2.accept(ClassUtil.createSignatureVisitor()) : "";
        }, ",");
    }

    private static PsiTypeVisitor<String> createSignatureVisitor() {
        return new PsiTypeVisitor<String>(){

            @Override
            public String visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                if (primitiveType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return primitiveType.getCanonicalText();
            }

            @Override
            public String visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass;
                if (classType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((aClass = classType.resolve()) == null) {
                    return "";
                }
                return ClassUtil.getJVMClassName(aClass);
            }

            @Override
            public String visitArrayType(@NotNull PsiArrayType arrayType2) {
                if (arrayType2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                PsiType componentType = arrayType2.getComponentType();
                String typePresentation = componentType.accept(this);
                if (arrayType2.getDeepComponentType() instanceof PsiPrimitiveType) {
                    return typePresentation + "[]";
                }
                if (componentType instanceof PsiClassType) {
                    typePresentation = "L" + typePresentation + ";";
                }
                return "[" + typePresentation;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "primitiveType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/ClassUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPrimitiveType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static String getClassObjectPresentation(@NotNull PsiType psiType) {
        if (psiType == null) {
            ClassUtil.$$$reportNull$$$0(23);
        }
        return ClassUtil.toBinary(psiType, false);
    }

    @NotNull
    public static String getBinaryPresentation(@NotNull PsiType psiType) {
        if (psiType == null) {
            ClassUtil.$$$reportNull$$$0(24);
        }
        return ClassUtil.toBinary(psiType, true);
    }

    @NotNull
    private static String toBinary(@NotNull PsiType psiType, boolean slashes) {
        if (psiType == null) {
            ClassUtil.$$$reportNull$$$0(25);
        }
        String string2 = Optional.of(psiType).map(type2 -> TypeConversionUtil.erasure(type2)).map(type2 -> type2.accept(ClassUtil.createBinarySignatureVisitor(slashes))).orElseGet(() -> psiType.getPresentableText());
        if (string2 == null) {
            ClassUtil.$$$reportNull$$$0(26);
        }
        return string2;
    }

    private static PsiTypeVisitor<String> createBinarySignatureVisitor(final boolean slashes) {
        return new PsiTypeVisitor<String>(){

            @Override
            public String visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                if (primitiveType == null) {
                    3.$$$reportNull$$$0(0);
                }
                return primitiveType.getKind().getBinaryName();
            }

            @Override
            public String visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass;
                if (classType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((aClass = classType.resolve()) == null) {
                    return "";
                }
                String jvmClassName = ClassUtil.getJVMClassName(aClass);
                if (jvmClassName != null) {
                    jvmClassName = "L" + (slashes ? jvmClassName.replace(".", "/") : jvmClassName) + ";";
                }
                return jvmClassName;
            }

            @Override
            public String visitArrayType(@NotNull PsiArrayType arrayType2) {
                if (arrayType2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                return "[" + arrayType2.getComponentType().accept(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "primitiveType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/ClassUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPrimitiveType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/ClassUtil";
                break;
            }
            case 2: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/ClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClassName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDigitPrefix";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "toBinary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractClassName";
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatClassName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNonQualifiedClassIdx";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findNonQualifiedClassByIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDigitPrefix";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSubClass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getJVMClassName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClassByJVMName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelClass";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getClassObjectPresentation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryPresentation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toBinary";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

