/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowAnalyzer;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class ControlFlowFactory
implements Disposable {
    private final Map<PsiElement, ConcurrentList<ControlFlowContext>> cachedFlows;

    public static ControlFlowFactory getInstance(Project project) {
        return project.getService(ControlFlowFactory.class);
    }

    public ControlFlowFactory(@NotNull Project project) {
        if (project == null) {
            ControlFlowFactory.$$$reportNull$$$0(0);
        }
        this.cachedFlows = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        project.getMessageBus().connect(this).subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    ControlFlowFactory.this.clearCache();
                }
            }
        });
    }

    private void clearCache() {
        this.cachedFlows.clear();
    }

    void registerSubRange(PsiElement codeFragment, ControlFlowSubRange flow, ControlFlowOptions options, ControlFlowPolicy policy) {
        this.registerControlFlow(codeFragment, flow, options, policy);
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element2, @NotNull ControlFlowPolicy policy) throws AnalysisCanceledException {
        if (element2 == null) {
            ControlFlowFactory.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(2);
        }
        return this.doGetControlFlow(element2, policy, ControlFlowOptions.create(true, true, true));
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element2, @NotNull ControlFlowPolicy policy, boolean evaluateConstantIfCondition) throws AnalysisCanceledException {
        if (element2 == null) {
            ControlFlowFactory.$$$reportNull$$$0(3);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(4);
        }
        return this.doGetControlFlow(element2, policy, ControlFlowOptions.create(true, evaluateConstantIfCondition, true));
    }

    @NotNull
    public static ControlFlow getControlFlow(@NotNull PsiElement element2, @NotNull ControlFlowPolicy policy, @NotNull ControlFlowOptions options) throws AnalysisCanceledException {
        if (element2 == null) {
            ControlFlowFactory.$$$reportNull$$$0(5);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(6);
        }
        if (options == null) {
            ControlFlowFactory.$$$reportNull$$$0(7);
        }
        return ControlFlowFactory.getInstance(element2.getProject()).doGetControlFlow(element2, policy, options);
    }

    @NotNull
    private ControlFlow doGetControlFlow(@NotNull PsiElement element2, @NotNull ControlFlowPolicy policy, @NotNull ControlFlowOptions options) throws AnalysisCanceledException {
        ControlFlowContext context22;
        if (element2 == null) {
            ControlFlowFactory.$$$reportNull$$$0(8);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(9);
        }
        if (options == null) {
            ControlFlowFactory.$$$reportNull$$$0(10);
        }
        if (!element2.isPhysical()) {
            ControlFlow controlFlow = new ControlFlowAnalyzer(element2, policy, options).buildControlFlow();
            if (controlFlow == null) {
                ControlFlowFactory.$$$reportNull$$$0(11);
            }
            return controlFlow;
        }
        long modificationCount = element2.getManager().getModificationTracker().getModificationCount();
        ConcurrentList<ControlFlowContext> cached = this.getOrCreateCachedFlowsForElement(element2);
        for (ControlFlowContext context22 : cached) {
            if (!context22.isFor(policy, options, modificationCount)) continue;
            ControlFlow controlFlow = context22.controlFlow;
            if (controlFlow == null) {
                ControlFlowFactory.$$$reportNull$$$0(12);
            }
            return controlFlow;
        }
        ControlFlow controlFlow = new ControlFlowAnalyzer(element2, policy, options).buildControlFlow();
        context22 = ControlFlowFactory.createContext(options, policy, controlFlow, modificationCount);
        cached.addIfAbsent(context22);
        ControlFlow controlFlow2 = controlFlow;
        if (controlFlow2 == null) {
            ControlFlowFactory.$$$reportNull$$$0(13);
        }
        return controlFlow2;
    }

    @NotNull
    private static ControlFlowContext createContext(@NotNull ControlFlowOptions options, @NotNull ControlFlowPolicy policy, @NotNull ControlFlow controlFlow, long modificationCount) {
        if (options == null) {
            ControlFlowFactory.$$$reportNull$$$0(14);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(15);
        }
        if (controlFlow == null) {
            ControlFlowFactory.$$$reportNull$$$0(16);
        }
        return new ControlFlowContext(options, policy, modificationCount, controlFlow);
    }

    private void registerControlFlow(@NotNull PsiElement element2, @NotNull ControlFlow flow, @NotNull ControlFlowOptions options, @NotNull ControlFlowPolicy policy) {
        if (element2 == null) {
            ControlFlowFactory.$$$reportNull$$$0(17);
        }
        if (flow == null) {
            ControlFlowFactory.$$$reportNull$$$0(18);
        }
        if (options == null) {
            ControlFlowFactory.$$$reportNull$$$0(19);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(20);
        }
        long modificationCount = element2.getManager().getModificationTracker().getModificationCount();
        ControlFlowContext controlFlowContext = ControlFlowFactory.createContext(options, policy, flow, modificationCount);
        ConcurrentList<ControlFlowContext> cached = this.getOrCreateCachedFlowsForElement(element2);
        cached.addIfAbsent(controlFlowContext);
    }

    @NotNull
    private ConcurrentList<ControlFlowContext> getOrCreateCachedFlowsForElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            ControlFlowFactory.$$$reportNull$$$0(21);
        }
        ConcurrentList concurrentList = this.cachedFlows.computeIfAbsent(element2, __ -> ContainerUtil.createConcurrentList());
        if (concurrentList == null) {
            ControlFlowFactory.$$$reportNull$$$0(22);
        }
        return concurrentList;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowFactory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowFactory";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetControlFlow";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCachedFlowsForElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlow";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetControlFlow";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerControlFlow";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCachedFlowsForElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ControlFlowContext {
        private final ControlFlowPolicy policy;
        @NotNull
        private final ControlFlowOptions options;
        private final long modificationCount;
        @NotNull
        private final ControlFlow controlFlow;

        /*
         * WARNING - void declaration
         */
        private ControlFlowContext(@NotNull ControlFlowOptions options, @NotNull ControlFlowPolicy policy, long modificationCount, @NotNull ControlFlow controlFlow) {
            void controlFlow2;
            if (options == null) {
                ControlFlowContext.$$$reportNull$$$0(0);
            }
            if (policy == null) {
                ControlFlowContext.$$$reportNull$$$0(1);
            }
            if (controlFlow == null) {
                ControlFlowContext.$$$reportNull$$$0(2);
            }
            this.options = options;
            this.policy = policy;
            this.modificationCount = modificationCount;
            this.controlFlow = controlFlow2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ControlFlowContext that = (ControlFlowContext)o;
            return this.isFor(that);
        }

        public int hashCode() {
            int result2 = this.policy.hashCode();
            result2 = 31 * result2 + this.options.hashCode();
            result2 = 31 * result2 + (int)(this.modificationCount ^ this.modificationCount >>> 32);
            return result2;
        }

        private boolean isFor(@NotNull ControlFlowPolicy policy, @NotNull ControlFlowOptions options, long modificationCount) {
            if (policy == null) {
                ControlFlowContext.$$$reportNull$$$0(3);
            }
            if (options == null) {
                ControlFlowContext.$$$reportNull$$$0(4);
            }
            if (modificationCount != this.modificationCount) {
                return false;
            }
            if (!policy.equals(this.policy)) {
                return false;
            }
            if (!options.equals(this.options)) {
                return !this.controlFlow.isConstantConditionOccurred() && this.options.dontEvaluateConstantIfCondition().equals(options);
            }
            return true;
        }

        private boolean isFor(@NotNull ControlFlowContext that) {
            if (that == null) {
                ControlFlowContext.$$$reportNull$$$0(5);
            }
            return this.isFor(that.policy, that.options, that.modificationCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controlFlow";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowFactory$ControlFlowContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

