/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0012\u001a\u00020\u000e*\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder;", "", "<init>", "()V", "findMultifileClassParts", "", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "partNames", "", "isKotlinInternalCompiledFile", "", "fileContent", "", "isMultifileClassPartFile", "isValidAndExists", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nClsClassFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClsClassFinder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1611#2,9:85\n1863#2:94\n1864#2:96\n1620#2:97\n1#3:95\n*S KotlinDebug\n*F\n+ 1 ClsClassFinder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder\n*L\n23#1:85,9\n23#1:94\n23#1:96\n23#1:97\n23#1:95\n*E\n"})
public final class ClsClassFinder {
    @NotNull
    public static final ClsClassFinder INSTANCE = new ClsClassFinder();

    private ClsClassFinder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinJvmBinaryClass> findMultifileClassParts(@NotNull VirtualFile file2, @NotNull ClassId classId, @NotNull List<String> partNames) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter(partNames, (String)"partNames");
        FqName packageFqName = classId.getPackageFqName();
        VirtualFile virtualFile = file2.getParent();
        Intrinsics.checkNotNull((Object)virtualFile);
        DirectoryBasedClassFinder partsFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        Iterable $this$mapNotNull$iv = partNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinJvmBinaryClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            KotlinClassFinder kotlinClassFinder = partsFinder;
            Name name2 = Name.identifier(StringsKt.substringAfterLast$default((String)it, (char)'/', null, (int)2, null));
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            if (KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, new ClassId(packageFqName, name2), JvmMetadataVersion.INSTANCE) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isKotlinInternalCompiledFile(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.isValidAndExists(file2, fileContent)) {
            return false;
        }
        ClsKotlinBinaryClassCache clsKotlinBinaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
        if (!clsKotlinBinaryClassCache.isKotlinJvmCompiledFile(file2, fileContent)) {
            return false;
        }
        try {
            bl = fileContent == null ? ClassFileViewProvider.isInnerClass(file2) : ClassFileViewProvider.isInnerClass(file2, fileContent);
        }
        catch (Exception exception) {
            Logger.getInstance("org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder.isKotlinInternalCompiledFile").debug(file2.getPath(), exception);
            return false;
        }
        boolean innerClass = bl;
        if (innerClass) {
            return true;
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = clsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(file2, fileContent);
        if (kotlinBinaryClassHeaderData == null) {
            return false;
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData header = kotlinBinaryClassHeaderData;
        if (header.getClassId().isLocal()) {
            return true;
        }
        return header.getKind() == KotlinClassHeader.Kind.SYNTHETIC_CLASS || header.getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    public static /* synthetic */ boolean isKotlinInternalCompiledFile$default(ClsClassFinder clsClassFinder, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return clsClassFinder.isKotlinInternalCompiledFile(virtualFile, byArray);
    }

    public final boolean isMultifileClassPartFile(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData headerData;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.isValidAndExists(file2, fileContent)) {
            return false;
        }
        ClsKotlinBinaryClassCache clsKotlinBinaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = headerData = clsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(file2, fileContent);
        return (kotlinBinaryClassHeaderData != null ? kotlinBinaryClassHeaderData.getKind() : null) == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    public static /* synthetic */ boolean isMultifileClassPartFile$default(ClsClassFinder clsClassFinder, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return clsClassFinder.isMultifileClassPartFile(virtualFile, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidAndExists(VirtualFile $this$isValidAndExists, byte[] fileContent) {
        boolean bl;
        if (!$this$isValidAndExists.isValid()) return false;
        if (fileContent != null) {
            if (fileContent.length == 0) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        if (!$this$isValidAndExists.exists()) return false;
        return true;
    }

    static /* synthetic */ boolean isValidAndExists$default(ClsClassFinder clsClassFinder, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = null;
        }
        return clsClassFinder.isValidAndExists(virtualFile, byArray);
    }
}

