/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.DelicateScopeAPI;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ.\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u001c\u0010\u001c\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001a0\u001dH\u0016J$\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001a0 H\u0016J(\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0016\u0010\u001c\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"\u0012\u0004\u0012\u00020\u001a0 H\u0016J\u0018\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "excludedNames", "", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Ljava/util/Set;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "classifierCache", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "functionCache", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "propertyCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "processClassifiersByNameWithSubstitution", "", "name", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "scopeOwnerLookupNames", "", "getScopeOwnerLookupNames", "()Ljava/util/List;", "withReplacedSessionOrNull", "newSession", "newScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirPackageMemberScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPackageMemberScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,84:1\n381#2,7:85\n381#2,7:92\n381#2,7:99\n*S KotlinDebug\n*F\n+ 1 FirPackageMemberScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope\n*L\n43#1:85,7\n56#1:92,7\n67#1:99,7\n*E\n"})
public final class FirPackageMemberScope
extends FirScope {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final Set<Name> excludedNames;
    @NotNull
    private final Map<Name, FirClassifierSymbol<?>> classifierCache;
    @NotNull
    private final Map<Name, List<FirNamedFunctionSymbol>> functionCache;
    @NotNull
    private final Map<Name, List<FirPropertySymbol>> propertyCache;
    @NotNull
    private final List<String> scopeOwnerLookupNames;

    public FirPackageMemberScope(@NotNull FqName fqName, @NotNull FirSession session, @NotNull FirSymbolProvider symbolProvider, @NotNull Set<Name> excludedNames) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)symbolProvider, (String)"symbolProvider");
        Intrinsics.checkNotNullParameter(excludedNames, (String)"excludedNames");
        this.fqName = fqName;
        this.session = session;
        this.symbolProvider = symbolProvider;
        this.excludedNames = excludedNames;
        this.classifierCache = new LinkedHashMap();
        this.functionCache = new LinkedHashMap();
        this.propertyCache = new LinkedHashMap();
        this.scopeOwnerLookupNames = new SmartList<String>(this.fqName.asString());
    }

    public /* synthetic */ FirPackageMemberScope(FqName fqName, FirSession firSession, FirSymbolProvider firSymbolProvider, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            firSymbolProvider = FirSymbolProviderKt.getSymbolProvider(firSession);
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        this(fqName, firSession, firSymbolProvider, set);
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        FirClassifierSymbol symbol;
        FirClassifierSymbol firClassifierSymbol;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        String string2 = name2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        if (((CharSequence)string2).length() == 0) {
            return;
        }
        if (this.excludedNames.contains(name2)) {
            return;
        }
        Map<Name, FirClassifierSymbol<?>> $this$getOrPut$iv = this.classifierCache;
        boolean $i$f$getOrPut = false;
        FirClassifierSymbol value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            boolean bl = false;
            ClassId unambiguousFqName = new ClassId(this.fqName, name2);
            FirClassifierSymbol answer$iv = this.symbolProvider.getClassLikeSymbolByClassId(unambiguousFqName);
            $this$getOrPut$iv.put(name2, answer$iv);
            firClassifierSymbol = answer$iv;
        } else {
            firClassifierSymbol = value$iv;
        }
        if ((symbol = firClassifierSymbol) != null) {
            processor.invoke(symbol, (Object)ConeSubstitutor.Empty.INSTANCE);
        }
    }

    @Override
    public void processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        List<FirNamedFunctionSymbol> list;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        if (this.excludedNames.contains(name2)) {
            return;
        }
        Map<Name, List<FirNamedFunctionSymbol>> $this$getOrPut$iv = this.functionCache;
        boolean $i$f$getOrPut = false;
        List<FirNamedFunctionSymbol> value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            boolean bl = false;
            List<FirNamedFunctionSymbol> answer$iv = this.symbolProvider.getTopLevelFunctionSymbols(this.fqName, name2);
            $this$getOrPut$iv.put(name2, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        List<FirNamedFunctionSymbol> symbols = list;
        for (FirNamedFunctionSymbol symbol : symbols) {
            processor.invoke((Object)symbol);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        List<FirPropertySymbol> list;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        if (this.excludedNames.contains(name2)) {
            return;
        }
        Map<Name, List<FirPropertySymbol>> $this$getOrPut$iv = this.propertyCache;
        boolean $i$f$getOrPut = false;
        List<FirPropertySymbol> value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            boolean bl = false;
            List<FirPropertySymbol> answer$iv = this.symbolProvider.getTopLevelPropertySymbols(this.fqName, name2);
            $this$getOrPut$iv.put(name2, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        List<FirPropertySymbol> symbols = list;
        for (FirPropertySymbol symbol : symbols) {
            processor.invoke((Object)symbol);
        }
    }

    @Override
    @NotNull
    public List<String> getScopeOwnerLookupNames() {
        return this.scopeOwnerLookupNames;
    }

    @Override
    @DelicateScopeAPI
    @NotNull
    public FirPackageMemberScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter((Object)newSession, (String)"newSession");
        Intrinsics.checkNotNullParameter((Object)newScopeSession, (String)"newScopeSession");
        return new FirPackageMemberScope(this.fqName, newSession, null, this.excludedNames, 4, null);
    }
}

