/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirSynchronizedAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirSynchronizedAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSynchronizedAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirSynchronizedAnnotationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,56:1\n40#2:57\n43#2:58\n12#2:60\n51#3:59\n*S KotlinDebug\n*F\n+ 1 FirSynchronizedAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirSynchronizedAnnotationChecker\n*L\n32#1:57\n36#1:58\n51#1:60\n49#1:59\n*E\n"})
public final class FirSynchronizedAnnotationChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirSynchronizedAnnotationChecker INSTANCE = new FirSynchronizedAnnotationChecker();

    private FirSynchronizedAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirAnnotation annotation;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                FirSession session = context2.getSession();
                FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JvmStandardClassIds.SYNCHRONIZED_ANNOTATION_CLASS_ID, session);
                if (firAnnotation == null) {
                    return;
                }
                annotation = firAnnotation;
                FirMemberDeclaration $this$isInline$iv = declaration2;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getStatus().isInline()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_ON_INLINE(), (DiagnosticContext)context2, null, 8, null);
                    return;
                }
                FirMemberDeclaration $this$isSuspend$iv = declaration2;
                boolean $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend()) break block13;
                Object object = declaration2 instanceof FirAnonymousFunction ? (FirAnonymousFunction)declaration2 : null;
                boolean bl = object != null && (object = ((FirAnonymousFunction)object).getTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType((ConeKotlinType)object, session) : false;
                if (!bl) break block14;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_ON_SUSPEND(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(declaration2);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> containingClass = firClassLikeSymbol;
        if (FirHelpersKt.getClassKind(containingClass) == ClassKind.INTERFACE) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
        } else if (FirHelpersKt.getClassKind(containingClass) == ClassKind.ANNOTATION_CLASS) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_IN_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
        } else {
            FirClassLikeSymbol<?> $this$isInline$iv = containingClass;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getRawStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_ON_VALUE_CLASS(), (DiagnosticContext)context2, null, 8, null);
            } else {
                FirMemberDeclaration $this$isAbstract$iv = declaration2;
                boolean $i$f$isAbstract = false;
                if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_ON_ABSTRACT(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
    }
}

