/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.index;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0005HIJKLB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020100H\u0016JK\u00102\u001a\u0004\u0018\u0001H3\"\b\b\u0000\u00103*\u0002042\u0006\u00105\u001a\u0002062\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u001a\u00107\u001a\u0016\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020.\u0012\u0006\u0012\u0004\u0018\u0001H300H\u0016\u00a2\u0006\u0002\u00108J=\u00109\u001a\u0004\u0018\u0001H3\"\b\b\u0000\u00103*\u0002042\u0006\u0010:\u001a\u00020;2\u001a\u0010<\u001a\u0016\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020.\u0012\u0006\u0012\u0004\u0018\u0001H300H\u0002\u00a2\u0006\u0002\u0010=J>\u0010>\u001a\u0004\u0018\u00010$2\u0006\u0010?\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010A\u001a\u00020\u000f2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003H\u0002J6\u0010C\u001a\u0004\u0018\u00010$2\u0006\u0010?\u001a\u00020\u000f2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010A\u001a\u00020\u000f2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003H\u0002J\u001e\u0010D\u001a\u0004\u0018\u00010$*\u00020$2\u0006\u0010E\u001a\u00020#2\u0006\u0010F\u001a\u00020.H\u0002J\u001c\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\f\u0010G\u001a\b\u0012\u0004\u0012\u00020#0\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\r\u001a\u0004\b\u001d\u0010\u001eR1\u0010 \u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010$0\"0!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\r\u001a\u0004\b%\u0010&\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl;", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;", "_roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "<init>", "(Ljava/util/List;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "roots", "getRoots", "()Ljava/util/List;", "roots$delegate", "Lkotlin/Lazy;", "maxIndex", "", "getMaxIndex", "()I", "rootCache", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$Cache;", "getRootCache", "()Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$Cache;", "rootCache$delegate", "lastClassSearch", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$FindClassRequest;", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchResult;", "indexedRoots", "Lkotlin/sequences/Sequence;", "getIndexedRoots", "()Lkotlin/sequences/Sequence;", "indexedRoots$delegate", "packageCache", "", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPackageCache", "()[Ljava/util/Map;", "packageCache$delegate", "traverseDirectoriesInPackage", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "acceptedRootTypes", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "continueSearch", "Lkotlin/Function2;", "", "findClass", "T", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findClassGivenDirectory", "(Lorg/jetbrains/kotlin/name/ClassId;Ljava/util/Set;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "search", "request", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchRequest;", "handler", "(Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchRequest;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "travelPath", "rootIndex", "packagesPath", "fillCachesAfter", "cachesPath", "doTravelPath", "findChildPackage", "subPackageName", "rootType", "path", "Cache", "FindClassRequest", "TraverseRequest", "SearchRequest", "SearchResult", "cli-base"})
@SourceDebugExtension(value={"SMAP\nJvmDependenciesIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDependenciesIndexImpl.kt\norg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,249:1\n1557#2:250\n1628#2,3:251\n1863#2,2:261\n381#3,7:254\n*S KotlinDebug\n*F\n+ 1 JvmDependenciesIndexImpl.kt\norg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl\n*L\n112#1:250\n112#1:251,3\n48#1:261,2\n165#1:254,7\n*E\n"})
public final class JvmDependenciesIndexImpl
implements JvmDependenciesIndex {
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final Lazy roots$delegate;
    @NotNull
    private final Lazy rootCache$delegate;
    @Nullable
    private Pair<FindClassRequest, ? extends SearchResult> lastClassSearch;
    @NotNull
    private final Lazy indexedRoots$delegate;
    @NotNull
    private final Lazy packageCache$delegate;

    public JvmDependenciesIndexImpl(@NotNull List<JavaRoot> _roots) {
        Intrinsics.checkNotNullParameter(_roots, (String)"_roots");
        this.lock = new ReentrantLock();
        this.roots$delegate = LazyKt.lazy(() -> JvmDependenciesIndexImpl.roots_delegate$lambda$0(_roots));
        this.rootCache$delegate = LazyKt.lazy(() -> JvmDependenciesIndexImpl.rootCache_delegate$lambda$2(this));
        this.indexedRoots$delegate = LazyKt.lazy(() -> JvmDependenciesIndexImpl.indexedRoots_delegate$lambda$3(this));
        this.packageCache$delegate = LazyKt.lazy(() -> JvmDependenciesIndexImpl.packageCache_delegate$lambda$4(this));
    }

    private final List<JavaRoot> getRoots() {
        Lazy lazy = this.roots$delegate;
        return (List)lazy.getValue();
    }

    private final int getMaxIndex() {
        return this.getRoots().size();
    }

    private final Cache getRootCache() {
        Lazy lazy = this.rootCache$delegate;
        return (Cache)lazy.getValue();
    }

    @Override
    @NotNull
    public Sequence<JavaRoot> getIndexedRoots() {
        Lazy lazy = this.indexedRoots$delegate;
        return (Sequence)lazy.getValue();
    }

    private final Map<String, VirtualFile>[] getPackageCache() {
        Lazy lazy = this.packageCache$delegate;
        return (Map[])lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traverseDirectoriesInPackage(@NotNull FqName packageFqName, @NotNull Set<? extends JavaRoot.RootType> acceptedRootTypes, @NotNull Function2<? super VirtualFile, ? super JavaRoot.RootType, Boolean> continueSearch) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(acceptedRootTypes, (String)"acceptedRootTypes");
        Intrinsics.checkNotNullParameter(continueSearch, (String)"continueSearch");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Unit unit = (Unit)this.search(new TraverseRequest(packageFqName, acceptedRootTypes), (arg_0, arg_1) -> JvmDependenciesIndexImpl.traverseDirectoriesInPackage$lambda$6$lambda$5(continueSearch, arg_0, arg_1));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T findClass(@NotNull ClassId classId, @NotNull Set<? extends JavaRoot.RootType> acceptedRootTypes, @NotNull Function2<? super VirtualFile, ? super JavaRoot.RootType, ? extends T> findClassGivenDirectory) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter(acceptedRootTypes, (String)"acceptedRootTypes");
        Intrinsics.checkNotNullParameter(findClassGivenDirectory, (String)"findClassGivenDirectory");
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            SearchResult cachedResult;
            boolean bl = false;
            Object object2 = this.lastClassSearch;
            if (!Intrinsics.areEqual(object2 != null && (object2 = (FindClassRequest)object2.getFirst()) != null ? ((FindClassRequest)object2).getClassId() : null, (Object)classId)) {
                T t = this.search(new FindClassRequest(classId, acceptedRootTypes), findClassGivenDirectory);
                return t;
            }
            Pair<FindClassRequest, ? extends SearchResult> pair = this.lastClassSearch;
            Intrinsics.checkNotNull(pair);
            Pair<FindClassRequest, ? extends SearchResult> pair2 = pair;
            FindClassRequest cachedRequest = (FindClassRequest)pair2.component1();
            SearchResult searchResult = cachedResult = (SearchResult)pair2.component2();
            if (searchResult instanceof SearchResult.NotFound) {
                Set limitedRootTypes = SetsKt.minus(acceptedRootTypes, (Iterable)cachedRequest.getAcceptedRootTypes());
                object = limitedRootTypes.isEmpty() ? null : this.search(new FindClassRequest(classId, limitedRootTypes), findClassGivenDirectory);
            } else if (searchResult instanceof SearchResult.Found) {
                object = Intrinsics.areEqual(cachedRequest.getAcceptedRootTypes(), acceptedRootTypes) ? findClassGivenDirectory.invoke((Object)((SearchResult.Found)cachedResult).getPackageDirectory(), (Object)((SearchResult.Found)cachedResult).getRoot().getType()) : this.search(new FindClassRequest(classId, acceptedRootTypes), findClassGivenDirectory);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Object object3 = object;
            return (T)object3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T search(SearchRequest request, Function2<? super VirtualFile, ? super JavaRoot.RootType, ? extends T> handler2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = request.getPackageFqName().pathSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getIdentifierOrNullIfSpecial();
            if (string2 == null) {
                return null;
            }
            collection.add(string2);
        }
        List packagesPath = (List)destination$iv$iv;
        List<Cache> caches = this.cachesPath(packagesPath);
        int processedRootsUpTo = -1;
        for (int cacheIndex = CollectionsKt.getLastIndex(caches); -1 < cacheIndex; --cacheIndex) {
            IntArrayList cacheRootIndices = caches.get(cacheIndex).getRootIndices();
            int n = cacheRootIndices.size();
            for (int i = 0; i < n; ++i) {
                VirtualFile directoryInRoot;
                Object result2;
                int rootIndex = cacheRootIndices.get(i);
                if (rootIndex <= processedRootsUpTo || this.travelPath(rootIndex, request.getPackageFqName(), packagesPath, cacheIndex, caches) == null) continue;
                JavaRoot root = this.getRoots().get(rootIndex);
                if (!request.getAcceptedRootTypes().contains((Object)root.getType()) || (result2 = handler2.invoke((Object)directoryInRoot, (Object)root.getType())) == null) continue;
                if (request instanceof FindClassRequest) {
                    this.lastClassSearch = new Pair((Object)request, (Object)new SearchResult.Found(directoryInRoot, root));
                }
                return (T)result2;
            }
            processedRootsUpTo = cacheRootIndices.isEmpty() ? processedRootsUpTo : cacheRootIndices.get(cacheRootIndices.size() - 1);
        }
        if (request instanceof FindClassRequest) {
            this.lastClassSearch = new Pair((Object)request, (Object)SearchResult.NotFound.INSTANCE);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile travelPath(int rootIndex, FqName packageFqName, List<String> packagesPath, int fillCachesAfter, List<Cache> cachesPath) {
        Object object;
        void $this$getOrPut$iv;
        if (rootIndex >= this.getMaxIndex()) {
            int n = cachesPath.size();
            for (int i = fillCachesAfter + 1; i < n; ++i) {
                cachesPath.get(i).getRootIndices().add(this.getMaxIndex());
                cachesPath.get(i).getRootIndices().trimToSize();
            }
            return null;
        }
        Map<String, VirtualFile> i = this.getPackageCache()[rootIndex];
        String key$iv = packageFqName.asString();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            VirtualFile answer$iv = this.doTravelPath(rootIndex, packagesPath, fillCachesAfter, cachesPath);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (VirtualFile)object;
    }

    private final VirtualFile doTravelPath(int rootIndex, List<String> packagesPath, int fillCachesAfter, List<Cache> cachesPath) {
        JavaRoot pathRoot = this.getRoots().get(rootIndex);
        FqName fqName = pathRoot.getPrefixFqName();
        List<Name> prefixPathSegments = fqName != null ? fqName.pathSegments() : null;
        VirtualFile currentFile = pathRoot.getFile();
        int n = ((Collection)packagesPath).size();
        for (int pathIndex = 0; pathIndex < n; ++pathIndex) {
            String subPackageName = packagesPath.get(pathIndex);
            if (prefixPathSegments != null && pathIndex < prefixPathSegments.size() ? !Intrinsics.areEqual((Object)prefixPathSegments.get(pathIndex).getIdentifier(), (Object)subPackageName) : this.findChildPackage(currentFile, subPackageName, pathRoot.getType()) == null) {
                return null;
            }
            int correspondingCacheIndex = pathIndex + 1;
            if (correspondingCacheIndex <= fillCachesAfter) continue;
            cachesPath.get(correspondingCacheIndex).getRootIndices().add(rootIndex);
        }
        return currentFile;
    }

    private final VirtualFile findChildPackage(VirtualFile $this$findChildPackage, String subPackageName, JavaRoot.RootType rootType) {
        String string2;
        VirtualFile virtualFile = $this$findChildPackage.findChild(subPackageName);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile childDirectory = virtualFile;
        switch (WhenMappings.$EnumSwitchMapping$0[rootType.ordinal()]) {
            case 1: {
                string2 = JavaClassFileType.INSTANCE.getDefaultExtension();
                break;
            }
            case 2: {
                string2 = "sig";
                break;
            }
            case 3: {
                string2 = JavaFileType.INSTANCE.getDefaultExtension();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        String fileExtension = string3;
        VirtualFile virtualFile2 = $this$findChildPackage.findChild(subPackageName + '.' + fileExtension);
        boolean bl = virtualFile2 != null ? !virtualFile2.isDirectory() : false;
        if (bl && VfsUtilCore.processFilesRecursively(childDirectory, arg_0 -> JvmDependenciesIndexImpl.findChildPackage$lambda$11(arg_0 -> JvmDependenciesIndexImpl.findChildPackage$lambda$10(fileExtension, arg_0), arg_0))) {
            return null;
        }
        return childDirectory;
    }

    private final List<Cache> cachesPath(List<String> path) {
        ArrayList<Cache> caches = new ArrayList<Cache>(path.size() + 1);
        caches.add(this.getRootCache());
        Cache currentCache = this.getRootCache();
        for (String subPackageName : path) {
            currentCache = currentCache.get(subPackageName);
            caches.add(currentCache);
        }
        return caches;
    }

    private static final List roots_delegate$lambda$0(List $_roots) {
        return CollectionsKt.toList((Iterable)$_roots);
    }

    /*
     * WARNING - void declaration
     */
    private static final Cache rootCache_delegate$lambda$2(JvmDependenciesIndexImpl this$0) {
        void $this$forEach$iv;
        Cache cache2;
        Cache $this$rootCache_delegate_u24lambda_u242_u24lambda_u241 = cache2 = new Cache();
        boolean bl = false;
        Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)this$0.getRoots());
        IntArrayList intArrayList = $this$rootCache_delegate_u24lambda_u242_u24lambda_u241.getRootIndices();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int p0 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl2 = false;
            intArrayList.add(p0);
        }
        $this$rootCache_delegate_u24lambda_u242_u24lambda_u241.getRootIndices().add(this$0.getMaxIndex());
        $this$rootCache_delegate_u24lambda_u242_u24lambda_u241.getRootIndices().trimToSize();
        return cache2;
    }

    private static final Sequence indexedRoots_delegate$lambda$3(JvmDependenciesIndexImpl this$0) {
        return CollectionsKt.asSequence((Iterable)this$0.getRoots());
    }

    private static final Object2ObjectOpenHashMap[] packageCache_delegate$lambda$4(JvmDependenciesIndexImpl this$0) {
        int n = 0;
        int n2 = this$0.getRoots().size();
        Object2ObjectOpenHashMap[] object2ObjectOpenHashMapArray = new Object2ObjectOpenHashMap[n2];
        while (n < n2) {
            int n3 = n++;
            object2ObjectOpenHashMapArray[n3] = new Object2ObjectOpenHashMap();
        }
        return object2ObjectOpenHashMapArray;
    }

    private static final Unit traverseDirectoriesInPackage$lambda$6$lambda$5(Function2 $continueSearch, VirtualFile dir, JavaRoot.RootType rootType) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"rootType");
        return (Boolean)$continueSearch.invoke((Object)dir, (Object)rootType) != false ? null : Unit.INSTANCE;
    }

    private static final boolean findChildPackage$lambda$10(String $fileExtension, VirtualFile file2) {
        return !Intrinsics.areEqual((Object)file2.getExtension(), (Object)$fileExtension);
    }

    private static final boolean findChildPackage$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\u00020\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$Cache;", "", "<init>", "()V", "innerPackageCaches", "Ljava/util/HashMap;", "", "get", "name", "rootIndices", "Lcom/intellij/util/containers/IntArrayList;", "getRootIndices$annotations", "getRootIndices", "()Lcom/intellij/util/containers/IntArrayList;", "cli-base"})
    @SourceDebugExtension(value={"SMAP\nJvmDependenciesIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDependenciesIndexImpl.kt\norg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$Cache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,249:1\n381#2,7:250\n*S KotlinDebug\n*F\n+ 1 JvmDependenciesIndexImpl.kt\norg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$Cache\n*L\n35#1:250,7\n*E\n"})
    private static final class Cache {
        @NotNull
        private final HashMap<String, Cache> innerPackageCaches = new HashMap();
        @NotNull
        private final IntArrayList rootIndices = new IntArrayList(2);

        @NotNull
        public final Cache get(@NotNull String name2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Map $this$getOrPut$iv = this.innerPackageCaches;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(name2);
            if (value$iv == null) {
                boolean bl = false;
                Cache answer$iv = new Cache();
                $this$getOrPut$iv.put(name2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (Cache)object;
        }

        @NotNull
        public final IntArrayList getRootIndices() {
            return this.rootIndices;
        }

        public static /* synthetic */ void getRootIndices$annotations() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$FindClassRequest;", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchRequest;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "acceptedRootTypes", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Ljava/util/Set;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getAcceptedRootTypes", "()Ljava/util/Set;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cli-base"})
    private static final class FindClassRequest
    implements SearchRequest {
        @NotNull
        private final ClassId classId;
        @NotNull
        private final Set<JavaRoot.RootType> acceptedRootTypes;

        public FindClassRequest(@NotNull ClassId classId, @NotNull Set<? extends JavaRoot.RootType> acceptedRootTypes) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter(acceptedRootTypes, (String)"acceptedRootTypes");
            this.classId = classId;
            this.acceptedRootTypes = acceptedRootTypes;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Override
        @NotNull
        public Set<JavaRoot.RootType> getAcceptedRootTypes() {
            return this.acceptedRootTypes;
        }

        @Override
        @NotNull
        public FqName getPackageFqName() {
            return this.classId.getPackageFqName();
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @NotNull
        public final Set<JavaRoot.RootType> component2() {
            return this.acceptedRootTypes;
        }

        @NotNull
        public final FindClassRequest copy(@NotNull ClassId classId, @NotNull Set<? extends JavaRoot.RootType> acceptedRootTypes) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter(acceptedRootTypes, (String)"acceptedRootTypes");
            return new FindClassRequest(classId, acceptedRootTypes);
        }

        public static /* synthetic */ FindClassRequest copy$default(FindClassRequest findClassRequest, ClassId classId, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                classId = findClassRequest.classId;
            }
            if ((n & 2) != 0) {
                set = findClassRequest.acceptedRootTypes;
            }
            return findClassRequest.copy(classId, set);
        }

        @NotNull
        public String toString() {
            return "FindClassRequest(classId=" + this.classId + ", acceptedRootTypes=" + this.acceptedRootTypes + ')';
        }

        public int hashCode() {
            int result2 = this.classId.hashCode();
            result2 = result2 * 31 + ((Object)this.acceptedRootTypes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FindClassRequest)) {
                return false;
            }
            FindClassRequest findClassRequest = (FindClassRequest)other;
            if (!Intrinsics.areEqual((Object)this.classId, (Object)findClassRequest.classId)) {
                return false;
            }
            return Intrinsics.areEqual(this.acceptedRootTypes, findClassRequest.acceptedRootTypes);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchRequest;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "acceptedRootTypes", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "getAcceptedRootTypes", "()Ljava/util/Set;", "cli-base"})
    private static interface SearchRequest {
        @NotNull
        public FqName getPackageFqName();

        @NotNull
        public Set<JavaRoot.RootType> getAcceptedRootTypes();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchResult;", "", "<init>", "()V", "Found", "NotFound", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchResult$Found;", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchResult$NotFound;", "cli-base"})
    private static abstract class SearchResult {
        private SearchResult() {
        }

        public /* synthetic */ SearchResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchResult$Found;", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchResult;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;)V", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getRoot", "()Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "cli-base"})
        public static final class Found
        extends SearchResult {
            @NotNull
            private final VirtualFile packageDirectory;
            @NotNull
            private final JavaRoot root;

            public Found(@NotNull VirtualFile packageDirectory, @NotNull JavaRoot root) {
                Intrinsics.checkNotNullParameter((Object)packageDirectory, (String)"packageDirectory");
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                super(null);
                this.packageDirectory = packageDirectory;
                this.root = root;
            }

            @NotNull
            public final VirtualFile getPackageDirectory() {
                return this.packageDirectory;
            }

            @NotNull
            public final JavaRoot getRoot() {
                return this.root;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchResult$NotFound;", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchResult;", "<init>", "()V", "cli-base"})
        public static final class NotFound
        extends SearchResult {
            @NotNull
            public static final NotFound INSTANCE = new NotFound();

            private NotFound() {
                super(null);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$TraverseRequest;", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndexImpl$SearchRequest;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "acceptedRootTypes", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/util/Set;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getAcceptedRootTypes", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cli-base"})
    private static final class TraverseRequest
    implements SearchRequest {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final Set<JavaRoot.RootType> acceptedRootTypes;

        public TraverseRequest(@NotNull FqName packageFqName, @NotNull Set<? extends JavaRoot.RootType> acceptedRootTypes) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter(acceptedRootTypes, (String)"acceptedRootTypes");
            this.packageFqName = packageFqName;
            this.acceptedRootTypes = acceptedRootTypes;
        }

        @Override
        @NotNull
        public FqName getPackageFqName() {
            return this.packageFqName;
        }

        @Override
        @NotNull
        public Set<JavaRoot.RootType> getAcceptedRootTypes() {
            return this.acceptedRootTypes;
        }

        @NotNull
        public final FqName component1() {
            return this.packageFqName;
        }

        @NotNull
        public final Set<JavaRoot.RootType> component2() {
            return this.acceptedRootTypes;
        }

        @NotNull
        public final TraverseRequest copy(@NotNull FqName packageFqName, @NotNull Set<? extends JavaRoot.RootType> acceptedRootTypes) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter(acceptedRootTypes, (String)"acceptedRootTypes");
            return new TraverseRequest(packageFqName, acceptedRootTypes);
        }

        public static /* synthetic */ TraverseRequest copy$default(TraverseRequest traverseRequest, FqName fqName, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                fqName = traverseRequest.packageFqName;
            }
            if ((n & 2) != 0) {
                set = traverseRequest.acceptedRootTypes;
            }
            return traverseRequest.copy(fqName, set);
        }

        @NotNull
        public String toString() {
            return "TraverseRequest(packageFqName=" + this.packageFqName + ", acceptedRootTypes=" + this.acceptedRootTypes + ')';
        }

        public int hashCode() {
            int result2 = this.packageFqName.hashCode();
            result2 = result2 * 31 + ((Object)this.acceptedRootTypes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TraverseRequest)) {
                return false;
            }
            TraverseRequest traverseRequest = (TraverseRequest)other;
            if (!Intrinsics.areEqual((Object)this.packageFqName, (Object)traverseRequest.packageFqName)) {
                return false;
            }
            return Intrinsics.areEqual(this.acceptedRootTypes, traverseRequest.acceptedRootTypes);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JavaRoot.RootType.values().length];
            try {
                nArray[JavaRoot.RootType.BINARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaRoot.RootType.BINARY_SIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaRoot.RootType.SOURCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

