/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptDependencyModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.CleanableSoftValueCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirBuiltinsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirAbstractSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirCommonSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirDanglingFileSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJvmSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirNativeSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatform;

@LLFirInternals
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0015H\u0002JK\u0010\u0016\u001a\u00020\t\"\b\b\u0000\u0010\u0017*\u00020\b2\u0006\u0010\u000f\u001a\u0002H\u00172\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\t0\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\bJ(\u0010 \u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\b2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0011J\u0006\u0010#\u001a\u00020\u001dJ\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\bJ\u0019\u0010&\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\bH\u0082\u0010J\u0006\u0010'\u001a\u00020\u001dJ\u0006\u0010(\u001a\u00020\u001dJ \u0010)\u001a\u00020\u001d2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J \u0010*\u001a\u00020\u001d2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J5\u0010+\u001a\u00020\u001d2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0082\bJ\u0010\u00100\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010\u000f\u001a\u00020\bH\u0002J\b\u00103\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010-\u001a\u00020\u0011*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sourceCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/SessionStorage;", "binaryCache", "danglingFileSessionCache", "unstableDanglingFileSessionCache", "getSession", "module", "preferBinary", "", "getSessionNoCaching", "getSessionNoCaching$low_level_api_fir", "getDanglingFileCachedSession", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule;", "getCachedSession", "T", "storage", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "checkSessionValidity", "", "session", "removeSession", "removeSessionFrom", "removeAllSessions", "includeLibraryModules", "removeUnstableDanglingFileSessions", "removeContextualDanglingFileSessions", "contextModule", "hasContextModule", "removeAllDanglingFileSessions", "removeAllScriptSessions", "removeAllScriptSessionsFrom", "removeAllSessionsFrom", "removeAllMatchingSessionsFrom", "shouldBeRemoved", "supportsIsolatedSessionCreation", "getSupportsIsolatedSessionCreation", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Z", "createSession", "createPlatformAwareSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirAbstractSessionFactory;", "dispose", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n212#1:297\n213#1,4:299\n217#1:304\n212#1:305\n213#1,4:307\n217#1:312\n212#1:313\n213#1,4:315\n217#1:320\n212#1:321\n213#1,4:323\n217#1:328\n37#2,2:292\n37#2,2:294\n1#3:296\n1863#4:298\n1864#4:303\n1863#4:306\n1864#4:311\n1863#4:314\n1864#4:319\n1863#4:322\n1864#4:327\n1863#4,2:329\n1734#4,3:331\n1734#4,3:334\n1734#4,3:337\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n*L\n159#1:297\n159#1:299,4\n159#1:304\n173#1:305\n173#1:307,4\n173#1:312\n176#1:313\n176#1:315,4\n176#1:320\n202#1:321\n202#1:323,4\n202#1:328\n89#1:292,2\n106#1:294,2\n159#1:298\n159#1:303\n173#1:306\n173#1:311\n176#1:314\n176#1:319\n202#1:322\n202#1:327\n212#1:329,2\n253#1:331,3\n254#1:334,3\n255#1:337,3\n*E\n"})
public final class LLFirSessionCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CleanableSoftValueCache<KaModule, LLFirSession> sourceCache;
    @NotNull
    private final CleanableSoftValueCache<KaModule, LLFirSession> binaryCache;
    @NotNull
    private final CleanableSoftValueCache<KaModule, LLFirSession> danglingFileSessionCache;
    @NotNull
    private final CleanableSoftValueCache<KaModule, LLFirSession> unstableDanglingFileSessionCache;

    public LLFirSessionCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sourceCache = new CleanableSoftValueCache(sourceCache.1.INSTANCE);
        this.binaryCache = new CleanableSoftValueCache(binaryCache.1.INSTANCE);
        this.danglingFileSessionCache = new CleanableSoftValueCache(danglingFileSessionCache.1.INSTANCE);
        this.unstableDanglingFileSessionCache = new CleanableSoftValueCache(unstableDanglingFileSessionCache.1.INSTANCE);
    }

    @NotNull
    public final LLFirSession getSession(@NotNull KaModule module2, boolean preferBinary) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        if (module2 instanceof KaBuiltinsModule && preferBinary) {
            return LLFirBuiltinsSessionFactory.Companion.getInstance(this.project).getBuiltinsSession(module2.getTargetPlatform());
        }
        if (module2 instanceof KaLibraryModule && (preferBinary || ((KaLibraryModule)module2).isSdk())) {
            return this.getCachedSession(module2, this.binaryCache, arg_0 -> LLFirSessionCache.getSession$lambda$0(this, module2, arg_0));
        }
        if (module2 instanceof KaDanglingFileModule) {
            return this.getDanglingFileCachedSession((KaDanglingFileModule)module2);
        }
        return this.getCachedSession(module2, this.sourceCache, (Function1)new Function1<KaModule, LLFirSession>((Object)this){

            public final LLFirSession invoke(KaModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
            }
        });
    }

    public static /* synthetic */ LLFirSession getSession$default(LLFirSessionCache lLFirSessionCache, KaModule kaModule, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lLFirSessionCache.getSession(kaModule, bl);
    }

    @NotNull
    public final LLFirSession getSessionNoCaching$low_level_api_fir(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.createSession(module2);
    }

    private final LLFirSession getDanglingFileCachedSession(KaDanglingFileModule module2) {
        if (KaModuleKt.isStable(module2)) {
            return this.getCachedSession((KaModule)module2, this.danglingFileSessionCache, (Function1)new Function1<KaModule, LLFirSession>((Object)this){

                public final LLFirSession invoke(KaModule p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
                }
            });
        }
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirSession session = this.unstableDanglingFileSessionCache.compute(module2, (Function2<KaModule, LLFirSession, LLFirSession>)((Function2)(arg_0, arg_1) -> LLFirSessionCache.getDanglingFileCachedSession$lambda$1(module2, this, arg_0, arg_1)));
        if (session == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.checkSessionValidity(session);
        return session;
    }

    private final <T extends KaModule> LLFirSession getCachedSession(T module2, CleanableSoftValueCache<KaModule, LLFirSession> storage, Function1<? super T, ? extends LLFirSession> factory2) {
        LLFirSession lLFirSession;
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        if (this.getSupportsIsolatedSessionCreation(module2)) {
            lLFirSession = storage.computeIfAbsent(module2, (Function1<KaModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$2(factory2, module2, arg_0)));
        } else {
            lLFirSession = storage.get(module2);
            if (lLFirSession == null) {
                LLFirSessionCache $this$getCachedSession_u24lambda_u244 = this;
                boolean bl = false;
                LLFirSession newSession = (LLFirSession)factory2.invoke(module2);
                lLFirSession = storage.computeIfAbsent(module2, (Function1<KaModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$4$lambda$3(newSession, arg_0)));
            }
        }
        LLFirSession session = lLFirSession;
        this.checkSessionValidity(session);
        return session;
    }

    private final void checkSessionValidity(LLFirSession session) {
        if (!session.isValid()) {
            boolean bl = false;
            String string2 = "A session acquired via `getSession` should always be valid. Module: " + session.getKtModule();
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final boolean removeSession(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean didSourceSessionExist = this.removeSessionFrom(module2, this.sourceCache);
        boolean didBinarySessionExist = module2 instanceof KaLibraryModule && this.removeSessionFrom(module2, this.binaryCache);
        boolean didDanglingFileSessionExist = module2 instanceof KaDanglingFileModule && this.removeSessionFrom(module2, this.danglingFileSessionCache);
        boolean didUnstableDanglingFileSessionExist = module2 instanceof KaDanglingFileModule && this.removeSessionFrom(module2, this.unstableDanglingFileSessionCache);
        return didSourceSessionExist || didBinarySessionExist || didDanglingFileSessionExist || didUnstableDanglingFileSessionExist;
    }

    private final boolean removeSessionFrom(KaModule module2, CleanableSoftValueCache<KaModule, LLFirSession> storage) {
        return storage.remove(module2) != null;
    }

    public final void removeAllSessions(boolean includeLibraryModules) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (includeLibraryModules) {
            this.removeAllSessionsFrom(this.sourceCache);
            this.removeAllSessionsFrom(this.binaryCache);
        } else {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableSoftValueCache<KaModule, LLFirSession> storage$iv = this.sourceCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl = false;
                KaModule it = module$iv;
                boolean bl2 = false;
                if (!(!(it instanceof KaLibraryModule) && !(it instanceof KaLibrarySourceModule))) continue;
                storage$iv.remove(module$iv);
            }
        }
        this.removeAllDanglingFileSessions();
    }

    public final void removeUnstableDanglingFileSessions() {
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeContextualDanglingFileSessions(@NotNull KaModule contextModule) {
        Intrinsics.checkNotNullParameter((Object)contextModule, (String)"contextModule");
        this.removeUnstableDanglingFileSessions();
        if (contextModule instanceof KaDanglingFileModule) {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableSoftValueCache<KaModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl = false;
                KaModule it = module$iv;
                boolean bl2 = false;
                if (!(it instanceof KaDanglingFileModule && this.hasContextModule((KaDanglingFileModule)it, contextModule))) continue;
                storage$iv.remove(module$iv);
            }
        } else {
            LLFirSessionCache this_$iv = this;
            CleanableSoftValueCache<KaModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl = false;
                KaModule it = module$iv;
                boolean bl3 = false;
                if (!(it instanceof KaDanglingFileModule && ((KaDanglingFileModule)it).isCodeFragment())) continue;
                storage$iv.remove(module$iv);
            }
        }
    }

    private final boolean hasContextModule(KaDanglingFileModule module2, KaModule contextModule) {
        boolean bl;
        block2: {
            LLFirSessionCache lLFirSessionCache = this;
            while (true) {
                KaModule candidate;
                if (Intrinsics.areEqual((Object)(candidate = module2.getContextModule()), (Object)contextModule)) {
                    bl = true;
                    break block2;
                }
                if (!(candidate instanceof KaDanglingFileModule)) break;
                LLFirSessionCache lLFirSessionCache2 = lLFirSessionCache;
                KaDanglingFileModule kaDanglingFileModule = (KaDanglingFileModule)candidate;
                KaModule kaModule = contextModule;
                lLFirSessionCache = lLFirSessionCache2;
                module2 = kaDanglingFileModule;
                contextModule = kaModule;
            }
            bl = false;
        }
        return bl;
    }

    public final void removeAllDanglingFileSessions() {
        this.removeAllSessionsFrom(this.danglingFileSessionCache);
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeAllScriptSessions() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeAllScriptSessionsFrom(this.sourceCache);
        this.removeAllScriptSessionsFrom(this.binaryCache);
    }

    private final void removeAllScriptSessionsFrom(CleanableSoftValueCache<KaModule, LLFirSession> storage) {
        LLFirSessionCache this_$iv = this;
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv$iv = storage.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            KaModule module$iv = (KaModule)element$iv$iv;
            boolean bl = false;
            KaModule it = module$iv;
            boolean bl2 = false;
            if (!(it instanceof KaScriptModule || it instanceof KaScriptDependencyModule)) continue;
            storage.remove(module$iv);
        }
    }

    private final void removeAllSessionsFrom(CleanableSoftValueCache<KaModule, LLFirSession> storage) {
        storage.clear();
    }

    private final void removeAllMatchingSessionsFrom(CleanableSoftValueCache<KaModule, LLFirSession> storage, Function1<? super KaModule, Boolean> shouldBeRemoved) {
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv = storage.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KaModule module2 = (KaModule)element$iv;
            boolean bl = false;
            if (!((Boolean)shouldBeRemoved.invoke((Object)module2)).booleanValue()) continue;
            storage.remove(module2);
        }
    }

    private final boolean getSupportsIsolatedSessionCreation(KaModule $this$supportsIsolatedSessionCreation) {
        return !($this$supportsIsolatedSessionCreation instanceof KaDanglingFileModule);
    }

    private final LLFirSession createSession(KaModule module2) {
        LLFirSession lLFirSession;
        LLFirAbstractSessionFactory sessionFactory = this.createPlatformAwareSessionFactory(module2);
        KaModule kaModule = module2;
        if (kaModule instanceof KaSourceModule) {
            lLFirSession = sessionFactory.createSourcesSession((KaSourceModule)module2);
        } else if (kaModule instanceof KaBuiltinsModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaLibraryModule) {
            lLFirSession = ((KaLibraryModule)module2).isSdk() ? (LLFirSession)sessionFactory.createBinaryLibrarySession((KaLibraryModule)module2) : (LLFirSession)sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaLibrarySourceModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaScriptModule) {
            lLFirSession = sessionFactory.createScriptSession((KaScriptModule)module2);
        } else if (kaModule instanceof KaDanglingFileModule) {
            LLFirSession contextSession = this.getSession(((KaDanglingFileModule)module2).getContextModule(), false);
            lLFirSession = sessionFactory.createDanglingFileSession((KaDanglingFileModule)module2, contextSession);
        } else if (kaModule instanceof KaNotUnderContentRootModule) {
            lLFirSession = sessionFactory.createNotUnderContentRootResolvableSession((KaNotUnderContentRootModule)module2);
        } else {
            throw new IllegalStateException(("Unexpected module kind: " + Reflection.getOrCreateKotlinClass(module2.getClass()).getSimpleName()).toString());
        }
        return lLFirSession;
    }

    private final LLFirAbstractSessionFactory createPlatformAwareSessionFactory(KaModule module2) {
        LLFirAbstractSessionFactory lLFirAbstractSessionFactory;
        SimplePlatform it;
        boolean bl;
        boolean $i$f$all;
        Iterable $this$all$iv;
        TargetPlatform targetPlatform;
        block13: {
            targetPlatform = module2.getTargetPlatform();
            $this$all$iv = targetPlatform;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (SimplePlatform)element$iv;
                    boolean bl2 = false;
                    if (it instanceof JvmPlatform) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            lLFirAbstractSessionFactory = new LLFirJvmSessionFactory(this.project);
        } else {
            boolean bl3;
            block14: {
                $this$all$iv = targetPlatform;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (SimplePlatform)element$iv;
                        boolean bl4 = false;
                        if (it instanceof JsPlatform) continue;
                        bl3 = false;
                        break block14;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                lLFirAbstractSessionFactory = new LLFirJsSessionFactory(this.project);
            } else {
                boolean bl5;
                block15: {
                    $this$all$iv = targetPlatform;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (SimplePlatform)element$iv;
                            boolean bl6 = false;
                            if (it instanceof NativePlatform) continue;
                            bl5 = false;
                            break block15;
                        }
                        bl5 = true;
                    }
                }
                lLFirAbstractSessionFactory = bl5 ? (LLFirAbstractSessionFactory)new LLFirNativeSessionFactory(this.project) : (LLFirAbstractSessionFactory)new LLFirCommonSessionFactory(this.project);
            }
        }
        return lLFirAbstractSessionFactory;
    }

    @Override
    public void dispose() {
    }

    private static final LLFirSession getSession$lambda$0(LLFirSessionCache this$0, KaModule $module, KaLibraryModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createPlatformAwareSessionFactory($module).createBinaryLibrarySession((KaLibraryModule)$module);
    }

    private static final LLFirSession getDanglingFileCachedSession$lambda$1(KaDanglingFileModule $module, LLFirSessionCache this$0, KaModule kaModule, LLFirSession existingSession) {
        Intrinsics.checkNotNullParameter((Object)kaModule, (String)"<unused var>");
        return existingSession instanceof LLFirDanglingFileSession && ((LLFirDanglingFileSession)existingSession).getModificationStamp() == $module.getFile().getModificationStamp() ? existingSession : this$0.createSession($module);
    }

    private static final LLFirSession getCachedSession$lambda$2(Function1 $factory, KaModule $module, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LLFirSession)$factory.invoke((Object)$module);
    }

    private static final LLFirSession getCachedSession$lambda$4$lambda$3(LLFirSession $newSession, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $newSession;
    }

    public static final /* synthetic */ LLFirSession access$createSession(LLFirSessionCache $this, KaModule module2) {
        return $this.createSession(module2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LLFirSessionCache lLFirSessionCache = project.getService(LLFirSessionCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)lLFirSessionCache, (String)"getService(...)");
            return lLFirSessionCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

