/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.nio.LongBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.BaseStreamEx;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.EmitterSpliterator;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.Internals;
import one.util.streamex.LongCollector;
import one.util.streamex.PairSpliterator;
import one.util.streamex.PrefixOps;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamEx;
import one.util.streamex.TakeDrop;
import one.util.streamex.UnknownSizeSpliterator;
import one.util.streamex.VerSpec;

public class LongStreamEx
extends BaseStreamEx<Long, LongStream, Spliterator.OfLong, LongStreamEx>
implements LongStream {
    LongStreamEx(LongStream stream, StreamContext context2) {
        super(stream, context2);
    }

    LongStreamEx(Spliterator.OfLong spliterator, StreamContext context2) {
        super(spliterator, context2);
    }

    @Override
    LongStream createStream() {
        return StreamSupport.longStream((Spliterator.OfLong)this.spliterator, this.isParallel());
    }

    private static LongStreamEx seq(LongStream stream) {
        return new LongStreamEx(stream, StreamContext.SEQUENTIAL);
    }

    final LongStreamEx delegate(Spliterator.OfLong spliterator) {
        return new LongStreamEx(spliterator, this.context);
    }

    @Override
    public LongStreamEx unordered() {
        return (LongStreamEx)super.unordered();
    }

    @Override
    public LongStreamEx onClose(Runnable closeHandler) {
        return (LongStreamEx)super.onClose(closeHandler);
    }

    @Override
    public LongStreamEx filter(LongPredicate predicate) {
        return new LongStreamEx(((LongStream)this.stream()).filter(predicate), this.context);
    }

    public LongStreamEx remove(LongPredicate predicate) {
        return this.filter(predicate.negate());
    }

    public boolean has(long value2) {
        return this.anyMatch(x -> x == value2);
    }

    public LongStreamEx without(long value2) {
        return this.filter(val -> val != value2);
    }

    public LongStreamEx without(long ... values2) {
        if (values2.length == 0) {
            return this;
        }
        if (values2.length == 1) {
            return this.without(values2[0]);
        }
        return this.filter(x -> {
            for (long val : values2) {
                if (x != val) continue;
                return false;
            }
            return true;
        });
    }

    public LongStreamEx greater(long value2) {
        return this.filter(val -> val > value2);
    }

    public LongStreamEx atLeast(long value2) {
        return this.filter(val -> val >= value2);
    }

    public LongStreamEx less(long value2) {
        return this.filter(val -> val < value2);
    }

    public LongStreamEx atMost(long value2) {
        return this.filter(val -> val <= value2);
    }

    @Override
    public LongStreamEx map(LongUnaryOperator mapper) {
        return new LongStreamEx(((LongStream)this.stream()).map(mapper), this.context);
    }

    public LongStreamEx mapFirst(LongUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfLong((a, b) -> b, mapper, (Spliterator.OfLong)this.spliterator(), 1));
    }

    public LongStreamEx mapLast(LongUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfLong((a, b) -> a, mapper, (Spliterator.OfLong)this.spliterator(), 2));
    }

    public <U> StreamEx<U> mapToObj(LongFunction<? extends U> mapper) {
        return new StreamEx<U>(((LongStream)this.stream()).mapToObj(mapper), this.context);
    }

    @Override
    public IntStreamEx mapToInt(LongToIntFunction mapper) {
        return new IntStreamEx(((LongStream)this.stream()).mapToInt(mapper), this.context);
    }

    @Override
    public DoubleStreamEx mapToDouble(LongToDoubleFunction mapper) {
        return new DoubleStreamEx(((LongStream)this.stream()).mapToDouble(mapper), this.context);
    }

    public <K, V> EntryStream<K, V> mapToEntry(LongFunction<? extends K> keyMapper, LongFunction<? extends V> valueMapper) {
        return new EntryStream(((LongStream)this.stream()).mapToObj((long t) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(t), valueMapper.apply(t))), this.context);
    }

    @Override
    public LongStreamEx flatMap(LongFunction<? extends LongStream> mapper) {
        return new LongStreamEx(((LongStream)this.stream()).flatMap(mapper), this.context);
    }

    public IntStreamEx flatMapToInt(LongFunction<? extends IntStream> mapper) {
        return new IntStreamEx(((LongStream)this.stream()).mapToObj(mapper).flatMapToInt(Function.identity()), this.context);
    }

    public DoubleStreamEx flatMapToDouble(LongFunction<? extends DoubleStream> mapper) {
        return new DoubleStreamEx(((LongStream)this.stream()).mapToObj(mapper).flatMapToDouble(Function.identity()), this.context);
    }

    public <R> StreamEx<R> flatMapToObj(LongFunction<? extends Stream<R>> mapper) {
        return new StreamEx(((LongStream)this.stream()).mapToObj(mapper).flatMap(Function.identity()), this.context);
    }

    public LongStreamEx intersperse(int delimiter) {
        return new LongStreamEx(((LongStream)this.stream()).flatMap((long s) -> LongStreamEx.of(delimiter, s)).skip(1L), this.context);
    }

    @Override
    public LongStreamEx distinct() {
        return new LongStreamEx(((LongStream)this.stream()).distinct(), this.context);
    }

    @Override
    public LongStreamEx sorted() {
        return new LongStreamEx(((LongStream)this.stream()).sorted(), this.context);
    }

    public LongStreamEx sorted(Comparator<Long> comparator) {
        return new LongStreamEx(((LongStream)this.stream()).boxed().sorted(comparator).mapToLong(Long::longValue), this.context);
    }

    public LongStreamEx reverseSorted() {
        LongUnaryOperator inv = x -> x ^ 0xFFFFFFFFFFFFFFFFL;
        return new LongStreamEx(((LongStream)this.stream()).map(inv).sorted().map(inv), this.context);
    }

    public <V extends Comparable<? super V>> LongStreamEx sortedBy(LongFunction<V> keyExtractor) {
        return this.sorted(Comparator.comparing(keyExtractor::apply));
    }

    public LongStreamEx sortedByInt(LongToIntFunction keyExtractor) {
        return this.sorted(Comparator.comparingInt(keyExtractor::applyAsInt));
    }

    public LongStreamEx sortedByLong(LongUnaryOperator keyExtractor) {
        return this.sorted(Comparator.comparingLong(keyExtractor::applyAsLong));
    }

    public LongStreamEx sortedByDouble(LongToDoubleFunction keyExtractor) {
        return this.sorted(Comparator.comparingDouble(keyExtractor::applyAsDouble));
    }

    @Override
    public LongStreamEx peek(LongConsumer action) {
        return new LongStreamEx(((LongStream)this.stream()).peek(action), this.context);
    }

    public LongStreamEx peekFirst(LongConsumer action) {
        return this.mapFirst(x -> {
            action.accept(x);
            return x;
        });
    }

    public LongStreamEx peekLast(LongConsumer action) {
        return this.mapLast(x -> {
            action.accept(x);
            return x;
        });
    }

    @Override
    public LongStreamEx limit(long maxSize) {
        return new LongStreamEx(((LongStream)this.stream()).limit(maxSize), this.context);
    }

    @Override
    public LongStreamEx skip(long n) {
        return new LongStreamEx(((LongStream)this.stream()).skip(n), this.context);
    }

    @Override
    public void forEach(LongConsumer action) {
        if (this.spliterator != null && !this.isParallel()) {
            ((Spliterator.OfLong)this.spliterator()).forEachRemaining(action);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((LongStream)this.stream()).forEach(action);
                return null;
            });
        } else {
            ((LongStream)this.stream()).forEach(action);
        }
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        if (this.spliterator != null && !this.isParallel()) {
            ((Spliterator.OfLong)this.spliterator()).forEachRemaining(action);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((LongStream)this.stream()).forEachOrdered(action);
                return null;
            });
        } else {
            ((LongStream)this.stream()).forEachOrdered(action);
        }
    }

    @Override
    public long[] toArray() {
        if (this.context.fjp != null) {
            return this.context.terminate(((LongStream)this.stream())::toArray);
        }
        return ((LongStream)this.stream()).toArray();
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        if (this.context.fjp != null) {
            return this.context.terminate(() -> ((LongStream)this.stream()).reduce(identity, op));
        }
        return ((LongStream)this.stream()).reduce(identity, op);
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        if (this.context.fjp != null) {
            return this.context.terminate(op, ((LongStream)this.stream())::reduce);
        }
        return ((LongStream)this.stream()).reduce(op);
    }

    public OptionalLong foldLeft(LongBinaryOperator accumulator) {
        Internals.PrimitiveBox b = new Internals.PrimitiveBox();
        this.forEachOrdered(t -> {
            if (b.b) {
                b.l = accumulator.applyAsLong(b.l, t);
            } else {
                b.l = t;
                b.b = true;
            }
        });
        return b.asLong();
    }

    public long foldLeft(long seed, LongBinaryOperator accumulator) {
        long[] box = new long[]{seed};
        this.forEachOrdered(t -> {
            box[0] = accumulator.applyAsLong(box[0], t);
        });
        return box[0];
    }

    public long[] scanLeft(LongBinaryOperator accumulator) {
        Spliterator.OfLong spliterator = (Spliterator.OfLong)this.spliterator();
        long size = spliterator.getExactSizeIfKnown();
        Internals.LongBuffer buf = new Internals.LongBuffer(size >= 0L && size <= Integer.MAX_VALUE ? (int)size : 128);
        this.delegate(spliterator).forEachOrdered(i -> buf.add(buf.size == 0 ? i : accumulator.applyAsLong(buf.data[buf.size - 1], i)));
        return buf.toArray();
    }

    public long[] scanLeft(long seed, LongBinaryOperator accumulator) {
        return this.prepend(seed).scanLeft(accumulator);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> ((LongStream)this.stream()).collect(supplier, accumulator, combiner));
        }
        return ((LongStream)this.stream()).collect(supplier, accumulator, combiner);
    }

    public <A, R> R collect(LongCollector<A, R> collector2) {
        if (collector2.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return (R)this.collect(collector2.supplier(), collector2.longAccumulator(), collector2.merger());
        }
        return collector2.finisher().apply(this.collect(collector2.supplier(), collector2.longAccumulator(), collector2.merger()));
    }

    @Override
    public long sum() {
        return this.reduce(0L, Long::sum);
    }

    @Override
    public OptionalLong min() {
        return this.reduce(Long::min);
    }

    public OptionalLong min(Comparator<Long> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) > 0 ? b : a);
    }

    public <V extends Comparable<? super V>> OptionalLong minBy(LongFunction<V> keyExtractor) {
        Internals.ObjLongBox result2 = this.collect(() -> new Internals.ObjLongBox<Object>(null, 0L), (box, i) -> {
            Comparable val = Objects.requireNonNull((Comparable)keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) > 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) > 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result2.a == null ? OptionalLong.empty() : OptionalLong.of(result2.b);
    }

    public OptionalLong minByInt(LongToIntFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, l) -> {
            int key = keyExtractor.applyAsInt(l);
            if (!box.b || box.i > key) {
                box.b = true;
                box.i = key;
                box.l = l;
            }
        }, Internals.PrimitiveBox.MIN_INT).asLong();
    }

    public OptionalLong minByLong(LongUnaryOperator keyExtractor) {
        long[] result2 = this.collect(() -> new long[3], (acc, l) -> {
            long key = keyExtractor.applyAsLong(l);
            if (acc[2] == 0L || acc[1] > key) {
                acc[0] = l;
                acc[1] = key;
                acc[2] = 1L;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1L && (acc1[2] == 0L || acc1[1] > acc2[1])) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result2[2] == 1L ? OptionalLong.of(result2[0]) : OptionalLong.empty();
    }

    public OptionalLong minByDouble(LongToDoubleFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, l) -> {
            double key = keyExtractor.applyAsDouble(l);
            if (!box.b || Double.compare(box.d, key) > 0) {
                box.b = true;
                box.d = key;
                box.l = l;
            }
        }, Internals.PrimitiveBox.MIN_DOUBLE).asLong();
    }

    @Override
    public OptionalLong max() {
        return this.reduce(Long::max);
    }

    public OptionalLong max(Comparator<Long> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) >= 0 ? a : b);
    }

    public <V extends Comparable<? super V>> OptionalLong maxBy(LongFunction<V> keyExtractor) {
        Internals.ObjLongBox result2 = this.collect(() -> new Internals.ObjLongBox<Object>(null, 0L), (box, i) -> {
            Comparable val = Objects.requireNonNull((Comparable)keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) < 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) < 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result2.a == null ? OptionalLong.empty() : OptionalLong.of(result2.b);
    }

    public OptionalLong maxByInt(LongToIntFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, l) -> {
            int key = keyExtractor.applyAsInt(l);
            if (!box.b || box.i < key) {
                box.b = true;
                box.i = key;
                box.l = l;
            }
        }, Internals.PrimitiveBox.MAX_INT).asLong();
    }

    public OptionalLong maxByLong(LongUnaryOperator keyExtractor) {
        long[] result2 = this.collect(() -> new long[3], (acc, l) -> {
            long key = keyExtractor.applyAsLong(l);
            if (acc[2] == 0L || acc[1] < key) {
                acc[0] = l;
                acc[1] = key;
                acc[2] = 1L;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1L && (acc1[2] == 0L || acc1[1] < acc2[1])) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result2[2] == 1L ? OptionalLong.of(result2[0]) : OptionalLong.empty();
    }

    public OptionalLong maxByDouble(LongToDoubleFunction keyExtractor) {
        return this.collect(Internals.PrimitiveBox::new, (box, l) -> {
            double key = keyExtractor.applyAsDouble(l);
            if (!box.b || Double.compare(box.d, key) < 0) {
                box.b = true;
                box.d = key;
                box.l = l;
            }
        }, Internals.PrimitiveBox.MAX_DOUBLE).asLong();
    }

    @Override
    public long count() {
        if (this.context.fjp != null) {
            return this.context.terminate(((LongStream)this.stream())::count);
        }
        return ((LongStream)this.stream()).count();
    }

    @Override
    public OptionalDouble average() {
        if (this.context.fjp != null) {
            return this.context.terminate(((LongStream)this.stream())::average);
        }
        return ((LongStream)this.stream()).average();
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return this.collect(LongSummaryStatistics::new, LongSummaryStatistics::accept, LongSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((LongStream)this.stream())::anyMatch);
        }
        return ((LongStream)this.stream()).anyMatch(predicate);
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((LongStream)this.stream())::allMatch);
        }
        return ((LongStream)this.stream()).allMatch(predicate);
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalLong findFirst() {
        if (this.context.fjp != null) {
            return this.context.terminate(((LongStream)this.stream())::findFirst);
        }
        return ((LongStream)this.stream()).findFirst();
    }

    public OptionalLong findFirst(LongPredicate predicate) {
        return this.filter(predicate).findFirst();
    }

    @Override
    public OptionalLong findAny() {
        if (this.context.fjp != null) {
            return this.context.terminate(((LongStream)this.stream())::findAny);
        }
        return ((LongStream)this.stream()).findAny();
    }

    public OptionalLong findAny(LongPredicate predicate) {
        return this.filter(predicate).findAny();
    }

    public OptionalLong indexOf(long value2) {
        return ((AbstractStreamEx)this.boxed()).indexOf((? super T i) -> i == value2);
    }

    public OptionalLong indexOf(LongPredicate predicate) {
        return ((AbstractStreamEx)this.boxed()).indexOf(predicate::test);
    }

    @Override
    public DoubleStreamEx asDoubleStream() {
        return new DoubleStreamEx(((LongStream)this.stream()).asDoubleStream(), this.context);
    }

    public StreamEx<Long> boxed() {
        return new StreamEx<Long>(((LongStream)this.stream()).boxed(), this.context);
    }

    @Override
    public LongStreamEx sequential() {
        return (LongStreamEx)super.sequential();
    }

    @Override
    public LongStreamEx parallel() {
        return (LongStreamEx)super.parallel();
    }

    @Override
    public LongStreamEx parallel(ForkJoinPool fjp) {
        return (LongStreamEx)super.parallel(fjp);
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return Spliterators.iterator((Spliterator.OfLong)this.spliterator());
    }

    public LongStreamEx append(long ... values2) {
        if (values2.length == 0) {
            return this;
        }
        return new LongStreamEx(LongStream.concat((LongStream)this.stream(), LongStream.of(values2)), this.context);
    }

    public LongStreamEx append(LongStream other) {
        return new LongStreamEx(LongStream.concat((LongStream)this.stream(), other), this.context.combine(other));
    }

    public LongStreamEx prepend(long ... values2) {
        if (values2.length == 0) {
            return this;
        }
        return new LongStreamEx(LongStream.concat(LongStream.of(values2), (LongStream)this.stream()), this.context);
    }

    public LongStreamEx prepend(LongStream other) {
        return new LongStreamEx(LongStream.concat(other, (LongStream)this.stream()), this.context.combine(other));
    }

    public LongStreamEx pairMap(LongBinaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfLong(mapper, null, (Spliterator.OfLong)this.spliterator(), 0));
    }

    public String joining(CharSequence delimiter) {
        return this.collect(LongCollector.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.collect(LongCollector.joining(delimiter, prefix, suffix));
    }

    @Override
    public LongStreamEx takeWhile(LongPredicate predicate) {
        return VerSpec.VER_SPEC.callWhile(this, Objects.requireNonNull(predicate), false);
    }

    public LongStreamEx takeWhileInclusive(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return this.delegate(new TakeDrop.TDOfLong((Spliterator.OfLong)this.spliterator(), false, true, predicate));
    }

    @Override
    public LongStreamEx dropWhile(LongPredicate predicate) {
        return VerSpec.VER_SPEC.callWhile(this, Objects.requireNonNull(predicate), true);
    }

    public LongStreamEx prefix(LongBinaryOperator op) {
        return this.delegate(new PrefixOps.OfLong((Spliterator.OfLong)this.spliterator(), op));
    }

    @Override
    public <U> U chain(Function<? super LongStreamEx, U> mapper) {
        return mapper.apply(this);
    }

    public static LongStreamEx empty() {
        return LongStreamEx.of(Spliterators.emptyLongSpliterator());
    }

    public static LongStreamEx of(long element2) {
        return LongStreamEx.of(new ConstSpliterator.OfLong(element2, 1L, true));
    }

    public static LongStreamEx of(long ... elements) {
        return LongStreamEx.of(Arrays.spliterator(elements));
    }

    public static LongStreamEx of(long[] array, int startInclusive, int endExclusive) {
        return LongStreamEx.of(Arrays.spliterator(array, startInclusive, endExclusive));
    }

    public static LongStreamEx of(Long[] array) {
        return LongStreamEx.seq(Arrays.stream(array).mapToLong(Long::longValue));
    }

    public static LongStreamEx of(LongBuffer buf) {
        return IntStreamEx.range(buf.position(), buf.limit()).mapToLong(buf::get);
    }

    public static LongStreamEx of(LongStream stream) {
        return stream instanceof LongStreamEx ? (LongStreamEx)stream : new LongStreamEx(stream, StreamContext.of(stream));
    }

    public static LongStreamEx of(Spliterator.OfLong spliterator) {
        return new LongStreamEx(spliterator, StreamContext.SEQUENTIAL);
    }

    public static LongStreamEx of(PrimitiveIterator.OfLong iterator2) {
        return LongStreamEx.of(new UnknownSizeSpliterator.USOfLong(iterator2));
    }

    public static LongStreamEx of(OptionalLong optional) {
        return optional.isPresent() ? LongStreamEx.of(optional.getAsLong()) : LongStreamEx.empty();
    }

    public static LongStreamEx of(Collection<Long> collection) {
        return LongStreamEx.seq(collection.stream().mapToLong(Long::longValue));
    }

    public static LongStreamEx of(Random random) {
        return LongStreamEx.seq(random.longs());
    }

    public static LongStreamEx of(Random random, long streamSize) {
        return LongStreamEx.seq(random.longs(streamSize));
    }

    public static LongStreamEx of(Random random, long randomNumberOrigin, long randomNumberBound) {
        return LongStreamEx.seq(random.longs(randomNumberOrigin, randomNumberBound));
    }

    public static LongStreamEx of(Random random, long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return LongStreamEx.seq(random.longs(streamSize, randomNumberOrigin, randomNumberBound));
    }

    public static LongStreamEx iterate(long seed, LongUnaryOperator f) {
        return LongStreamEx.iterate(seed, x -> true, f);
    }

    public static LongStreamEx iterate(final long seed, final LongPredicate predicate, final LongUnaryOperator f) {
        Objects.requireNonNull(f);
        Objects.requireNonNull(predicate);
        Spliterators.AbstractLongSpliterator spliterator = new Spliterators.AbstractLongSpliterator(Long.MAX_VALUE, 1296){
            long prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(LongConsumer action) {
                long t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = f.applyAsLong(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!predicate.test(t)) {
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(LongConsumer action) {
                long t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                long l = t = this.started ? f.applyAsLong(this.prev) : seed;
                while (predicate.test(t)) {
                    action.accept(t);
                    t = f.applyAsLong(t);
                }
            }
        };
        return LongStreamEx.of(spliterator);
    }

    public static LongStreamEx generate(LongSupplier s) {
        return LongStreamEx.seq(LongStream.generate(s));
    }

    public static LongStreamEx produce(Predicate<LongConsumer> producer) {
        Internals.Box box = new Internals.Box();
        box.a = action -> producer.test(action) ? (LongEmitter)box.a : null;
        return box.a.stream();
    }

    public static LongStreamEx longs() {
        return LongStreamEx.seq(LongStream.range(0L, Long.MAX_VALUE));
    }

    public static LongStreamEx range(long endExclusive) {
        return LongStreamEx.seq(LongStream.range(0L, endExclusive));
    }

    public static LongStreamEx range(long startInclusive, long endExclusive) {
        return LongStreamEx.seq(LongStream.range(startInclusive, endExclusive));
    }

    public static LongStreamEx range(long startInclusive, long endExclusive, long step) {
        long endInclusive = endExclusive - (long)Long.signum(step);
        if (endInclusive > endExclusive && step > 0L || endInclusive < endExclusive && step < 0L) {
            return LongStreamEx.empty();
        }
        return LongStreamEx.rangeClosed(startInclusive, endInclusive, step);
    }

    public static LongStreamEx rangeClosed(long startInclusive, long endInclusive) {
        return LongStreamEx.seq(LongStream.rangeClosed(startInclusive, endInclusive));
    }

    public static LongStreamEx rangeClosed(long startInclusive, long endInclusive, long step) {
        if (step == 0L) {
            throw new IllegalArgumentException("step = 0");
        }
        if (step == 1L) {
            return LongStreamEx.seq(LongStream.rangeClosed(startInclusive, endInclusive));
        }
        if (step == -1L) {
            long sum = endInclusive + startInclusive;
            return LongStreamEx.seq(LongStream.rangeClosed(endInclusive, startInclusive).map(x -> sum - x));
        }
        if (endInclusive > startInclusive ^ step > 0L || endInclusive == startInclusive) {
            return LongStreamEx.empty();
        }
        long limit = (endInclusive - startInclusive) * (long)Long.signum(step);
        limit = Long.divideUnsigned(limit, Math.abs(step));
        return LongStreamEx.seq(LongStream.rangeClosed(0L, limit).map(x -> x * step + startInclusive));
    }

    public static LongStreamEx constant(long value2, long length) {
        return LongStreamEx.of(new ConstSpliterator.OfLong(value2, length, false));
    }

    public static LongStreamEx zip(long[] first, long[] second, LongBinaryOperator mapper) {
        return LongStreamEx.of(new RangeBasedSpliterator.ZipLong(0, Internals.checkLength(first.length, second.length), mapper, first, second));
    }

    @FunctionalInterface
    public static interface LongEmitter {
        public LongEmitter next(LongConsumer var1);

        default public Spliterator.OfLong spliterator() {
            return new EmitterSpliterator.OfLong(this);
        }

        default public LongStreamEx stream() {
            return LongStreamEx.of(this.spliterator());
        }
    }
}

