/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Function1;
import javaslang.Kind1;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.Value;
import javaslang.collection.Collections;
import javaslang.collection.Iterator;
import javaslang.collection.LinearSeq;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.control.Option;
import javaslang.\u03bb;

public class Queue<T>
implements Kind1<Queue<?>, T>,
LinearSeq<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Queue<?> EMPTY = new Queue(List.empty(), List.empty());
    private final List<T> front;
    private final List<T> rear;

    private Queue(List<T> front, List<T> rear) {
        boolean frontIsEmpty = front.isEmpty();
        this.front = frontIsEmpty ? rear.reverse() : front;
        this.rear = frontIsEmpty ? front : rear;
    }

    public static <T> Collector<T, ArrayList<T>, Queue<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, Queue> finisher = Queue::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Queue<T> empty() {
        return EMPTY;
    }

    public static <T> Queue<T> narrow(Queue<? extends T> queue) {
        return queue;
    }

    public static <T> Queue<T> of(T element2) {
        return Queue.ofAll(List.of(element2));
    }

    @SafeVarargs
    public static <T> Queue<T> of(T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Queue.ofAll(List.of(elements));
    }

    public static <T> Queue<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof Queue) {
            return (Queue)elements;
        }
        if (!elements.iterator().hasNext()) {
            return Queue.empty();
        }
        if (elements instanceof List) {
            return new Queue((List)elements, List.empty());
        }
        return new Queue<T>(List.ofAll(elements), List.empty());
    }

    public static Queue<Boolean> ofAll(boolean[] array) {
        Objects.requireNonNull(array, "array is null");
        return Queue.ofAll(List.ofAll(array));
    }

    public static Queue<Byte> ofAll(byte[] array) {
        Objects.requireNonNull(array, "array is null");
        return Queue.ofAll(List.ofAll(array));
    }

    public static Queue<Character> ofAll(char[] array) {
        Objects.requireNonNull(array, "array is null");
        return Queue.ofAll(List.ofAll(array));
    }

    public static Queue<Double> ofAll(double[] array) {
        Objects.requireNonNull(array, "array is null");
        return Queue.ofAll(List.ofAll(array));
    }

    public static Queue<Float> ofAll(float[] array) {
        Objects.requireNonNull(array, "array is null");
        return Queue.ofAll(List.ofAll(array));
    }

    public static Queue<Integer> ofAll(int[] array) {
        Objects.requireNonNull(array, "array is null");
        return Queue.ofAll(List.ofAll(array));
    }

    public static Queue<Long> ofAll(long[] array) {
        Objects.requireNonNull(array, "array is null");
        return Queue.ofAll(List.ofAll(array));
    }

    public static Queue<Short> ofAll(short[] array) {
        Objects.requireNonNull(array, "array is null");
        return Queue.ofAll(List.ofAll(array));
    }

    public static <T> Queue<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f, Queue.empty(), Queue::of);
    }

    public static <T> Queue<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s, Queue.empty(), Queue::of);
    }

    public static Queue<Character> range(char from2, char toExclusive) {
        return Queue.ofAll(Iterator.range(from2, toExclusive));
    }

    public static Queue<Character> rangeBy(char from2, char toExclusive, int step) {
        return Queue.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static Queue<Double> rangeBy(double from2, double toExclusive, double step) {
        return Queue.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static Queue<Integer> range(int from2, int toExclusive) {
        return Queue.ofAll(Iterator.range(from2, toExclusive));
    }

    public static Queue<Integer> rangeBy(int from2, int toExclusive, int step) {
        return Queue.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static Queue<Long> range(long from2, long toExclusive) {
        return Queue.ofAll(Iterator.range(from2, toExclusive));
    }

    public static Queue<Long> rangeBy(long from2, long toExclusive, long step) {
        return Queue.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static Queue<Character> rangeClosed(char from2, char toInclusive) {
        return Queue.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static Queue<Character> rangeClosedBy(char from2, char toInclusive, int step) {
        return Queue.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static Queue<Double> rangeClosedBy(double from2, double toInclusive, double step) {
        return Queue.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static Queue<Integer> rangeClosed(int from2, int toInclusive) {
        return Queue.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static Queue<Integer> rangeClosedBy(int from2, int toInclusive, int step) {
        return Queue.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static Queue<Long> rangeClosed(long from2, long toInclusive) {
        return Queue.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static Queue<Long> rangeClosedBy(long from2, long toInclusive, long step) {
        return Queue.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public Tuple2<T, Queue<T>> dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("dequeue of empty Queue");
        }
        return Tuple.of(this.head(), this.tail());
    }

    public Option<Tuple2<T, Queue<T>>> dequeueOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.dequeue());
    }

    public Queue<T> enqueue(T element2) {
        return new Queue<T>(this.front, this.rear.prepend((Object)element2));
    }

    public Queue<T> enqueue(T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        LinearSeq<T> temp = this.rear;
        for (T element2 : elements) {
            temp = temp.prepend((Object)element2);
        }
        return new Queue<T>(this.front, temp);
    }

    public Queue<T> enqueueAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        LinearSeq<T> temp = this.rear;
        for (T element2 : elements) {
            temp = temp.prepend((Object)element2);
        }
        return new Queue<T>(this.front, temp);
    }

    public T peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("peek of empty Queue");
        }
        return this.front.head();
    }

    public Option<T> peekOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.peek());
    }

    @Override
    public Queue<T> append(T element2) {
        return this.enqueue(element2);
    }

    @Override
    public Queue<T> appendAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return this.enqueueAll(elements);
    }

    @Override
    public Queue<Queue<T>> combinations() {
        return this.toList().combinations().map(Queue::ofAll).toQueue();
    }

    @Override
    public Queue<Queue<T>> combinations(int k) {
        return this.toList().combinations(k).map(Queue::ofAll).toQueue();
    }

    @Override
    public Iterator<Queue<T>> crossProduct(int power) {
        return Collections.crossProduct(Queue.empty(), this, power);
    }

    @Override
    public Queue<T> distinct() {
        return this.toList().distinct().toQueue();
    }

    @Override
    public Queue<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.toList().distinctBy((Comparator)comparator).toQueue();
    }

    @Override
    public <U> Queue<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return this.toList().distinctBy((Function)keyExtractor).toQueue();
    }

    @Override
    public Queue<T> drop(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return Queue.empty();
        }
        return new Queue<T>(this.front.drop(n), this.rear.dropRight(n - (long)this.front.length()));
    }

    @Override
    public Queue<T> dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return Queue.empty();
        }
        return new Queue<T>(this.front.dropRight(n - (long)this.rear.length()), this.rear.drop(n));
    }

    @Override
    public Queue<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public Queue<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LinearSeq dropped = this.toList().dropWhile((Predicate)predicate);
        return dropped.length() == this.length() ? this : dropped.toQueue();
    }

    @Override
    public Queue<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LinearSeq filtered = this.toList().filter((Predicate)predicate);
        return filtered.length() == this.length() ? this : filtered.toQueue();
    }

    @Override
    public <U> Queue<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return Queue.empty();
        }
        return new Queue<T>(this.front.flatMap(mapper), this.rear.flatMap(mapper));
    }

    @Override
    public T get(int index2) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index2 + ") on empty Queue");
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("get(" + index2 + ")");
        }
        int length = this.front.length();
        if (index2 < length) {
            return this.front.get(index2);
        }
        int rearIndex = index2 - length;
        int rearLength = this.rear.length();
        if (rearIndex < rearLength) {
            int reverseRearIndex = rearLength - rearIndex - 1;
            return this.rear.get(reverseRearIndex);
        }
        throw new IndexOutOfBoundsException(String.format("get(%s) on Queue of length %s", index2, this.length()));
    }

    @Override
    public <C> Map<C, Queue<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return Collections.groupBy(this, classifier, Queue::ofAll);
    }

    @Override
    public Iterator<Queue<T>> grouped(long size) {
        return this.sliding(size, size);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty queue");
        }
        return this.front.head();
    }

    @Override
    public int indexOf(T element2, int from2) {
        int frontIndex = this.front.indexOf(element2, from2);
        if (frontIndex != -1) {
            return frontIndex;
        }
        int rearIndex = this.rear.reverse().indexOf(element2, from2 - this.front.length());
        return rearIndex == -1 ? -1 : rearIndex + this.front.length();
    }

    @Override
    public Queue<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty Queue");
        }
        if (this.rear.isEmpty()) {
            return new Queue<T>(this.front.init(), this.rear);
        }
        return new Queue<T>(this.front, this.rear.tail());
    }

    @Override
    public Option<Queue<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public Queue<T> insert(int index2, T element2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e)");
        }
        int length = this.front.length();
        if (index2 <= length) {
            return new Queue<T>(this.front.insert(index2, (Object)element2), this.rear);
        }
        int rearIndex = index2 - length;
        int rearLength = this.rear.length();
        if (rearIndex <= rearLength) {
            int reverseRearIndex = rearLength - rearIndex;
            return new Queue<T>(this.front, this.rear.insert(reverseRearIndex, (Object)element2));
        }
        throw new IndexOutOfBoundsException(String.format("insert(%s, e) on Queue of length %s", index2, this.length()));
    }

    @Override
    public Queue<T> insertAll(int index2, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("insertAll(" + index2 + ", e)");
        }
        int length = this.front.length();
        if (index2 <= length) {
            return new Queue<T>(this.front.insertAll(index2, (Iterable)elements), this.rear);
        }
        int rearIndex = index2 - length;
        int rearLength = this.rear.length();
        if (rearIndex <= rearLength) {
            int reverseRearIndex = rearLength - rearIndex;
            return new Queue<T>(this.front, this.rear.insertAll(reverseRearIndex, (Iterable)List.ofAll(elements).reverse()));
        }
        throw new IndexOutOfBoundsException(String.format("insertAll(%s, e) on Queue of length %s", index2, this.length()));
    }

    @Override
    public Queue<T> intersperse(T element2) {
        if (this.isEmpty()) {
            return this;
        }
        if (this.rear.isEmpty()) {
            return new Queue<T>(this.front.intersperse((Object)element2), this.rear);
        }
        return new Queue<T>(this.front.intersperse((Object)element2), this.rear.intersperse((Object)element2).append((Object)element2));
    }

    @Override
    public boolean isEmpty() {
        return this.front.isEmpty();
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public int lastIndexOf(T element2, int end) {
        return this.toList().lastIndexOf(element2, end);
    }

    @Override
    public int length() {
        return this.front.length() + this.rear.length();
    }

    @Override
    public <U> Queue<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new Queue<T>(this.front.map(mapper), this.rear.map(mapper));
    }

    @Override
    public Queue<T> padTo(int length, T element2) {
        if (length <= this.length()) {
            return this;
        }
        return this.toList().padTo(length, (Object)element2).toQueue();
    }

    @Override
    public Queue<T> patch(int from2, Iterable<? extends T> that, int replaced) {
        from2 = from2 < 0 ? 0 : from2;
        replaced = replaced < 0 ? 0 : replaced;
        LinearSeq result2 = ((Queue)this.take(from2)).appendAll((Iterable)that);
        result2 = ((Queue)result2).appendAll((Iterable)this.drop(from2 += replaced));
        return result2;
    }

    @Override
    public Tuple2<Queue<T>, Queue<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.toList().partition(predicate).map(Value::toQueue, Value::toQueue);
    }

    @Override
    public Queue<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.head());
        }
        return this;
    }

    @Override
    public Queue<Queue<T>> permutations() {
        return this.toList().permutations().map(Value::toQueue).toQueue();
    }

    @Override
    public Queue<T> prepend(T element2) {
        return new Queue<T>(this.front.prepend((Object)element2), this.rear);
    }

    @Override
    public Queue<T> prependAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return new Queue<T>(this.front.prependAll((Iterable)elements), this.rear);
    }

    @Override
    public Queue<T> remove(T element2) {
        LinearSeq removed = this.toList().remove((Object)element2);
        return removed.length() == this.length() ? this : removed.toQueue();
    }

    @Override
    public Queue<T> removeFirst(Predicate<T> predicate) {
        LinearSeq removed = this.toList().removeFirst((Predicate)predicate);
        return removed.length() == this.length() ? this : removed.toQueue();
    }

    @Override
    public Queue<T> removeLast(Predicate<T> predicate) {
        LinearSeq removed = this.toList().removeLast((Predicate)predicate);
        return removed.length() == this.length() ? this : removed.toQueue();
    }

    @Override
    public Queue<T> removeAt(int index2) {
        return this.toList().removeAt(index2).toQueue();
    }

    @Override
    public Queue<T> removeAll(T element2) {
        LinearSeq newFront = this.front.removeAll((Object)element2);
        LinearSeq newRear = this.rear.removeAll((Object)element2);
        return newFront.length() + newRear.length() == this.length() ? this : new Queue<T>(newFront, newRear);
    }

    @Override
    public Queue<T> removeAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        LinearSeq newFront = this.front.removeAll((Iterable)elements);
        LinearSeq newRear = this.rear.removeAll((Iterable)elements);
        return newFront.length() + newRear.length() == this.length() ? this : new Queue<T>(newFront, newRear);
    }

    @Override
    public Queue<T> replace(T currentElement, T newElement) {
        LinearSeq newFront = this.front.replace((Object)currentElement, (Object)newElement);
        LinearSeq newRear = this.rear.replace((Object)currentElement, (Object)newElement);
        return newFront.size() + newRear.size() == 0 ? Queue.empty() : (newFront == this.front && newRear == this.rear ? this : new Queue<T>(newFront, newRear));
    }

    @Override
    public Queue<T> replaceAll(T currentElement, T newElement) {
        LinearSeq newFront = this.front.replaceAll((Object)currentElement, (Object)newElement);
        LinearSeq newRear = this.rear.replaceAll((Object)currentElement, (Object)newElement);
        return newFront.size() + newRear.size() == 0 ? Queue.empty() : (newFront == this.front && newRear == this.rear ? this : new Queue<T>(newFront, newRear));
    }

    @Override
    public Queue<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        LinearSeq newFront = this.front.retainAll((Iterable)elements);
        LinearSeq newRear = this.rear.retainAll((Iterable)elements);
        return newFront.size() + newRear.size() == 0 ? Queue.empty() : (newFront.size() + newRear.size() == this.size() ? this : new Queue<T>(newFront, newRear));
    }

    @Override
    public Queue<T> reverse() {
        return this.isEmpty() ? this : this.toList().reverse().toQueue();
    }

    @Override
    public Queue<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <U> Queue<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <U> Queue<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        List list = (List)Collections.scanRight(this, zero, operation, List.empty(), List::prepend, Function.identity());
        return Queue.ofAll(list);
    }

    @Override
    public Queue<T> slice(long beginIndex, long endIndex) {
        return this.toList().slice(beginIndex, endIndex).toQueue();
    }

    @Override
    public Iterator<Queue<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    public Iterator<Queue<T>> sliding(long size, long step) {
        return this.iterator().sliding(size, step).map(Queue::ofAll);
    }

    @Override
    public Queue<T> sorted() {
        return this.toList().sorted().toQueue();
    }

    @Override
    public Queue<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.toList().sorted((Comparator)comparator).toQueue();
    }

    @Override
    public <U extends Comparable<? super U>> Queue<T> sortBy(Function<? super T, ? extends U> mapper) {
        return this.sortBy(Comparable::compareTo, (Function)mapper);
    }

    @Override
    public <U> Queue<T> sortBy(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        \u03bb domain = Function1.of(mapper::apply).memoized();
        return this.toJavaStream().sorted((arg_0, arg_1) -> Queue.lambda$sortBy$1(comparator, (Function)((Object)domain), arg_0, arg_1)).collect(Queue.collector());
    }

    @Override
    public Tuple2<Queue<T>, Queue<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.toList().span(predicate).map(Value::toQueue, Value::toQueue);
    }

    @Override
    public Tuple2<Queue<T>, Queue<T>> splitAt(long n) {
        return this.toList().splitAt(n).map(Value::toQueue, Value::toQueue);
    }

    @Override
    public Tuple2<Queue<T>, Queue<T>> splitAt(Predicate<? super T> predicate) {
        return this.toList().splitAt(predicate).map(Value::toQueue, Value::toQueue);
    }

    @Override
    public Tuple2<Queue<T>, Queue<T>> splitAtInclusive(Predicate<? super T> predicate) {
        return this.toList().splitAtInclusive(predicate).map(Value::toQueue, Value::toQueue);
    }

    @Override
    public boolean startsWith(Iterable<? extends T> that, int offset) {
        return this.toList().startsWith(that, offset);
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    public Queue<T> subSequence(int beginIndex) {
        return this.toList().subSequence(beginIndex).toQueue();
    }

    @Override
    public Queue<T> subSequence(int beginIndex, int endIndex) {
        return this.toList().subSequence(beginIndex, endIndex).toQueue();
    }

    @Override
    public Queue<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty Queue");
        }
        return new Queue<T>(this.front.tail(), this.rear);
    }

    @Override
    public Option<Queue<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public Queue<T> take(long n) {
        if (n <= 0L) {
            return Queue.empty();
        }
        if (n >= (long)this.length()) {
            return this;
        }
        int frontLength = this.front.length();
        if (n < (long)frontLength) {
            return new Queue(this.front.take(n), List.empty());
        }
        if (n == (long)frontLength) {
            return new Queue<T>(this.front, List.empty());
        }
        return new Queue<T>(this.front, this.rear.takeRight(n - (long)frontLength));
    }

    @Override
    public Queue<T> takeRight(long n) {
        if (n <= 0L) {
            return Queue.empty();
        }
        if (n >= (long)this.length()) {
            return this;
        }
        int rearLength = this.rear.length();
        if (n < (long)rearLength) {
            return new Queue(this.rear.take(n).reverse(), List.empty());
        }
        if (n == (long)rearLength) {
            return new Queue(this.rear.reverse(), List.empty());
        }
        return new Queue<T>(this.front.takeRight(n - (long)rearLength), this.rear);
    }

    @Override
    public Queue<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    @Override
    public Queue<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LinearSeq taken = this.toList().takeWhile((Predicate)predicate);
        return taken.length() == this.length() ? this : taken.toQueue();
    }

    public <U> U transform(Function<? super Queue<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public <U> Queue<U> unit(Iterable<? extends U> iterable) {
        return Queue.ofAll(iterable);
    }

    @Override
    public <T1, T2> Tuple2<Queue<T1>, Queue<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.toList().unzip(unzipper).map(Value::toQueue, Value::toQueue);
    }

    @Override
    public <T1, T2, T3> Tuple3<Queue<T1>, Queue<T2>, Queue<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.toList().unzip3(unzipper).map(Value::toQueue, Value::toQueue, Value::toQueue);
    }

    @Override
    public Queue<T> update(int index2, T element2) {
        return this.toList().update(index2, (Object)element2).toQueue();
    }

    @Override
    public <U> Queue<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        return this.toList().zip((Iterable)that).toQueue();
    }

    @Override
    public <U> Queue<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return this.toList().zipAll((Iterable)that, (Object)thisElem, (Object)thatElem).toQueue();
    }

    @Override
    public Queue<Tuple2<T, Long>> zipWithIndex() {
        return this.toList().zipWithIndex().toQueue();
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Queue) {
            Queue that = (Queue)o;
            return this.toList().equals(that.toList());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toList().hashCode();
    }

    @Override
    public String stringPrefix() {
        return "Queue";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static /* synthetic */ int lambda$sortBy$1(Comparator comparator, Function domain, Object e1, Object e2) {
        return comparator.compare(domain.apply(e1), domain.apply(e2));
    }
}

