/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImplKt;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\rJ@\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0003J'\u0010\u001a\u001a\u0004\u0018\u0001H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00130\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ&\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00130\u001f\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00130!H\u0016J \u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010 \u001a\u00020\u0007H\u0016J\"\u0010\"\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0014\u0010#\u001a\u00020\u00182\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0012\u0010$\u001a\u00020\r2\b\u0010%\u001a\u0004\u0018\u00010\u0000H\u0007J\u001a\u0010&\u001a\u00020\r2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0(H\u0007J,\u0010)\u001a\u00020\r2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J(\u0010)\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0019\u001a\u00020\u0018H\u0017J\u001e\u00101\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0007J\u001c\u00101\u001a\u00020\r2\f\u00105\u001a\b\u0012\u0004\u0012\u000206032\u0006\u0010\u000f\u001a\u00020\u0010J(\u00107\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J>\u00108\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u0018H\u0007J\u001c\u0010:\u001a\u00020\r2\f\u0010;\u001a\b\u0012\u0004\u0012\u000206032\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010<\u001a\u00020\u0007H\u0016J\u0010\u0010=\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0017J\u001c\u0010>\u001a\u00020\r2\f\u0010;\u001a\b\u0012\u0004\u0012\u000206032\u0006\u0010\u000f\u001a\u00020\u0010J6\u0010?\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010@\u001a\n\u0012\u0006\b\u0000\u0012\u00020B0A2\u000e\u0010C\u001a\n\u0012\u0006\b\u0000\u0012\u00020B0AR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/openapi/extensions/impl/ExtensionsAreaImpl;", "Lcom/intellij/openapi/extensions/ExtensionsArea;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "(Lcom/intellij/openapi/components/ComponentManager;)V", "epTraces", "Ljava/util/HashMap;", "", "", "extensionPoints", "", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "checkThatPointNotDuplicated", "", "pointName", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "clearUserCache", "doRegisterExtensionPoint", "T", "", "name", "extensionClass", "isInterface", "", "dynamic", "findExtensionByClass", "aClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getExtensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPoint;", "extensionPointName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointIfRegistered", "hasExtensionPoint", "notifyAreaReplaced", "newArea", "processExtensionPoints", "consumer", "Ljava/util/function/Consumer;", "registerExtensionPoint", "extensionPoint", "Lcom/intellij/openapi/extensions/BaseExtensionPointName;", "extensionPointBeanClass", "kind", "Lcom/intellij/openapi/extensions/ExtensionPoint$Kind;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "registerExtensionPoints", "extensionPointElements", "", "Lorg/jdom/Element;", "points", "Lcom/intellij/openapi/extensions/ExtensionPointDescriptor;", "registerFakeBeanPoint", "registerPoint", "isDynamic", "resetExtensionPoints", "descriptors", "toString", "unregisterExtensionPoint", "unregisterExtensionPoints", "unregisterExtensions", "priorityListenerCallbacks", "", "Ljava/lang/Runnable;", "listenerCallbacks", "intellij.platform.extensions"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExtensionsAreaImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionsAreaImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionsAreaImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n1855#2,2:323\n*S KotlinDebug\n*F\n+ 1 ExtensionsAreaImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionsAreaImpl\n*L\n136#1:323,2\n*E\n"})
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    @NotNull
    private final ComponentManager componentManager;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public volatile Map<String, ? extends ExtensionPointImpl<?>> extensionPoints;
    @Nullable
    private final HashMap<String, Throwable> epTraces;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        this.componentManager = componentManager;
        this.extensionPoints = MapsKt.emptyMap();
        this.epTraces = null;
    }

    @TestOnly
    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    @TestOnly
    public final void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<? extends Element> extensionPointElements) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter(extensionPointElements, (String)"extensionPointElements");
        for (Element element2 : extensionPointElements) {
            String pointName = element2.getAttributeValue("qualifiedName");
            if (pointName == null) {
                String string2 = element2.getAttributeValue("name");
                if (string2 == null) {
                    RuntimeException runtimeException = this.componentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"createError(...)");
                    throw (Throwable)runtimeException;
                }
                String name2 = string2;
                pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name2;
            }
            String beanClassName = element2.getAttributeValue("beanClass");
            String interfaceClassName = element2.getAttributeValue("interface");
            if (beanClassName == null && interfaceClassName == null) {
                RuntimeException runtimeException = this.componentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"createError(...)");
                throw (Throwable)runtimeException;
            }
            if (beanClassName != null && interfaceClassName != null) {
                RuntimeException runtimeException = this.componentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"createError(...)");
                throw (Throwable)runtimeException;
            }
            boolean dynamic = Boolean.parseBoolean(element2.getAttributeValue("dynamic"));
            String string3 = pointName;
            Intrinsics.checkNotNull((Object)string3);
            String string2 = string3;
            String string4 = interfaceClassName;
            if (string4 == null) {
                string4 = beanClassName;
            }
            string3 = string4;
            Intrinsics.checkNotNull((Object)string3);
            this.doRegisterExtensionPoint(string2, string3, pluginDescriptor, interfaceClassName != null, dynamic);
        }
    }

    public final boolean unregisterExtensions(@NotNull String extensionPointName, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<? super Runnable> priorityListenerCallbacks, @NotNull List<? super Runnable> listenerCallbacks) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter(priorityListenerCallbacks, (String)"priorityListenerCallbacks");
        Intrinsics.checkNotNullParameter(listenerCallbacks, (String)"listenerCallbacks");
        ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(extensionPointName);
        if (extensionPointImpl == null) {
            return false;
        }
        ExtensionPointImpl<?> point = extensionPointImpl;
        point.unregisterExtensions(this.componentManager, pluginDescriptor, priorityListenerCallbacks, listenerCallbacks);
        return true;
    }

    public final void resetExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        for (ExtensionPointDescriptor descriptor2 : descriptors) {
            ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(descriptor2.getQualifiedName(pluginDescriptor));
            if (extensionPointImpl == null) continue;
            extensionPointImpl.reset();
        }
    }

    public final void clearUserCache() {
        Iterable $this$forEach$iv = this.extensionPoints.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtensionPointImpl p0 = (ExtensionPointImpl)element$iv;
            boolean bl = false;
            p0.clearUserCache();
        }
    }

    public final void unregisterExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (descriptors.isEmpty()) {
            return;
        }
        HashMap map = new HashMap(this.extensionPoints);
        for (ExtensionPointDescriptor descriptor2 : descriptors) {
            map.remove(descriptor2.getQualifiedName(pluginDescriptor));
        }
        Map map2 = Collections.unmodifiableMap(map);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        this.extensionPoints = map2;
    }

    @TestOnly
    public final void registerExtensionPoint(@NotNull BaseExtensionPointName<?> extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(extensionPoint, (String)"extensionPoint");
        Intrinsics.checkNotNullParameter((Object)extensionPointBeanClass, (String)"extensionPointBeanClass");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        String extensionPointName = extensionPoint.getName();
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, kind, false);
        Disposer.register(parentDisposable, () -> ExtensionsAreaImpl.registerExtensionPoint$lambda$0(this, extensionPointName));
    }

    @Override
    @TestOnly
    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, boolean dynamic) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        Intrinsics.checkNotNullParameter((Object)extensionPointBeanClass, (String)"extensionPointBeanClass");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("fakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, dynamic);
    }

    @TestOnly
    @NotNull
    public final <T> ExtensionPointImpl<T> registerPoint(@NotNull String name2, @NotNull Class<T> extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isDynamic) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        String string2 = extensionClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return this.doRegisterExtensionPoint(name2, string2, pluginDescriptor, extensionClass.isInterface() || (extensionClass.getModifiers() & 0x400) != 0, isDynamic);
    }

    @TestOnly
    private final <T> ExtensionPointImpl<T> doRegisterExtensionPoint(String name2, String extensionClass, PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        ExtensionPointImpl extensionPointImpl;
        if (isInterface) {
            ComponentManager componentManager = this.componentManager;
            extensionPointImpl = new InterfaceExtensionPoint(name2, extensionClass, pluginDescriptor, componentManager, null, dynamic, false);
        } else {
            extensionPointImpl = new BeanExtensionPoint(name2, extensionClass, pluginDescriptor, this.componentManager, dynamic);
        }
        ExtensionPointImpl point = extensionPointImpl;
        PluginDescriptor pluginDescriptor2 = point.getPluginDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor2, (String)"getPluginDescriptor(...)");
        this.checkThatPointNotDuplicated(name2, pluginDescriptor2);
        HashMap<String, ExtensionPointImpl<Object>> newMap2 = new HashMap<String, ExtensionPointImpl<Object>>(this.extensionPoints.size() + 1);
        newMap2.putAll(this.extensionPoints);
        newMap2.put(name2, point);
        Map map = Collections.unmodifiableMap((Map)newMap2);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        this.extensionPoints = map;
        return point;
    }

    @TestOnly
    @NotNull
    public final <T> ExtensionPointImpl<T> registerFakeBeanPoint(@NotNull String name2, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        String string2 = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return this.doRegisterExtensionPoint(name2, string2, pluginDescriptor, false, false);
    }

    private final void checkThatPointNotDuplicated(String pointName, PluginDescriptor pluginDescriptor) {
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId pluginId = ((ExtensionPointImpl)this.getExtensionPoint(pointName)).getPluginDescriptor().getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        PluginId id1 = pluginId;
        PluginId pluginId2 = pluginDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getPluginId(...)");
        PluginId id2 = pluginId2;
        String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        RuntimeException runtimeException = this.componentManager.createError(message, pluginDescriptor.getPluginId());
        Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"createError(...)");
        throw (Throwable)runtimeException;
    }

    public final void registerExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        HashMap map = new HashMap(this.extensionPoints);
        ExtensionsAreaImplKt.createExtensionPoints(points, this.componentManager, map, pluginDescriptor);
        Map map2 = Collections.unmodifiableMap(map);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        this.extensionPoints = map2;
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        return extensionPoint;
    }

    @Nullable
    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, (String)"extensionPointName");
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @TestOnly
    public final void processExtensionPoints(@NotNull Consumer<ExtensionPointImpl<?>> consumer2) {
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        this.extensionPoints.values().forEach(consumer2);
    }

    @ApiStatus.Internal
    @Nullable
    public final <T> T findExtensionByClass(@NotNull Class<T> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        if (Intrinsics.areEqual((Object)aClass.getName(), (Object)"com.intellij.execution.executors.DefaultDebugExecutor")) {
            ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered("com.intellij.executor");
            return extensionPoint != null ? (T)((ExtensionPointImpl)extensionPoint).findExtension(aClass, false, ThreeState.YES) : null;
        }
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            if (!(point instanceof InterfaceExtensionPoint)) continue;
            try {
                if (!point.getExtensionClass().isAssignableFrom(aClass)) continue;
                T t = point.findExtension(aClass, false, ThreeState.YES);
                if (t == null) continue;
                return t;
            }
            catch (Throwable e) {
                ExtensionsAreaImplKt.access$getLOG().warn("error during findExtensionPointByClass", e);
            }
        }
        return null;
    }

    @Override
    @TestOnly
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint == null) {
            return;
        }
        ExtensionPoint extensionPoint2 = extensionPoint;
        ((ExtensionPointImpl)extensionPoint2).reset();
        HashMap map = new HashMap(this.extensionPoints);
        map.remove(extensionPointName);
        Map map2 = Collections.unmodifiableMap(map);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        this.extensionPoints = map2;
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, (String)"extensionPointName");
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    @NotNull
    public String toString() {
        return this.componentManager.toString();
    }

    private static final void registerExtensionPoint$lambda$0(ExtensionsAreaImpl this$0, String $extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$extensionPointName, (String)"$extensionPointName");
        this$0.unregisterExtensionPoint($extensionPointName);
    }
}

