/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\b\u0086\b\u0018\u0000 n2\u00020\u0001:\u0001nB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0016\u00106\u001a\n 7*\u0004\u0018\u00010\u00030\u00032\u0006\u00108\u001a\u000209J\u0014\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050=J\u000e\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020\u0005J\u000e\u0010@\u001a\n 7*\u0004\u0018\u00010A0AJ\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0005J\u000e\u0010B\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\bCJ\u0013\u0010D\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010E\u001a\u00020;2\u0006\u0010F\u001a\u00020\u0000J\u000e\u0010G\u001a\u00020;2\u0006\u0010H\u001a\u00020\u0005J\u0006\u0010I\u001a\u00020\u001bJ\u0006\u0010J\u001a\u00020\u001bJ\u0006\u0010K\u001a\u00020\u0000J\u0006\u0010L\u001a\u00020;J\u0006\u0010M\u001a\u00020;J\u0013\u0010N\u001a\u00020\u001b2\b\u0010O\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001a\u0010P\u001a\u00020;2\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020;0RJ\b\u0010S\u001a\u00020TH\u0016J$\u0010U\u001a\u00020V2\b\b\u0002\u0010W\u001a\u00020X2\b\b\u0002\u0010Y\u001a\u00020Z2\b\b\u0002\u0010[\u001a\u00020ZJ\u000e\u0010\\\u001a\n 7*\u0004\u0018\u00010\u00030\u0003J\u000e\u0010]\u001a\n 7*\u0004\u0018\u00010^0^J\u001a\u0010_\u001a\u00020;2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020;0RJ\u001a\u0010a\u001a\u00020;2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020;0RJ\u0006\u0010b\u001a\u00020cJ\u000e\u0010d\u001a\n 7*\u0004\u0018\u00010909J\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00050fJ\u000e\u0010g\u001a\u00020\u001b2\u0006\u0010F\u001a\u00020\u0000J\u000e\u0010h\u001a\u00020\u001b2\u0006\u0010i\u001a\u00020\u0000J\b\u0010j\u001a\u00020\u0005H\u0016J\u0016\u0010k\u001a\n 7*\u0004\u0018\u00010\u00030\u00032\u0006\u00108\u001a\u000209J\u0014\u0010l\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050=J\u000e\u0010m\u001a\u00020;2\u0006\u0010?\u001a\u00020\u0005R\u0011\u0010\u000e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u001b\u0010\u0016\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u0011\u0010 \u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0011\u0010$\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001dR\u0011\u0010%\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0014\u0010\f\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00000)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000)8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010+R\u0011\u0010.\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0013R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050)8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010+R\u0011\u0010\u0002\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0013R\u0011\u00103\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0010R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0013\u00a8\u0006o"}, d2={"Lorg/jetbrains/kotlin/konan/file/File;", "", "parent", "Ljava/nio/file/Path;", "child", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;)V", "(Lorg/jetbrains/kotlin/konan/file/File;Lorg/jetbrains/kotlin/konan/file/File;)V", "path", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "javaPath", "(Ljava/nio/file/Path;)V", "absoluteFile", "getAbsoluteFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "canonicalFile", "getCanonicalFile", "canonicalPath", "getCanonicalPath", "canonicalPath$delegate", "Lkotlin/Lazy;", "exists", "", "getExists", "()Z", "extension", "getExtension", "fileKey", "getFileKey", "()Ljava/lang/Object;", "isAbsolute", "isDirectory", "isFile", "getJavaPath$kotlin_util_io", "()Ljava/nio/file/Path;", "listFiles", "", "getListFiles", "()Ljava/util/List;", "listFilesOrEmpty", "getListFilesOrEmpty", "name", "getName", "nameSegments", "getNameSegments", "getParent", "parentFile", "getParentFile", "getPath", "appendBytes", "kotlin.jvm.PlatformType", "bytes", "", "appendLines", "", "lines", "", "appendText", "text", "bufferedReader", "Ljava/io/BufferedReader;", "component1", "component1$kotlin_util_io", "copy", "copyTo", "destination", "createAsSymlink", "target", "createNew", "delete", "deleteOnExit", "deleteOnExitRecursively", "deleteRecursively", "equals", "other", "forEachLine", "action", "Lkotlin/Function1;", "hashCode", "", "map", "Ljava/nio/MappedByteBuffer;", "mode", "Ljava/nio/channels/FileChannel$MapMode;", "start", "", "size", "mkdirs", "outputStream", "Ljava/io/OutputStream;", "postorder", "task", "preorder", "printWriter", "Ljava/io/PrintWriter;", "readBytes", "readStrings", "", "renameTo", "startsWith", "another", "toString", "writeBytes", "writeLines", "writeText", "Companion", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 File.kt\norg/jetbrains/kotlin/konan/file/File\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1557#2:229\n1628#2,3:230\n1557#2:236\n1628#2,3:237\n212#3,3:233\n223#3,2:240\n215#3,7:242\n212#3,13:250\n1#4:249\n*S KotlinDebug\n*F\n+ 1 File.kt\norg/jetbrains/kotlin/konan/file/File\n*L\n42#1:229\n42#1:230,3\n57#1:236\n57#1:237,3\n57#1:233,3\n57#1:240,2\n57#1:242,7\n156#1:250,13\n*E\n"})
public final class File {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path javaPath;
    @NotNull
    private final Lazy canonicalPath$delegate;
    private static final String pathSeparator = java.io.File.pathSeparator;
    private static final String separator = java.io.File.separator;
    private static final char separatorChar = java.io.File.separatorChar;

    public File(@NotNull Path javaPath) {
        Intrinsics.checkNotNullParameter((Object)javaPath, (String)"javaPath");
        this.javaPath = javaPath;
        this.canonicalPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ File this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.getJavaPath$kotlin_util_io().toFile().getCanonicalPath();
            }
        }));
    }

    @NotNull
    public final Path getJavaPath$kotlin_util_io() {
        return this.javaPath;
    }

    public File(@NotNull Path parent2, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path = parent2.resolve(child);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.resolve(child)");
        this(path);
    }

    public File(@NotNull File parent2, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path = parent2.javaPath.resolve(child);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.javaPath.resolve(child)");
        this(path);
    }

    public File(@NotNull File parent2, @NotNull File child) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path = parent2.javaPath.resolve(child.javaPath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.javaPath.resolve(child.javaPath)");
        this(path);
    }

    public File(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        this(path2);
    }

    public File(@NotNull String parent2, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        String[] stringArray = new String[]{child};
        Path path = Paths.get(parent2, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(parent, child)");
        this(path);
    }

    @NotNull
    public final String getPath() {
        return ((Object)this.javaPath).toString();
    }

    @NotNull
    public final String getAbsolutePath() {
        return ((Object)this.javaPath.toAbsolutePath()).toString();
    }

    @NotNull
    public final File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    @NotNull
    public final String getCanonicalPath() {
        Lazy lazy = this.canonicalPath$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-canonicalPath>(...)");
        return (String)object;
    }

    @NotNull
    public final File getCanonicalFile() {
        return new File(this.getCanonicalPath());
    }

    @NotNull
    public final String getName() {
        String string2 = ((Object)this.javaPath.getFileName()).toString();
        String string3 = separator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
        return UtilKt.removeSuffixIfPresent(string2, string3);
    }

    @NotNull
    public final String getExtension() {
        return StringsKt.substringAfterLast((String)this.getName(), (char)'.', (String)"");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getNameSegments() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.javaPath;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)it.getFileName()).toString());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getParent() {
        return ((Object)this.javaPath.getParent()).toString();
    }

    @NotNull
    public final File getParentFile() {
        Path path = this.javaPath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"javaPath.parent");
        return new File(path);
    }

    public final boolean getExists() {
        return Files.exists(this.javaPath, new LinkOption[0]);
    }

    public final boolean isDirectory() {
        return Files.isDirectory(this.javaPath, new LinkOption[0]);
    }

    public final boolean isFile() {
        return Files.isRegularFile(this.javaPath, new LinkOption[0]);
    }

    public final boolean isAbsolute() {
        return this.javaPath.isAbsolute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getListFiles() {
        Iterable stream;
        AutoCloseable $this$use$iv = Files.newDirectoryStream(this.javaPath);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            void $this$mapTo$iv$iv;
            stream = (DirectoryStream)$this$use$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            Iterable $this$map$iv = stream;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new File((Path)p0));
            }
            stream = (List)destination$iv$iv;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return stream;
    }

    @NotNull
    public final List<File> getListFilesOrEmpty() {
        return this.getExists() ? this.getListFiles() : CollectionsKt.emptyList();
    }

    @NotNull
    public final Object getFileKey() {
        Object key = Files.readAttributes(this.javaPath, BasicFileAttributes.class, new LinkOption[0]).fileKey();
        if (key == null) {
            key = this.getCanonicalPath();
        }
        Object object = key;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key");
        return object;
    }

    @NotNull
    public final File child(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new File(this, name2);
    }

    public final boolean startsWith(@NotNull File another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return this.javaPath.startsWith(another.javaPath);
    }

    public final void copyTo(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(this.javaPath, destination.javaPath, copyOptionArray);
    }

    public final boolean renameTo(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.javaPath.toFile().renameTo(destination.javaPath.toFile());
    }

    public final Path mkdirs() {
        return Files.createDirectories(this.javaPath, new FileAttribute[0]);
    }

    public final boolean delete() {
        return Files.deleteIfExists(this.javaPath);
    }

    public final void deleteRecursively() {
        this.postorder((Function1<? super Path, Unit>)((Function1)deleteRecursively.1.INSTANCE));
    }

    public final void deleteOnExitRecursively() {
        this.preorder((Function1<? super Path, Unit>)((Function1)deleteOnExitRecursively.1.INSTANCE));
    }

    public final void preorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1<Path, Unit> $task;
            {
                this.$task = $task;
            }

            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                Path path = file2;
                Intrinsics.checkNotNull((Object)path);
                this.$task.invoke((Object)path);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Path path = dir;
                Intrinsics.checkNotNull((Object)path);
                this.$task.invoke((Object)path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public final void postorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1<Path, Unit> $task;
            {
                this.$task = $task;
            }

            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                Path path = file2;
                Intrinsics.checkNotNull((Object)path);
                this.$task.invoke((Object)path);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                Path path = dir;
                Intrinsics.checkNotNull((Object)path);
                this.$task.invoke((Object)path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @NotNull
    public final MappedByteBuffer map(@NotNull FileChannel.MapMode mode, long start, long size) {
        MappedByteBuffer mappedByteBuffer;
        long l;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        RandomAccessFile file2 = new RandomAccessFile(this.getPath(), Intrinsics.areEqual((Object)mode, (Object)FileChannel.MapMode.READ_ONLY) ? "r" : "rw");
        if (Intrinsics.areEqual((Object)mode, (Object)FileChannel.MapMode.READ_ONLY)) {
            l = file2.length();
        } else {
            boolean bl;
            long l2;
            long it = l2 = size;
            boolean bl2 = false;
            boolean bl3 = bl = size != -1L;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            l = l2;
        }
        long fileSize = l;
        FileChannel channel = file2.getChannel();
        MappedByteBuffer it = mappedByteBuffer = channel.map(mode, start, fileSize);
        boolean bl = false;
        channel.close();
        MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer2, (String)"channel.map(mode, start,\u2026.also { channel.close() }");
        return mappedByteBuffer2;
    }

    public static /* synthetic */ MappedByteBuffer map$default(File file2, FileChannel.MapMode mapMode, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            FileChannel.MapMode mapMode2 = FileChannel.MapMode.READ_ONLY;
            Intrinsics.checkNotNullExpressionValue((Object)mapMode2, (String)"READ_ONLY");
            mapMode = mapMode2;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        return file2.map(mapMode, l, l2);
    }

    @NotNull
    public final File deleteOnExit() {
        this.javaPath.toFile().deleteOnExit();
        return this;
    }

    public final boolean createNew() {
        return this.javaPath.toFile().createNewFile();
    }

    public final byte[] readBytes() {
        return Files.readAllBytes(this.javaPath);
    }

    public final Path writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return Files.write(this.javaPath, bytes, new OpenOption[0]);
    }

    public final Path appendBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        return Files.write(this.javaPath, bytes, openOptionArray);
    }

    public final void writeLines(@NotNull Iterable<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Files.write(this.javaPath, lines, new OpenOption[0]);
    }

    public final void writeText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.writeLines(CollectionsKt.listOf((Object)text));
    }

    public final void appendLines(@NotNull Iterable<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        Files.write(this.javaPath, lines, openOptionArray);
    }

    public final void appendText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.appendLines(CollectionsKt.listOf((Object)text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachLine(@NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable $this$use$iv = Files.lines(this.javaPath);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Stream lines = (Stream)$this$use$iv;
            boolean bl = false;
            lines.forEach(new Consumer(action){
                final /* synthetic */ Function1<String, Unit> $action;
                {
                    this.$action = $action;
                }

                public final void accept(String it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$action.invoke((Object)it);
                }
            });
            lines = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
    }

    public final void createAsSymlink(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path targetPath = Paths.get(target, new String[0]);
        if (Files.isSymbolicLink(this.javaPath) && Intrinsics.areEqual((Object)Files.readSymbolicLink(this.javaPath), (Object)targetPath)) {
            return;
        }
        Files.createSymbolicLink(this.javaPath, targetPath, new FileAttribute[0]);
    }

    @NotNull
    public String toString() {
        return this.getPath();
    }

    public final BufferedReader bufferedReader() {
        return Files.newBufferedReader(this.javaPath);
    }

    public final OutputStream outputStream() {
        return Files.newOutputStream(this.javaPath, new OpenOption[0]);
    }

    @NotNull
    public final PrintWriter printWriter() {
        java.io.File file2 = this.javaPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"javaPath.toFile()");
        java.io.File file3 = file2;
        Charset charset = Charsets.UTF_8;
        java.io.File file4 = file3;
        int n = 8192;
        Object object = file4;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((java.io.File)object), charset);
        return new PrintWriter(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n));
    }

    @NotNull
    public final List<String> readStrings() {
        List list;
        List list2 = list = (List)new ArrayList();
        boolean bl = false;
        this.forEachLine((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((List<String>)list2){
            final /* synthetic */ List<String> $list;
            {
                this.$list = $list;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$list.add(it);
            }
        }));
        return list;
    }

    public boolean equals(@Nullable Object other) {
        File file2 = other instanceof File ? (File)other : null;
        if (file2 == null) {
            return false;
        }
        File otherFile = file2;
        return Intrinsics.areEqual((Object)otherFile.javaPath.toAbsolutePath(), (Object)this.javaPath.toAbsolutePath());
    }

    public int hashCode() {
        return ((Object)this.javaPath.toAbsolutePath()).hashCode();
    }

    @NotNull
    public final Path component1$kotlin_util_io() {
        return this.javaPath;
    }

    @NotNull
    public final File copy(@NotNull Path javaPath) {
        Intrinsics.checkNotNullParameter((Object)javaPath, (String)"javaPath");
        return new File(javaPath);
    }

    public static /* synthetic */ File copy$default(File file2, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = file2.javaPath;
        }
        return file2.copy(path);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/konan/file/File$Companion;", "", "()V", "javaHome", "Lorg/jetbrains/kotlin/konan/file/File;", "getJavaHome", "()Lorg/jetbrains/kotlin/konan/file/File;", "pathSeparator", "", "kotlin.jvm.PlatformType", "getPathSeparator", "()Ljava/lang/String;", "separator", "getSeparator", "separatorChar", "", "getSeparatorChar", "()C", "userDir", "getUserDir", "userHome", "getUserHome", "kotlin-util-io"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getUserDir() {
            String string2 = System.getProperty("user.dir");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"user.dir\")");
            return new File(string2);
        }

        @NotNull
        public final File getUserHome() {
            String string2 = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"user.home\")");
            return new File(string2);
        }

        @NotNull
        public final File getJavaHome() {
            String string2 = System.getProperty("java.home");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"java.home\")");
            return new File(string2);
        }

        public final String getPathSeparator() {
            return pathSeparator;
        }

        public final String getSeparator() {
            return separator;
        }

        public final char getSeparatorChar() {
            return separatorChar;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

