/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\n\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\r\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"doUnify", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "originalTypeProjection", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "typeWithParametersProjection", "targetTypeParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "result", "", "removeQuestionMark", "session", "replaceType", "newType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "providers"})
public final class TypeUnificationKt {
    public static final boolean doUnify(@NotNull FirSession $this$doUnify, @NotNull ConeTypeProjection originalTypeProjection, @NotNull ConeTypeProjection typeWithParametersProjection, @NotNull Set<FirTypeParameterSymbol> targetTypeParameters, @NotNull Map<FirTypeParameterSymbol, ConeTypeProjection> result2) {
        Object object;
        FirTypeParameterSymbol typeParameter;
        Object object2;
        ConeRigidType typeWithParameters;
        Intrinsics.checkNotNullParameter((Object)$this$doUnify, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalTypeProjection, (String)"originalTypeProjection");
        Intrinsics.checkNotNullParameter((Object)typeWithParametersProjection, (String)"typeWithParametersProjection");
        Intrinsics.checkNotNullParameter(targetTypeParameters, (String)"targetTypeParameters");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(originalTypeProjection);
        ConeRigidType originalType = coneKotlinType != null && (coneKotlinType = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType)) != null ? TypeExpansionUtilsKt.fullyExpandedType$default((ConeRigidType)coneKotlinType, $this$doUnify, null, 2, null) : null;
        ConeKotlinType coneKotlinType2 = ConeTypeProjectionKt.getType(typeWithParametersProjection);
        ConeRigidType coneRigidType = coneKotlinType2 != null && (coneKotlinType2 = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType2)) != null ? TypeExpansionUtilsKt.fullyExpandedType$default((ConeRigidType)coneKotlinType2, $this$doUnify, null, 2, null) : (typeWithParameters = null);
        if (typeWithParameters instanceof ConeErrorType) {
            return true;
        }
        if (originalType instanceof ConeIntersectionType) {
            Map intersectionResult = new LinkedHashMap();
            for (ConeKotlinType entry : ((ConeIntersectionType)originalType).getIntersectedTypes()) {
                Map localResult;
                if (!TypeUnificationKt.doUnify($this$doUnify, entry, typeWithParametersProjection, targetTypeParameters, localResult = (Map)new LinkedHashMap())) {
                    return false;
                }
                for (Map.Entry entry2 : localResult.entrySet()) {
                    FirTypeParameterSymbol typeParameter2 = (FirTypeParameterSymbol)entry2.getKey();
                    ConeTypeProjection typeProjection = (ConeTypeProjection)entry2.getValue();
                    ConeTypeProjection existingTypeProjection = (ConeTypeProjection)intersectionResult.get(typeParameter2);
                    if (existingTypeProjection != null && (!(typeProjection instanceof KotlinTypeMarker) || !(existingTypeProjection instanceof KotlinTypeMarker) || !AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext($this$doUnify), (KotlinTypeMarker)((Object)typeProjection), (KotlinTypeMarker)((Object)existingTypeProjection), false, 8, null))) continue;
                    intersectionResult.put(typeParameter2, typeProjection);
                }
            }
            for (Map.Entry entry : intersectionResult.entrySet()) {
                FirTypeParameterSymbol key = (FirTypeParameterSymbol)entry.getKey();
                ConeTypeProjection value2 = (ConeTypeProjection)entry.getValue();
                result2.put(key, value2);
            }
            return true;
        }
        if (originalTypeProjection.getKind() == typeWithParametersProjection.getKind() && originalTypeProjection.getKind() != ProjectionKind.INVARIANT && originalTypeProjection.getKind() != ProjectionKind.STAR) {
            ConeRigidType coneRigidType2 = originalType;
            Intrinsics.checkNotNull((Object)coneRigidType2);
            ConeTypeProjection coneTypeProjection = coneRigidType2;
            ConeRigidType coneRigidType3 = typeWithParameters;
            Intrinsics.checkNotNull((Object)coneRigidType3);
            return TypeUnificationKt.doUnify($this$doUnify, coneTypeProjection, coneRigidType3, targetTypeParameters, result2);
        }
        ConeRigidType coneRigidType4 = originalType;
        if ((coneRigidType4 != null ? coneRigidType4.getNullability() : null) == ConeNullability.NULLABLE) {
            ConeRigidType coneRigidType5 = typeWithParameters;
            if ((coneRigidType5 != null ? coneRigidType5.getNullability() : null) == ConeNullability.NULLABLE) {
                return TypeUnificationKt.doUnify($this$doUnify, TypeUnificationKt.removeQuestionMark(originalTypeProjection, $this$doUnify), TypeUnificationKt.removeQuestionMark(typeWithParametersProjection, $this$doUnify), targetTypeParameters, result2);
            }
        }
        if (originalTypeProjection.getKind() != typeWithParametersProjection.getKind() && typeWithParametersProjection.getKind() != ProjectionKind.INVARIANT) {
            return true;
        }
        if (typeWithParameters instanceof ConeDefinitelyNotNullType) {
            return TypeUnificationKt.doUnify($this$doUnify, originalTypeProjection, TypeUnificationKt.replaceType(typeWithParametersProjection, ((ConeDefinitelyNotNullType)typeWithParameters).getOriginal()), targetTypeParameters, result2);
        }
        if (!(originalTypeProjection instanceof ConeStarProjection)) {
            ConeRigidType coneRigidType6 = originalType;
            if ((coneRigidType6 != null ? coneRigidType6.getNullability() : null) != ConeNullability.NULLABLE) {
                ConeRigidType coneRigidType7 = typeWithParameters;
                if ((coneRigidType7 != null ? coneRigidType7.getNullability() : null) == ConeNullability.NULLABLE) {
                    return true;
                }
            }
        }
        FirTypeParameterSymbol firTypeParameterSymbol = (object2 = typeWithParameters instanceof ConeTypeParameterType ? (ConeTypeParameterType)typeWithParameters : null) != null && (object2 = ((ConeTypeParameterType)object2).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object2).getTypeParameterSymbol() : (typeParameter = null);
        if (typeParameter != null && targetTypeParameters.contains(typeParameter)) {
            if (result2.containsKey(typeParameter) && !Intrinsics.areEqual((Object)result2.get(typeParameter), (Object)originalTypeProjection)) {
                return false;
            }
            result2.put(typeParameter, originalTypeProjection);
            return true;
        }
        Object object3 = originalType;
        if (!Intrinsics.areEqual((Object)(object3 != null && (object3 = ((ConeKotlinType)object3).getNullability()) != null ? Boolean.valueOf(((ConeNullability)((Object)object3)).isNullable()) : null), (object = typeWithParameters) != null && (object = ((ConeKotlinType)object).getNullability()) != null ? Boolean.valueOf(((ConeNullability)((Object)object)).isNullable()) : null)) {
            return true;
        }
        if (originalTypeProjection.getKind() != typeWithParametersProjection.getKind()) {
            return true;
        }
        ConeRigidType coneRigidType8 = originalType;
        ConeRigidType coneRigidType9 = typeWithParameters;
        if (!Intrinsics.areEqual((Object)(coneRigidType8 != null ? ConeTypeUtilsKt.getLookupTagIfAny(coneRigidType8) : null), (Object)(coneRigidType9 != null ? ConeTypeUtilsKt.getLookupTagIfAny(coneRigidType9) : null))) {
            return true;
        }
        if (originalType == null || typeWithParameters == null) {
            return true;
        }
        if (originalType.getTypeArguments().length != typeWithParameters.getTypeArguments().length) {
            return true;
        }
        if (originalType.getTypeArguments().length == 0) {
            return true;
        }
        for (Pair pair : ArraysKt.zip((Object[])originalType.getTypeArguments(), (Object[])typeWithParameters.getTypeArguments())) {
            ConeTypeProjection typeWithParametersArgument;
            ConeTypeProjection originalTypeArgument = (ConeTypeProjection)pair.component1();
            if (TypeUnificationKt.doUnify($this$doUnify, originalTypeArgument, typeWithParametersArgument = (ConeTypeProjection)pair.component2(), targetTypeParameters, result2)) continue;
            return false;
        }
        return true;
    }

    private static final ConeTypeProjection removeQuestionMark(ConeTypeProjection $this$removeQuestionMark, FirSession session) {
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType($this$removeQuestionMark);
        ConeKotlinType type2 = coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType, session, null, 2, null) : null;
        if (!(type2 != null && type2.getNullability().isNullable())) {
            boolean bl = false;
            String string2 = "Expected nullable type, got " + type2;
            throw new IllegalArgumentException(string2.toString());
        }
        return TypeUnificationKt.replaceType($this$removeQuestionMark, TypeUtilsKt.withNullability$default(type2, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(session), null, false, 12, null));
    }

    private static final ConeTypeProjection replaceType(ConeTypeProjection $this$replaceType, ConeKotlinType newType) {
        ConeTypeProjection coneTypeProjection;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$replaceType.getKind().ordinal()]) {
            case 1: {
                coneTypeProjection = newType;
                break;
            }
            case 2: {
                coneTypeProjection = new ConeKotlinTypeProjectionIn(newType);
                break;
            }
            case 3: {
                coneTypeProjection = new ConeKotlinTypeProjectionOut(newType);
                break;
            }
            case 4: {
                throw new IllegalStateException("Should not be a star projection".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneTypeProjection;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

