/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirStarProjectionModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirStarProjectionModifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStarProjectionModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirStarProjectionModifierChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class FirStarProjectionModifierChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final FirStarProjectionModifierChecker INSTANCE = new FirStarProjectionModifierChecker();

    private FirStarProjectionModifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirTypeRef firTypeRef = typeRef.getDelegatedTypeRef();
        FirUserTypeRef firUserTypeRef = firTypeRef instanceof FirUserTypeRef ? (FirUserTypeRef)firTypeRef : null;
        if (firUserTypeRef == null) {
            return;
        }
        FirUserTypeRef delegatedTypeRef = firUserTypeRef;
        for (FirQualifierPart part : delegatedTypeRef.getQualifier()) {
            for (FirTypeProjection typeArgument : part.getTypeArgumentList().getTypeArguments()) {
                FirModifierList modifierList2;
                KtSourceElement source;
                KtSourceElement ktSourceElement;
                if (!(typeArgument instanceof FirStarProjection)) continue;
                KtSourceElement ktSourceElement2 = ((FirStarProjection)typeArgument).getSource();
                if (ktSourceElement2 == null) continue;
                KtSourceElement it = ktSourceElement = ktSourceElement2;
                boolean bl = false;
                ktSourceElement2 = it.getKind() instanceof KtRealSourceElementKind ? ktSourceElement : null;
                if (ktSourceElement2 == null || FirKeywordUtilsKt.getModifierList(source = ktSourceElement2) == null) continue;
                for (FirModifier<?> modifier : modifierList2.getModifiers()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifier.getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)modifier.getToken(), (Object)KotlinTarget.STAR_PROJECTION.getDescription(), (DiagnosticContext)context2, null, 32, null);
                }
            }
        }
    }
}

