/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.components.ClassicTypeSystemContextForCS;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.AlternativeTypeSubstitutionKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/types/TypeApproximator;", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "approximateDeclarationType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "baseType", "Lorg/jetbrains/kotlin/types/KotlinType;", "local", "", "approximateToSuperType", "type", "conf", "Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;", "approximateToSubType", "approximateTo", "toSuperType", "resolution"})
public final class TypeApproximator
extends AbstractTypeApproximator {
    public TypeApproximator(@NotNull KotlinBuiltIns builtIns2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        super(new ClassicTypeSystemContextForCS(builtIns2, KotlinTypeRefiner.Default.INSTANCE), languageVersionSettings);
    }

    @NotNull
    public final UnwrappedType approximateDeclarationType(@NotNull KotlinType baseType, boolean local) {
        TypeApproximatorConfiguration.AllFlexibleSameValue configuration2;
        Intrinsics.checkNotNullParameter((Object)baseType, (String)"baseType");
        if (!this.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return baseType.unwrap();
        }
        UnwrappedType preparedType = local ? baseType.unwrap() : AlternativeTypeSubstitutionKt.substituteAlternativesInPublicType(baseType);
        UnwrappedType unwrappedType = this.approximateToSuperType(preparedType, (TypeApproximatorConfiguration)(configuration2 = local ? (TypeApproximatorConfiguration.AllFlexibleSameValue)TypeApproximatorConfiguration.LocalDeclaration.INSTANCE : (TypeApproximatorConfiguration.AllFlexibleSameValue)TypeApproximatorConfiguration.PublicDeclaration.SaveAnonymousTypes.INSTANCE));
        if (unwrappedType == null) {
            unwrappedType = preparedType;
        }
        return unwrappedType;
    }

    @Nullable
    public final UnwrappedType approximateToSuperType(@NotNull UnwrappedType type2, @NotNull TypeApproximatorConfiguration conf) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return (UnwrappedType)super.approximateToSuperType(type2, conf);
    }

    @Nullable
    public final UnwrappedType approximateToSubType(@NotNull UnwrappedType type2, @NotNull TypeApproximatorConfiguration conf) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return (UnwrappedType)super.approximateToSubType(type2, conf);
    }

    @Nullable
    public final UnwrappedType approximateTo(@NotNull UnwrappedType type2, @NotNull TypeApproximatorConfiguration conf, boolean toSuperType) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        return toSuperType ? this.approximateToSuperType(type2, conf) : this.approximateToSubType(type2, conf);
    }
}

