/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ValueClassDeclarationCheckerKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ValueClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isInapplicableParameterType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "isParameterAcceptableForInlineClass", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "frontend"})
@SourceDebugExtension(value={"SMAP\nValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ValueClassDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1#2:280\n1251#3,2:281\n295#4,2:283\n669#4,11:285\n808#4,11:296\n*S KotlinDebug\n*F\n+ 1 ValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ValueClassDeclarationChecker\n*L\n158#1:281,2\n174#1:283,2\n176#1:285,11\n171#1:296,11\n*E\n"})
public final class ValueClassDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final ValueClassDeclarationChecker INSTANCE = new ValueClassDeclarationChecker();

    private ValueClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block33: {
            Object v11;
            KtNamedFunction typedEquals;
            BindingTrace trace;
            block32: {
                Object v10;
                block31: {
                    boolean bl;
                    PsiElement inlineOrValueKeyword;
                    block30: {
                        PsiElement modalityModifier;
                        PsiElement valueKeyword;
                        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        if (!(declaration2 instanceof KtClass)) {
                            return;
                        }
                        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isInline() && !((ClassDescriptor)descriptor2).isValue()) {
                            return;
                        }
                        if (((ClassDescriptor)descriptor2).getKind() != ClassKind.CLASS) {
                            return;
                        }
                        trace = context2.getTrace();
                        KtModifierList ktModifierList = ((KtClass)declaration2).getModifierList();
                        PsiElement psiElement = valueKeyword = ktModifierList != null ? ktModifierList.getModifier(KtTokens.VALUE_KEYWORD) : null;
                        if (valueKeyword != null && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmInlineValueClasses) && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClasses)) {
                            trace.report(Errors.UNSUPPORTED_FEATURE.on(valueKeyword, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.JvmInlineValueClasses), (Object)context2.getLanguageVersionSettings())));
                            return;
                        }
                        PsiElement psiElement2 = ((KtClass)declaration2).getModifierList();
                        if (psiElement2 == null || (psiElement2 = psiElement2.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
                            psiElement2 = valueKeyword;
                        }
                        if (!((inlineOrValueKeyword = psiElement2) != null)) {
                            boolean $i$a$-require-ValueClassDeclarationChecker$check$22 = false;
                            String $i$a$-require-ValueClassDeclarationChecker$check$22 = "Declaration of inline class must have 'inline' keyword";
                            throw new IllegalArgumentException($i$a$-require-ValueClassDeclarationChecker$check$22.toString());
                        }
                        if (((ClassDescriptor)descriptor2).isInner() || DescriptorUtils.isLocal(descriptor2)) {
                            trace.report(Errors.VALUE_CLASS_NOT_TOP_LEVEL.on(inlineOrValueKeyword));
                            return;
                        }
                        if (!((Collection)((KtClass)declaration2).getContextReceivers()).isEmpty()) {
                            KtContextReceiverList contextReceiverList = ((KtClass)declaration2).getContextReceiverList();
                            if (contextReceiverList == null) {
                                boolean $i$a$-requireNotNull-ValueClassDeclarationChecker$check$32 = false;
                                String $i$a$-requireNotNull-ValueClassDeclarationChecker$check$32 = "Declaration cannot have context receivers with no context receiver list";
                                throw new IllegalArgumentException($i$a$-requireNotNull-ValueClassDeclarationChecker$check$32.toString());
                            }
                            trace.report(Errors.VALUE_CLASS_CANNOT_HAVE_CONTEXT_RECEIVERS.on((KtContextReceiverList)((PsiElement)contextReceiverList)));
                        }
                        if ((modalityModifier = KtPsiUtilKt.modalityModifier(declaration2)) != null && ((ClassDescriptor)descriptor2).getModality() != Modality.FINAL) {
                            trace.report(Errors.VALUE_CLASS_NOT_FINAL.on(modalityModifier));
                            return;
                        }
                        KtPrimaryConstructor primaryConstructor2 = ((KtClass)declaration2).getPrimaryConstructor();
                        if (primaryConstructor2 == null) {
                            trace.report(Errors.ABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS.on(inlineOrValueKeyword));
                            return;
                        }
                        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
                            if (primaryConstructor2.getValueParameters().isEmpty()) {
                                KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
                                KtElementImplStub it = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration2);
                                boolean bl2 = false;
                                trace.report(Errors.VALUE_CLASS_EMPTY_CONSTRUCTOR.on((KtElement)((PsiElement)it)));
                                return;
                            }
                        } else if (primaryConstructor2.getValueParameters().size() != 1) {
                            KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
                            KtElementImplStub it = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration2);
                            boolean bl3 = false;
                            trace.report(Errors.INLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE.on((KtElement)((PsiElement)it)));
                            return;
                        }
                        boolean baseParametersOk = true;
                        SimpleType simpleType = ((ClassDescriptor)descriptor2).getDefaultType();
                        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
                        List<KotlinType> baseParameterTypes = InlineClassesUtilsKt.substitutedUnderlyingTypes(simpleType);
                        for (Pair pair : CollectionsKt.zip((Iterable)primaryConstructor2.getValueParameters(), (Iterable)baseParameterTypes)) {
                            KtParameter baseParameter = (KtParameter)pair.component1();
                            KotlinType baseParameterType = (KotlinType)pair.component2();
                            Intrinsics.checkNotNull((Object)baseParameter);
                            if (!this.isParameterAcceptableForInlineClass(baseParameter)) {
                                trace.report(Errors.VALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER.on((KtParameter)((PsiElement)baseParameter)));
                                baseParametersOk = false;
                                continue;
                            }
                            KtTypeReference baseParameterTypeReference = baseParameter.getTypeReference();
                            if (baseParameterType == null || baseParameterTypeReference == null) continue;
                            if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter) && (TypeUtilsKt.isTypeParameter(baseParameterType) || TypeUtilsKt.isGenericArrayOfTypeParameter(baseParameterType))) {
                                trace.report(Errors.UNSUPPORTED_FEATURE.on(baseParameterTypeReference, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.GenericInlineClassParameter), (Object)context2.getLanguageVersionSettings())));
                                baseParametersOk = false;
                                continue;
                            }
                            if (this.isInapplicableParameterType(baseParameterType)) {
                                trace.report(Errors.VALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE.on((KtTypeReference)((PsiElement)baseParameterTypeReference), baseParameterType));
                                baseParametersOk = false;
                                continue;
                            }
                            if (InlineClassesUtilsKt.isRecursiveInlineOrValueClassType(baseParameterType)) {
                                trace.report(Errors.VALUE_CLASS_CANNOT_BE_RECURSIVE.on((KtTypeReference)((PsiElement)baseParameterTypeReference)));
                                baseParametersOk = false;
                                continue;
                            }
                            if (!InlineClassesUtilsKt.isMultiFieldValueClass(descriptor2) || baseParameter.getDefaultValue() == null) continue;
                            KtExpression ktExpression = baseParameter.getDefaultValue();
                            Intrinsics.checkNotNull((Object)ktExpression);
                            trace.report(Errors.MULTI_FIELD_VALUE_CLASS_PRIMARY_CONSTRUCTOR_DEFAULT_PARAMETER.on((KtExpression)((PsiElement)ktExpression)));
                        }
                        if (!baseParametersOk) {
                            return;
                        }
                        for (KtSuperTypeListEntry supertypeEntry : ((KtClass)declaration2).getSuperTypeListEntries()) {
                            ClassifierDescriptor typeDescriptor;
                            KotlinType type2;
                            Object typeReference;
                            if (supertypeEntry.getTypeReference() == null || (KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) continue;
                            if (supertypeEntry instanceof KtDelegatedSuperTypeEntry) {
                                ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                                KtElement ktElement = ((KtDelegatedSuperTypeEntry)supertypeEntry).getDelegateExpression();
                                BindingContext bindingContext = trace.getBindingContext();
                                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                                if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null || context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClassImplementationByDelegation) && resolvedCall2.getResultingDescriptor() instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getContainingDeclaration(), (Object)trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, primaryConstructor2))) continue;
                                trace.report(Errors.VALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION.on(supertypeEntry));
                                return;
                            }
                            if (type2.getConstructor().getDeclarationDescriptor() == null || DescriptorUtils.isInterface(typeDescriptor)) continue;
                            trace.report(Errors.VALUE_CLASS_CANNOT_EXTEND_CLASSES.on((KtTypeReference)((PsiElement)typeReference)));
                            return;
                        }
                        Sequence<ClassifierDescriptor> $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            ClassifierDescriptor it = (ClassifierDescriptor)element$iv;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)StandardNames.FqNames.cloneable) || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)ValueClassDeclarationCheckerKt.access$getJavaLangCloneable$p()))) continue;
                            bl = true;
                            break block30;
                        }
                        bl = false;
                    }
                    if (bl) {
                        trace.report(Errors.VALUE_CLASS_CANNOT_BE_CLONEABLE.on(inlineOrValueKeyword));
                        return;
                    }
                    if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.CustomEqualsInValueClasses)) break block33;
                    Iterable $this$firstOrNull$iv = ValueClassDeclarationChecker.check$namedFunctions((KtClass)declaration2);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtNamedFunction it = (KtNamedFunction)element$iv;
                        boolean bl5 = false;
                        if (!ValueClassDeclarationChecker.check$isTypedEquals(context2, it)) continue;
                        v10 = element$iv;
                        break block31;
                    }
                    v10 = null;
                }
                typedEquals = v10;
                Iterable $this$singleOrNull$iv = ValueClassDeclarationChecker.check$namedFunctions((KtClass)declaration2);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtNamedFunction it = (KtNamedFunction)element$iv;
                    boolean bl = false;
                    if (!ValueClassDeclarationChecker.check$isUntypedEquals(context2, it)) continue;
                    if (found$iv) {
                        v11 = null;
                        break block32;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v11 = !found$iv ? null : single$iv;
            }
            KtNamedFunction ktNamedFunction = v11;
            if (ktNamedFunction != null) {
                KtNamedFunction ktNamedFunction2;
                KtNamedFunction $this$check_u24lambda_u247 = ktNamedFunction2 = ktNamedFunction;
                boolean bl = false;
                if (typedEquals == null) {
                    PsiElement psiElement = $this$check_u24lambda_u247;
                    SimpleType simpleType = ((ClassDescriptor)descriptor2).getDefaultType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
                    trace.report(Errors.INEFFICIENT_EQUALS_OVERRIDING_IN_VALUE_CLASS.on((KtNamedFunction)psiElement, TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType)));
                }
            }
        }
    }

    private final boolean isInapplicableParameterType(KotlinType $this$isInapplicableParameterType) {
        return TypeUtilsKt.isUnit($this$isInapplicableParameterType) || TypeUtilsKt.isNothing($this$isInapplicableParameterType);
    }

    private final boolean isParameterAcceptableForInlineClass(KtParameter parameter2) {
        UserDataHolder userDataHolder = KtPsiUtilKt.modalityModifier(parameter2);
        boolean isOpen = Intrinsics.areEqual((Object)(userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? userDataHolder.getElementType() : null), (Object)KtTokens.OPEN_KEYWORD);
        return parameter2.hasValOrVar() && !parameter2.isMutable() && !parameter2.isVarArg() && !isOpen;
    }

    private static final SimpleFunctionDescriptor check$getFunctionDescriptor(DeclarationCheckerContext $context, KtNamedFunction declaration2) {
        return (SimpleFunctionDescriptor)$context.getTrace().getBindingContext().get(BindingContext.FUNCTION, declaration2);
    }

    private static final boolean check$isUntypedEquals(DeclarationCheckerContext $context, KtNamedFunction declaration2) {
        SimpleFunctionDescriptor simpleFunctionDescriptor = ValueClassDeclarationChecker.check$getFunctionDescriptor($context, declaration2);
        return simpleFunctionDescriptor != null ? DescriptorUtilKt.overridesEqualsFromAny(simpleFunctionDescriptor) : false;
    }

    private static final boolean check$isTypedEquals(DeclarationCheckerContext $context, KtNamedFunction declaration2) {
        SimpleFunctionDescriptor simpleFunctionDescriptor = ValueClassDeclarationChecker.check$getFunctionDescriptor($context, declaration2);
        return simpleFunctionDescriptor != null ? DescriptorUtilKt.isTypedEqualsInValueClass(simpleFunctionDescriptor) : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtNamedFunction> check$namedFunctions(KtClass $this$check_u24namedFunctions) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$check_u24namedFunctions.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

