/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedParentInImport;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageAndClass;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"findLongestExistingPackage", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageAndClass;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "resolveToPackageOrClass", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "semantics"})
@SourceDebugExtension(value={"SMAP\nImportUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ImportUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1557#2:70\n1628#2,3:71\n*S KotlinDebug\n*F\n+ 1 ImportUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ImportUtilsKt\n*L\n38#1:70\n38#1:71,3\n*E\n"})
public final class ImportUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PackageAndClass findLongestExistingPackage(@NotNull FirSymbolProvider symbolProvider, @NotNull FqName fqName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int prefixSize;
        Intrinsics.checkNotNullParameter((Object)symbolProvider, (String)"symbolProvider");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        FqName currentPackage = fqName;
        List<Name> pathSegments = fqName.pathSegments();
        for (prefixSize = pathSegments.size(); !currentPackage.isRoot() && prefixSize > 0 && !symbolProvider.hasPackage(currentPackage); --prefixSize) {
            currentPackage = currentPackage.parent();
        }
        if (Intrinsics.areEqual((Object)currentPackage, (Object)fqName)) {
            return new PackageAndClass(currentPackage, null);
        }
        Iterable iterable = (Iterable)RangesKt.until((int)prefixSize, (int)pathSegments.size());
        FqName.Companion companion = FqName.Companion;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(pathSegments.get((int)it).asString());
        }
        FqName relativeClassFqName = companion.fromSegments((List)destination$iv$iv);
        return new PackageAndClass(currentPackage, relativeClassFqName);
    }

    @NotNull
    public static final PackageResolutionResult resolveToPackageOrClass(@NotNull FirSymbolProvider symbolProvider, @NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)symbolProvider, (String)"symbolProvider");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        PackageAndClass packageAndClass = ImportUtilsKt.findLongestExistingPackage(symbolProvider, fqName);
        FqName currentPackage = packageAndClass.component1();
        FqName relativeClassFqName = packageAndClass.component2();
        if (relativeClassFqName == null) {
            return new PackageResolutionResult.PackageOrClass(currentPackage, null, null);
        }
        ClassId classId = new ClassId(currentPackage, relativeClassFqName, false);
        return ImportUtilsKt.resolveToPackageOrClass(symbolProvider, classId);
    }

    @NotNull
    public static final PackageResolutionResult resolveToPackageOrClass(@NotNull FirSymbolProvider symbolProvider, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)symbolProvider, (String)"symbolProvider");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(classId);
        if (firClassLikeSymbol == null) {
            return new PackageResolutionResult.Error(new ConeUnresolvedParentInImport(classId));
        }
        FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
        return new PackageResolutionResult.PackageOrClass(classId.getPackageFqName(), classId.getRelativeClassName(), symbol);
    }
}

