/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;

@PhaseDescription(name="ObjectClass")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "pendingTransformations", "", "Lkotlin/Function0;", "", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nObjectClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class ObjectClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final List<Function0<Unit>> pendingTransformations;

    public ObjectClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.pendingTransformations = new ArrayList();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        ClassLoweringPass.super.lower(irFile);
        for (Function0<Unit> transformation : this.pendingTransformations) {
            transformation.invoke();
        }
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Object v0;
        IrField privateInstanceField;
        IrField publicInstanceField;
        block6: {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            if (!IrUtilsKt.isObject(irClass)) {
                return;
            }
            publicInstanceField = this.context.getCachedDeclarations().getFieldForObjectInstance(irClass);
            privateInstanceField = this.context.getCachedDeclarations().getPrivateFieldForObjectInstance(irClass);
            Sequence<IrConstructor> sequence2 = IrUtilsKt.getConstructors(irClass);
            for (Object e : sequence2) {
                IrConstructor it = (IrConstructor)e;
                boolean bl = false;
                if (!it.isPrimary()) continue;
                v0 = e;
                break block6;
            }
            v0 = null;
        }
        IrConstructor irConstructor = v0;
        if (irConstructor == null) {
            throw new AssertionError((Object)("Object should have a primary constructor: " + irClass.getName()));
        }
        IrConstructor constructor = irConstructor;
        if (!Intrinsics.areEqual((Object)privateInstanceField, (Object)publicInstanceField)) {
            DeclarationIrBuilder $this$lower_u24lambda_u241 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)privateInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            privateInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$lower_u24lambda_u241, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$lower_u24lambda_u241, constructor.getSymbol())));
            DeclarationIrBuilder $this$lower_u24lambda_u242 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)publicInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl2 = false;
            publicInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$lower_u24lambda_u242, ExpressionHelpersKt.irGetField$default($this$lower_u24lambda_u242, null, privateInstanceField, null, 4, null)));
            this.pendingTransformations.add((Function0<Unit>)((Function0)() -> ObjectClassLowering.lower$lambda$3(privateInstanceField)));
        } else {
            DeclarationIrBuilder $this$lower_u24lambda_u244 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)publicInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            publicInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$lower_u24lambda_u244, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$lower_u24lambda_u244, constructor.getSymbol())));
        }
        if (!this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperVisibilityForCompanionObjectInstanceField) && (Intrinsics.areEqual((Object)irClass.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) || Intrinsics.areEqual((Object)irClass.getVisibility(), (Object)DescriptorVisibilities.PROTECTED))) {
            JvmIrBuilder $this$lower_u24lambda_u245 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, irClass.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            publicInstanceField.setAnnotations(CollectionsKt.plus((Collection)AdditionalIrUtilsKt.filterOutAnnotations(DeprecationResolver.Companion.getJAVA_DEPRECATED(), publicInstanceField.getAnnotations()), (Object)ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$lower_u24lambda_u245, $this$lower_u24lambda_u245.getIrSymbols().getJavaLangDeprecatedConstructorWithDeprecatedFlag())));
        }
        this.pendingTransformations.add((Function0<Unit>)((Function0)() -> ObjectClassLowering.lower$lambda$6(publicInstanceField)));
    }

    private static final Unit lower$lambda$3(IrField $privateInstanceField) {
        IrDeclarationParent irDeclarationParent = $privateInstanceField.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
        ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(0, $privateInstanceField);
        return Unit.INSTANCE;
    }

    private static final Unit lower$lambda$6(IrField $publicInstanceField) {
        IrDeclarationParent irDeclarationParent = $publicInstanceField.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
        ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(0, $publicInstanceField);
        return Unit.INSTANCE;
    }
}

