/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DefaultParameterInjector;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmDefaultArgumentFunctionFactory;
import org.jetbrains.kotlin.backend.jvm.lower.JvmInlineCallableReferenceToLambdaPhase;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@PhaseDescription(name="DefaultParameterInjector", prerequisite={FunctionReferenceLowering.class, JvmInlineCallableReferenceToLambdaPhase.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J*\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmDefaultParameterInjector;", "Lorg/jetbrains/kotlin/backend/common/lower/DefaultParameterInjector;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "context", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "nullConst", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "irParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "defaultArgumentStubVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "useConstructorMarker", "", "isStatic", "argumentsForCall", "", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "stubFunction", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmDefaultParameterInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDefaultParameterInjector.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmDefaultParameterInjector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n827#2:110\n855#2,2:111\n1567#2:114\n1598#2,4:115\n827#2:119\n855#2,2:120\n1187#2,2:122\n1261#2,4:124\n827#2:128\n855#2,2:129\n1#3:113\n*S KotlinDebug\n*F\n+ 1 JvmDefaultParameterInjector.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmDefaultParameterInjector\n*L\n64#1:110\n64#1:111,2\n70#1:114\n70#1:115,4\n73#1:119\n73#1:120,2\n73#1:122,2\n73#1:124,4\n98#1:128\n98#1:129,2\n*E\n"})
public final class JvmDefaultParameterInjector
extends DefaultParameterInjector<JvmBackendContext> {
    public JvmDefaultParameterInjector(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, new JvmDefaultArgumentFunctionFactory(context2), false, false, false, 16, null);
    }

    @Override
    @Nullable
    protected IrExpression nullConst(int startOffset, int endOffset, @NotNull IrValueParameter irParameter) {
        Intrinsics.checkNotNullParameter((Object)irParameter, (String)"irParameter");
        return this.nullConst(startOffset, endOffset, irParameter.getType());
    }

    @Override
    @NotNull
    protected IrExpression nullConst(int startOffset, int endOffset, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return JvmIrTypeUtilsKt.defaultValue(type2, startOffset, endOffset, (JvmBackendContext)this.getContext());
    }

    @Override
    @NotNull
    protected DescriptorVisibility defaultArgumentStubVisibility(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return JvmIrUtilsKt.getJvmVisibilityOfDefaultArgumentStub(function2);
    }

    @Override
    protected boolean useConstructorMarker(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2 instanceof IrConstructor || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_INLINE_CLASS_CONSTRUCTOR()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_MULTI_FIELD_VALUE_CLASS_CONSTRUCTOR());
    }

    @Override
    protected boolean isStatic(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_INLINE_CLASS_REPLACEMENT()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_MULTI_FIELD_VALUE_CLASS_REPLACEMENT());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Map<IrValueParameter, IrExpression> argumentsForCall(@NotNull IrBlockBuilder $this$argumentsForCall, @NotNull IrFunctionAccessExpression expression2, @NotNull IrFunction stubFunction) {
        void $this$filterNotTo$iv$iv;
        Map map;
        void $this$associateTo$iv$iv;
        void $this$filterNotTo$iv$iv2;
        Iterable $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        IrValueParameter it;
        Object it2;
        Map $this$filterNotTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)$this$argumentsForCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)stubFunction, (String)"stubFunction");
        int startOffset = expression2.getStartOffset();
        int endOffset = expression2.getEndOffset();
        IrFunction declaration2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        Iterable $this$filterNot$iv = declaration2.getValueParameters();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            it2 = (IrValueParameter)element$iv$iv;
            boolean bl4 = false;
            if (this.isMovedReceiver((IrValueParameter)it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int realArgumentsNumber = ((List)destination$iv$iv).size();
        int[] maskValues = new int[(realArgumentsNumber + 31) / 32];
        Map $this$argumentsForCall_u24lambda_u244 = $this$filterNotTo$iv$iv3 = MapsKt.createMapBuilder();
        boolean bl = false;
        IrValueParameter irValueParameter = declaration2.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            it = irValueParameter;
            boolean bl2 = false;
            $this$argumentsForCall_u24lambda_u244.put(it, expression2.getDispatchReceiver());
        }
        IrValueParameter irValueParameter2 = declaration2.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            it = irValueParameter2;
            boolean bl3 = false;
            $this$argumentsForCall_u24lambda_u244.put(it, expression2.getExtensionReceiver());
        }
        it2 = declaration2.getValueParameters();
        Map bl4 = $this$argumentsForCall_u24lambda_u244;
        boolean $i$f$mapIndexed = false;
        it = $this$mapIndexed$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void parameter2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv2;
            boolean bl5 = false;
            collection.add(TuplesKt.to((Object)parameter2, (Object)expression2.getValueArgument((int)index2)));
        }
        MapsKt.putAll((Map)bl4, (Iterable)((List)destination$iv$iv2));
        Map oldArguments = MapsKt.build((Map)$this$filterNotTo$iv$iv3);
        Iterable $this$filterNot$iv2 = declaration2.getValueParameters();
        boolean $i$f$filterNot2 = false;
        $this$mapIndexedTo$iv$iv = $this$filterNot$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            IrValueParameter it3 = (IrValueParameter)element$iv$iv;
            boolean bl6 = false;
            if (this.isMovedReceiver(it3)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv2));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl6 = destination$iv$iv3;
            IndexedValue it4 = (IndexedValue)element$iv$iv;
            boolean bl7 = false;
            Pair pair = TuplesKt.to((Object)it4.getValue(), (Object)it4.getIndex());
            bl6.put(pair.getFirst(), pair.getSecond());
        }
        Map indexes = destination$iv$iv3;
        Map<IrValueParameter, IrExpression> mainArguments = ((JvmBackendContext)this.getContext()).getMultiFieldValueClassReplacements().mapFunctionMfvcStructures($this$argumentsForCall, stubFunction, declaration2, (Function2<? super IrValueParameter, ? super IrType, ? extends IrExpression>)((Function2)(arg_0, arg_1) -> JvmDefaultParameterInjector.argumentsForCall$lambda$7(oldArguments, indexes, maskValues, expression2, this, startOffset, endOffset, arg_0, arg_1)));
        Object[] objectArray = new Integer[]{0, 1};
        boolean bl8 = CollectionsKt.listOf((Object[])objectArray).contains(IrUtilsKt.getExplicitParametersCount(stubFunction) - mainArguments.size() - maskValues.length);
        if (_Assertions.ENABLED && !bl8) {
            boolean $i$a$-assert-JvmDefaultParameterInjector$argumentsForCall$22 = false;
            String $i$a$-assert-JvmDefaultParameterInjector$argumentsForCall$22 = "argument count mismatch: expected " + realArgumentsNumber + " arguments + " + maskValues.length + " masks + optional handler/marker, got " + IrUtilsKt.getExplicitParametersCount(stubFunction) + " total in " + RenderIrElementKt.render$default(stubFunction, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-JvmDefaultParameterInjector$argumentsForCall$22);
        }
        Map $this$argumentsForCall_u24lambda_u2410 = map = MapsKt.createMapBuilder();
        boolean bl9 = false;
        $this$argumentsForCall_u24lambda_u2410.putAll(mainArguments);
        Iterable $this$filterNot$iv3 = stubFunction.getValueParameters();
        boolean $i$f$filterNot3 = false;
        Object element$iv$iv = $this$filterNot$iv3;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterNotTo3 = false;
        for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
            IrValueParameter it5 = (IrValueParameter)element$iv$iv2;
            boolean bl10 = false;
            if (mainArguments.containsKey(it5)) continue;
            destination$iv$iv4.add(element$iv$iv2);
        }
        List restParameters = (List)destination$iv$iv4;
        for (Pair pair : CollectionsKt.zip((Iterable)restParameters, (Iterable)ArraysKt.asList((int[])maskValues))) {
            IrValueParameter maskParameter = (IrValueParameter)pair.component1();
            int maskValue = ((Number)pair.component2()).intValue();
            $this$argumentsForCall_u24lambda_u2410.put(maskParameter, IrConstImpl.Companion.int(startOffset, endOffset, maskParameter.getType(), maskValue));
        }
        if (restParameters.size() > maskValues.length) {
            IrValueParameter lastParameter = (IrValueParameter)CollectionsKt.last((List)restParameters);
            $this$argumentsForCall_u24lambda_u2410.put(lastParameter, IrConstImpl.Companion.constNull(startOffset, endOffset, lastParameter.getType()));
        }
        return MapsKt.build((Map)map);
    }

    private static final IrExpression argumentsForCall$lambda$7(Map $oldArguments, Map $indexes, int[] $maskValues, IrFunctionAccessExpression $expression, JvmDefaultParameterInjector this$0, int $startOffset, int $endOffset, IrValueParameter sourceParameter, IrType targetParameterType) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)sourceParameter, (String)"sourceParameter");
        Intrinsics.checkNotNullParameter((Object)targetParameterType, (String)"targetParameterType");
        IrExpression valueArgument = (IrExpression)$oldArguments.get(sourceParameter);
        if (valueArgument == null) {
            Object v = $indexes.get(sourceParameter);
            Intrinsics.checkNotNull(v);
            int index2 = ((Number)v).intValue();
            $maskValues[index2 / 32] = $maskValues[index2 / 32] | 1 << index2 % 32;
        }
        if ((irExpression = valueArgument) == null) {
            irExpression = new IrCompositeImpl($expression.getStartOffset(), $expression.getEndOffset(), targetParameterType, IrStatementOrigin.Companion.getDEFAULT_VALUE(), CollectionsKt.listOf((Object)this$0.nullConst($startOffset, $endOffset, targetParameterType)));
        }
        return irExpression;
    }
}

