/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.resolve.checkers.ConstApplicability;
import org.jetbrains.kotlin.resolve.checkers.ConstModifierCheckerKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ConstModifierChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "canBeConst", "", "constModifierPsiElement", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "checkCanBeConst", "Lorg/jetbrains/kotlin/resolve/checkers/ConstApplicability;", "frontend"})
public final class ConstModifierChecker
implements DeclarationChecker {
    @NotNull
    public static final ConstModifierChecker INSTANCE = new ConstModifierChecker();

    private ConstModifierChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof VariableDescriptor) || !declaration2.hasModifier(KtTokens.CONST_KEYWORD)) {
            return;
        }
        KtModifierList ktModifierList = declaration2.getModifierList();
        Intrinsics.checkNotNull((Object)ktModifierList);
        PsiElement psiElement = ktModifierList.getModifier(KtTokens.CONST_KEYWORD);
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement constModifierPsiElement = psiElement;
        Diagnostic diagnostic = this.checkCanBeConst(declaration2, constModifierPsiElement, (VariableDescriptor)descriptor2).getDiagnostic();
        if (diagnostic != null) {
            context2.getTrace().report(diagnostic);
        }
    }

    public final boolean canBeConst(@NotNull KtDeclaration declaration2, @NotNull PsiElement constModifierPsiElement, @NotNull VariableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)constModifierPsiElement, (String)"constModifierPsiElement");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.checkCanBeConst(declaration2, constModifierPsiElement, descriptor2).getCanBeConst();
    }

    private final ConstApplicability checkCanBeConst(KtDeclaration declaration2, PsiElement constModifierPsiElement, VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.WRONG_MODIFIER_TARGET.on(constModifierPsiElement, KtTokens.CONST_KEYWORD, "vars");
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() != ClassKind.OBJECT) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_NOT_TOP_LEVEL_OR_OBJECT.on(constModifierPsiElement);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        if (!(declaration2 instanceof KtProperty) || !(descriptor2 instanceof PropertyDescriptor)) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        if (((KtProperty)declaration2).hasDelegate()) {
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration2).getDelegate();
            Intrinsics.checkNotNull((Object)ktPropertyDelegate);
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITH_DELEGATE.on(ktPropertyDelegate);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        KtPropertyAccessor getter2 = ((KtProperty)declaration2).getGetter();
        PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
        Intrinsics.checkNotNull((Object)propertyGetterDescriptor);
        if (!propertyGetterDescriptor.isDefault() && getter2 != null) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITH_GETTER.on(getter2);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        if (KotlinTypeKt.isError(kotlinType)) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        KotlinType kotlinType2 = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        if (!ConstUtilKt.canBeUsedForConstVal(kotlinType2)) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.TYPE_CANT_BE_USED_FOR_CONST_VAL.on(constModifierPsiElement, ((PropertyDescriptor)descriptor2).getType());
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        if (((KtProperty)declaration2).getInitializer() == null) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITHOUT_INITIALIZER.on(constModifierPsiElement);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        if (((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null) {
            KtExpression ktExpression = ((KtProperty)declaration2).getInitializer();
            Intrinsics.checkNotNull((Object)ktExpression);
            SimpleDiagnostic<KtExpression> simpleDiagnostic = Errors.CONST_VAL_WITH_NON_CONST_INITIALIZER.on((KtExpression)((PsiElement)ktExpression));
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        return ConstApplicability.Applicable.INSTANCE;
    }
}

