/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.caches;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.BuiltInWithDifferentJvmName;
import org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethods;
import org.jetbrains.kotlin.backend.common.lower.SpecialMethodWithDefaultInfo;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.SpecialBridge;
import org.jetbrains.kotlin.backend.jvm.caches.BridgeLoweringCacheKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/caches/BridgeLoweringCache;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "specialBridgeMethods", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "computeJvmMethod", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canHaveSpecialBridge", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "computeSpecialBridge", "Lorg/jetbrains/kotlin/backend/jvm/SpecialBridge;", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nBridgeLoweringCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeLoweringCache.kt\norg/jetbrains/kotlin/backend/jvm/caches/BridgeLoweringCache\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,123:1\n395#2,3:124\n1755#3,3:127\n1567#3:130\n1598#3,4:131\n1557#3:139\n1628#3,3:140\n237#4,4:135\n*S KotlinDebug\n*F\n+ 1 BridgeLoweringCache.kt\norg/jetbrains/kotlin/backend/jvm/caches/BridgeLoweringCache\n*L\n31#1:124,3\n40#1:127,3\n84#1:130\n84#1:131,4\n94#1:139\n94#1:140,3\n88#1:135,4\n*E\n"})
public final class BridgeLoweringCache {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final SpecialBridgeMethods specialBridgeMethods;

    public BridgeLoweringCache(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.specialBridgeMethods = new SpecialBridgeMethods(this.context);
    }

    @NotNull
    public final Method computeJvmMethod(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(function2){

            public Object get() {
                return BridgeLoweringCacheKt.access$getCachedJvmSignature((IrFunction)this.receiver);
            }

            public void set(Object value2) {
                BridgeLoweringCacheKt.access$setCachedJvmSignature((IrFunction)this.receiver, (Method)value2);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            Method method;
            boolean bl = false;
            Method it$iv = method = this.context.getDefaultMethodSignatureMapper().mapAsmMethod(function2);
            boolean bl2 = false;
            $this$getOrSetIfNull$iv.set((Object)it$iv);
            object = method;
        }
        return (Method)object;
    }

    private final boolean canHaveSpecialBridge(IrSimpleFunction function2) {
        boolean bl;
        block4: {
            if (this.specialBridgeMethods.getSpecialMethodNames().contains(function2.getName())) {
                return true;
            }
            String string2 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String functionName = string2;
            Iterable $this$any$iv = this.specialBridgeMethods.getSpecialMethodNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String specialMethodNameString;
                    Name it = (Name)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.asString(), (String)"asString(...)");
                    int specialMethodNameLength = specialMethodNameString.length();
                    if (!(StringsKt.startsWith$default((String)functionName, (String)specialMethodNameString, (boolean)false, (int)2, null) && functionName.length() > specialMethodNameLength && functionName.charAt(specialMethodNameLength) == '-')) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SpecialBridge computeSpecialBridge(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        IrPropertySymbol correspondingProperty = function2.getCorrespondingPropertySymbol();
        if (correspondingProperty != null ? !this.specialBridgeMethods.getSpecialPropertyNames().contains(((IrProperty)correspondingProperty.getOwner()).getName()) : !this.canHaveSpecialBridge(function2)) {
            return null;
        }
        SpecialMethodWithDefaultInfo specialMethodInfo = this.specialBridgeMethods.getSpecialMethodInfo(function2);
        if (specialMethodInfo != null) {
            return new SpecialBridge(function2, this.computeJvmMethod(function2), specialMethodInfo.getNeedsGenericSignature(), null, null, specialMethodInfo, null, false, false, false, specialMethodInfo.getNeedsUnsubstitutedBridge(), null, 3032, null);
        }
        BuiltInWithDifferentJvmName specialBuiltInInfo = this.specialBridgeMethods.getBuiltInWithDifferentJvmName(function2);
        if (specialBuiltInInfo != null) {
            return new SpecialBridge(function2, this.computeJvmMethod(function2), specialBuiltInInfo.getNeedsGenericSignature(), null, null, null, null, false, false, specialBuiltInInfo.isOverriding(), false, null, 3576, null);
        }
        for (IrSimpleFunctionSymbol overridden : function2.getOverriddenSymbols()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object item$iv$iv2;
            void $this$mapIndexedTo$iv$iv;
            SpecialBridge specialBridge = this.computeSpecialBridge((IrSimpleFunction)overridden.getOwner());
            if (specialBridge == null) continue;
            SpecialBridge specialBridge2 = specialBridge;
            if (!specialBridge2.getNeedsGenericSignature()) {
                return specialBridge2;
            }
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = specialBridge2.getMethodInfo();
            int erasedParameterCount = specialMethodWithDefaultInfo != null ? specialMethodWithDefaultInfo.getArgumentsToCheck() : 0;
            Iterable $this$mapIndexed$iv = function2.getValueParameters();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void param;
                void index2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(index2 < erasedParameterCount ? this.context.getIrBuiltIns().getAnyNType() : param.getType());
            }
            List substitutedParameterTypes = (List)destination$iv$iv;
            Object $this$buildFun$iv = this.context.getIrFactory();
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
            IrFunctionBuilder $this$computeSpecialBridge_u24lambda_u243 = $this$buildFun_u24lambda_u2420$iv;
            boolean bl = false;
            $this$computeSpecialBridge_u24lambda_u243.updateFrom(specialBridge2.getOverridden());
            Name name2 = Name.identifier(specialBridge2.getSignature().getName());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            $this$computeSpecialBridge_u24lambda_u243.setName(name2);
            $this$computeSpecialBridge_u24lambda_u243.setReturnType(function2.getReturnType());
            Object $this$computeSpecialBridge_u24lambda_u245 = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
            boolean bl2 = false;
            Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = CollectionsKt.zip((Iterable)function2.getValueParameters(), (Iterable)substitutedParameterTypes);
            Object object = $this$computeSpecialBridge_u24lambda_u245;
            boolean $i$f$map = false;
            item$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv3;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                IrValueParameter param = (IrValueParameter)pair.component1();
                IrType type2 = (IrType)pair.component2();
                collection.add(IrUtilsKt.copyTo$default(param, (IrFunction)$this$computeSpecialBridge_u24lambda_u245, IrDeclarationOrigin.Companion.getBRIDGE(), 0, 0, null, null, type2, null, null, false, false, false, 4028, null));
            }
            ((IrFunction)object).setValueParameters((List)destination$iv$iv2);
            ((IrSimpleFunction)$this$computeSpecialBridge_u24lambda_u245).setOverriddenSymbols(CollectionsKt.listOf((Object)specialBridge2.getOverridden().getSymbol()));
            ((IrDeclarationBase)$this$computeSpecialBridge_u24lambda_u245).setParent(function2.getParent());
            Object substitutedOverride = $this$buildFun$iv;
            Method substitutedOverrideSignature = this.computeJvmMethod((IrFunction)substitutedOverride);
            SpecialBridge unsubstitutedSpecialBridge = specialBridge2.getUnsubstitutedSpecialBridge() != null ? specialBridge2.getUnsubstitutedSpecialBridge() : (specialBridge2.getNeedsUnsubstitutedBridge() && !Intrinsics.areEqual((Object)specialBridge2.getSignature(), (Object)substitutedOverrideSignature) ? SpecialBridge.copy$default(specialBridge2, null, null, false, null, null, null, null, false, true, false, false, null, 3839, null) : null);
            return SpecialBridge.copy$default(specialBridge2, null, substitutedOverrideSignature, false, substitutedParameterTypes, function2.getReturnType(), null, null, false, false, false, false, unsubstitutedSpecialBridge, 2021, null);
        }
        return null;
    }
}

