/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationTopics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0086\b\u00f8\u0001\u0000J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationEventPublisher;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "invalidatedModules", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "collectSessionsAndPublishInvalidationEvent", "", "action", "Lkotlin/Function0;", "collectSession", "session", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Companion", "low-level-api-fir"})
public final class LLFirSessionInvalidationEventPublisher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Set<KaModule> invalidatedModules;

    public LLFirSessionInvalidationEventPublisher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collectSessionsAndPublishInvalidationEvent(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$collectSessionsAndPublishInvalidationEvent = false;
        if (!(this.invalidatedModules == null)) {
            boolean bl = false;
            String string2 = "The set of invalidated modules should be `null` when `collectSessionsAndPublishInvalidationEvent` has just been called.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.invalidatedModules = new LinkedHashSet();
        try {
            action.invoke();
            Set set = this.invalidatedModules;
            boolean bl = set != null ? !((Collection)set).isEmpty() : false;
            if (bl) {
                Set set2 = this.invalidatedModules;
                Intrinsics.checkNotNull((Object)set2);
                KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(LLFirSessionInvalidationTopics.INSTANCE.getSESSION_INVALIDATION()).afterInvalidation(set2);
            }
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.invalidatedModules = null;
            InlineMarker.finallyEnd((int)1);
        }
    }

    public final void collectSession(@NotNull LLFirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Set<KaModule> set = this.invalidatedModules;
        if (set == null) {
            return;
        }
        Set<KaModule> invalidatedModules = set;
        KaModule ktModule = session.getKtModule();
        if (ktModule instanceof KaDanglingFileModule && !KaModuleKt.isStable((KaDanglingFileModule)ktModule)) {
            return;
        }
        invalidatedModules.add(ktModule);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationEventPublisher$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationEventPublisher;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionInvalidationEventPublisher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LLFirSessionInvalidationEventPublisher lLFirSessionInvalidationEventPublisher = project.getService(LLFirSessionInvalidationEventPublisher.class);
            Intrinsics.checkNotNullExpressionValue((Object)lLFirSessionInvalidationEventPublisher, (String)"getService(...)");
            return lLFirSessionInvalidationEventPublisher;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

