/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtilRt;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtil {
    private ClassUtil() {
    }

    @NotNull
    public static Class<?> getRawType(@NotNull Type type2) {
        if (type2 == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(1);
            }
            return clazz;
        }
        if (type2 instanceof ParameterizedType) {
            return ClassUtil.getRawType(((ParameterizedType)type2).getRawType());
        }
        if (type2 instanceof GenericArrayType) {
            Class<?> clazz = Array.newInstance(ClassUtil.getRawType(((GenericArrayType)type2).getGenericComponentType()), 0).getClass();
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(2);
            }
            return clazz;
        }
        assert (false) : type2;
        if (null == null) {
            ClassUtil.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public static Class<?> typeToClass(@NotNull Type type2) {
        if (type2 == null) {
            ClassUtil.$$$reportNull$$$0(4);
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(5);
            }
            return clazz;
        }
        if (type2 instanceof TypeVariable) {
            Type bound = ((TypeVariable)type2).getBounds()[0];
            Class clazz = bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(6);
            }
            return clazz;
        }
        if (type2 instanceof WildcardType) {
            Class clazz = (Class)((WildcardType)type2).getUpperBounds()[0];
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(7);
            }
            return clazz;
        }
        Class clazz = (Class)((ParameterizedType)type2).getRawType();
        if (clazz == null) {
            ClassUtil.$$$reportNull$$$0(8);
        }
        return clazz;
    }

    public static boolean isPrimitive(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(9);
        }
        return aClass.isPrimitive() || aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass.isEnum() || Date.class.isAssignableFrom(aClass);
    }

    public static boolean isMutableCollection(@NotNull Object object) {
        if (object == null) {
            ClassUtil.$$$reportNull$$$0(10);
        }
        if (object == Collections.emptyList() || object == Collections.emptySet()) {
            return false;
        }
        if (object instanceof Collection) {
            Class<?> aClass = object.getClass();
            String simpleName2 = aClass.getSimpleName();
            if (simpleName2.equals("EmptyList") || simpleName2.startsWith("Unmodifiable") || simpleName2.equals("EmptySet")) {
                return false;
            }
            String fullName = aClass.getName();
            if (fullName.equals("java.util.Arrays$ArrayList") || fullName.equals("java.util.Collections$SingletonList") || fullName.equals("java.util.Collections$SingletonSet")) {
                return false;
            }
            Class<?> declaringClass = aClass.getDeclaringClass();
            return declaringClass == null || !"ImmutableCollections".equals(declaringClass.getSimpleName());
        }
        return false;
    }

    public static boolean isMutableMap(@NotNull Map<?, ?> object) {
        if (object == null) {
            ClassUtil.$$$reportNull$$$0(11);
        }
        if (object == Collections.emptyMap()) {
            return false;
        }
        String simpleName2 = object.getClass().getSimpleName();
        return !simpleName2.equals("EmptyMap") && !simpleName2.equals("UnmodifiableMap") && !simpleName2.equals("ImmutableMap") && !simpleName2.equals("SingletonMap");
    }

    @Nullable
    public static Object stringToEnum(@NotNull String value2, @NotNull Class<? extends Enum<?>> valueClass, boolean isAlwaysIgnoreCase) {
        if (value2 == null) {
            ClassUtil.$$$reportNull$$$0(12);
        }
        if (valueClass == null) {
            ClassUtil.$$$reportNull$$$0(13);
        }
        Enum<?>[] enumConstants = valueClass.getEnumConstants();
        if (!isAlwaysIgnoreCase) {
            for (Enum<?> enumConstant : enumConstants) {
                if (!enumConstant.toString().equals(value2)) continue;
                return enumConstant;
            }
        }
        for (Enum<?> enumConstant : enumConstants) {
            if (!enumConstant.toString().equalsIgnoreCase(value2)) continue;
            return enumConstant;
        }
        return null;
    }

    public static Type resolveVariableInHierarchy(@NotNull TypeVariable<?> variable, @NotNull Class<?> aClass) {
        Type type2;
        if (variable == null) {
            ClassUtil.$$$reportNull$$$0(14);
        }
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(15);
        }
        Class<?> current = aClass;
        while ((type2 = ClassUtil.resolveVariable(variable, current, false)) == null) {
            if ((current = current.getSuperclass()) != null) continue;
            return null;
        }
        if (type2 instanceof TypeVariable) {
            return ClassUtil.resolveVariableInHierarchy((TypeVariable)type2, aClass);
        }
        return type2;
    }

    @Nullable
    public static Type resolveVariable(@NotNull TypeVariable<?> variable, @NotNull Class<?> classType, boolean resolveInInterfacesOnly) {
        Class<?> aClass;
        int index2;
        if (variable == null) {
            ClassUtil.$$$reportNull$$$0(16);
        }
        if (classType == null) {
            ClassUtil.$$$reportNull$$$0(17);
        }
        if ((index2 = ArrayUtilRt.find((aClass = ClassUtil.getRawType(classType)).getTypeParameters(), variable)) >= 0) {
            return variable;
        }
        Class<?>[] classes = aClass.getInterfaces();
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        for (int i = 0; i <= classes.length; ++i) {
            Type type2;
            Class<?> anInterface;
            if (i < classes.length) {
                anInterface = classes[i];
            } else {
                anInterface = aClass.getSuperclass();
                if (resolveInInterfacesOnly || anInterface == null) continue;
            }
            Type resolved = ClassUtil.resolveVariable(variable, anInterface, true);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index2 = ArrayUtilRt.find(anInterface.getTypeParameters(), typeVariable);
            if (index2 < 0) {
                Logger.getInstance(ClassUtil.class).error("Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\ngenericDeclaration = " + ClassUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\nsearching in " + ClassUtil.declarationToString(anInterface));
            }
            Type type3 = type2 = i < genericInterfaces.length ? genericInterfaces[i] : aClass.getGenericSuperclass();
            if (type2 instanceof Class) {
                return Object.class;
            }
            if (type2 instanceof ParameterizedType) {
                return ((ParameterizedType)type2).getActualTypeArguments()[index2];
            }
            throw new AssertionError((Object)("Invalid type: " + type2));
        }
        return null;
    }

    @NotNull
    private static String declarationToString(@NotNull GenericDeclaration anInterface) {
        if (anInterface == null) {
            ClassUtil.$$$reportNull$$$0(18);
        }
        String string2 = anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
        if (string2 == null) {
            ClassUtil.$$$reportNull$$$0(19);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/serialization/ClassUtil";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/serialization/ClassUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "typeToClass";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRawType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "typeToClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitive";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMutableCollection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMutableMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stringToEnum";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariableInHierarchy";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "declarationToString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

